/*
 * Decompiled with CFR 0.152.
 */
package com.machbase.jdbc;

import com.machbase.jdbc.MachBuffer;
import com.machbase.jdbc.MachColumnData;
import com.machbase.jdbc.MachConnection;
import com.machbase.jdbc.MachException;
import com.machbase.jdbc.MachProtocol;
import com.machbase.jdbc.MachResultSet;
import com.machbase.jdbc.MachStatement;
import com.machbase.jdbc.MachTypeConversion;
import com.machbase.jdbc.MachTypes;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.URL;
import java.net.UnknownHostException;
import java.sql.Array;
import java.sql.BatchUpdateException;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Locale;
import java.util.Vector;
import java.util.concurrent.TimeUnit;

public class MachPreparedStatement
extends MachStatement
implements PreparedStatement {
    protected String sqlStmt = null;
    protected int paramsCount = 0;
    protected int isOrderedMode = 0;
    protected Integer[] bind_appendtype = null;
    protected Vector<Object> bind_ins = null;
    protected Vector<Object> bind_ins_forbatch = null;
    protected int[] bind_type = null;
    protected boolean isSelect = false;
    protected static final int sErrorCheckCount = 100;
    protected MachBuffer readBuffer = null;

    MachPreparedStatement(MachConnection c, String sql) throws SQLException {
        super(c);
        c.addStatement(this);
        this.sqlStmt = sql;
        this.bind_ins = new Vector();
        this.bind_ins_forbatch = new Vector();
        this.readBuffer = ((MachStatement)this).readBuffer;
        if (sql.trim().substring(0, 1).equals("@")) {
            this.setAppendMode(1);
        } else {
            int ret = this.mcbConn.getProtocol().setPrepareStatement(this, sql.trim(), this.StatementId);
            if (ret == 1) {
                this.isSelect = true;
            }
        }
    }

    MachPreparedStatement(MachConnection c, String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        super(c, resultSetType, resultSetConcurrency);
        this.sqlStmt = sql;
        this.bind_ins = new Vector();
        this.readBuffer = ((MachStatement)this).readBuffer;
        try {
            int ret = this.mcbConn.getProtocol().setPrepareStatement(this, sql.trim(), this.StatementId);
            if (ret == 1) {
                this.isSelect = true;
            }
        }
        catch (Exception e) {
            throw new SQLException(e.getMessage());
        }
    }

    public void setAppendMode(int aMode) {
        this.isOrderedMode = aMode;
    }

    public int getAppendMode() {
        return this.isOrderedMode;
    }

    public void setParamsCount(int count) throws SQLException {
        this.paramsCount = count;
        this.bind_ins.setSize(this.paramsCount);
        this.bind_type = new int[this.paramsCount];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet executeQuery() throws SQLException {
        Object object = this.mcbConn.getLock();
        synchronized (object) {
            if (!this.isSelect) {
                throw new SQLException("this is not select query");
            }
            this.missingCheck();
            int qto = this.queryTimeout;
            if (qto > 0) {
                this.timeHandle = this.scheduler.schedule(new MachStatement.QueryTimeout(this.mcbConn, this), (long)qto, TimeUnit.MILLISECONDS);
            }
            int ret = this.mcbConn.getProtocol().execPrepareStatement(this, this.bind_ins);
            if (qto > 0 && this.timeHandle != null) {
                this.timeHandle.cancel(false);
                this.scheduler.shutdown();
                this.timeHandle = null;
            }
            if (this.resultSets.size() > 0) {
                return (MachResultSet)this.resultSets.get(0);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int executeUpdate() throws SQLException {
        Object object = this.mcbConn.getLock();
        synchronized (object) {
            this.missingCheck();
            this.reset();
            int qto = this.queryTimeout;
            if (qto > 0) {
                this.timeHandle = this.scheduler.schedule(new MachStatement.QueryTimeout(this.mcbConn, this), (long)qto, TimeUnit.MILLISECONDS);
            }
            int ret = this.mcbConn.getProtocol().execPrepareStatement(this, this.bind_ins);
            if (qto > 0 && this.timeHandle != null) {
                this.timeHandle.cancel(false);
                this.scheduler.shutdown();
                this.timeHandle = null;
            }
            if (ret != 0) {
                throw new SQLException("invalid UpdateCount");
            }
            if (this.resultSets.size() > 0) {
                return ((MachResultSet)this.resultSets.get(0)).getUpdateCount();
            }
            return 0;
        }
    }

    @Override
    public void close() throws SQLException {
        try {
            super.close();
        }
        finally {
            this.bind_ins.removeAllElements();
            this.bind_ins = null;
            this.bind_type = null;
            this.bind_appendtype = null;
            this.setAppendMode(0);
        }
    }

    @Override
    public void setNull(int ind, int type) throws SQLException {
        this.validateIndex(ind);
        switch (type) {
            case 5: {
                this.setItem(ind, MachTypeConversion.shortToBytes((short)Short.MIN_VALUE), 4);
                break;
            }
            case 4: {
                this.setItem(ind, MachTypeConversion.intToBytes(Integer.MIN_VALUE), 8);
                break;
            }
            case -5: {
                this.setItem(ind, MachTypeConversion.longToBytes(Long.MIN_VALUE), 12);
                break;
            }
            case 6: {
                this.setItem(ind, MachTypeConversion.floatToBytes(Float.MAX_VALUE), 16);
                break;
            }
            case 8: {
                this.setItem(ind, MachTypeConversion.doubleToBytes(Double.MAX_VALUE), 20);
                break;
            }
            case 91: 
            case 92: 
            case 93: {
                this.setItem(ind, MachTypeConversion.longToBytes(-1L), 6);
                break;
            }
            case 1: 
            case 12: {
                this.setItem(ind, null, 5);
                break;
            }
            case 2111: {
                this.setItem(ind, null, 61);
                break;
            }
            case 2104: {
                this.setItem(ind, MachProtocol.MCB_IPV4_NULL, 32);
                break;
            }
            case 2106: {
                this.setItem(ind, MachProtocol.MCB_IPV6_NULL, 36);
                break;
            }
            case 2110: {
                this.setItem(ind, null, 49);
                break;
            }
            case -2: {
                this.setItem(ind, null, 97);
                break;
            }
            case 2201: {
                this.setItem(ind, MachTypeConversion.ushortToBytes(65535), 104);
                break;
            }
            case 2202: {
                this.setItem(ind, MachTypeConversion.uintToBytes(0xFFFFFFFFL), 108);
                break;
            }
            case 2203: {
                this.setItem(ind, MachTypeConversion.ulongToBytes(-1L), 112);
                break;
            }
        }
    }

    @Override
    public void setShort(int ind, short s) throws SQLException {
        this.validateIndex(ind);
        this.setItem(ind, MachTypeConversion.shortToBytes(s), 4);
    }

    public void setShort(int ind, int x) throws SQLException {
        this.validateIndex(ind);
        short s = (short)x;
        this.setItem(ind, MachTypeConversion.shortToBytes(s), 4);
    }

    public void setShort(int ind, long l) throws SQLException {
        this.validateIndex(ind);
        short s = (short)l;
        this.setItem(ind, MachTypeConversion.shortToBytes(s), 4);
    }

    public void setShort(int ind, float f) throws SQLException {
        this.validateIndex(ind);
        short s = (short)f;
        this.setItem(ind, MachTypeConversion.shortToBytes(s), 4);
    }

    public void setShort(int ind, double d) throws SQLException {
        this.validateIndex(ind);
        short s = (short)d;
        this.setItem(ind, MachTypeConversion.shortToBytes(s), 4);
    }

    public void setUShort(int ind, short aVal) throws SQLException {
        this.validateIndex(ind);
        short s = aVal;
        this.setItem(ind, MachTypeConversion.ushortToBytes(s), 104);
    }

    public void setUShort(int ind, int x) throws SQLException {
        this.validateIndex(ind);
        this.setItem(ind, MachTypeConversion.ushortToBytes(x), 104);
    }

    public void setUShort(int ind, long aVal) throws SQLException {
        this.validateIndex(ind);
        int s = (int)aVal;
        this.setItem(ind, MachTypeConversion.ushortToBytes(s), 104);
    }

    public void setUShort(int ind, float aVal) throws SQLException {
        this.validateIndex(ind);
        int s = (int)aVal;
        this.setItem(ind, MachTypeConversion.ushortToBytes(s), 104);
    }

    public void setUShort(int ind, double aVal) throws SQLException {
        this.validateIndex(ind);
        int s = (int)aVal;
        this.setItem(ind, MachTypeConversion.ushortToBytes(s), 104);
    }

    public void setInt(int ind, short s) throws SQLException {
        this.validateIndex(ind);
        short x = s;
        this.setItem(ind, MachTypeConversion.intToBytes(x), 8);
    }

    @Override
    public void setInt(int ind, int x) throws SQLException {
        this.validateIndex(ind);
        this.setItem(ind, MachTypeConversion.intToBytes(x), 8);
    }

    public void setInt(int ind, long l) throws SQLException {
        this.validateIndex(ind);
        int x = (int)l;
        this.setItem(ind, MachTypeConversion.intToBytes(x), 8);
    }

    public void setInt(int ind, float f) throws SQLException {
        this.validateIndex(ind);
        int x = (int)f;
        this.setItem(ind, MachTypeConversion.intToBytes(x), 8);
    }

    public void setInt(int ind, double d) throws SQLException {
        this.validateIndex(ind);
        int x = (int)d;
        this.setItem(ind, MachTypeConversion.intToBytes(x), 8);
    }

    public void setUInt(int ind, short sVal) throws SQLException {
        this.validateIndex(ind);
        long x = sVal;
        this.setItem(ind, MachTypeConversion.uintToBytes(x), 108);
    }

    public void setUInt(int ind, int sVal) throws SQLException {
        this.validateIndex(ind);
        long x = sVal;
        this.setItem(ind, MachTypeConversion.uintToBytes(x), 108);
    }

    public void setUInt(int ind, long x) throws SQLException {
        this.validateIndex(ind);
        this.setItem(ind, MachTypeConversion.uintToBytes(x), 108);
    }

    public void setUInt(int ind, float sVal) throws SQLException {
        this.validateIndex(ind);
        long x = (long)sVal;
        this.setItem(ind, MachTypeConversion.uintToBytes(x), 108);
    }

    public void setUInt(int ind, double sVal) throws SQLException {
        this.validateIndex(ind);
        long x = (long)sVal;
        this.setItem(ind, MachTypeConversion.uintToBytes(x), 108);
    }

    public void setLong(int ind, short s) throws SQLException {
        this.validateIndex(ind);
        long l = s;
        this.setItem(ind, MachTypeConversion.longToBytes(l), 12);
    }

    public void setLong(int ind, int x) throws SQLException {
        this.validateIndex(ind);
        long l = x;
        this.setItem(ind, MachTypeConversion.longToBytes(l), 12);
    }

    @Override
    public void setLong(int ind, long l) throws SQLException {
        this.validateIndex(ind);
        this.setItem(ind, MachTypeConversion.longToBytes(l), 12);
    }

    public void setLong(int ind, float f) throws SQLException {
        this.validateIndex(ind);
        long l = (long)f;
        this.setItem(ind, MachTypeConversion.longToBytes(l), 12);
    }

    public void setLong(int ind, double d) throws SQLException {
        this.validateIndex(ind);
        long l = (long)d;
        this.setItem(ind, MachTypeConversion.longToBytes(l), 12);
    }

    public void setULong(int ind, short s) throws SQLException {
        this.validateIndex(ind);
        long l = s;
        this.setItem(ind, MachTypeConversion.ulongToBytes(l), 112);
    }

    public void setULong(int ind, int x) throws SQLException {
        this.validateIndex(ind);
        long l = x;
        this.setItem(ind, MachTypeConversion.ulongToBytes(l), 112);
    }

    public void setULong(int ind, long l) throws SQLException {
        this.validateIndex(ind);
        this.setItem(ind, MachTypeConversion.ulongToBytes(l), 112);
    }

    public void setULong(int ind, float f) throws SQLException {
        this.validateIndex(ind);
        long l = (long)f;
        this.setItem(ind, MachTypeConversion.ulongToBytes(l), 112);
    }

    public void setULong(int ind, double d) throws SQLException {
        this.validateIndex(ind);
        long l = (long)d;
        this.setItem(ind, MachTypeConversion.ulongToBytes(l), 112);
    }

    public void setULong(int ind, BigInteger sVal) throws SQLException {
        this.validateIndex(ind);
        this.setItem(ind, MachTypeConversion.ulongToBytes(sVal), 112);
    }

    public void setFloat(int ind, short s) throws SQLException {
        this.validateIndex(ind);
        float f = s;
        this.setItem(ind, MachTypeConversion.floatToBytes(f), 16);
    }

    public void setFloat(int ind, int x) throws SQLException {
        this.validateIndex(ind);
        float f = x;
        this.setItem(ind, MachTypeConversion.floatToBytes(f), 16);
    }

    public void setFloat(int ind, long l) throws SQLException {
        this.validateIndex(ind);
        float f = l;
        this.setItem(ind, MachTypeConversion.floatToBytes(f), 16);
    }

    @Override
    public void setFloat(int ind, float f) throws SQLException {
        this.validateIndex(ind);
        this.setItem(ind, MachTypeConversion.floatToBytes(f), 16);
    }

    public void setFloat(int ind, double d) throws SQLException {
        this.validateIndex(ind);
        float f = (float)d;
        this.setItem(ind, MachTypeConversion.floatToBytes(f), 16);
    }

    public void setDouble(int ind, short s) throws SQLException {
        this.validateIndex(ind);
        double d = s;
        this.setItem(ind, MachTypeConversion.doubleToBytes(d), 20);
    }

    public void setDouble(int ind, int x) throws SQLException {
        this.validateIndex(ind);
        double d = x;
        this.setItem(ind, MachTypeConversion.doubleToBytes(d), 20);
    }

    public void setDouble(int ind, long l) throws SQLException {
        this.validateIndex(ind);
        double d = l;
        this.setItem(ind, MachTypeConversion.doubleToBytes(d), 20);
    }

    public void setDouble(int ind, float f) throws SQLException {
        this.validateIndex(ind);
        double d = f;
        this.setItem(ind, MachTypeConversion.doubleToBytes(d), 20);
    }

    @Override
    public void setDouble(int ind, double d) throws SQLException {
        this.validateIndex(ind);
        this.setItem(ind, MachTypeConversion.doubleToBytes(d), 20);
    }

    @Override
    public void setDate(int ind, Date d) throws SQLException {
        this.validateIndex(ind);
        this.setItem(ind, MachTypeConversion.dateToBytes(d, this.mcbConn.getTimezoneSec()), 6);
    }

    public void setDate(int ind, long l) throws SQLException {
        this.validateIndex(ind);
        this.setItem(ind, MachTypeConversion.longToBytes(l), 6);
    }

    @Override
    public void setTime(int ind, Time t) throws SQLException {
        this.validateIndex(ind);
        this.setItem(ind, MachTypeConversion.timeToBytes(t, this.mcbConn.getTimezoneSec()), 6);
    }

    public void setTime(int ind, long l) throws SQLException {
        this.validateIndex(ind);
        this.setItem(ind, MachTypeConversion.longToBytes(l), 6);
    }

    @Override
    public void setTimestamp(int ind, Timestamp t) throws SQLException {
        this.validateIndex(ind);
        this.setItem(ind, MachTypeConversion.timestampToBytes(t, this.mcbConn.getTimezoneSec()), 6);
    }

    public void setTimestamp(int ind, String s) throws SQLException {
        this.validateIndex(ind);
        SimpleDateFormat dateFormat = null;
        if (s.indexOf(45) < 0) {
            dateFormat = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss SSS");
            s = s.substring(0, 4) + "-" + s.substring(4, 6) + "-" + s.substring(6, 8) + " " + s.substring(8, 10) + ":" + s.substring(10, 12) + ":" + s.substring(12, 14) + " " + s.substring(14, 17);
        } else {
            dateFormat = s.indexOf(46) < 0 ? new SimpleDateFormat("yyyy-MM-dd hh:mm:ss SSS") : new SimpleDateFormat("yyyy-MM-dd hh:mm:ss.SSS");
        }
        Timestamp ts = null;
        try {
            java.util.Date parsedDate = dateFormat.parse(s);
            ts = new Timestamp(parsedDate.getTime());
        }
        catch (ParseException te) {
            te.printStackTrace();
        }
        this.setTimestamp(ind, ts);
    }

    public void setTimestamp(int ind, String s, String f) throws SQLException {
        this.validateIndex(ind);
        SimpleDateFormat dateFormat = null;
        dateFormat = new SimpleDateFormat(f);
        Timestamp ts = null;
        try {
            java.util.Date parsedDate = dateFormat.parse(s);
            ts = new Timestamp(parsedDate.getTime());
        }
        catch (ParseException te) {
            te.printStackTrace();
        }
        this.setTimestamp(ind, ts);
    }

    public void setTimestamp(int ind, long l) throws SQLException {
        this.validateIndex(ind);
        this.setItem(ind, MachTypeConversion.longToBytes(l), 6);
    }

    public void setIpv4(int ind, String str) throws SQLException {
        this.validateIndex(ind);
        this.setItem(ind, MachTypeConversion.ipv4ToBytes(str), 32);
    }

    public void setIpv6(int ind, String str) throws SQLException {
        this.validateIndex(ind);
        this.setItem(ind, MachTypeConversion.ipv6ToBytes(str), 36);
    }

    @Override
    public void setString(int ind, String str) throws SQLException {
        this.validateIndex(ind);
        if (str == null || str.equals("")) {
            this.setItem(ind, null, 5);
        } else {
            try {
                this.setItem(ind, str.getBytes("UTF-8"), 5);
            }
            catch (UnsupportedEncodingException e) {
                throw new SQLException(e.getMessage());
            }
        }
    }

    public void setJson(int ind, String str) throws SQLException {
        this.validateIndex(ind);
        if (str == null || str.equals("")) {
            this.setItem(ind, null, 61);
        } else {
            try {
                this.setItem(ind, str.getBytes("UTF-8"), 61);
            }
            catch (UnsupportedEncodingException e) {
                throw new SQLException(e.getMessage());
            }
        }
    }

    public void setText(int ind, String str) throws SQLException {
        this.validateIndex(ind);
        if (str == null || str.equals("")) {
            this.setItem(ind, null, 49);
        } else {
            try {
                this.setItem(ind, str.getBytes("UTF-8"), 49);
            }
            catch (UnsupportedEncodingException e) {
                throw new SQLException(e.getMessage());
            }
        }
    }

    @Override
    public void setBoolean(int ind, boolean b) throws SQLException {
        throw new SQLException("data type not supported.");
    }

    @Override
    public void setByte(int ind, byte b) throws SQLException {
        this.validateIndex(ind);
        byte[] by = new byte[]{b};
        this.setItem(ind, by, 45);
    }

    @Override
    public void setBytes(int ind, byte[] data) throws SQLException {
        this.validateIndex(ind);
        this.setItem(ind, data, 97);
    }

    @Override
    public void setBigDecimal(int ind, BigDecimal bd) throws SQLException {
        this.validateIndex(ind);
        double d = bd.doubleValue();
        this.setItem(ind, MachTypeConversion.doubleToBytes(d), 72);
    }

    @Override
    public void setAsciiStream(int ind, InputStream in, int len) throws SQLException {
        this.validateIndex(ind);
        byte[] str = new byte[len];
        try {
            in.read(str, 0, len);
        }
        catch (IOException e) {
            throw new MachException(e);
        }
        this.setItem(ind, str, 97);
    }

    @Override
    public void setUnicodeStream(int ind, InputStream in, int len) throws SQLException {
        this.validateIndex(ind);
        byte[] str = new byte[len];
        try {
            in.read(str, 0, len);
            this.setItem(ind, str, 97);
        }
        catch (IOException e) {
            throw new MachException(e);
        }
    }

    @Override
    public void setBinaryStream(int ind, InputStream in, int len) throws SQLException {
        this.validateIndex(ind);
        byte[] sBuf = new byte[len];
        try {
            in.read(sBuf, 0, len);
            this.setItem(ind, sBuf, 97);
        }
        catch (IOException e) {
            throw new MachException(e);
        }
    }

    @Override
    public void clearParameters() throws SQLException {
        this.bind_ins.removeAllElements();
        this.bind_appendtype = null;
        this.setParamsCount(this.paramsCount);
    }

    @Override
    public void setArray(int i, Array x) throws SQLException {
        throw new SQLException("data type not supported.");
    }

    @Override
    public void setBlob(int i, Blob x) throws SQLException {
        throw new SQLException("data type not supported.");
    }

    @Override
    public void setCharacterStream(int ind, Reader in, int len) throws SQLException {
        this.validateIndex(ind);
        char[] str = new char[len];
        try {
            in.read(str, 0, len);
            String s = new String(str);
            byte[] data = s.getBytes("UTF-8");
            this.setItem(ind, data, 45);
        }
        catch (IOException e) {
            throw new MachException(e);
        }
    }

    @Override
    public void setClob(int i, Clob x) throws SQLException {
        throw new SQLException("data type not supported.");
    }

    @Override
    public void setDate(int ind, Date d, Calendar cal) throws SQLException {
        this.validateIndex(ind);
        this.setItem(ind, MachTypeConversion.dateToBytes(d, this.mcbConn.getTimezoneSec()), 6);
    }

    @Override
    public void setRef(int i, Ref x) throws SQLException {
        throw new SQLException("data type not supported.");
    }

    @Override
    public void setTime(int ind, Time t, Calendar cal) throws SQLException {
        this.validateIndex(ind);
        this.setItem(ind, MachTypeConversion.timeToBytes(t, this.mcbConn.getTimezoneSec()), 6);
    }

    @Override
    public void setTimestamp(int ind, Timestamp t, Calendar cal) throws SQLException {
        this.validateIndex(ind);
        this.setItem(ind, MachTypeConversion.timestampToBytes(t, this.mcbConn.getTimezoneSec()), 6);
    }

    @Override
    public void setObject(int ind, Object ob, int type, int scale) throws SQLException {
        this.validateIndex(ind);
        this.setObject(ind, ob, type);
    }

    @Override
    public void setObject(int ind, Object ob, int type) throws SQLException {
        this.validateIndex(ind);
        switch (type) {
            case -7: {
                String value = ob.toString();
                if (value.length() < 1) {
                    this.setByte(ind, (byte)0);
                } else {
                    byte b = (byte)value.charAt(0);
                    this.setByte(ind, b);
                }
                return;
            }
            case -6: 
            case 5: {
                this.setShort(ind, Short.parseShort(ob.toString()));
                return;
            }
            case 4: {
                this.setInt(ind, Integer.parseInt(ob.toString()));
                return;
            }
            case -5: {
                this.setLong(ind, Long.parseLong(ob.toString()));
                return;
            }
            case 6: 
            case 7: {
                float f = Float.valueOf(ob.toString()).floatValue();
                this.setFloat(ind, f);
                return;
            }
            case 8: {
                double d = Double.valueOf(ob.toString());
                this.setDouble(ind, d);
                return;
            }
            case 2: 
            case 3: {
                this.setBigDecimal(ind, new BigDecimal(ob.toString()));
                return;
            }
            case -1: 
            case 1: 
            case 12: 
            case 2110: {
                this.setString(ind, ob.toString());
                return;
            }
            case 91: 
            case 92: {
                String tmp = ob.toString();
                String fmtstr = type == 91 ? "dd-MMM-yyyy" : "HH:mm:ss";
                try {
                    SimpleDateFormat fmt = new SimpleDateFormat(fmtstr, Locale.US);
                    if (type == 91) {
                        this.setDate(ind, (Date)fmt.parse(tmp));
                    } else {
                        this.setTime(ind, (Time)fmt.parse(tmp));
                    }
                }
                catch (ParseException e) {
                    throw new MachException(e);
                }
                return;
            }
            case 93: {
                SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss.SSS");
                java.util.Date parsedDate = null;
                Timestamp ts = null;
                try {
                    parsedDate = dateFormat.parse(ob.toString());
                    ts = new Timestamp(parsedDate.getTime());
                }
                catch (Exception e) {
                    ts = new Timestamp(Long.parseLong(ob.toString()));
                }
                this.setTimestamp(ind, ts);
                return;
            }
            case -4: 
            case -3: 
            case -2: {
                if (ob instanceof byte[]) {
                    this.setBytes(ind, (byte[])ob);
                } else if (ob instanceof Serializable) {
                    try {
                        ByteArrayOutputStream baos = new ByteArrayOutputStream();
                        ObjectOutputStream oos = new ObjectOutputStream(baos);
                        oos.writeObject(ob);
                        oos.flush();
                        this.setBytes(ind, baos.toByteArray());
                    }
                    catch (IOException e) {
                        throw new MachException(e);
                    }
                } else {
                    throw new MachException("invalid binary object type");
                }
                return;
            }
            case 1111: {
                throw new MachException("UDTs are not supported.");
            }
        }
    }

    @Override
    public void setObject(int ind, Object ob) throws SQLException {
        this.validateIndex(ind);
        if (ob instanceof Date) {
            this.setDate(ind, (Date)ob);
        } else if (ob instanceof String) {
            this.setString(ind, ob.toString());
        } else if (ob instanceof StringBuffer) {
            this.setString(ind, ob.toString());
        } else if (ob instanceof Short) {
            this.setShort(ind, (Short)ob);
        } else if (ob instanceof Integer) {
            this.setInt(ind, (Integer)ob);
        } else if (ob instanceof Long) {
            this.setLong(ind, (Long)ob);
        } else if (ob instanceof Float) {
            this.setFloat(ind, ((Float)ob).floatValue());
        } else if (ob instanceof Double) {
            this.setDouble(ind, (Double)ob);
        } else if (ob instanceof StringBuffer) {
            this.setString(ind, ob.toString());
        } else if (ob instanceof Timestamp) {
            this.setTimestamp(ind, (Timestamp)ob);
        } else {
            this.setObject(ind, ob, -2);
        }
    }

    @Override
    public boolean execute() throws SQLException {
        Object object = this.mcbConn.getLock();
        synchronized (object) {
            this.missingCheck();
            int ret = -1;
            int qto = this.queryTimeout;
            if (qto > 0) {
                this.timeHandle = this.scheduler.schedule(new MachStatement.QueryTimeout(this.mcbConn, this), (long)qto, TimeUnit.MILLISECONDS);
            }
            ret = this.mcbConn.getProtocol().execPrepareStatement(this, this.bind_ins);
            if (qto > 0 && this.timeHandle != null) {
                this.timeHandle.cancel(false);
                this.scheduler.shutdown();
                this.timeHandle = null;
            }
            if (ret == 0) {
                return false;
            }
            if (ret == 1) {
                return true;
            }
            throw new SQLException("invalid execution");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        Object object = this.mcbConn.getLock();
        synchronized (object) {
            MachResultSet rs;
            ResultSetMetaData rsm = null;
            if (super.getMoreResults() && (rsm = (rs = super.getRslt()).getMetaData()) == null) {
                throw new MachException("operation not yet supported.");
            }
            return rsm;
        }
    }

    @Override
    public void setNull(int ind, int type, String tname) throws SQLException {
        throw new MachException("operation not yet supported.");
    }

    @Override
    public void addBatch() throws SQLException {
        this.bind_ins_forbatch.addElement(this.bind_ins.clone());
    }

    @Override
    public void clearBatch() throws SQLException {
        this.bind_ins_forbatch.removeAllElements();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int[] executeBatch() throws SQLException {
        Object object = this.mcbConn.getLock();
        synchronized (object) {
            int[] ret = null;
            ret = this.getAppendMode() < 1 ? this.executeBatchMixed() : this.executeBatchOrdered();
            return ret;
        }
    }

    public int[] executeBatchOrdered() throws SQLException {
        String sInsertTable = null;
        String sSql = this.sqlStmt.toUpperCase().trim();
        int sTableColumnCount = this.bind_appendtype.length;
        int aSize = this.bind_ins_forbatch.size();
        int[] counts = new int[aSize];
        ArrayList<Integer> sColType = new ArrayList<Integer>(Arrays.asList(this.bind_appendtype));
        MachPreparedStatement stmt = this;
        String[] sSplits = sSql.split("[\\s\\(]+");
        sInsertTable = sSplits[2];
        ArrayList<ArrayList<Object>> sAppendDatas = new ArrayList<ArrayList<Object>>();
        Object[] sArray = new Object[sTableColumnCount];
        for (int i = 0; i < aSize; ++i) {
            Vector bind = (Vector)this.bind_ins_forbatch.elementAt(i);
            block15: for (int j = 0; j < bind.size(); ++j) {
                MachColumnData sColData = (MachColumnData)bind.elementAt(j);
                byte[] sData = sColData.getData();
                if (sData == null) {
                    if (sColData.getType() == 6) {
                        sArray[j] = -1L;
                        continue;
                    }
                    if (sColData.getType() == 97) {
                        sArray[j] = new ByteArrayInputStream(new byte[0]);
                        continue;
                    }
                    sArray[j] = null;
                    continue;
                }
                switch (sColData.getType()) {
                    case 4: {
                        int sTemp = 0;
                        sTemp = (sData[0] << 8) + (sData[1] & 0xFF);
                        sArray[j] = String.valueOf(sTemp);
                        continue block15;
                    }
                    case 8: 
                    case 104: {
                        int sTemp = 0;
                        for (int k = 0; k < sData.length; ++k) {
                            sTemp = (sTemp << 8) + (sData[k] & 0xFF);
                        }
                        sArray[j] = String.valueOf(sTemp);
                        continue block15;
                    }
                    case 6: 
                    case 12: 
                    case 108: 
                    case 112: {
                        long sTemp = 0L;
                        for (int k = 0; k < sData.length; ++k) {
                            sTemp = (sTemp << 8) + (long)(sData[k] & 0xFF);
                        }
                        if (sColData.getType() == 6) {
                            sArray[j] = sTemp;
                            continue block15;
                        }
                        sArray[j] = String.valueOf(sTemp);
                        continue block15;
                    }
                    case 16: {
                        float sRes = 0.0f;
                        int sTemp = 0;
                        for (int k = 0; k < sData.length; ++k) {
                            sTemp = (sTemp << 8) + (sData[k] & 0xFF);
                        }
                        sRes = Float.intBitsToFloat(sTemp);
                        sArray[j] = String.format("%.12f", Float.valueOf(sRes));
                        continue block15;
                    }
                    case 20: {
                        double sRes = 0.0;
                        long sTemp = 0L;
                        for (int k = 0; k < sData.length; ++k) {
                            sTemp = (sTemp << 8) + (long)(sData[k] & 0xFF);
                        }
                        sRes = Double.longBitsToDouble(sTemp);
                        sArray[j] = String.format("%.12f", sRes);
                        continue block15;
                    }
                    case 32: {
                        String sTemp = String.valueOf(sData[1]) + "." + String.valueOf(sData[2]) + "." + String.valueOf(sData[3]) + "." + String.valueOf(sData[4]);
                        sArray[j] = sTemp;
                        continue block15;
                    }
                    case 36: {
                        String sTemp = "";
                        byte[] sRes = new byte[]{};
                        if (sData[1] == 0 && sData[2] == 0 && sData[3] == 0) {
                            sRes = new byte[4];
                            System.arraycopy(sData, 13, sRes, 0, 4);
                        } else {
                            sRes = new byte[16];
                            System.arraycopy(sData, 1, sRes, 0, 16);
                        }
                        try {
                            InetAddress sAddr = InetAddress.getByAddress(sRes);
                            sTemp = sAddr.toString();
                            if (sTemp.charAt(0) == '/') {
                                sTemp = sTemp.substring(1, sTemp.length());
                            }
                        }
                        catch (UnknownHostException e) {
                            sTemp = "";
                        }
                        sArray[j] = sTemp;
                        continue block15;
                    }
                    case 5: 
                    case 49: 
                    case 61: {
                        String sTemp = new String(sData);
                        sArray[j] = sTemp;
                        continue block15;
                    }
                    case 97: {
                        sArray[j] = new ByteArrayInputStream(sData);
                        continue block15;
                    }
                    case 0: {
                        continue block15;
                    }
                    default: {
                        String sTemp = new String(sData);
                        sArray[j] = sTemp;
                        continue block15;
                    }
                }
            }
            ArrayList<Object> sBuf = new ArrayList<Object>(Arrays.asList(sArray));
            sAppendDatas.add(sBuf);
            counts[i] = 1;
        }
        this.mcbConn.getProtocol().executeAppendBatchByTimeInternal(stmt, sInsertTable, 0L, sColType, sAppendDatas);
        this.clearBatch();
        return counts;
    }

    public int[] executeBatchMixed() throws SQLException {
        int size = this.bind_ins_forbatch.size();
        int[] counts = new int[size];
        for (int i = 0; i < size; ++i) {
            Vector bind = (Vector)this.bind_ins_forbatch.elementAt(i);
            try {
                int qto = this.queryTimeout;
                if (qto > 0) {
                    this.timeHandle = this.scheduler.schedule(new MachStatement.QueryTimeout(this.mcbConn, this), (long)qto, TimeUnit.MILLISECONDS);
                }
                int ret = this.mcbConn.getProtocol().execPrepareStatement(this, bind);
                if (qto > 0 && this.timeHandle != null) {
                    this.timeHandle.cancel(false);
                    this.scheduler.shutdown();
                    this.timeHandle = null;
                }
                if (ret != 0) {
                    throw new SQLException("invalid execute batch");
                }
                if (this.resultSets.size() > 0) {
                    counts[i] = ((MachResultSet)this.resultSets.get(0)).getUpdateCount();
                    continue;
                }
                counts[i] = 0;
                continue;
            }
            catch (SQLException e) {
                int[] updates = new int[i];
                for (int j = 0; j < i; ++j) {
                    updates[j] = counts[j];
                }
                throw new BatchUpdateException(e.getMessage(), updates);
            }
        }
        this.clearBatch();
        return counts;
    }

    public void missingCheck() throws SQLException {
        int size = this.bind_ins.size();
        for (int i = 0; i < size; ++i) {
            if (this.bind_ins.elementAt(i) != null) continue;
            throw new SQLException("missing in parameter at index" + (i + 1));
        }
    }

    public int getParamsCount() {
        return this.paramsCount;
    }

    private int parseParamsCount() {
        String sql = this.sqlStmt;
        int ind = 0;
        int count = 0;
        while ((ind = sql.indexOf("?", ind + 1)) >= 0) {
            ++count;
        }
        return count;
    }

    protected void setItem(int idx, byte[] data, int type) {
        if (this.isOrderedMode > 0 && this.bind_ins_forbatch.size() <= 0) {
            this.setAppendTypeArray(idx, MachTypes.getAppendAllTypeForMachbase(type));
        }
        MachColumnData cdata = new MachColumnData(idx, type, data);
        this.bind_ins.setElementAt(cdata, idx - 1);
        this.bind_type[idx - 1] = 1;
    }

    public void setAppendTypeArray(int aIdx, int aType) {
        if (this.bind_appendtype == null || this.bind_appendtype.length < aIdx) {
            this.bind_ins.setSize(aIdx);
            if (this.bind_appendtype == null) {
                this.bind_type = new int[aIdx];
                this.bind_appendtype = new Integer[aIdx];
            } else {
                this.bind_type = Arrays.copyOf(this.bind_type, aIdx);
                this.bind_appendtype = Arrays.copyOf(this.bind_appendtype, aIdx);
            }
        }
        this.bind_appendtype[aIdx - 1] = aType;
    }

    protected void validateIndex(int ind) throws SQLException {
        if (this.getAppendMode() < 1) {
            if (ind < 1) {
                throw new MachException("cannot address an index less than 1.");
            }
            if (ind > this.paramsCount) {
                throw new MachException(String.format("attempted to assign a value to parameter %d when there are only %d parameters", ind, this.paramsCount));
            }
        }
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream, long length) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setClob(int parameterIndex, Reader reader) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setClob(int parameterIndex, Reader reader, long length) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, long length) throws SQLException {
        this.setBinaryStream(parameterIndex, x, (int)length);
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, long length) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, long length) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value, long length) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setNClob(int parameterIndex, NClob value) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader, long length) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setNString(int parameterIndex, String value) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setRowId(int parameterIndex, RowId x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setSQLXML(int parameterIndex, SQLXML xmlObject) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public synchronized ParameterMetaData getParameterMetaData() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public synchronized void setURL(int index, URL x) throws SQLException {
        throw new UnsupportedOperationException();
    }
}

