/*
 * Decompiled with CFR 0.152.
 */
package com.machbase.jdbc;

import com.machbase.jdbc.HostInfo;
import com.machbase.jdbc.MachAppendCallback;
import com.machbase.jdbc.MachBuffer;
import com.machbase.jdbc.MachCallableStatement;
import com.machbase.jdbc.MachColumnData;
import com.machbase.jdbc.MachConnection;
import com.machbase.jdbc.MachInputStream;
import com.machbase.jdbc.MachOutputStream;
import com.machbase.jdbc.MachPacket;
import com.machbase.jdbc.MachPreparedStatement;
import com.machbase.jdbc.MachResult;
import com.machbase.jdbc.MachResultSet;
import com.machbase.jdbc.MachResultSetMetaData;
import com.machbase.jdbc.MachRow;
import com.machbase.jdbc.MachStatement;
import com.machbase.jdbc.MachTableMetaData;
import com.machbase.jdbc.MachTableMetaParam;
import com.machbase.jdbc.MachTypes;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import java.sql.SQLException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.TimeZone;
import java.util.Vector;

public class MachProtocol {
    static final int MCB_PROTOCOL_CNT = 9;
    static final int MCB_PROTOCOL_MAJOR_VERSION = 4;
    static final int MCB_PROTOCOL_MINOR_VERSION = 0;
    static final int MCB_PROTOCOL_FIX_VERSION = 0;
    static final int MCB_PACKET_MODE_COMPLETE = 0;
    static final int MCB_PACKET_MODE_BEGIN = 1;
    static final int MCB_PACKET_MODE_MIDDLE = 2;
    static final int MCB_PACKET_MODE_END = 3;
    static final long MCB_PROTOCOL_TYPE = 1L;
    static final long MCB_STRING_TYPE = 2L;
    static final long MCB_BINARY_TYPE = 3L;
    static final long MCB_SCHAR_TYPE = 4L;
    static final long MCB_UCHAR_TYPE = 5L;
    static final long MCB_SSHORT_TYPE = 6L;
    static final long MCB_USHORT_TYPE = 7L;
    static final long MCB_SINT_TYPE = 8L;
    static final long MCB_UINT_TYPE = 9L;
    static final long MCB_SLONG_TYPE = 10L;
    static final long MCB_ULONG_TYPE = 11L;
    static final long MCB_DATE_TYPE = 12L;
    static final long MCB_ROWS_TYPE = 13L;
    static final long MCB_TNUMERIC_TYPE = 241L;
    static final long MCB_NUMBER_TYPE = 3570L;
    static final long MCB_ERROR_PROTOCOL = 1163022162L;
    static final long MCB_CONNECT_PROTOCOL = 0L;
    static final long MCB_DISCONNECT_PROTOCOL = 1L;
    static final long MCB_INVALID_PROTOCOL = 2L;
    static final long MCB_LARGE_PROTOCOL = 3L;
    static final long MCB_TIMEOUT_PROTOCOL = 4L;
    static final long MCB_ADMIN_PROTOCOL = 5L;
    static final long MCB_PREPARE_PROTOCOL = 6L;
    static final long MCB_EXECUTE_PROTOCOL = 7L;
    static final long MCB_EXECDIRECT_PROTOCOL = 8L;
    static final long MCB_FETCH_PROTOCOL = 9L;
    static final long MCB_FREE_PROTOCOL = 10L;
    static final long MCB_APPEND_OPEN_PROTOCOL = 11L;
    static final long MCB_APPEND_DATA_PROTOCOL = 12L;
    static final long MCB_APPEND_CLOSE_PROTOCOL = 13L;
    static final long MCB_COLLECTORMANAGER_PROTOCOL = 14L;
    static final long MCB_COLLECTOR_META_PROTOCOL = 15L;
    static final long MCB_COLLECTOR_SOURCE_PROTOCOL = 16L;
    static final long MCB_MSG_PROTOCOL = 17L;
    static final long MCB_EXECARRAY_PROTOCOL = 18L;
    static final long MCB_APPEND_BATCH_PROTOCOL = 19L;
    static final long MCB_MAX_MAX_PROTOCOL = 20L;
    static final long MCB_C_VERSION_ID = 1L;
    static final long MCB_C_CLIENT_ID = 2L;
    static final long MCB_C_LANG_ID = 3L;
    static final long MCB_C_DATABASE_ID = 4L;
    static final long MCB_C_ENDIAN_ID = 5L;
    static final long MCB_C_USER_ID = 6L;
    static final long MCB_C_PASSWORD_ID = 7L;
    static final long MCB_C_TIMEOUT_ID = 8L;
    static final long MCB_C_SID_ID = 64L;
    static final long MCB_C_SHC_ID = 65L;
    static final long MCB_C_IP_ID = 66L;
    static final long MCB_C_NODE_STATE = 80L;
    static final long MCB_C_TIMEZONE_ID = 112L;
    static final long MCB_C_SLANG_ID = 9L;
    static final long MCB_R_RESULT_ID = 16L;
    static final long MCB_R_MESSAGE_ID = 17L;
    static final long MCB_R_EMESSAGE_ID = 18L;
    static final long MCB_P_STATEMENT_ID = 32L;
    static final long MCB_P_BINDS_ID = 33L;
    static final long MCB_P_ID_ID = 34L;
    static final long MCB_P_ROWS_ID = 35L;
    static final long MCB_P_COLUMNS_ID = 36L;
    static final long MCB_P_TABLE_ID = 37L;
    static final long MCB_P_COLNAME_ID = 38L;
    static final long MCB_P_COLTYPE_ID = 39L;
    static final long MCB_P_DDF_ID = 40L;
    static final long MCB_P_PARAMTYPE_ID = 41L;
    static final long MCB_E_BIND_ID = 48L;
    static final long MCB_E_PARAM_ID = 49L;
    static final long MCB_E_OUTPARAM_ID = 50L;
    static final long MCB_E_STATEMENT_ID = 32L;
    static final long MCB_E_ID_ID = 34L;
    static final long MCB_E_ROWS_ID = 35L;
    static final long MCB_E_COLUMNS_ID = 36L;
    static final long MCB_E_TABLE_ID = 37L;
    static final long MCB_E_COLNAME_ID = 38L;
    static final long MCB_E_COLTYPE_ID = 39L;
    static final long MCB_E_ENDIAN_ID = 52L;
    static final long MCB_E_PARAMTYPE_ID = 41L;
    static final long MCB_D_ID_ID = 34L;
    static final long MCB_D_STATEMENT_ID = 64L;
    static final long MCB_D_ROWS_ID = 35L;
    static final long MCB_D_COLUMNS_ID = 36L;
    static final long MCB_D_TABLE_ID = 37L;
    static final long MCB_D_COLNAME_ID = 38L;
    static final long MCB_D_COLTYPE_ID = 39L;
    static final long MCB_D_PARAMTYPE_ID = 41L;
    static final long MCB_F_ID_ID = 80L;
    static final long MCB_F_ROWS_ID = 81L;
    static final long MCB_F_VALUE_ID = 82L;
    static final long MCB_X_ID_ID = 96L;
    static final long MCB_X_APPEND_SUCCESS_ID = 97L;
    static final long MCB_X_APPEND_FAILURE_ID = 98L;
    static final long MCB_TIMEOUT_RESULT = 1918126413L;
    static final long MCB_LARGE_RESULT = 1917604423L;
    static final long MCB_INVALID_RESULT = 1917406806L;
    static final long MCB_NONE_RESULT = 1917733196L;
    static final long MCB_OK_RESULT = 1917799263L;
    static final long MCB_LAST_RESULT = 1917604692L;
    static final long MCB_ERROR_RESULT = 1917013343L;
    static final short MCB_SHORT_NULL = Short.MIN_VALUE;
    static final int MCB_USHORT_NULL = 65535;
    static final int MCB_INT_NULL = Integer.MIN_VALUE;
    static final long MCB_UINT_NULL = 0xFFFFFFFFL;
    static final long MCB_LONG_NULL = Long.MIN_VALUE;
    static final long MCB_ULONG_NULL = -1L;
    static final byte[] MCB_ULONG_NULL_BYTE = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1};
    static final float MCB_FLOAT_NULL = Float.MAX_VALUE;
    static final double MCB_DOUBLE_NULL = Double.MAX_VALUE;
    static final long MCB_DATETIME_NULL = -1L;
    static final byte[] MCB_IPV4_NULL = new byte[5];
    static final byte[] MCB_IPV6_NULL = new byte[17];
    static final String SQL_NULL_STR = "NULL";
    static final int MAX_BUF_128M = 1344217728;
    static final int MAX_BUF_64K = 65536;
    static final int STMT_MAX_NUM = 1024;
    static final int ERR_XM_BROKER_NOT_ACTIVE = 7043;
    static final long clientEndian = 1L;
    static final int PACKET_HEADER_SIZE = 16;
    MachConnection mcbConn = null;
    private Socket mcbSocket = null;
    private int hostIndex = -1;
    private MachInputStream mcbIn = null;
    private MachOutputStream mcbOut = null;
    private String appendTableName = null;
    private int[] columnType = new int[256];
    private int[] columnPrecision = new int[256];
    private int columns = 0;
    private int oneRowLen = 0;
    private long errorCheckCount = 0L;
    private long appendAddCount = 0L;
    private long successCount = 0L;
    private long failureCount = 0L;
    private long appendErrorNo = -1L;
    private MachAppendCallback callback = null;
    MachBuffer packet = null;

    public MachProtocol() {
    }

    public MachProtocol(MachConnection con) throws SQLException {
        this.mcbConn = con;
        this.connectSocket(null);
    }

    public SQLException convertException(Exception aException) {
        SQLException sSQLException = new SQLException(aException.getMessage());
        sSQLException.setStackTrace(aException.getStackTrace());
        return sSQLException;
    }

    public SQLException convertException(Exception aException, String aSQLState, int aErrorCode, String aInnerMsg) {
        SQLException sSQLException = new SQLException(aException.getMessage() + ", " + aInnerMsg, aSQLState, aErrorCode);
        sSQLException.setStackTrace(aException.getStackTrace());
        return sSQLException;
    }

    public boolean checkAllSocket() throws SQLException {
        int i = 0;
        HostInfo sHostInfo = null;
        InetSocketAddress sAddr = null;
        Socket sTempSocket = null;
        for (i = 0; i < this.mcbConn.hostList.size(); ++i) {
            sHostInfo = this.mcbConn.hostList.get(i);
            try {
                sAddr = new InetSocketAddress(sHostInfo.getHost(), sHostInfo.getPort());
                sTempSocket = new Socket();
                sTempSocket.connect(sAddr, this.mcbConn.getConnectionTimeout());
                sTempSocket.close();
                return true;
            }
            catch (Exception e) {
                continue;
            }
        }
        return false;
    }

    public boolean checkSocket() throws SQLException {
        boolean sRC = true;
        HostInfo sHostInfo = null;
        if (this.hostIndex < 0 || this.hostIndex >= this.mcbConn.hostList.size()) {
            System.out.println("Host list does not setted");
            sRC = false;
        } else {
            sHostInfo = this.mcbConn.hostList.get(this.hostIndex);
            try {
                InetSocketAddress sAddr = new InetSocketAddress(sHostInfo.getHost(), sHostInfo.getPort());
                Socket sTempSocket = new Socket();
                sTempSocket.connect(sAddr, this.mcbConn.getConnectionTimeout());
                sTempSocket.close();
            }
            catch (Exception e) {
                sRC = false;
            }
        }
        return sRC;
    }

    public void connectSocket(String aHstIndex) throws SQLException {
        int i = 0;
        for (i = 0; i < this.mcbConn.hostList.size(); ++i) {
            if (aHstIndex != null && i == Integer.parseInt(aHstIndex)) continue;
            HostInfo sHostInfo = this.mcbConn.hostList.get(i);
            InetSocketAddress sAddr = new InetSocketAddress(sHostInfo.getHost(), sHostInfo.getPort());
            this.mcbSocket = new Socket();
            try {
                this.mcbSocket.setSoTimeout(this.mcbConn.getSocketTimeout());
                this.mcbSocket.connect(sAddr, this.mcbConn.getConnectionTimeout());
                this.hostIndex = i;
                break;
            }
            catch (ConnectException connectException) {
                continue;
            }
            catch (Exception e) {
                throw this.convertException(e);
            }
        }
        if (i == this.mcbConn.hostList.size()) {
            throw new SQLException("Connect broker failure", "", 9043);
        }
        try {
            this.mcbIn = new MachInputStream(this.mcbSocket.getInputStream());
            this.mcbOut = new MachOutputStream(this.mcbSocket.getOutputStream());
            this.packet = new MachBuffer(65536);
        }
        catch (Exception e) {
            throw this.convertException(e);
        }
    }

    public synchronized void readFromSoc(boolean aIsTerminate, int aCurStmtId) throws SQLException {
        MachBuffer readBuf = ((MachStatement)this.mcbConn.getStatement(aCurStmtId)).getReadBuffer();
        if (readBuf.getLastPacketFlag() == 0 || readBuf.getLastPacketFlag() == 3) {
            return;
        }
        try {
            while (true) {
                int sSeqFlag = this.mcbIn.readPacketFlag();
                long sProtocol = this.mcbIn.getPacketProtocol();
                int sReadLen = this.mcbIn.getPacketLength();
                int sStmtId = this.mcbIn.getStmtId();
                readBuf = ((MachStatement)this.mcbConn.getStatement(sStmtId)).getReadBuffer();
                switch (sSeqFlag) {
                    case 2: {
                        readBuf.setBuffer(sSeqFlag, this.mcbIn.readBytes(sReadLen));
                        break;
                    }
                    case 3: {
                        readBuf.setBuffer(sSeqFlag, this.mcbIn.readBytes(sReadLen));
                        break;
                    }
                    case 0: {
                        readBuf.setBuffer(sSeqFlag, this.mcbIn.readBytes(sReadLen));
                        readBuf.setProtocol(sProtocol);
                        break;
                    }
                    case 1: {
                        readBuf.setBuffer(sSeqFlag, this.mcbIn.readBytes(sReadLen));
                        readBuf.setProtocol(sProtocol);
                        break;
                    }
                    default: {
                        Date today = new Date();
                        SimpleDateFormat dateformat = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
                        throw new SQLException(String.format("[" + dateformat.format(today) + "] " + "invalid protocol while reading next packet(protocol=[%d], seqFlag=[%d])", sSeqFlag, sProtocol));
                    }
                }
                if (sSeqFlag != 3 && sSeqFlag != 0) continue;
                if (aCurStmtId != sStmtId) {
                    if (!aIsTerminate) continue;
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            throw this.convertException(e);
        }
    }

    public synchronized void init() throws SQLException {
        try {
            this.mcbOut.writeString("CMI_JDBC1");
            this.mcbOut.flush();
            byte[] b_proto_buffer = this.mcbIn.readBytes(9);
            String s_proto_buffer = new String(b_proto_buffer);
            if (s_proto_buffer.length() != 9) {
                this.clean();
                throw new SQLException("server rejected the connection");
            }
            if (!s_proto_buffer.equals("CMI_READY")) {
                this.clean();
                throw new SQLException("server rejected the connection");
            }
        }
        catch (Exception e) {
            throw this.convertException(e);
        }
    }

    public synchronized void connect(String user, String passwd) throws SQLException {
        MachStatement temp = new MachStatement(this.mcbConn, 1024);
        this.mcbConn.addStatement(temp);
        MachBuffer readBuf = temp.getReadBuffer();
        this.packet.clear();
        this.packet.skip(16);
        this.packet.writeProtocol(1L);
        this.packet.writeType(11L);
        this.packet.writeBytes(this.makeVersion(4, 0, 0));
        this.packet.writeProtocol(2L);
        this.packet.writeType(2L);
        this.packet.writeLength("JDBC".length());
        this.packet.writeString("JDBC");
        this.packet.writeProtocol(3L);
        this.packet.writeType(2L);
        String enc = this.mcbConn.getEncoding();
        this.packet.writeLength(enc.length());
        this.packet.writeString(enc);
        this.packet.writeProtocol(4L);
        this.packet.writeType(2L);
        this.packet.writeLength(this.mcbConn.getCatalog().length());
        this.packet.writeString(this.mcbConn.getCatalog());
        this.packet.writeProtocol(6L);
        this.packet.writeType(2L);
        this.packet.writeLength(user.length());
        this.packet.writeString(user);
        this.packet.writeProtocol(7L);
        this.packet.writeType(2L);
        this.packet.writeLength(passwd.length());
        this.packet.writeString(passwd);
        this.packet.writeProtocol(8L);
        this.packet.writeType(11L);
        this.packet.writeLong(3000000L);
        this.packet.writeProtocol(65L);
        this.packet.writeType(9L);
        this.packet.writeInt(this.mcbConn.getShowHiddenColumns());
        if (!this.mcbConn.getTimezoneStr().isEmpty()) {
            this.packet.writeProtocol(112L);
            this.packet.writeType(2L);
            this.packet.writeLength(this.mcbConn.getTimezoneStr().length());
            this.packet.writeString(this.mcbConn.getTimezoneStr());
        }
        this.packet.writePacketHeader(0L, 0, 1024);
        try {
            this.mcbOut.writeBytes(this.packet.getBuf(), this.packet.getCurrPos());
            this.mcbOut.flush();
            this.readFromSoc(false, temp.getStatementId());
            if (readBuf.getProtocol() == 1163022162L) {
                this.printError(readBuf);
            } else {
                if (readBuf.getProtocol() != 0L) {
                    Date today = new Date();
                    SimpleDateFormat dateformat = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
                    this.clean();
                    throw new SQLException(String.format("[" + dateformat.format(today) + "] " + "invalid protocol while connecting (%d)", readBuf.getProtocol()));
                }
                MachPacket pac = readBuf.readNext();
                while (pac != null) {
                    long protocol = pac.getProtocol();
                    long type = pac.getType();
                    if (protocol == 16L) {
                        this.checkResult(pac.getResult(), readBuf);
                    } else if (protocol == 1L) {
                        String cVer = pac.getVersion();
                        this.mcbConn.setVersion(cVer);
                    } else if (protocol == 9L) {
                        String cVer = pac.getString();
                    } else if (protocol == 5L) {
                        long cEndian = pac.getEndian();
                        this.mcbConn.setEndian(cEndian);
                    } else if (protocol == 64L) {
                        long cSessionId = pac.getSessionId();
                        this.mcbConn.setSessionId(cSessionId);
                    } else if (protocol != 17L && protocol != 80L) {
                        if (protocol == 112L) {
                            String cTimeZoneStr = pac.getTimeZone();
                            this.mcbConn.setTimezoneStr(cTimeZoneStr);
                            long cTimeZoneSec = this.mcbConn.convertTimeZone(cTimeZoneStr);
                            this.mcbConn.setTimezoneSec(cTimeZoneSec);
                        } else {
                            Date today = new Date();
                            SimpleDateFormat dateformat = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
                            this.clean();
                            throw new SQLException(String.format("[" + dateformat.format(today) + "] " + "invalid protocol while connecting (%d)", protocol));
                        }
                    }
                    pac = readBuf.readNext();
                }
            }
            temp.close();
        }
        catch (Exception e) {
            throw this.convertException(e);
        }
    }

    public void checkResult(MachResult result, MachBuffer readBuf) throws SQLException {
        if (result.getResult() != 1917799263L) {
            String msg = this.getErrorMessage(readBuf);
            throw new SQLException(String.format("[ERR-%05d: %s]", result.getErrorNo(), msg), "", (int)result.getErrorNo());
        }
    }

    public Socket getSocket() {
        return this.mcbSocket;
    }

    public byte[] makeVersion(int major, int minor, int patch) {
        byte[] bytes = new byte[8];
        bytes[0] = (byte)(major / 256);
        bytes[1] = (byte)(major % 256);
        bytes[2] = (byte)(minor / 256);
        bytes[3] = (byte)(minor % 256);
        int pos = 4;
        for (int i = 3; i >= 0; --i) {
            if (i > 0) {
                int size_t = patch >>> i * 8;
                bytes[pos++] = (byte)size_t;
                continue;
            }
            bytes[pos++] = (byte)patch;
        }
        return bytes;
    }

    public void setAppendTableName(String aAppendTableName) {
        this.appendTableName = aAppendTableName;
    }

    public String getAppendTableName() {
        return this.appendTableName;
    }

    public void setErrorCheckCount(long count) {
        this.errorCheckCount = count;
    }

    public long getErrorCheckCount() {
        return this.errorCheckCount;
    }

    public void increaseAppendAddCount() {
        ++this.appendAddCount;
    }

    public void setAppendAddCount(long count) {
        this.appendAddCount = count;
    }

    public long getAppendAddCount() {
        return this.appendAddCount;
    }

    public void setSuccessCount(long count) {
        this.successCount = count;
    }

    public long getSuccessCount() {
        return this.successCount;
    }

    public void setFailureCount(long count) {
        this.failureCount = count;
    }

    public long getFailureCount() {
        return this.failureCount;
    }

    public synchronized void clean() {
        if (this.mcbIn != null) {
            try {
                this.mcbIn.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.mcbIn = null;
        }
        if (this.mcbOut != null) {
            try {
                this.mcbOut.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.mcbOut = null;
        }
        if (this.mcbSocket != null) {
            try {
                this.mcbSocket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.mcbSocket = null;
        }
    }

    public synchronized void disconnect() throws SQLException {
        block15: {
            MachStatement temp = new MachStatement(this.mcbConn, this.mcbConn.getStmtMaxNum());
            this.mcbConn.addStatement(temp);
            MachBuffer readBuf = temp.getReadBuffer();
            try {
                this.packet.clear();
                this.packet.skip(16);
                this.packet.writeProtocol(8L);
                this.packet.writeType(11L);
                this.packet.writeLong(3000000L);
                this.packet.writePacketHeader(1L, 0, this.mcbConn.getStmtMaxNum());
                this.mcbOut.writeBytes(this.packet.getBuf(), this.packet.getCurrPos());
                this.mcbOut.flush();
                this.readFromSoc(true, temp.getStatementId());
                long rprotocol = readBuf.getProtocol();
                if (rprotocol == 1163022162L) {
                    this.printError(readBuf);
                } else {
                    if (rprotocol != 1L && rprotocol != 10L) {
                        Date today = new Date();
                        SimpleDateFormat dateformat = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
                        this.clean();
                        throw new SQLException(String.format("[" + dateformat.format(today) + "] " + "invalid protocol while disconnecting (%d)", rprotocol));
                    }
                    MachPacket pac = readBuf.readNext();
                    if (pac != null) {
                        long protocol = pac.getProtocol();
                        long type = pac.getType();
                        if (protocol == 16L) {
                            this.checkResult(pac.getResult(), readBuf);
                        }
                    }
                }
            }
            catch (SocketException ie) {
                try {
                    if (this.mcbConn.hostList.size() > 1 && this.checkAllSocket()) {
                        this.clean();
                        break block15;
                    }
                    throw this.convertException(ie);
                }
                catch (Exception e) {
                    throw this.convertException(e);
                }
            }
            catch (Exception e) {
                throw this.convertException(e);
            }
            finally {
                this.mcbConn.removeStatement(temp);
                this.mcbConn.returnStatementId(temp.getStatementId());
                this.clean();
            }
        }
    }

    public synchronized int execSQLinternal(MachStatement stmt, String sql) throws Exception {
        int id = stmt.getStatementId();
        this.mcbConn.writeLogWithDate(sql, id);
        stmt.setUseFlag(false);
        this.packet.clear();
        this.packet.skip(16);
        this.packet.writeProtocol(64L);
        this.packet.writeType(2L);
        this.packet.writeStringWithLen(sql, this.mcbConn.getEncoding());
        this.packet.writeProtocol(34L);
        this.packet.writeType(11L);
        this.packet.writeLong(id);
        this.packet.writePacketHeader(8L, 0, id);
        int ret = -1;
        this.mcbOut.writeBytes(this.packet.getBuf(), this.packet.getCurrPos());
        this.mcbOut.flush();
        MachResultSet rslt = new MachResultSet(stmt);
        ret = this.afterExec(8L, 35L, 36L, stmt, rslt, 0);
        stmt.setUseFlag(true);
        return ret;
    }

    public synchronized int reExecSQL(MachStatement stmt, String sql) throws SQLException {
        int id = stmt.getStatementId();
        int ret = -1;
        long start = System.currentTimeMillis();
        while (!this.checkAllSocket() && (double)(System.currentTimeMillis() - start) < (double)this.mcbConn.getConnectionTimeout() * 1000.0) {
        }
        try {
            ret = this.execSQLinternal(stmt, sql);
        }
        catch (SQLException se) {
            if (stmt.timeHandle != null) {
                stmt.timeHandle.cancel(false);
                stmt.scheduler.shutdown();
                stmt.timeHandle = null;
            }
            this.mcbConn.returnStatementId(id);
            throw this.convertException(se);
        }
        catch (Exception e) {
            if (stmt.timeHandle != null) {
                stmt.timeHandle.cancel(false);
                stmt.scheduler.shutdown();
                stmt.timeHandle = null;
            }
            this.mcbConn.returnStatementId(id);
            throw this.convertException(e);
        }
        return ret;
    }

    public synchronized int execSQL(MachStatement stmt, String sql) throws SQLException {
        int id = stmt.getStatementId();
        int ret = -1;
        try {
            ret = this.execSQLinternal(stmt, sql);
        }
        catch (SQLException se) {
            try {
                this.clean();
                this.connectSocket(null);
                this.init();
                this.connect(this.mcbConn.getUser(), this.mcbConn.getPassword());
                ret = this.reExecSQL(stmt, sql);
            }
            catch (Exception e) {
                throw this.convertException(e);
            }
        }
        catch (SocketException se) {
            try {
                this.clean();
                this.connectSocket(null);
                this.init();
                this.connect(this.mcbConn.getUser(), this.mcbConn.getPassword());
                ret = this.reExecSQL(stmt, sql);
            }
            catch (Exception e) {
                throw this.convertException(e);
            }
        }
        catch (Exception e) {
            if (stmt.timeHandle != null) {
                stmt.timeHandle.cancel(false);
                stmt.scheduler.shutdown();
                stmt.timeHandle = null;
            }
            this.mcbConn.returnStatementId(id);
            throw this.convertException(e);
        }
        return ret;
    }

    private MachTableMetaData getMetaData(long aExecProtocol, int count, MachStatement stmt) throws SQLException {
        long type;
        long protocol;
        MachTableMetaData tMetaData = new MachTableMetaData(this.mcbConn, count);
        MachBuffer readBuf = stmt.getReadBuffer();
        MachPacket pac = null;
        String tName = "";
        String cName = "";
        String sDateFormat = "";
        byte[] cType = null;
        if (aExecProtocol != 11L) {
            pac = readBuf.readNext();
            protocol = pac.getProtocol();
            type = pac.getType();
            if (protocol == 40L) {
                sDateFormat = pac.getString();
            }
        }
        for (int i = 0; i < count * 3; ++i) {
            pac = readBuf.readNext();
            protocol = pac.getProtocol();
            type = pac.getType();
            if (protocol == 37L || protocol == 37L || protocol == 37L) {
                tName = pac.getString();
                continue;
            }
            if (protocol == 38L || protocol == 38L || protocol == 38L) {
                cName = pac.getString();
                continue;
            }
            if (protocol != 39L && protocol != 39L && protocol != 39L) continue;
            cType = pac.getValue();
            tMetaData.addColumn(tName, cName, cType);
        }
        return tMetaData;
    }

    private MachTableMetaParam getMetaParam(long aExecProtocol, int aCount, MachStatement stmt) throws SQLException {
        MachTableMetaParam sMetaParam = new MachTableMetaParam(this.mcbConn, aCount);
        MachBuffer readBuf = stmt.getReadBuffer();
        MachPacket pac = null;
        byte[] cType = null;
        for (int i = 0; i < aCount; ++i) {
            pac = readBuf.readNext();
            long protocol = pac.getProtocol();
            long type = pac.getType();
            if (protocol != 41L && protocol != 41L && protocol != 41L) continue;
            cType = pac.getValue();
            sMetaParam.addParam(cType);
        }
        return sMetaParam;
    }

    public synchronized void execFetch(MachResultSet mcbResult, int colCount, long id) throws SQLException {
        MachBuffer readBuf = ((MachStatement)mcbResult.getStatement()).getReadBuffer();
        this.packet.clear();
        this.packet.skip(16);
        this.packet.writeProtocol(80L);
        this.packet.writeType(11L);
        this.packet.writeLong(id);
        this.packet.writeProtocol(81L);
        this.packet.writeType(11L);
        long fetchSize = mcbResult.getStatement().getFetchSize();
        this.packet.writeLong(fetchSize);
        this.packet.writePacketHeader(9L, 0, (int)id);
        int cnt = 0;
        boolean endFlag = false;
        try {
            this.mcbOut.writeBytes(this.packet.getBuf(), this.packet.getCurrPos());
            this.mcbOut.flush();
            mcbResult.setFetchComplete(false);
            block2: do {
                this.readFromSoc(false, (int)id);
                if (readBuf.getProtocol() == 1163022162L) {
                    this.printError(readBuf);
                    continue;
                }
                if (readBuf.getProtocol() != 9L) {
                    Date today;
                    if (readBuf.getProtocol() == 0L && readBuf.getBufLength() == 0) {
                        today = new Date();
                        SimpleDateFormat dateformat = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
                        throw new SQLException(String.format("[" + dateformat.format(today) + " sid:" + id + "] " + "Connect broker failure", "", 9043));
                    }
                    today = new Date();
                    SimpleDateFormat dateformat = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
                    throw new SQLException(String.format("[" + dateformat.format(today) + " sid:" + id + "] " + "invalid protocol while fetching (%d)", readBuf.getProtocol()));
                }
                MachPacket pac = readBuf.readNext();
                while (pac != null) {
                    long protocol = pac.getProtocol();
                    long type = pac.getType();
                    if (protocol == 16L) {
                        MachResult result = pac.getResult();
                        if (result.getResult() == 1917604692L) {
                            mcbResult.setFetchComplete(true);
                            endFlag = true;
                            continue block2;
                        }
                        if (result.getResult() != 1917799263L) {
                            String msg = this.getErrorMessage(readBuf);
                            throw new SQLException(String.format("[ERR-%05d: %s]", result.getErrorNo(), msg));
                        }
                    } else if (protocol == 82L) {
                        this.readRow(colCount, pac, mcbResult);
                        ++cnt;
                    } else if (protocol == 81L) {
                        int fetchCnt = (int)pac.getSLong();
                        if (fetchCnt > 0) {
                            endFlag = false;
                        } else if (fetchCnt == 0) {
                            endFlag = true;
                        }
                    }
                    pac = readBuf.readNext();
                }
            } while (!endFlag);
        }
        catch (Exception e) {
            throw this.convertException(e);
        }
    }

    public static String byteArrayToHex(byte[] ba) {
        if (ba == null || ba.length == 0) {
            return null;
        }
        StringBuffer sb = new StringBuffer(ba.length * 2);
        for (int x = 0; x < ba.length; ++x) {
            String hexNumber = "0" + Integer.toHexString(0xFF & ba[x]);
            sb.append(hexNumber.substring(hexNumber.length() - 2));
        }
        return sb.toString();
    }

    private synchronized void readRow(int colCount, MachPacket pac, MachResultSet mcbResult) throws SQLException {
        MachRow row = new MachRow(mcbResult.getEncoding());
        row.setSize(colCount);
        block14: for (int i = 0; i < colCount; ++i) {
            int type = mcbResult.getTableMetaData().getColumnType(i + 1);
            int len = mcbResult.getTableMetaData().getPrecision(i + 1);
            byte[] b = null;
            switch (type) {
                case 5: 
                case 49: 
                case 61: 
                case 97: {
                    b = pac.getBinary();
                    row.setColumn(i, type, b);
                    continue block14;
                }
                case 4: 
                case 40: {
                    b = pac.getQpdShort();
                    row.setColumn(i, type, b);
                    continue block14;
                }
                case 104: {
                    b = pac.getQpdUShort();
                    row.setColumn(i, type, b);
                    continue block14;
                }
                case 8: {
                    b = pac.getQpdInt();
                    row.setColumn(i, type, b);
                    continue block14;
                }
                case 108: {
                    b = pac.getQpdUInt();
                    row.setColumn(i, type, b);
                    continue block14;
                }
                case 12: {
                    b = pac.getQpdLong();
                    row.setColumn(i, type, b);
                    continue block14;
                }
                case 112: {
                    b = pac.getQpdULong();
                    row.setColumn(i, type, b);
                    continue block14;
                }
                case 16: {
                    b = pac.getQpdFloat();
                    row.setColumn(i, type, b);
                    continue block14;
                }
                case 20: {
                    b = pac.getQpdDouble();
                    row.setColumn(i, type, b);
                    continue block14;
                }
                case 6: {
                    b = pac.getDate();
                    row.setColumn(i, type, b);
                    continue block14;
                }
                case 32: {
                    b = pac.getIpv4();
                    row.setColumn(i, type, b);
                    continue block14;
                }
                case 36: {
                    b = pac.getIpv6();
                    row.setColumn(i, type, b);
                    continue block14;
                }
                default: {
                    System.out.format("unknown type : index=%d, type=%d\n", i, type);
                }
            }
        }
        mcbResult.addRow(row);
    }

    public synchronized int setPrepareStatement(MachPreparedStatement stmt, String sql, int id) throws SQLException {
        stmt.setUseFlag(false);
        this.packet.clear();
        this.packet.skip(16);
        this.packet.writeProtocol(34L);
        this.packet.writeType(11L);
        this.packet.writeLong(id);
        this.packet.writeProtocol(32L);
        this.packet.writeType(2L);
        this.packet.writeStringWithLen(sql, this.mcbConn.getEncoding());
        this.packet.writePacketHeader(6L, 0, id);
        int ret = -1;
        try {
            this.mcbOut.writeBytes(this.packet.getBuf(), this.packet.getCurrPos());
            this.mcbOut.flush();
            MachResultSet rslt = new MachResultSet(stmt);
            ret = this.afterExecForPrepare(stmt, rslt, 0);
            stmt.setUseFlag(true);
        }
        catch (Exception e) {
            throw this.convertException(e);
        }
        return ret;
    }

    public void writeBindingValues(MachBuffer packet, Vector bind_ins) {
        int sBindingCount = 0;
        byte[] tmp = null;
        int sWriteSize = 2;
        int sAlignSize = 0;
        int sGap = 0;
        Enumeration e = bind_ins.elements();
        packet.writeProtocol(49L);
        packet.writeType(3L);
        int cntPos = packet.getCurrPos();
        packet.skip(10);
        while (e.hasMoreElements()) {
            MachColumnData cdata = (MachColumnData)e.nextElement();
            if (cdata == null) continue;
            ++sBindingCount;
            tmp = cdata.getBindValue();
            packet.writeBytes2(tmp);
            if (tmp.length % 2 == 1) {
                sWriteSize += tmp.length + 1;
                continue;
            }
            sWriteSize += tmp.length;
        }
        if (sBindingCount > 0) {
            sAlignSize = sWriteSize + 7 & 0xFFFFFFF8;
            sGap = sAlignSize - sWriteSize;
            if (sGap > 0) {
                byte[] sTmp = new byte[sGap];
                packet.writeBytesOrgSize(sTmp);
            }
            packet.writeParamLength(cntPos, sAlignSize);
            packet.writeParamCnt(cntPos + 8, sBindingCount);
        }
    }

    public synchronized int execPrepareStatementInternal(MachPreparedStatement stmt, Vector bind_ins) throws Exception {
        this.packet.clear();
        this.packet.skip(16);
        this.packet.writeProtocol(34L);
        this.packet.writeType(11L);
        int id = stmt.getStatementId();
        this.packet.writeLong(id);
        this.writeBindingValues(this.packet, bind_ins);
        this.packet.writePacketHeader(7L, 0, id);
        int ret = -1;
        this.mcbOut.writeBytes(this.packet.getBuf(), this.packet.getCurrPos());
        this.mcbOut.flush();
        MachResultSet rslt = null;
        int col = 0;
        if (stmt.isSelect) {
            rslt = stmt.getRslt();
            if (rslt == null) {
                if (stmt.timeHandle != null) {
                    stmt.timeHandle.cancel(false);
                    stmt.scheduler.shutdown();
                    stmt.timeHandle = null;
                }
                throw new SQLException("data does not exist.");
            }
            col = rslt.getTableMetaData().getColumnCount();
        } else {
            rslt = new MachResultSet(stmt);
        }
        ret = this.afterExec(7L, 35L, 36L, stmt, rslt, col);
        return ret;
    }

    public synchronized int reExecPrepareStatement(MachPreparedStatement stmt, Vector bind_ins) throws SQLException {
        int ret = -1;
        long start = System.currentTimeMillis();
        while (!this.checkAllSocket() && (double)(System.currentTimeMillis() - start) < (double)this.mcbConn.getConnectionTimeout() * 1000.0) {
        }
        try {
            ret = this.execPrepareStatementInternal(stmt, bind_ins);
        }
        catch (Exception e) {
            if (stmt.timeHandle != null) {
                stmt.timeHandle.cancel(false);
                stmt.scheduler.shutdown();
                stmt.timeHandle = null;
            }
            throw this.convertException(e);
        }
        return ret;
    }

    public synchronized int execPrepareStatement(MachPreparedStatement stmt, Vector bind_ins) throws SQLException {
        int ret = -1;
        try {
            ret = this.execPrepareStatementInternal(stmt, bind_ins);
        }
        catch (SocketException e) {
            if (!this.checkSocket() && stmt.sqlStmt != null) {
                this.clean();
                this.connectSocket(null);
                this.init();
                this.connect(this.mcbConn.getUser(), this.mcbConn.getPassword());
                this.setPrepareStatement(stmt, stmt.sqlStmt.trim(), stmt.StatementId);
                ret = this.reExecPrepareStatement(stmt, bind_ins);
            }
            if (stmt.timeHandle != null) {
                stmt.timeHandle.cancel(false);
                stmt.scheduler.shutdown();
                stmt.timeHandle = null;
            }
            throw this.convertException(e);
        }
        catch (SQLException se) {
            if (se.getErrorCode() == 9042 && !this.checkSocket() && stmt.sqlStmt != null) {
                this.clean();
                this.connectSocket(null);
                this.init();
                this.connect(this.mcbConn.getUser(), this.mcbConn.getPassword());
                this.setPrepareStatement(stmt, stmt.sqlStmt.trim(), stmt.StatementId);
                ret = this.reExecPrepareStatement(stmt, bind_ins);
            }
            if (stmt.timeHandle != null) {
                stmt.timeHandle.cancel(false);
                stmt.scheduler.shutdown();
                stmt.timeHandle = null;
            }
            throw se;
        }
        catch (Exception e) {
            if (stmt.timeHandle != null) {
                stmt.timeHandle.cancel(false);
                stmt.scheduler.shutdown();
                stmt.timeHandle = null;
            }
            throw this.convertException(e);
        }
        return ret;
    }

    public synchronized int afterExec(long execP, long rowP, long columnP, MachStatement stmt, MachResultSet rslt, int colCount) throws SQLException {
        MachBuffer readBuf = stmt.getReadBuffer();
        int ret = -1;
        this.readFromSoc(false, stmt.getStatementId());
        long rprotocol = readBuf.getProtocol();
        int id = stmt.getStatementId();
        if (rprotocol == 1163022162L) {
            this.printError(readBuf);
        } else {
            if (rprotocol != execP) {
                Date today = new Date();
                SimpleDateFormat dateformat = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
                throw new SQLException(String.format("[" + dateformat.format(today) + " sid:" + id + "] " + "invalid protocol after executing(%d != %d)\n", execP, rprotocol), "08S01", 9042);
            }
            MachPacket pac = readBuf.readNext();
            String tName = "";
            String cName = "";
            Object cType = null;
            while (pac != null) {
                long protocol = pac.getProtocol();
                long type = pac.getType();
                if (protocol == 16L) {
                    if (pac.getResult().getErrorNo() == 7043L) {
                        this.appendErrorNo = 7043L;
                    } else {
                        this.appendErrorNo = -1L;
                        this.checkResult(pac.getResult(), readBuf);
                    }
                } else if (protocol == rowP) {
                    int count = pac.getCount();
                    rslt.setUpdateCount(count);
                    stmt.addResultSet(rslt);
                    ret = 0;
                } else if (protocol == 33L) {
                    int count = pac.getCount();
                    MachPreparedStatement st = (MachPreparedStatement)stmt;
                    st.setParamsCount(count);
                } else if (protocol == columnP) {
                    colCount = pac.getCount();
                    MachTableMetaData tMetaData = this.getMetaData(execP, colCount, stmt);
                    rslt.setTableMetaData(tMetaData);
                    stmt.addResultSet(rslt);
                    ret = 1;
                } else if (protocol == 81L) {
                    this.exec_n_fetch(rslt, colCount);
                    ret = 1;
                } else if (protocol == 50L) {
                    this.bindOutParam(pac, (MachCallableStatement)stmt);
                } else if (protocol == 17L) {
                    String errMsg = pac.getString();
                    this.processAppendError(0L, errMsg, null);
                }
                pac = readBuf.readNext();
            }
        }
        return ret;
    }

    public synchronized int afterExecForPrepare(MachStatement stmt, MachResultSet rslt, int colCount) throws SQLException {
        MachBuffer readBuf = stmt.getReadBuffer();
        int ret = -1;
        this.readFromSoc(false, stmt.getStatementId());
        long rprotocol = readBuf.getProtocol();
        if (rprotocol == 1163022162L) {
            this.printError(readBuf);
        } else {
            if (rprotocol != 6L) {
                throw new SQLException(String.format("invalid protocol after executing(%d != %d)\n", 6L, rprotocol), "08S01", 9042);
            }
            MachPacket pac = readBuf.readNext();
            String tName = "";
            String cName = "";
            Object cType = null;
            while (pac != null) {
                long protocol = pac.getProtocol();
                long type = pac.getType();
                if (protocol == 16L) {
                    this.checkResult(pac.getResult(), readBuf);
                } else if (protocol == 33L) {
                    int paramCount = pac.getCount();
                    MachPreparedStatement st = (MachPreparedStatement)stmt;
                    MachTableMetaParam tMetaParam = this.getMetaParam(6L, paramCount, stmt);
                    rslt.setTableMetaParam(tMetaParam);
                    st.setParamsCount(paramCount);
                } else if (protocol == 36L) {
                    colCount = pac.getCount();
                    MachTableMetaData tMetaData = this.getMetaData(6L, colCount, stmt);
                    rslt.setTableMetaData(tMetaData);
                    stmt.addResultSet(rslt);
                    ret = 1;
                }
                pac = readBuf.readNext();
            }
        }
        return ret;
    }

    private void bindOutParam(MachPacket pac, MachCallableStatement stmt) throws SQLException {
        MachRow row = new MachRow();
        int colCount = pac.readUShortNoCnt();
        row.setSize(stmt.getParamsCount());
        block5: for (int i = 0; i < colCount; ++i) {
            int type = pac.readByte();
            int idx = pac.readByte() - 1;
            if (type == 24) {
                row.setColumn(idx, type, null);
                continue;
            }
            int len = pac.readUShortNoCnt();
            int alloc_size = pac.readUShortNoCnt();
            switch (type) {
                case 5: 
                case 49: 
                case 61: {
                    byte[] b = pac.getBytesValue(alloc_size, alloc_size);
                    row.setColumn(idx, type, b);
                    continue block5;
                }
                case 6: {
                    byte[] b = pac.getBytesValue(alloc_size, alloc_size);
                    row.setColumn(idx, type, b);
                    continue block5;
                }
                case 4: 
                case 8: 
                case 12: 
                case 16: 
                case 20: 
                case 40: {
                    byte[] b = pac.getBytesValue(len, alloc_size);
                    row.setColumn(idx, type, b);
                    continue block5;
                }
            }
        }
        stmt.setOutParams(row);
    }

    public void exec_n_fetch(MachResultSet rslt, int colCount) throws SQLException {
        MachBuffer readBuf = ((MachStatement)rslt.getStatement()).getReadBuffer();
        MachPacket pac = readBuf.readNext();
        while (pac != null) {
            long protocol = pac.getProtocol();
            long type = pac.getType();
            if (protocol == 16L) {
                MachResult result = pac.getResult();
                if (result.getResult() == 1917604692L) {
                    rslt.setFetchComplete(true);
                    break;
                }
                if (result.getResult() != 1917799263L) {
                    String msg = this.getErrorMessage(readBuf);
                    throw new SQLException(String.format("[ERR-%05d: %s]", result.getErrorNo(), msg));
                }
            } else if (protocol == 82L) {
                this.readRow(colCount, pac, rslt);
            }
            pac = readBuf.readNext();
        }
    }

    public synchronized void execDirect(String sql) throws SQLException {
        MachStatement temp = (MachStatement)this.mcbConn.createStatement();
        MachBuffer readBuf = temp.getReadBuffer();
        int id = temp.getStatementId();
        this.mcbConn.writeLogWithDate(sql, id);
        this.packet.clear();
        this.packet.skip(16);
        this.packet.writeProtocol(64L);
        this.packet.writeType(2L);
        this.packet.writeStringWithLen(sql, this.mcbConn.getEncoding());
        this.packet.writeProtocol(34L);
        this.packet.writeType(11L);
        this.packet.writeLong(id);
        this.packet.writePacketHeader(8L, 0, id);
        try {
            this.mcbOut.writeBytes(this.packet.getBuf(), this.packet.getCurrPos());
            this.mcbOut.flush();
            this.readFromSoc(false, id);
            if (readBuf.getProtocol() == 1163022162L) {
                this.printError(readBuf);
                return;
            }
            if (readBuf.getProtocol() != 8L) {
                Date today = new Date();
                SimpleDateFormat dateformat = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
                throw new SQLException(String.format("[" + dateformat.format(today) + " sid:" + id + "] " + "invalid protocol while execdirect (%d)", readBuf.getProtocol()));
            }
            MachPacket pac = readBuf.readNext();
            while (pac != null) {
                long protocol = pac.getProtocol();
                long type = pac.getType();
                if (protocol == 16L) {
                    this.checkResult(pac.getResult(), readBuf);
                }
                pac = readBuf.readNext();
            }
        }
        catch (Exception e) {
            throw this.convertException(e);
        }
        try {
            temp.close();
        }
        catch (Exception e) {
            throw this.convertException(e);
        }
    }

    public synchronized void close(int stmtId) throws SQLException {
        block13: {
            MachBuffer readBuf = ((MachStatement)this.mcbConn.getStatement(stmtId)).getReadBuffer();
            readBuf.clear();
            this.packet.clear();
            this.packet.skip(16);
            this.packet.writeProtocol(96L);
            this.packet.writeType(11L);
            this.packet.writeLong(stmtId);
            this.packet.writePacketHeader(10L, 0, stmtId);
            try {
                this.mcbOut.writeBytes(this.packet.getBuf(), this.packet.getCurrPos());
                this.mcbOut.flush();
                this.readFromSoc(true, stmtId);
                long rProtocol = readBuf.getProtocol();
                if (rProtocol == 1163022162L) {
                    this.printError(readBuf);
                } else {
                    if (rProtocol != 10L) {
                        Date today = new Date();
                        SimpleDateFormat dateformat = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
                        throw new SQLException(String.format("[" + dateformat.format(today) + " sid:" + stmtId + "] " + "invalid protocol while closing (%d)", rProtocol));
                    }
                    MachPacket pac = readBuf.readNext();
                    if (pac != null) {
                        long protocol = pac.getProtocol();
                        long type = pac.getType();
                        if (protocol == 16L) {
                            this.checkResult(pac.getResult(), readBuf);
                        }
                    }
                }
            }
            catch (SocketException ie) {
                if (this.mcbConn.hostList.size() > 1 && this.checkAllSocket()) {
                    break block13;
                }
                throw this.convertException(ie);
            }
            catch (IOException e) {
                throw this.convertException(e, "", 9043, "Connect broker failure");
            }
            finally {
                readBuf.clear();
            }
        }
    }

    public synchronized int appendOpen(MachStatement stmt, String aTableName, int aErrorCheckCount) throws SQLException {
        stmt.setUseFlag(false);
        this.columns = 0;
        this.oneRowLen = 0;
        this.errorCheckCount = 0L;
        this.appendAddCount = 0L;
        this.successCount = 0L;
        this.failureCount = 0L;
        this.appendErrorNo = -1L;
        this.packet.clear();
        this.packet.skip(16);
        this.packet.writeProtocol(34L);
        this.packet.writeType(11L);
        int id = stmt.getStatementId();
        this.packet.writeLong(id);
        this.packet.writeProtocol(37L);
        this.packet.writeType(2L);
        this.packet.writeStringWithLen(aTableName, this.mcbConn.getEncoding());
        this.packet.writeProtocol(52L);
        this.packet.writeType(11L);
        this.packet.writeLong(1L);
        this.packet.writePacketHeader(11L, 0, id);
        int ret = -1;
        try {
            this.mcbOut.writeBytes(this.packet.getBuf(), this.packet.getCurrPos());
            this.mcbOut.flush();
            int cols = 0;
            MachResultSet rslt = new MachResultSet(stmt);
            ret = this.afterExec(11L, 35L, 36L, stmt, rslt, cols);
            if (ret != -1) {
                this.setAppendTableName(aTableName);
                this.setErrorCheckCount(aErrorCheckCount);
                this.packet.clear();
                this.packet.skip(16);
                this.packet.writeProtocol(34L);
                this.packet.writeType(11L);
                this.packet.writeLong(id);
            } else if (this.appendErrorNo == 7043L) {
                this.appendErrorNo = -1L;
                this.clean();
                if (this.mcbConn.hostList.size() > 1) {
                    this.connectSocket(String.valueOf(this.hostIndex));
                } else {
                    this.connectSocket(null);
                }
                this.init();
                this.connect(this.mcbConn.getUser(), this.mcbConn.getPassword());
                ret = this.appendOpen(stmt, aTableName, aErrorCheckCount);
            }
            stmt.setUseFlag(false);
        }
        catch (Exception e) {
            throw this.convertException(e);
        }
        return ret;
    }

    public synchronized int setAppendErrorCallback(MachStatement stmt, MachAppendCallback cb) throws SQLException {
        this.callback = cb;
        return 1;
    }

    public synchronized int processAppendError(long aErrNo, String aErrMsg, String aRowMsg) throws SQLException {
        if (this.callback != null) {
            this.callback.onAppendError(aErrNo, aErrMsg, aRowMsg);
        }
        return 1;
    }

    public synchronized int checkAppendErrorAndProcess(MachStatement stmt) throws SQLException {
        block12: {
            MachBuffer readBuf = stmt.getReadBuffer();
            long errNo = 0L;
            String errMsg = null;
            String rowMsg = null;
            boolean ret = false;
            try {
                if (this.mcbIn.isReadable() <= 0) break block12;
                this.readFromSoc(false, stmt.getStatementId());
                MachPacket pac = readBuf.readNext();
                while (pac != null) {
                    long protocol = pac.getProtocol();
                    long type = pac.getType();
                    if (protocol == 16L) {
                        MachResult result = pac.getResult();
                        if (result.getResult() != 1917799263L) {
                            errNo = result.getErrorNo();
                        }
                    } else if (protocol == 17L) {
                        errMsg = pac.getString();
                    } else if (protocol == 18L) {
                        rowMsg = pac.getString();
                    }
                    pac = readBuf.readNext();
                }
                this.processAppendError(errNo, errMsg, rowMsg);
                this.appendErrorNo = errNo;
                if (errNo != 0L) {
                    System.out.format("append Error (%d:%s:%s)\n", errNo, errMsg, rowMsg);
                    break block12;
                }
                if (errNo == 0L || this.checkSocket() || this.getAppendTableName() == null) break block12;
                this.clean();
                this.connectSocket(null);
                this.init();
                this.connect(this.mcbConn.getUser(), this.mcbConn.getPassword());
                this.appendOpen(stmt, this.getAppendTableName(), (int)this.getErrorCheckCount());
            }
            catch (Exception e) {
                throw this.convertException(e);
            }
        }
        return 1;
    }

    public synchronized int appendFlush(MachStatement stmt) throws SQLException {
        if (this.getAppendAddCount() > 0L) {
            this.packet.writePacketHeader(12L, 0, stmt.getStatementId());
            try {
                this.mcbOut.writeBytes(this.packet.getBuf(), this.packet.getCurrPos());
                this.mcbOut.flush();
                this.checkAppendErrorAndProcess(stmt);
                this.packet.clear();
                this.packet.skip(16);
                this.packet.writeProtocol(34L);
                this.packet.writeType(11L);
                this.packet.writeLong(stmt.getStatementId());
                this.setAppendAddCount(0L);
            }
            catch (Exception e) {
                throw this.convertException(e);
            }
        }
        return 1;
    }

    public synchronized int appendFlushNoErrCheck(MachStatement stmt) throws SQLException {
        if (this.getAppendAddCount() > 0L) {
            this.packet.writePacketHeader(12L, 0, stmt.getStatementId());
            try {
                this.mcbOut.writeBytes(this.packet.getBuf(), this.packet.getCurrPos());
                this.mcbOut.flush();
                this.packet.clear();
                this.packet.skip(16);
                this.packet.writeProtocol(34L);
                this.packet.writeType(11L);
                this.packet.writeLong(stmt.getStatementId());
                this.setAppendAddCount(0L);
            }
            catch (Exception e) {
                throw this.convertException(e);
            }
        }
        return 1;
    }

    public synchronized boolean appendWriteBinary(MachResultSetMetaData aRsmd, ArrayList aData, long aTime) throws SQLException {
        Integer sColumnsCount;
        int sDiffCount;
        if (this.columns == 0) {
            try {
                this.columns = aRsmd.getColumnCount();
                for (int i = 1; i <= this.columns; ++i) {
                    this.columnType[i - 1] = aRsmd.getColumnTypeForAppend(i);
                    this.columnPrecision[i - 1] = aRsmd.getPrecision(i);
                    this.oneRowLen += this.columnPrecision[i - 1];
                }
            }
            catch (SQLException se) {
                System.err.println("SQLException : " + se.getMessage());
            }
        }
        if ((sDiffCount = (sColumnsCount = Integer.valueOf(this.columns - 1)) - aData.size()) != 0 && sDiffCount < 0) {
            throw new SQLException(String.format("column counts differ.(%d != %d)\n", (int)sColumnsCount, aData.size()));
        }
        int loop = 0;
        int writeCnt = 0;
        Object tmp = null;
        this.packet.writeProtocol(35L);
        this.packet.writeType(3L);
        int cntPos = this.packet.getCurrPos();
        this.packet.skip(8);
        this.packet.appendByte((byte)0);
        ++writeCnt;
        int sNullBitSize = sColumnsCount / 8;
        if (sColumnsCount % 8 > 0) {
            ++sNullBitSize;
        }
        if (this.mcbConn.getEndian() == 1L) {
            this.packet.appendUInt(sNullBitSize);
        } else {
            this.packet.appendUInt(this.packet.swap(sNullBitSize));
        }
        writeCnt += 4;
        this.packet.assignNullBitArray(sColumnsCount, sNullBitSize);
        writeCnt += sNullBitSize;
        long arrival_dt = aTime;
        if (arrival_dt == 0L) {
            this.packet.writeDate(arrival_dt);
        } else if (this.mcbConn.getEndian() == 1L) {
            this.packet.writeDate(arrival_dt);
        } else {
            this.packet.writeDate(this.packet.swap(arrival_dt));
        }
        writeCnt += this.columnPrecision[0];
        loop = 1;
        SimpleDateFormat sSdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss SSS");
        TimeZone tmpTimezone = TimeZone.getDefault();
        tmpTimezone.setRawOffset((int)(this.mcbConn.getTimezoneSec() * 1000L));
        sSdf.setTimeZone(tmpTimezone);
        for (Object data : aData) {
            if (data == null) {
                this.packet.setNullBitArray(loop);
            } else {
                switch (this.columnType[loop]) {
                    case -2: {
                        byte[] temp = new byte[1];
                        try {
                            InputStream sInTmp = (InputStream)data;
                            int sBinLen = sInTmp.available();
                            temp = new byte[sBinLen];
                            sInTmp.read(temp, 0, sBinLen);
                        }
                        catch (IOException ex) {
                            System.err.println("binary read error");
                        }
                        if (this.mcbConn.getEndian() == 1L) {
                            this.packet.appendInt(temp.length);
                        } else {
                            this.packet.appendInt(this.packet.swap(temp.length));
                        }
                        this.packet.writeBytesOrgSize(temp);
                        writeCnt += temp.length + 4;
                        break;
                    }
                    case 12: 
                    case 2110: 
                    case 2111: {
                        String tmpStr = data.toString();
                        byte[] temp = null;
                        if (tmpStr.length() > this.columnPrecision[loop]) {
                            tmpStr = tmpStr.substring(0, this.columnPrecision[loop]);
                        }
                        temp = tmpStr.getBytes();
                        if (this.mcbConn.getEndian() == 1L) {
                            this.packet.appendInt(temp.length);
                        } else {
                            this.packet.appendInt(this.packet.swap(temp.length));
                        }
                        this.packet.writeBytesOrgSize(temp);
                        writeCnt += temp.length + 4;
                        break;
                    }
                    case 5: {
                        short temp = data instanceof Short ? ((Short)data).shortValue() : Short.valueOf((String)data).shortValue();
                        if (this.mcbConn.getEndian() == 1L) {
                            this.packet.appendShort(temp);
                        } else {
                            this.packet.appendShort(this.packet.swap(temp));
                        }
                        writeCnt += this.columnPrecision[loop];
                        break;
                    }
                    case 2201: {
                        int temp = data instanceof Integer ? ((Integer)data).intValue() : Integer.valueOf((String)data).intValue();
                        if (this.mcbConn.getEndian() == 1L) {
                            this.packet.appendUShort((short)temp);
                        } else {
                            this.packet.appendUShort(this.packet.swap((short)temp));
                        }
                        writeCnt += this.columnPrecision[loop];
                        break;
                    }
                    case 4: {
                        int temp = data instanceof Integer ? ((Integer)data).intValue() : Integer.valueOf((String)data).intValue();
                        if (this.mcbConn.getEndian() == 1L) {
                            this.packet.appendInt(temp);
                        } else {
                            this.packet.appendInt(this.packet.swap(temp));
                        }
                        writeCnt += this.columnPrecision[loop];
                        break;
                    }
                    case 2202: {
                        long temp = data instanceof Long ? ((Long)data).longValue() : Long.valueOf((String)data).longValue();
                        if (this.mcbConn.getEndian() == 1L) {
                            this.packet.appendUInt((int)temp);
                        } else {
                            this.packet.appendUInt(this.packet.swap((int)temp));
                        }
                        writeCnt += this.columnPrecision[loop];
                        break;
                    }
                    case -5: {
                        long temp = data instanceof Long ? ((Long)data).longValue() : Long.valueOf((String)data).longValue();
                        if (this.mcbConn.getEndian() == 1L) {
                            this.packet.appendLong(temp);
                        } else {
                            this.packet.appendLong(this.packet.swap(temp));
                        }
                        writeCnt += this.columnPrecision[loop];
                        break;
                    }
                    case 2203: {
                        if (data.equals("-1")) {
                            this.packet.setNullBitArray(loop);
                            break;
                        }
                        BigInteger temp = null;
                        temp = data instanceof BigInteger ? (BigInteger)data : new BigInteger((String)data);
                        if (this.mcbConn.getEndian() == 1L) {
                            this.packet.appendULong(temp, false);
                        } else {
                            this.packet.appendULong(temp, true);
                        }
                        writeCnt += this.columnPrecision[loop];
                        break;
                    }
                    case 6: {
                        float temp = data instanceof Float ? ((Float)data).floatValue() : Float.valueOf((String)data).floatValue();
                        if (this.mcbConn.getEndian() == 1L) {
                            this.packet.appendFloat(temp);
                        } else {
                            this.packet.appendFloat(this.packet.swap(temp));
                        }
                        writeCnt += this.columnPrecision[loop];
                        break;
                    }
                    case 8: {
                        double temp = data instanceof Double ? ((Double)data).doubleValue() : Double.valueOf((String)data).doubleValue();
                        if (this.mcbConn.getEndian() == 1L) {
                            this.packet.writeDouble(temp);
                        } else {
                            this.packet.writeDouble(this.packet.swap(temp));
                        }
                        writeCnt += this.columnPrecision[loop];
                        break;
                    }
                    case 91: {
                        long temp = data instanceof Long ? ((Long)data).longValue() : Long.valueOf(data.toString()).longValue();
                        if (this.mcbConn.getEndian() == 1L) {
                            this.packet.writeDate(temp);
                        } else {
                            this.packet.writeDate(this.packet.swap(temp));
                        }
                        writeCnt += this.columnPrecision[loop];
                        break;
                    }
                    case 93: {
                        long temp = -1L;
                        if (data instanceof Long) {
                            temp = (Long)data;
                        } else {
                            try {
                                Date timestamp = sSdf.parse((String)data);
                                temp = timestamp.getTime() * 1000000L;
                            }
                            catch (ParseException te) {
                                te.printStackTrace();
                            }
                        }
                        if (this.mcbConn.getEndian() == 1L) {
                            this.packet.writeDate(temp);
                        } else {
                            this.packet.writeDate(this.packet.swap(temp));
                        }
                        writeCnt += this.columnPrecision[loop];
                        break;
                    }
                    case 2104: {
                        this.packet.writeIpv4(data.toString());
                        writeCnt += this.columnPrecision[loop];
                        break;
                    }
                    case 2106: {
                        this.packet.writeIpv6(data.toString());
                        writeCnt += this.columnPrecision[loop];
                        break;
                    }
                    default: {
                        System.out.format("unknown type : index=%d, type=%d\n", loop, this.columnType[loop]);
                    }
                }
            }
            ++loop;
        }
        while (loop <= sColumnsCount) {
            switch (this.columnType[loop]) {
                case -2: 
                case 9: 
                case 10: 
                case 12: 
                case 2110: 
                case 2111: {
                    this.packet.setNullBitArray(loop);
                    break;
                }
                case 5: {
                    short temp = 0;
                    if (this.mcbConn.getEndian() == 1L) {
                        this.packet.appendShort(temp);
                    } else {
                        this.packet.appendShort(this.packet.swap(temp));
                    }
                    writeCnt += this.columnPrecision[loop];
                    break;
                }
                case 4: 
                case 2201: {
                    int temp = 0;
                    if (this.mcbConn.getEndian() == 1L) {
                        this.packet.appendInt(temp);
                    } else {
                        this.packet.appendInt(this.packet.swap(temp));
                    }
                    writeCnt += this.columnPrecision[loop];
                    break;
                }
                case -5: 
                case 2202: 
                case 2203: {
                    long temp = 0L;
                    if (this.mcbConn.getEndian() == 1L) {
                        this.packet.appendLong(temp);
                    } else {
                        this.packet.appendLong(this.packet.swap(temp));
                    }
                    writeCnt += this.columnPrecision[loop];
                    break;
                }
                case 6: {
                    float temp = 0.0f;
                    if (this.mcbConn.getEndian() == 1L) {
                        this.packet.appendFloat(temp);
                    } else {
                        this.packet.appendFloat(this.packet.swap(temp));
                    }
                    writeCnt += this.columnPrecision[loop];
                    break;
                }
                case 8: {
                    double temp = 0.0;
                    if (this.mcbConn.getEndian() == 1L) {
                        this.packet.writeDouble(temp);
                    } else {
                        this.packet.writeDouble(this.packet.swap(temp));
                    }
                    writeCnt += this.columnPrecision[loop];
                    break;
                }
                case 91: 
                case 93: {
                    long temp = 0L;
                    if (this.mcbConn.getEndian() == 1L) {
                        this.packet.writeDate(temp);
                    } else {
                        this.packet.writeDate(this.packet.swap(temp));
                    }
                    writeCnt += this.columnPrecision[loop];
                    break;
                }
                default: {
                    System.out.format("unknown type : index=%d, type=%d\n", loop, this.columnType[loop]);
                    this.packet.setNullBitArray(loop);
                }
            }
            ++loop;
        }
        if (loop > 0) {
            this.packet.writeParamLength(cntPos, writeCnt);
        }
        this.increaseAppendAddCount();
        return this.packet.getCurrPos() + 20 <= 65536;
    }

    public synchronized int appendData(MachStatement stmt, MachResultSetMetaData aRsmd, ArrayList aData) throws SQLException {
        int ret = 1;
        if (!this.appendWriteBinary(aRsmd, aData, 0L)) {
            this.packet.writePacketHeader(12L, 0, stmt.getStatementId());
            try {
                this.mcbOut.writeBytes(this.packet.getBuf(), this.packet.getCurrPos());
                this.mcbOut.flush();
                this.checkAppendErrorAndProcess(stmt);
                this.setAppendAddCount(0L);
                this.packet.clear();
                this.packet.skip(16);
                this.packet.writeProtocol(34L);
                this.packet.writeType(11L);
                int id = stmt.getStatementId();
                this.packet.writeLong(id);
            }
            catch (SocketException se) {
                if (this.getAppendTableName() != null) {
                    MachBuffer tempPacket = this.packet;
                    this.clean();
                    this.connectSocket(null);
                    this.init();
                    this.connect(this.mcbConn.getUser(), this.mcbConn.getPassword());
                    this.appendOpen(stmt, this.getAppendTableName(), (int)this.getErrorCheckCount());
                    try {
                        this.mcbOut.writeBytes(tempPacket.getBuf(), tempPacket.getCurrPos());
                        this.mcbOut.flush();
                        this.checkAppendErrorAndProcess(stmt);
                        this.setAppendAddCount(0L);
                    }
                    catch (Exception ee) {
                        throw this.convertException(ee);
                    }
                }
                throw this.convertException(se);
            }
            catch (Exception e) {
                throw this.convertException(e);
            }
        }
        if (this.appendErrorNo == 7043L) {
            this.appendFlushNoErrCheck(stmt);
            this.appendClose(stmt);
            this.clean();
            if (this.mcbConn.hostList.size() > 1) {
                this.connectSocket(String.valueOf(this.hostIndex));
            } else {
                this.connectSocket(null);
            }
            this.init();
            this.connect(this.mcbConn.getUser(), this.mcbConn.getPassword());
            this.appendOpen(stmt, this.getAppendTableName(), (int)this.getErrorCheckCount());
            this.appendErrorNo = -1L;
        }
        return ret;
    }

    public synchronized int appendDataByTime(MachStatement stmt, MachResultSetMetaData aRsmd, long aTime, ArrayList aData) throws SQLException {
        int ret = 1;
        if (!this.appendWriteBinary(aRsmd, aData, aTime)) {
            this.packet.writePacketHeader(12L, 0, stmt.getStatementId());
            try {
                this.mcbOut.writeBytes(this.packet.getBuf(), this.packet.getCurrPos());
                this.mcbOut.flush();
                this.checkAppendErrorAndProcess(stmt);
                this.setAppendAddCount(0L);
                this.packet.clear();
                this.packet.skip(16);
                this.packet.writeProtocol(34L);
                this.packet.writeType(11L);
                int id = stmt.getStatementId();
                this.packet.writeLong(id);
            }
            catch (SocketException se) {
                if (this.getAppendTableName() != null) {
                    MachBuffer tempPacket = this.packet;
                    this.clean();
                    this.connectSocket(null);
                    this.init();
                    this.connect(this.mcbConn.getUser(), this.mcbConn.getPassword());
                    this.appendOpen(stmt, this.getAppendTableName(), (int)this.getErrorCheckCount());
                    try {
                        this.mcbOut.writeBytes(tempPacket.getBuf(), tempPacket.getCurrPos());
                        this.mcbOut.flush();
                        this.checkAppendErrorAndProcess(stmt);
                        this.setAppendAddCount(0L);
                    }
                    catch (Exception ee) {
                        throw this.convertException(ee);
                    }
                }
                throw this.convertException(se);
            }
            catch (Exception e) {
                throw this.convertException(e);
            }
        }
        if (this.appendErrorNo == 7043L) {
            this.appendFlushNoErrCheck(stmt);
            this.appendClose(stmt);
            this.clean();
            if (this.mcbConn.hostList.size() > 1) {
                this.connectSocket(String.valueOf(this.hostIndex));
            } else {
                this.connectSocket(null);
            }
            this.init();
            this.connect(this.mcbConn.getUser(), this.mcbConn.getPassword());
            this.appendOpen(stmt, this.getAppendTableName(), (int)this.getErrorCheckCount());
            this.appendErrorNo = -1L;
        }
        return ret;
    }

    public synchronized int appendClose(MachStatement stmt) throws SQLException {
        MachBuffer readBuf = stmt.getReadBuffer();
        int id = stmt.getStatementId();
        long returnProtocol = -1L;
        if (this.getAppendAddCount() > 0L) {
            this.packet.writePacketHeader(12L, 0, id);
            try {
                this.mcbOut.writeBytes(this.packet.getBuf(), this.packet.getCurrPos());
                this.mcbOut.flush();
                this.setAppendAddCount(0L);
            }
            catch (Exception e) {
                throw this.convertException(e);
            }
        }
        this.packet.clear();
        this.packet.skip(16);
        this.packet.writeProtocol(34L);
        this.packet.writeType(11L);
        this.packet.writeLong(id);
        this.packet.writePacketHeader(13L, 0, id);
        int ret = -1;
        try {
            this.mcbOut.writeBytes(this.packet.getBuf(), this.packet.getCurrPos());
            this.mcbOut.flush();
            while (true) {
                this.readFromSoc(false, id);
                returnProtocol = readBuf.getProtocol();
                if (returnProtocol != 12L) break;
                readBuf.readNext();
            }
            if (returnProtocol == 1163022162L) {
                this.printError(readBuf);
            } else if (returnProtocol == 4L) {
                System.err.println("return timeout protocol while append close");
            } else if (returnProtocol == 13L) {
                MachPacket pac = readBuf.readNext();
                while (pac != null) {
                    long protocol = pac.getProtocol();
                    long type = pac.getType();
                    if (protocol == 16L) {
                        this.checkResult(pac.getResult(), readBuf);
                    } else if (protocol == 97L) {
                        this.setSuccessCount(pac.getSuccessCount());
                    } else if (protocol == 98L) {
                        this.setFailureCount(pac.getFailureCount());
                    }
                    pac = readBuf.readNext();
                }
            } else {
                System.err.println("return invalid protocol while append close");
            }
            ret = 1;
        }
        catch (Exception e) {
            throw this.convertException(e);
        }
        return ret;
    }

    public synchronized int executeAppendBatchByTimeInternal(MachStatement stmt, String aTableName, long aTime, ArrayList aTypes, ArrayList aData) throws SQLException {
        int ret = 1;
        int id = stmt.getStatementId();
        byte[] sTypes = new byte[aTypes.size()];
        try {
            stmt.setUseFlag(false);
            this.packet.clear();
            this.packet.skip(16);
            this.packet.writeProtocol(34L);
            this.packet.writeType(11L);
            this.packet.writeLong(id);
            this.packet.writeProtocol(37L);
            this.packet.writeType(2L);
            this.packet.writeStringWithLen(aTableName, this.mcbConn.getEncoding());
            this.packet.writeProtocol(32L);
            this.packet.writeType(3L);
            this.columns = aTypes.size() + 1;
            this.columnType[0] = this.getColumnTypeForAppendAll(11);
            this.columnPrecision[0] = this.getPrecisionForAppendAll(11);
            this.oneRowLen += this.columnPrecision[0];
            for (int i = 0; i < aTypes.size(); ++i) {
                this.columnType[i + 1] = this.getColumnTypeForAppendAll((Integer)aTypes.get(i));
                this.columnPrecision[i + 1] = this.getPrecisionForAppendAll((Integer)aTypes.get(i));
                this.oneRowLen += this.columnPrecision[i + 1];
                int sTemp = (Integer)aTypes.get(i);
                sTypes[i] = (byte)sTemp;
            }
            this.packet.writeLength(aTypes.size());
            this.packet.writeBytes(sTypes);
            this.packet.writeProtocol(35L);
            this.packet.writeType(3L);
            int cntPos = this.packet.getCurrPos();
            this.packet.skip(8);
            int writeCnt = 0;
            for (int i = 0; i < aData.size(); ++i) {
                ArrayList aDataRow = (ArrayList)aData.get(i);
                writeCnt += this.appendAllWriteBinary(aTypes, aDataRow, aTime);
                this.increaseAppendAddCount();
            }
            if (writeCnt > 0) {
                this.packet.writeParamLength(cntPos, writeCnt);
            }
            if (this.packet.getCurrPos() + 20 > 65536) {
                return -1;
            }
            this.packet.writePacketHeader(19L, 0, id);
            try {
                this.mcbOut.writeBytes(this.packet.getBuf(), this.packet.getCurrPos());
                this.mcbOut.flush();
                int cols = 0;
                ret = this.afterExec(19L, 35L, 36L, stmt, null, cols);
                this.setAppendAddCount(0L);
            }
            catch (SocketException e) {
                throw this.convertException(e);
            }
            catch (Exception e) {
                throw this.convertException(e);
            }
            stmt.setUseFlag(true);
        }
        catch (Exception e) {
            ret = -1;
            throw this.convertException(e);
        }
        return ret;
    }

    public synchronized int appendAllWriteBinary(ArrayList aTypes, ArrayList aData, long aTime) {
        int loop = 0;
        int writeCnt = 0;
        Object tmp = null;
        long arrival_dt = aTime;
        if (arrival_dt == 0L) {
            this.packet.writeDate(arrival_dt);
        } else if (this.mcbConn.getEndian() == 1L) {
            this.packet.writeDate(arrival_dt);
        } else {
            this.packet.writeDate(this.packet.swap(arrival_dt));
        }
        writeCnt += this.columnPrecision[0];
        SimpleDateFormat sSdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss SSS");
        TimeZone tmpTimezone = TimeZone.getDefault();
        tmpTimezone.setRawOffset((int)(this.mcbConn.getTimezoneSec() * 1000L));
        sSdf.setTimeZone(tmpTimezone);
        block20: for (int i = 0; i < aData.size(); ++i) {
            Object sData = aData.get(i);
            int sType = (Integer)aTypes.get(i);
            loop = i + 1;
            switch (sType) {
                case 0: {
                    continue block20;
                }
                case 1: {
                    short s = sData == null ? (short)Short.MIN_VALUE : (sData instanceof Short ? (short)((Short)sData) : (short)Short.valueOf((String)sData));
                    if (this.mcbConn.getEndian() == 1L) {
                        this.packet.appendShort(s);
                    } else {
                        this.packet.appendShort(this.packet.swap(s));
                    }
                    writeCnt += this.columnPrecision[loop];
                    continue block20;
                }
                case 4: {
                    int sx = sData == null ? 65535 : (sData instanceof Integer ? ((Integer)sData).intValue() : Integer.valueOf((String)sData).intValue());
                    if (this.mcbConn.getEndian() == 1L) {
                        this.packet.appendUShort((short)sx);
                    } else {
                        this.packet.appendUShort(this.packet.swap((short)sx));
                    }
                    writeCnt += this.columnPrecision[loop];
                    continue block20;
                }
                case 2: {
                    int x = sData == null ? Integer.MIN_VALUE : (sData instanceof Integer ? ((Integer)sData).intValue() : Integer.valueOf((String)sData).intValue());
                    if (this.mcbConn.getEndian() == 1L) {
                        this.packet.appendInt(x);
                    } else {
                        this.packet.appendInt(this.packet.swap(x));
                    }
                    writeCnt += this.columnPrecision[loop];
                    continue block20;
                }
                case 5: {
                    long sl = sData == null ? 0xFFFFFFFFL : (sData instanceof Long ? ((Long)sData).longValue() : Long.valueOf((String)sData).longValue());
                    if (this.mcbConn.getEndian() == 1L) {
                        this.packet.appendUInt((int)sl);
                    } else {
                        this.packet.appendUInt(this.packet.swap((int)sl));
                    }
                    writeCnt += this.columnPrecision[loop];
                    continue block20;
                }
                case 3: {
                    long l = sData == null ? Long.MIN_VALUE : (sData instanceof Long ? ((Long)sData).longValue() : Long.valueOf((String)sData).longValue());
                    if (this.mcbConn.getEndian() == 1L) {
                        this.packet.appendLong(l);
                    } else {
                        this.packet.appendLong(this.packet.swap(l));
                    }
                    writeCnt += this.columnPrecision[loop];
                    continue block20;
                }
                case 6: {
                    BigInteger sb = null;
                    sb = sData == null ? new BigInteger(1, MCB_ULONG_NULL_BYTE) : (sData instanceof BigInteger ? (BigInteger)sData : new BigInteger((String)sData));
                    if (this.mcbConn.getEndian() == 1L) {
                        this.packet.appendULong(sb, false);
                    } else {
                        this.packet.appendULong(sb, true);
                    }
                    writeCnt += this.columnPrecision[loop];
                    continue block20;
                }
                case 7: {
                    float f = sData == null ? Float.MAX_VALUE : (sData instanceof Float ? ((Float)sData).floatValue() : Float.valueOf((String)sData).floatValue());
                    if (this.mcbConn.getEndian() == 1L) {
                        this.packet.appendFloat(f);
                    } else {
                        this.packet.appendFloat(this.packet.swap(f));
                    }
                    writeCnt += this.columnPrecision[loop];
                    continue block20;
                }
                case 8: {
                    double d = sData == null ? Double.MAX_VALUE : (sData instanceof Double ? ((Double)sData).doubleValue() : Double.valueOf((String)sData).doubleValue());
                    if (this.mcbConn.getEndian() == 1L) {
                        this.packet.writeDouble(d);
                    } else {
                        this.packet.writeDouble(this.packet.swap(d));
                    }
                    writeCnt += this.columnPrecision[loop];
                    continue block20;
                }
                case 11: {
                    long sDt = -1L;
                    if (sData == null) {
                        sDt = -1L;
                    } else if (sData instanceof String) {
                        try {
                            Date sTimestamp = sSdf.parse((String)sData);
                            sDt = sTimestamp.getTime() * 1000000L;
                        }
                        catch (ParseException te) {
                            te.printStackTrace();
                        }
                    } else {
                        sDt = sData instanceof Long ? ((Long)sData).longValue() : Long.valueOf(sData.toString()).longValue();
                    }
                    if (this.mcbConn.getEndian() == 1L) {
                        this.packet.writeDate(sDt);
                    } else {
                        this.packet.writeDate(this.packet.swap(sDt));
                    }
                    writeCnt += this.columnPrecision[loop];
                    continue block20;
                }
                case 9: {
                    if (sData == null) {
                        this.packet.writeBytesOrgSize(MCB_IPV4_NULL);
                    } else {
                        this.packet.writeIpv4(sData.toString());
                    }
                    writeCnt += this.columnPrecision[loop];
                    continue block20;
                }
                case 10: {
                    if (sData == null) {
                        this.packet.writeBytesOrgSize(MCB_IPV6_NULL);
                    } else {
                        this.packet.writeIpv6(sData.toString());
                    }
                    writeCnt += this.columnPrecision[loop];
                    continue block20;
                }
                case 12: {
                    String tmpStr = sData.toString();
                    byte[] b = null;
                    if (tmpStr.length() > this.columnPrecision[loop]) {
                        tmpStr = tmpStr.substring(0, this.columnPrecision[loop]);
                    }
                    b = tmpStr.getBytes();
                    if (this.mcbConn.getEndian() == 1L) {
                        this.packet.appendInt(b.length);
                    } else {
                        this.packet.appendInt(this.packet.swap(b.length));
                    }
                    this.packet.writeBytesOrgSize(b);
                    writeCnt += b.length + 4;
                    continue block20;
                }
                case 13: 
                case 14: {
                    byte[] b = new byte[1];
                    try {
                        InputStream sInTmp = (InputStream)sData;
                        int sBinLen = sInTmp.available();
                        b = new byte[sBinLen];
                        sInTmp.read(b, 0, sBinLen);
                    }
                    catch (IOException ex) {
                        System.err.println("binary read error");
                    }
                    if (this.mcbConn.getEndian() == 1L) {
                        this.packet.appendInt(b.length);
                    } else {
                        this.packet.appendInt(this.packet.swap(b.length));
                    }
                    this.packet.writeBytesOrgSize(b);
                    writeCnt += b.length + 4;
                    continue block20;
                }
            }
        }
        return writeCnt;
    }

    public int getColumnTypeForAppendAll(int aType) throws SQLException {
        return MachTypes.getSQLTypeForAppendAll(aType);
    }

    public int getPrecisionForAppendAll(int aType) throws SQLException {
        switch (aType) {
            case 12: {
                return Short.MAX_VALUE;
            }
            case 11: {
                return 8;
            }
            case 1: {
                return 2;
            }
            case 4: {
                return 2;
            }
            case 2: {
                return 4;
            }
            case 5: {
                return 4;
            }
            case 3: {
                return 8;
            }
            case 6: {
                return 8;
            }
            case 7: {
                return 4;
            }
            case 8: {
                return 8;
            }
            case 9: {
                return 5;
            }
            case 10: {
                return 17;
            }
            case 13: {
                return 20000;
            }
            case 14: {
                return 20000;
            }
            case 0: {
                return 0;
            }
        }
        return 0;
    }

    public synchronized int executeAppendAll(MachStatement stmt, String aTableName, ArrayList aTypes, ArrayList aData) throws SQLException {
        ArrayList aDataRow;
        int ret = 1;
        if (aData.size() == 0) {
            return ret;
        }
        Integer sColumnsCount = aTypes.size();
        if (!sColumnsCount.equals((aDataRow = (ArrayList)aData.get(0)).size())) {
            System.out.format("column counts differ.(%d != %d)\n", aTypes.size(), aDataRow.size());
            return -1;
        }
        try {
            this.executeAppendBatchByTimeInternal(stmt, aTableName, 0L, aTypes, aData);
        }
        catch (Exception e) {
            throw this.convertException(e);
        }
        return ret;
    }

    public synchronized int executeAppendAllByTime(MachStatement stmt, String aTableName, long aTime, ArrayList aTypes, ArrayList aData) throws SQLException {
        ArrayList aDataRow;
        int ret = 1;
        if (aData.size() == 0) {
            return ret;
        }
        Integer sColumnsCount = aTypes.size();
        if (!sColumnsCount.equals((aDataRow = (ArrayList)aData.get(0)).size())) {
            System.out.format("column counts differ.(%d != %d)\n", aTypes.size(), aDataRow.size());
            return -1;
        }
        try {
            this.executeAppendBatchByTimeInternal(stmt, aTableName, aTime, aTypes, aData);
        }
        catch (Exception e) {
            throw this.convertException(e);
        }
        return ret;
    }

    public synchronized String getErrorMessage(MachBuffer readBuf) throws SQLException {
        String msg = "";
        MachPacket pac = readBuf.readNext();
        while (pac != null) {
            long protocol = pac.getProtocol();
            long type = pac.getType();
            if (protocol == 17L) {
                msg = pac.getString();
            }
            pac = readBuf.readNext();
        }
        return msg;
    }

    public static String protocolToString(long val) {
        long tmpValue = 0L;
        byte[] buf = new byte[4];
        int cnt = 0;
        for (int i = 3; i >= 0; --i) {
            if (i > 0) {
                tmpValue = val >>> i * 8;
                buf[cnt++] = (byte)tmpValue;
                continue;
            }
            buf[cnt++] = (byte)val;
        }
        return new String(buf);
    }

    void printError(MachBuffer readBuf) throws SQLException {
        MachPacket pac = readBuf.readNext();
        MachResult result = null;
        while (pac != null) {
            long protocol = pac.getProtocol();
            long type = pac.getType();
            if (protocol == 16L) {
                result = pac.getResult();
            } else if (protocol == 17L) {
                String msg = pac.getString();
                throw new SQLException(String.format("[ERR-%05d: %s]", result.getErrorNo(), msg));
            }
            pac = readBuf.readNext();
        }
    }
}

