/*
 * Decompiled with CFR 0.152.
 */
package com.machbase.jdbc;

import com.machbase.jdbc.MachColumnData;
import com.machbase.jdbc.MachConnection;
import com.machbase.jdbc.MachException;
import com.machbase.jdbc.MachProtocol;
import com.machbase.jdbc.MachResultSetMetaData;
import com.machbase.jdbc.MachRow;
import com.machbase.jdbc.MachStatement;
import com.machbase.jdbc.MachTableMetaData;
import com.machbase.jdbc.MachTableMetaParam;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;
import java.util.Vector;

public class MachResultSet
implements ResultSet {
    private MachStatement stmt = null;
    private MachTableMetaData tMetaData = null;
    private MachTableMetaParam tMetaParam = null;
    private int updateCount = -1;
    private Vector<Object> rowSets = null;
    private boolean fetchComplete = false;
    private int curRow = -1;
    private long fetchedRows = 0L;
    private int StatementId = 0;
    public boolean closeStmt = false;
    private boolean is_opened = false;
    private boolean is_holdable = false;
    protected boolean was_null = false;
    private int last_column_id = -1;

    MachResultSet(MachStatement stmt) throws SQLException {
        this.stmt = stmt;
        this.rowSets = new Vector();
        this.closeStmt = false;
        this.is_opened = true;
        this.StatementId = stmt.getStatementId();
    }

    public int getRowSize() {
        return this.rowSets.size();
    }

    public void setStatementId(int id) {
        this.StatementId = id;
    }

    public int getStatementId() {
        return this.StatementId;
    }

    public void cleanRowSet() {
        this.curRow = -1;
        this.rowSets.removeAllElements();
    }

    public void setFetchComplete(boolean f) {
        this.fetchComplete = f;
    }

    public boolean getFetchComplete() {
        return this.fetchComplete;
    }

    public int getUpdateCount() {
        return this.updateCount;
    }

    public void setUpdateCount(int cnt) {
        this.updateCount = cnt;
    }

    public void setTableMetaData(MachTableMetaData tmd) {
        this.tMetaData = tmd;
    }

    public MachTableMetaData getTableMetaData() {
        return this.tMetaData;
    }

    public void setTableMetaParam(MachTableMetaParam tmp) {
        this.tMetaParam = tmp;
    }

    public MachTableMetaParam getTableMetaParam() {
        return this.tMetaParam;
    }

    public void addRow(MachRow row) {
        this.rowSets.addElement(row);
    }

    @Override
    public void clearWarnings() throws SQLException {
    }

    @Override
    public void close() throws SQLException {
        if (this.closeStmt) {
            this.closeStmt = false;
            this.stmt.closeForMeta();
        }
        this.cleanRowSet();
        this.is_opened = false;
    }

    @Override
    public synchronized boolean next() throws SQLException {
        boolean ret = false;
        int maxRows = this.stmt.getMaxRows();
        if (maxRows > 0) {
            if ((long)maxRows <= this.fetchedRows) {
                if (this.stmt.timeHandle != null) {
                    this.stmt.timeHandle.cancel(false);
                    this.stmt.scheduler.shutdown();
                    this.stmt.timeHandle = null;
                }
                return false;
            }
            if ((long)maxRows - this.fetchedRows < (long)this.stmt.getFetchSize()) {
                this.stmt.setFetchSize((int)((long)maxRows - this.fetchedRows));
            }
        }
        if (this.curRow < this.rowSets.size() - 1) {
            ++this.curRow;
            ++this.fetchedRows;
            ret = true;
        } else if (!this.fetchComplete) {
            this.cleanRowSet();
            MachProtocol sProtocol = ((MachConnection)this.stmt.getConnection()).getProtocol();
            sProtocol.execFetch(this, this.tMetaData.getColumnCount(), this.stmt.getStatementId());
            if (this.rowSets.size() > 0) {
                ++this.curRow;
                ++this.fetchedRows;
                ret = true;
            } else {
                ret = false;
            }
        } else {
            ret = false;
        }
        if (this.stmt.timeHandle != null) {
            this.stmt.timeHandle.cancel(false);
            this.stmt.scheduler.shutdown();
            this.stmt.timeHandle = null;
        }
        return ret;
    }

    private int getColumnType(int col) throws SQLException {
        return this.getTableMetaData().getColumnType(col);
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        MachResultSetMetaData rdata = new MachResultSetMetaData(this.stmt.getConnection().getCatalog(), this.tMetaData);
        return rdata;
    }

    @Override
    public String getString(int columnIndex) throws SQLException {
        this.last_column_id = columnIndex;
        MachRow row = (MachRow)this.rowSets.elementAt(this.curRow);
        String sValue = row.getString(columnIndex, this.getCharset(), true, ((MachConnection)this.stmt.getConnection()).getTimezoneSec());
        this.was_null = sValue == null;
        return sValue;
    }

    public MachRow getMachRow() throws SQLException {
        MachRow row = (MachRow)this.rowSets.elementAt(this.curRow);
        return row;
    }

    @Override
    public byte getByte(int columnIndex) throws SQLException {
        byte[] tmp = this.getBytes(columnIndex);
        return tmp[0];
    }

    @Override
    public byte[] getBytes(int columnIndex) throws SQLException {
        this.last_column_id = columnIndex;
        MachRow row = (MachRow)this.rowSets.elementAt(this.curRow);
        byte[] b = row.getBytes(columnIndex);
        return b;
    }

    @Override
    public InputStream getAsciiStream(int columnIndex) throws SQLException {
        byte[] tmp = this.getBytes(columnIndex);
        return new ByteArrayInputStream(tmp);
    }

    @Override
    public boolean getBoolean(int columnIndex) throws SQLException {
        return Boolean.valueOf(this.getString(columnIndex));
    }

    @Override
    public InputStream getAsciiStream(String cname) throws SQLException {
        return this.getAsciiStream(this.findColumn(cname));
    }

    @Override
    public BigDecimal getBigDecimal(String cname) throws SQLException {
        return this.getBigDecimal(this.findColumn(cname));
    }

    @Override
    public BigDecimal getBigDecimal(int column) throws SQLException {
        this.last_column_id = column;
        MachRow row = (MachRow)this.rowSets.elementAt(this.curRow);
        return row.getBigDecimal(column);
    }

    @Override
    public BigDecimal getBigDecimal(String cname, int scale) throws SQLException {
        return this.getBigDecimal(this.findColumn(cname), scale);
    }

    @Override
    public BigDecimal getBigDecimal(int column, int scale) throws SQLException {
        this.last_column_id = column;
        MachRow row = (MachRow)this.rowSets.elementAt(this.curRow);
        return row.getBigDecimal(column, scale);
    }

    @Override
    public InputStream getBinaryStream(String cname) throws SQLException {
        return this.getBinaryStream(this.findColumn(cname));
    }

    @Override
    public boolean getBoolean(String cname) throws SQLException {
        return this.getBoolean(this.findColumn(cname));
    }

    @Override
    public byte getByte(String cname) throws SQLException {
        return this.getByte(this.findColumn(cname));
    }

    @Override
    public byte[] getBytes(String cname) throws SQLException {
        return this.getBytes(this.findColumn(cname));
    }

    @Override
    public synchronized InputStream getUnicodeStream(String cname) throws SQLException {
        return this.getUnicodeStream(this.findColumn(cname));
    }

    @Override
    public synchronized InputStream getUnicodeStream(int column) throws SQLException {
        throw new SQLException("this method not supported.");
    }

    @Override
    public String getCursorName() throws SQLException {
        throw new SQLException("this method not supported.");
    }

    @Override
    public Date getDate(String cname) throws SQLException {
        return this.getDate(this.findColumn(cname));
    }

    @Override
    public Date getDate(int column) throws SQLException {
        this.last_column_id = column;
        MachRow row = (MachRow)this.rowSets.elementAt(this.curRow);
        Date sValue = row.getDate(column);
        this.was_null = sValue == null;
        return sValue;
    }

    @Override
    public Date getDate(String cname, Calendar cal) throws SQLException {
        return this.getDate(this.findColumn(cname), cal);
    }

    @Override
    public Date getDate(int column, Calendar cal) throws SQLException {
        this.last_column_id = column;
        MachRow row = (MachRow)this.rowSets.elementAt(this.curRow);
        return row.getDate(column, cal);
    }

    @Override
    public double getDouble(String cname) throws SQLException {
        return this.getDouble(this.findColumn(cname));
    }

    @Override
    public double getDouble(int column) throws SQLException {
        this.last_column_id = column;
        MachRow row = (MachRow)this.rowSets.elementAt(this.curRow);
        double sValue = row.getDouble(column);
        this.was_null = sValue == Double.MAX_VALUE;
        return sValue;
    }

    public String getEncoding() {
        if (this.stmt != null) {
            return this.stmt.getEncoding();
        }
        return "UTF-8";
    }

    public String getCharset() {
        if (this.stmt != null) {
            return ((MachConnection)this.stmt.getConnection()).getCharset();
        }
        return null;
    }

    @Override
    public float getFloat(String cname) throws SQLException {
        return this.getFloat(this.findColumn(cname));
    }

    @Override
    public float getFloat(int column) throws SQLException {
        this.last_column_id = column;
        MachRow row = (MachRow)this.rowSets.elementAt(this.curRow);
        float sValue = row.getFloat(column);
        this.was_null = sValue == Float.MAX_VALUE;
        return sValue;
    }

    @Override
    public int getInt(String cname) throws SQLException {
        return this.getInt(this.findColumn(cname));
    }

    @Override
    public int getInt(int column) throws SQLException {
        this.last_column_id = column;
        MachRow row = (MachRow)this.rowSets.elementAt(this.curRow);
        int sValue = row.getInt(column);
        this.was_null = sValue == Integer.MIN_VALUE;
        return sValue;
    }

    public long getUInt(String cname) throws SQLException {
        return this.getUInt(this.findColumn(cname));
    }

    public long getUInt(int column) throws SQLException {
        this.last_column_id = column;
        MachRow row = (MachRow)this.rowSets.elementAt(this.curRow);
        long sValue = row.getUInt(column);
        this.was_null = sValue == 0xFFFFFFFFL;
        return sValue;
    }

    @Override
    public long getLong(String cname) throws SQLException {
        return this.getLong(this.findColumn(cname));
    }

    @Override
    public long getLong(int column) throws SQLException {
        this.last_column_id = column;
        MachRow row = (MachRow)this.rowSets.elementAt(this.curRow);
        long sValue = row.getLong(column);
        this.was_null = sValue == Long.MIN_VALUE;
        return sValue;
    }

    public BigInteger getULong(String cname) throws SQLException {
        return this.getULong(this.findColumn(cname));
    }

    public BigInteger getULong(int column) throws SQLException {
        this.last_column_id = column;
        MachRow row = (MachRow)this.rowSets.elementAt(this.curRow);
        BigInteger sValue = row.getULong(column);
        this.was_null = sValue.compareTo(new BigInteger(1, MachProtocol.MCB_ULONG_NULL_BYTE)) == 0;
        return sValue;
    }

    @Override
    public Object getObject(String cname) throws SQLException {
        return this.getObject(this.findColumn(cname));
    }

    @Override
    public Object getObject(int column) throws SQLException {
        this.last_column_id = column;
        MachRow row = (MachRow)this.rowSets.elementAt(this.curRow);
        return row.getObject(column);
    }

    @Override
    public int getRow() throws SQLException {
        if (this.curRow > this.rowSets.size() - 1) {
            return 0;
        }
        return this.curRow + 1;
    }

    @Override
    public short getShort(String cname) throws SQLException {
        return this.getShort(this.findColumn(cname));
    }

    @Override
    public short getShort(int column) throws SQLException {
        this.last_column_id = column;
        MachRow row = (MachRow)this.rowSets.elementAt(this.curRow);
        short sValue = row.getShort(column);
        this.was_null = sValue == Short.MIN_VALUE;
        return sValue;
    }

    public int getUShort(String cname) throws SQLException {
        return this.getUShort(this.findColumn(cname));
    }

    public int getUShort(int column) throws SQLException {
        this.last_column_id = column;
        MachRow row = (MachRow)this.rowSets.elementAt(this.curRow);
        int sValue = row.getUShort(column);
        this.was_null = sValue == 65535;
        return sValue;
    }

    @Override
    public Statement getStatement() throws SQLException {
        return this.stmt;
    }

    @Override
    public String getString(String cname) throws SQLException {
        return this.getString(this.findColumn(cname));
    }

    @Override
    public Time getTime(String cname) throws SQLException {
        return this.getTime(this.findColumn(cname));
    }

    @Override
    public Time getTime(int column) throws SQLException {
        this.last_column_id = column;
        MachRow row = (MachRow)this.rowSets.elementAt(this.curRow);
        Time sValue = row.getTime(column);
        this.was_null = sValue == null;
        return sValue;
    }

    @Override
    public Time getTime(String cname, Calendar cal) throws SQLException {
        return this.getTime(this.findColumn(cname), cal);
    }

    @Override
    public Time getTime(int column, Calendar cal) throws SQLException {
        this.last_column_id = column;
        MachRow row = (MachRow)this.rowSets.elementAt(this.curRow);
        return row.getTime(column, cal);
    }

    @Override
    public Timestamp getTimestamp(String cname) throws SQLException {
        return this.getTimestamp(this.findColumn(cname));
    }

    @Override
    public Timestamp getTimestamp(int column) throws SQLException {
        this.last_column_id = column;
        MachRow row = (MachRow)this.rowSets.elementAt(this.curRow);
        Timestamp sValue = row.getTimestamp(column);
        this.was_null = sValue == null;
        return sValue;
    }

    @Override
    public Timestamp getTimestamp(String cname, Calendar cal) throws SQLException {
        return this.getTimestamp(this.findColumn(cname), cal);
    }

    @Override
    public Timestamp getTimestamp(int column, Calendar cal) throws SQLException {
        this.last_column_id = column;
        MachRow row = (MachRow)this.rowSets.elementAt(this.curRow);
        return row.getTimestamp(column, cal);
    }

    @Override
    public boolean wasNull() throws SQLException {
        MachRow row = (MachRow)this.rowSets.elementAt(this.curRow);
        MachColumnData cd = row.getColumn(this.last_column_id - 1);
        String sValue = cd.getString();
        this.was_null = false;
        if (sValue == null || sValue.equals("NULL")) {
            this.was_null = true;
        }
        return this.was_null;
    }

    @Override
    public InputStream getBinaryStream(int columnIndex) throws SQLException {
        byte[] tmp = this.getBytes(columnIndex);
        return new ByteArrayInputStream(tmp);
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return null;
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        return this.getRow() == -2;
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        return this.getRow() == 0;
    }

    @Override
    public int findColumn(String columnName) throws SQLException {
        int idx = this.tMetaData.findColumn(columnName);
        if (idx == -1) {
            throw new MachException(String.format("column(%s) does not exist", columnName));
        }
        return idx;
    }

    @Override
    public void moveToInsertRow() throws SQLException {
    }

    @Override
    public void updateBytes(int columnIndex, byte[] x) throws SQLException {
        throw new MachException("this method not supported.");
    }

    @Override
    public void updateBytes(String columnName, byte[] x) throws SQLException {
        throw new MachException("this method not supported.");
    }

    @Override
    public boolean previous() throws SQLException {
        return false;
    }

    @Override
    public void afterLast() throws SQLException {
    }

    @Override
    public void beforeFirst() throws SQLException {
    }

    @Override
    public void updateByte(int columnIndex, byte x) throws SQLException {
        throw new MachException("this method not supported.");
    }

    @Override
    public void updateByte(String columnName, byte x) throws SQLException {
        throw new MachException("this method not supported.");
    }

    @Override
    public boolean isFirst() throws SQLException {
        return false;
    }

    @Override
    public void updateObject(int columnIndex, Object x) throws SQLException {
        throw new MachException("this method not supported.");
    }

    @Override
    public void updateObject(int columnIndex, Object x, int scale) throws SQLException {
        throw new MachException("this method not supported.");
    }

    @Override
    public void updateObject(String columnName, Object x) throws SQLException {
        throw new MachException("this method not supported.");
    }

    @Override
    public void updateObject(String columnName, Object x, int scale) throws SQLException {
        throw new MachException("this method not supported.");
    }

    @Override
    public int getType() throws SQLException {
        return 1003;
    }

    @Override
    public void updateBigDecimal(int columnIndex, BigDecimal x) throws SQLException {
        throw new MachException("this method not supported.");
    }

    @Override
    public void updateBigDecimal(String columnName, BigDecimal x) throws SQLException {
        throw new MachException("this method not supported.");
    }

    @Override
    public void updateRow() throws SQLException {
        throw new MachException("this method not supported.");
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x, int length) throws SQLException {
        throw new MachException("this method not supported.");
    }

    @Override
    public void updateCharacterStream(String columnName, Reader x, int length) throws SQLException {
        throw new MachException("this method not supported.");
    }

    @Override
    public void insertRow() throws SQLException {
    }

    @Override
    public void updateTimestamp(int columnIndex, Timestamp x) throws SQLException {
        throw new MachException("this method not supported.");
    }

    @Override
    public void updateTimestamp(String columnName, Timestamp x) throws SQLException {
        throw new MachException("this method not supported.");
    }

    @Override
    public void updateBoolean(int columnIndex, boolean x) throws SQLException {
        throw new MachException("this method not supported.");
    }

    @Override
    public void updateBoolean(String columnName, boolean x) throws SQLException {
        throw new MachException("this method not supported.");
    }

    @Override
    public void updateString(int columnIndex, String x) throws SQLException {
        throw new MachException("this method not supported.");
    }

    @Override
    public void updateString(String columnName, String x) throws SQLException {
        throw new MachException("this method not supported.");
    }

    @Override
    public void updateFloat(int columnIndex, float x) throws SQLException {
        throw new MachException("this method not supported.");
    }

    @Override
    public void updateFloat(String columnName, float x) throws SQLException {
        throw new MachException("this method not supported.");
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
    }

    @Override
    public void setFetchSize(int size) throws SQLException {
    }

    public void upateBinaryStream(int columnIndex, InputStream x, int length) throws SQLException {
        throw new MachException("this method not supported.");
    }

    @Override
    public void updateBinaryStream(String columnName, InputStream x, int length) throws SQLException {
        throw new MachException("this method not supported.");
    }

    @Override
    public boolean first() throws SQLException {
        return false;
    }

    @Override
    public void updateDouble(int columnIndex, double x) throws SQLException {
        throw new MachException("this method not supported.");
    }

    @Override
    public void updateDouble(String columnName, double x) throws SQLException {
        throw new MachException("this method not supported.");
    }

    @Override
    public boolean relative(int rows) throws SQLException {
        return false;
    }

    @Override
    public void updateShort(int columnIndex, short x) throws SQLException {
        throw new MachException("this method not supported.");
    }

    @Override
    public void updateShort(String columnName, short x) throws SQLException {
        throw new MachException("this method not supported.");
    }

    @Override
    public void cancelRowUpdates() throws SQLException {
    }

    @Override
    public void updateNull(int columnIndex) throws SQLException {
        throw new MachException("this method not supported.");
    }

    @Override
    public void updateNull(String columnName) throws SQLException {
        throw new MachException("this method not supported.");
    }

    @Override
    public boolean last() throws SQLException {
        return false;
    }

    @Override
    public Ref getRef(int columnIndex) throws SQLException {
        return null;
    }

    @Override
    public Ref getRef(String columnName) throws SQLException {
        return null;
    }

    @Override
    public void moveToCurrentRow() throws SQLException {
    }

    @Override
    public boolean absolute(int row) throws SQLException {
        return false;
    }

    @Override
    public int getFetchSize() throws SQLException {
        return 0;
    }

    @Override
    public void updateLong(int columnIndex, long x) throws SQLException {
        throw new MachException("this method not supported.");
    }

    @Override
    public void updateLong(String columnName, long x) throws SQLException {
        throw new MachException("this method not supported.");
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x, int length) throws SQLException {
        throw new MachException("this method not supported.");
    }

    @Override
    public void updateAsciiStream(String columnName, InputStream x, int length) throws SQLException {
        throw new MachException("this method not supported.");
    }

    @Override
    public boolean isLast() throws SQLException {
        return false;
    }

    @Override
    public int getFetchDirection() throws SQLException {
        return 0;
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x, int length) throws SQLException {
        throw new MachException("this method not supported.");
    }

    public Object getObject(int columnIndex, Map map) throws SQLException {
        throw new MachException("this method not supported.");
    }

    public Object getObject(String columnName, Map map) throws SQLException {
        throw new MachException("this method not supported.");
    }

    @Override
    public Reader getCharacterStream(int columnIndex) throws SQLException {
        throw new MachException("this method not supported.");
    }

    @Override
    public void updateTime(int columnIndex, Time x) throws SQLException {
        throw new MachException("this method not supported.");
    }

    @Override
    public void updateTime(String columnName, Time x) throws SQLException {
        throw new MachException("this method not supported.");
    }

    @Override
    public void updateInt(int columnIndex, int x) throws SQLException {
        throw new MachException("this method not supported.");
    }

    @Override
    public void updateInt(String columnName, int x) throws SQLException {
        throw new MachException("this method not supported.");
    }

    @Override
    public void updateDate(int columnIndex, Date x) throws SQLException {
        throw new MachException("this method not supported.");
    }

    @Override
    public void updateDate(String columnName, Date x) throws SQLException {
        throw new MachException("this method not supported.");
    }

    @Override
    public boolean rowInserted() throws SQLException {
        throw new MachException("this method not supported.");
    }

    @Override
    public boolean rowUpdated() throws SQLException {
        throw new MachException("this method not supported.");
    }

    @Override
    public boolean rowDeleted() throws SQLException {
        throw new MachException("this method not supported.");
    }

    @Override
    public void deleteRow() throws SQLException {
        throw new MachException("this method not supported.");
    }

    @Override
    public void refreshRow() throws SQLException {
        throw new MachException("this method not supported.");
    }

    @Override
    public Array getArray(int columnIndex) throws SQLException {
        throw new MachException("this method not supported.");
    }

    @Override
    public Array getArray(String columnName) throws SQLException {
        throw new MachException("this method not supported.");
    }

    @Override
    public Blob getBlob(int columnIndex) throws SQLException {
        throw new MachException("this method not supported.");
    }

    @Override
    public Blob getBlob(String columnName) throws SQLException {
        throw new MachException("this method not supported.");
    }

    @Override
    public Clob getClob(int columnIndex) throws SQLException {
        throw new MachException("this method not supported.");
    }

    @Override
    public Clob getClob(String columnName) throws SQLException {
        throw new MachException("this method not supported.");
    }

    @Override
    public int getConcurrency() throws SQLException {
        return 0;
    }

    @Override
    public synchronized Reader getCharacterStream(String columnName) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getHoldability() throws SQLException {
        return this.is_holdable ? 1 : 2;
    }

    @Override
    public Reader getNCharacterStream(int columnIndex) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Reader getNCharacterStream(String columnLabel) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public NClob getNClob(int columnIndex) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public NClob getNClob(String columnLabel) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getNString(int columnIndex) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getNString(String columnLabel) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public RowId getRowId(int columnIndex) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public RowId getRowId(String columnLabel) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public SQLXML getSQLXML(int columnIndex) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public SQLXML getSQLXML(String columnLabel) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isClosed() throws SQLException {
        return !this.is_opened;
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x, long length) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x, long length) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x, long length) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x, long length) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateBlob(int columnIndex, InputStream inputStream) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateBlob(String columnLabel, InputStream inputStream) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateBlob(int columnIndex, InputStream inputStream, long length) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateBlob(String columnLabel, InputStream inputStream, long length) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateClob(int columnIndex, Reader reader) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateClob(String columnLabel, Reader reader) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateClob(int columnIndex, Reader reader, long length) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateClob(String columnLabel, Reader reader, long length) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader reader) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateNClob(int columnIndex, NClob clob) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateNClob(String columnLabel, NClob clob) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateNClob(int columnIndex, Reader reader) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateNClob(String columnLabel, Reader reader) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateNClob(int columnIndex, Reader reader, long length) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateNClob(String columnLabel, Reader reader, long length) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateNString(int columnIndex, String string) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateNString(String columnLabel, String string) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateRowId(int columnIndex, RowId x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateRowId(String columnLabel, RowId x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateSQLXML(int columnIndex, SQLXML xmlObject) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateSQLXML(String columnLabel, SQLXML xmlObject) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> T getObject(int columnIndex, Class<T> type) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> T getObject(String columnLabel, Class<T> type) throws SQLException {
        throw new UnsupportedOperationException();
    }

    private void updateValue(int columnIndex, Object value) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public synchronized URL getURL(int columnIndex) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public synchronized URL getURL(String columnName) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public synchronized void updateArray(int columnIndex, Array x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public synchronized void updateArray(String columnName, Array x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public synchronized void updateBlob(int columnIndex, Blob x) throws SQLException {
        this.updateValue(columnIndex, x);
    }

    @Override
    public synchronized void updateBlob(String columnName, Blob x) throws SQLException {
        this.updateValue(this.findColumn(columnName), x);
    }

    @Override
    public synchronized void updateClob(int columnIndex, Clob x) throws SQLException {
        this.updateValue(columnIndex, x);
    }

    @Override
    public synchronized void updateClob(String columnName, Clob x) throws SQLException {
        this.updateValue(this.findColumn(columnName), x);
    }

    @Override
    public synchronized void updateRef(int columnIndex, Ref x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public synchronized void updateRef(String columnName, Ref x) throws SQLException {
        throw new UnsupportedOperationException();
    }
}

