/*
 * Decompiled with CFR 0.152.
 */
package com.machbase.jdbc;

import com.machbase.jdbc.MachMetaData;
import com.machbase.jdbc.MachTableMetaData;
import com.machbase.jdbc.MachTypes;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;

public class MachResultSetMetaData
implements ResultSetMetaData {
    private String catalog = null;
    private int columnCount = -1;
    private MachTableMetaData tMetaData = null;

    MachResultSetMetaData(String cat, MachTableMetaData tdata) throws SQLException {
        this.catalog = cat;
        this.tMetaData = tdata;
    }

    @Override
    public String getCatalogName(int column) throws SQLException {
        return this.catalog;
    }

    private MachMetaData getColumn(int column) throws SQLException {
        return (MachMetaData)this.tMetaData.columnTypeList.elementAt(column - 1);
    }

    @Override
    public String getColumnClassName(int column) throws SQLException {
        return null;
    }

    @Override
    public synchronized int getColumnCount() throws SQLException {
        return this.tMetaData.getColumnCount();
    }

    @Override
    public int getColumnDisplaySize(int column) throws SQLException {
        return this.tMetaData.getColumnDisplaySize(column);
    }

    @Override
    public String getColumnLabel(int column) throws SQLException {
        return this.tMetaData.getColumnName(column);
    }

    @Override
    public String getColumnName(int column) throws SQLException {
        return this.tMetaData.getColumnName(column);
    }

    @Override
    public int getColumnType(int column) throws SQLException {
        int sType = this.tMetaData.getConnection().getUseMachbaseType() == 1 ? MachTypes.getSQLTypeForMachbase(this.tMetaData.getColumnType(column)) : MachTypes.getSQLTypeForJava(this.tMetaData.getColumnType(column));
        return sType;
    }

    public int getColumnTypeForAppend(int column) throws SQLException {
        return MachTypes.getSQLTypeForMachbase(this.tMetaData.getColumnType(column));
    }

    @Override
    public String getColumnTypeName(int column) throws SQLException {
        int t = this.tMetaData.getColumnType(column);
        return MachTypes.getMachbaseTypeNameForMachbase(t);
    }

    @Override
    public int getPrecision(int column) throws SQLException {
        return this.tMetaData.getPrecision(column);
    }

    @Override
    public int getScale(int column) throws SQLException {
        return this.tMetaData.getScale(column);
    }

    @Override
    public String getSchemaName(int column) throws SQLException {
        return "";
    }

    @Override
    public String getTableName(int column) throws SQLException {
        return this.tMetaData.getTableName(column);
    }

    @Override
    public boolean isAutoIncrement(int column) throws SQLException {
        return false;
    }

    @Override
    public boolean isCaseSensitive(int column) throws SQLException {
        return true;
    }

    @Override
    public boolean isCurrency(int column) throws SQLException {
        return false;
    }

    @Override
    public boolean isDefinitelyWritable(int column) throws SQLException {
        return true;
    }

    @Override
    public int isNullable(int column) throws SQLException {
        return this.tMetaData.isNullable(column);
    }

    @Override
    public boolean isReadOnly(int column) throws SQLException {
        return false;
    }

    @Override
    public boolean isSearchable(int column) throws SQLException {
        return true;
    }

    @Override
    public boolean isSigned(int column) throws SQLException {
        int sType = this.getColumnType(column);
        return sType == 5 || sType == 4 || sType == -5;
    }

    @Override
    public boolean isWritable(int column) throws SQLException {
        return true;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        throw new UnsupportedOperationException();
    }
}

