/*
 * Decompiled with CFR 0.152.
 */
package com.machbase.jdbc;

import com.machbase.jdbc.MachColumnData;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;
import java.util.Vector;

public class MachRow {
    private Vector<Object> columns = new Vector();
    private String encoding = null;

    public MachRow() {
        this.encoding = "UTF-8";
    }

    public MachRow(String enc) {
        this.encoding = enc;
    }

    public void setSize(int size) {
        this.columns.setSize(size);
    }

    public void addColumn(int idx, int t, byte[] b) throws SQLException {
        MachColumnData cd = new MachColumnData(t, b);
        this.columns.addElement(cd);
    }

    public void addColumn(int idx, byte[] b) throws SQLException {
        MachColumnData cd = new MachColumnData(b);
        this.columns.addElement(cd);
    }

    public void setColumn(int idx, int t, byte[] b) throws SQLException {
        MachColumnData cd = new MachColumnData(t, b);
        this.columns.setElementAt(cd, idx);
    }

    public void setColumn(int idx, byte[] b) throws SQLException {
        MachColumnData cd = new MachColumnData(b);
        this.columns.setElementAt(cd, idx);
    }

    public MachColumnData getColumn(int idx) throws SQLException {
        if (idx > this.columns.size()) {
            throw new SQLException("out of index");
        }
        return (MachColumnData)this.columns.elementAt(idx);
    }

    public String getString(int idx, String charset) throws SQLException {
        return this.getString(idx, charset, false, 0L);
    }

    public String getString(int idx, String charset, boolean aUseTimezone, long aTimezoneSec) throws SQLException {
        MachColumnData cd = this.getColumn(idx - 1);
        return cd.getString(charset, aUseTimezone, aTimezoneSec);
    }

    public String getString(int idx) throws SQLException {
        return this.getString(idx, false, 0L);
    }

    public String getString(int idx, boolean aUseTimezone, long aTimezoneSec) throws SQLException {
        MachColumnData cd = this.getColumn(idx - 1);
        return cd.getString(aUseTimezone, aTimezoneSec);
    }

    public boolean getBoolean(int idx) throws SQLException {
        return false;
    }

    public byte getByte(int idx) throws SQLException {
        return 1;
    }

    public short getShort(int idx) throws SQLException {
        MachColumnData cd = this.getColumn(idx - 1);
        return cd.getShort();
    }

    public int getUShort(int idx) throws SQLException {
        MachColumnData cd = this.getColumn(idx - 1);
        return cd.getUShort();
    }

    public int getInt(int idx) throws SQLException {
        MachColumnData cd = this.getColumn(idx - 1);
        return cd.getInt();
    }

    public long getUInt(int idx) throws SQLException {
        MachColumnData cd = this.getColumn(idx - 1);
        return cd.getUInt();
    }

    public long getLong(int idx) throws SQLException {
        MachColumnData cd = this.getColumn(idx - 1);
        return cd.getLong();
    }

    public BigInteger getULong(int idx) throws SQLException {
        MachColumnData cd = this.getColumn(idx - 1);
        return cd.getULong();
    }

    public float getFloat(int idx) throws SQLException {
        MachColumnData cd = this.getColumn(idx - 1);
        return cd.getFloat();
    }

    public double getDouble(int idx) throws SQLException {
        MachColumnData cd = this.getColumn(idx - 1);
        return cd.getDouble();
    }

    public BigDecimal getBigDecimal(int idx, int scale) throws SQLException {
        return this.getBigDecimal(idx).setScale(scale);
    }

    public byte[] getBytes(int idx) throws SQLException {
        MachColumnData cd = this.getColumn(idx - 1);
        return cd.getData();
    }

    public Date getDate(int idx) throws SQLException {
        MachColumnData cd = this.getColumn(idx - 1);
        return cd.getDate();
    }

    public Time getTime(int idx) throws SQLException {
        MachColumnData cd = this.getColumn(idx - 1);
        return cd.getTime();
    }

    public Timestamp getTimestamp(int idx) throws SQLException {
        MachColumnData cd = this.getColumn(idx - 1);
        return cd.getTimestamp();
    }

    public Object getObject(int idx) throws SQLException {
        MachColumnData cd = this.getColumn(idx - 1);
        return cd.getObject();
    }

    public Array getArray(int idx) throws SQLException {
        return null;
    }

    public Blob getBlob(int idx) throws SQLException {
        return null;
    }

    public Clob getClob(int idx) throws SQLException {
        return null;
    }

    public Ref getRef(int idx) throws SQLException {
        return null;
    }

    public BigDecimal getBigDecimal(int idx) throws SQLException {
        MachColumnData cd = this.getColumn(idx - 1);
        return cd.getBigDecimal();
    }

    public Date getDate(int idx, Calendar cal) throws SQLException {
        MachColumnData cd = this.getColumn(idx - 1);
        return cd.getDate();
    }

    public Time getTime(int idx, Calendar cal) throws SQLException {
        MachColumnData cd = this.getColumn(idx - 1);
        return cd.getTime();
    }

    public Timestamp getTimestamp(int idx, Calendar cal) throws SQLException {
        MachColumnData cd = this.getColumn(idx - 1);
        return cd.getTimestamp();
    }

    public Object getObject(int idx, Map map) throws SQLException {
        MachColumnData cd = this.getColumn(idx - 1);
        return cd.getObject();
    }
}

