/*
 * Decompiled with CFR 0.152.
 */
package com.machbase.jdbc;

import com.machbase.jdbc.MachAppendCallback;
import com.machbase.jdbc.MachBuffer;
import com.machbase.jdbc.MachConnection;
import com.machbase.jdbc.MachResultSet;
import com.machbase.jdbc.MachResultSetMetaData;
import java.sql.BatchUpdateException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

public class MachStatement
implements Statement {
    private ArrayList<String> batches = new ArrayList();
    private int maxFieldSize = 0;
    private int maxRows = 0;
    protected ArrayList<Object> resultSets = new ArrayList();
    protected MachConnection mcbConn = null;
    protected int StatementId = 0;
    private int fetchSize = 20000;
    private boolean useFlag = false;
    private boolean is_holdable = false;
    int resultSetType = 1003;
    int resultSetConcurrency = 1007;
    protected int queryTimeout = 0;
    protected MachBuffer readBuffer = null;
    public final ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor();
    public ScheduledFuture<?> timeHandle = null;

    MachStatement(MachConnection c) throws SQLException {
        this.mcbConn = c;
        this.StatementId = this.mcbConn.getStatementId();
        this.readBuffer = new MachBuffer();
    }

    MachStatement(MachConnection c, int stmtId) throws SQLException {
        this.mcbConn = c;
        if (!this.mcbConn.isAvailableStmtId(stmtId)) {
            Date today = new Date();
            SimpleDateFormat dateformat = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
            throw new SQLException(String.format("[" + dateformat.format(today) + "] " + "Try to create statement with exist id: %d.", stmtId));
        }
        this.StatementId = stmtId;
        this.readBuffer = new MachBuffer();
    }

    MachStatement(MachConnection c, int resultSetType, int resultSetConcurrency) throws SQLException {
        this(c);
        this.resultSetType = resultSetType;
        this.resultSetConcurrency = resultSetConcurrency;
        this.setFetchSize(0);
    }

    public synchronized int getStatementId() {
        return this.StatementId;
    }

    public synchronized void setUseFlag(boolean b) {
        this.useFlag = b;
    }

    @Override
    public synchronized void addBatch(String sql) throws SQLException {
        this.batches.add(sql);
    }

    @Override
    public synchronized void cancel() throws SQLException {
        this.closeAllResults();
    }

    @Override
    public synchronized void clearBatch() throws SQLException {
        this.batches.clear();
    }

    @Override
    public synchronized void clearWarnings() throws SQLException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws SQLException {
        Object object = this.mcbConn.getLock();
        synchronized (object) {
            this.closeAllResults();
            this.mcbConn.returnStatementId(this.StatementId);
            this.mcbConn.removeStatement(this);
        }
    }

    public synchronized void closeForMeta() throws SQLException {
        this.mcbConn.returnStatementId(this.StatementId);
        this.mcbConn.removeStatement(this);
    }

    private synchronized void closeAllResults() throws SQLException {
        if (this.timeHandle != null) {
            this.timeHandle.cancel(false);
            this.scheduler.shutdown();
            this.timeHandle = null;
        }
        for (MachResultSet machResultSet : this.resultSets) {
            machResultSet.close();
        }
        if (this.useFlag) {
            this.mcbConn.getProtocol().close(this.StatementId);
            this.useFlag = false;
        }
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        Object object = this.mcbConn.getLock();
        synchronized (object) {
            this.cancel();
            this.reset();
            int ret = -1;
            int qto = this.queryTimeout;
            if (qto > 0) {
                this.timeHandle = this.scheduler.schedule(new QueryTimeout(this.mcbConn, this), (long)qto, TimeUnit.MILLISECONDS);
            }
            ret = this.mcbConn.getProtocol().execSQL(this, sql.trim());
            if (qto > 0 && this.timeHandle != null) {
                this.timeHandle.cancel(false);
                this.scheduler.shutdown();
                this.timeHandle = null;
            }
            if (ret == 0) {
                return false;
            }
            if (ret == 1) {
                return true;
            }
            throw new SQLException("invalid execution");
        }
    }

    public synchronized void addResultSet(MachResultSet rslt) {
        this.resultSets.add(rslt);
    }

    @Override
    public synchronized int[] executeBatch() throws SQLException {
        this.cancel();
        this.reset();
        int size = this.batches.size();
        int[] counts = new int[size];
        for (int i = 0; i < size; ++i) {
            String sql = this.batches.get(i);
            try {
                int qto = this.queryTimeout;
                if (qto > 0) {
                    this.timeHandle = this.scheduler.schedule(new QueryTimeout(this.mcbConn, this), (long)qto, TimeUnit.MILLISECONDS);
                }
                int ret = this.mcbConn.getProtocol().execSQL(this, sql.trim());
                if (qto > 0 && this.timeHandle != null) {
                    this.timeHandle.cancel(false);
                    this.scheduler.shutdown();
                    this.timeHandle = null;
                }
                if (ret != 0) {
                    throw new SQLException("invalid UpdateCount");
                }
                if (this.resultSets.size() > 0) {
                    counts[i] = ((MachResultSet)this.resultSets.get(0)).getUpdateCount();
                    continue;
                }
                counts[i] = 0;
                continue;
            }
            catch (SQLException e) {
                int[] updates = new int[i];
                for (int j = 0; j < i; ++j) {
                    updates[j] = counts[j];
                }
                throw new BatchUpdateException(e.getMessage(), updates);
            }
        }
        this.clearBatch();
        return counts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        Object object = this.mcbConn.getLock();
        synchronized (object) {
            int ret;
            this.cancel();
            this.reset();
            int qto = this.queryTimeout;
            if (qto > 0) {
                this.timeHandle = this.scheduler.schedule(new QueryTimeout(this.mcbConn, this), (long)qto, TimeUnit.MILLISECONDS);
            }
            if ((ret = this.mcbConn.getProtocol().execSQL(this, sql.trim())) != 1) {
                if (this.timeHandle != null) {
                    this.timeHandle.cancel(false);
                    this.scheduler.shutdown();
                    this.timeHandle = null;
                }
                throw new SQLException("invalid resultset");
            }
            ResultSet rslt = null;
            if (this.resultSets.size() > 0) {
                rslt = (MachResultSet)this.resultSets.get(0);
            }
            return rslt;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int executeUpdate(String sql) throws SQLException {
        Object object = this.mcbConn.getLock();
        synchronized (object) {
            this.cancel();
            this.reset();
            int qto = this.queryTimeout;
            if (qto > 0) {
                this.timeHandle = this.scheduler.schedule(new QueryTimeout(this.mcbConn, this), (long)qto, TimeUnit.MILLISECONDS);
            }
            int ret = this.mcbConn.getProtocol().execSQL(this, sql.trim());
            if (qto > 0 && this.timeHandle != null) {
                this.timeHandle.cancel(false);
                this.scheduler.shutdown();
                this.timeHandle = null;
            }
            if (ret != 0) {
                throw new SQLException("invalid UpdateCount");
            }
            if (this.resultSets.size() > 0) {
                return ((MachResultSet)this.resultSets.get(0)).getUpdateCount();
            }
            return 0;
        }
    }

    @Override
    public synchronized int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        return this.executeUpdate(sql);
    }

    @Override
    public synchronized int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        return this.executeUpdate(sql);
    }

    @Override
    public synchronized int executeUpdate(String sql, String[] columnNames) throws SQLException {
        return this.executeUpdate(sql);
    }

    public synchronized ResultSet executeAppendOpen(String aTableName, int aErrorCheckCount) throws SQLException {
        int ret = this.mcbConn.getProtocol().appendOpen(this, aTableName, aErrorCheckCount);
        if (ret != 1) {
            throw new SQLException("invalid append open result");
        }
        if (this.resultSets.size() > 0) {
            return (MachResultSet)this.resultSets.get(0);
        }
        return null;
    }

    public synchronized int executeSetAppendErrorCallback(MachAppendCallback aCallback) throws SQLException {
        int ret = this.mcbConn.getProtocol().setAppendErrorCallback(this, aCallback);
        if (ret != 1) {
            throw new SQLException("invalid append set error callback");
        }
        return 1;
    }

    public synchronized int executeAppendFlush() throws SQLException {
        int ret = this.mcbConn.getProtocol().appendFlush(this);
        if (ret != 1) {
            throw new SQLException("invalid append flush");
        }
        return 1;
    }

    public synchronized int executeAppendData(ResultSetMetaData rsmd, ArrayList aData) throws SQLException {
        this.cancel();
        this.reset();
        int ret = this.mcbConn.getProtocol().appendData(this, (MachResultSetMetaData)rsmd, aData);
        if (ret != 1 && ret != 2) {
            throw new SQLException("invalid append data");
        }
        return 1;
    }

    public synchronized int executeAppendDataByTime(ResultSetMetaData rsmd, long aTime, ArrayList aData) throws SQLException {
        int ret = this.mcbConn.getProtocol().appendDataByTime(this, (MachResultSetMetaData)rsmd, aTime, aData);
        if (ret != 1) {
            throw new SQLException("invalid append data");
        }
        return 1;
    }

    public synchronized int executeAppendClose() throws SQLException {
        int ret = this.mcbConn.getProtocol().appendClose(this);
        if (ret != 1) {
            throw new SQLException("invalid append close");
        }
        return 1;
    }

    public synchronized long getAppendSuccessCount() throws SQLException {
        return this.mcbConn.getProtocol().getSuccessCount();
    }

    public synchronized long getAppendFailureCount() throws SQLException {
        return this.mcbConn.getProtocol().getFailureCount();
    }

    @Override
    public synchronized Connection getConnection() {
        return this.mcbConn;
    }

    public String getEncoding() {
        return this.mcbConn.getEncoding();
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        return this.maxFieldSize;
    }

    @Override
    public int getMaxRows() throws SQLException {
        return this.maxRows;
    }

    @Override
    public synchronized boolean getMoreResults() throws SQLException {
        return this.resultSets.size() > 1;
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        return this.queryTimeout / 1000;
    }

    @Override
    public synchronized ResultSet getResultSet() throws SQLException {
        MachResultSet rslt = null;
        if (this.resultSets.size() > 0) {
            rslt = (MachResultSet)this.resultSets.get(0);
        }
        return rslt;
    }

    public synchronized MachResultSet getRslt() {
        if (this.resultSets.size() > 0) {
            return (MachResultSet)this.resultSets.get(0);
        }
        return null;
    }

    @Override
    public synchronized int getUpdateCount() throws SQLException {
        if (this.resultSets.size() > 0) {
            MachResultSet rslt = (MachResultSet)this.resultSets.get(0);
            int x = rslt.getUpdateCount();
            return x;
        }
        return 0;
    }

    @Override
    public final SQLWarning getWarnings() throws SQLException {
        return null;
    }

    protected synchronized void reset() throws SQLException {
        try {
            this.clearWarnings();
        }
        catch (SQLException e) {
            throw new SQLException(e.getMessage());
        }
        this.resultSets.clear();
    }

    @Override
    public void setQueryTimeout(int second) throws SQLException {
        this.queryTimeout = second * 1000;
    }

    @Override
    public void setCursorName(String unused) throws SQLException {
    }

    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
        if (enable) {
            throw new SQLException("this method not supported.");
        }
    }

    @Override
    public void setMaxFieldSize(int max) throws SQLException {
        this.maxFieldSize = max;
    }

    @Override
    public void setMaxRows(int max) throws SQLException {
        this.maxRows = max;
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        return 0;
    }

    @Override
    public int getResultSetType() throws SQLException {
        return 0;
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
    }

    @Override
    public int getFetchSize() throws SQLException {
        return this.fetchSize;
    }

    @Override
    public int getFetchDirection() throws SQLException {
        return 0;
    }

    @Override
    public void setFetchSize(int max) throws SQLException {
        this.fetchSize = max <= 0 ? 20000 : max;
    }

    public MachBuffer getReadBuffer() throws SQLException {
        return this.readBuffer;
    }

    @Override
    public synchronized boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public synchronized boolean execute(String sql, int[] columnIndexes) throws SQLException {
        boolean returnvalue = this.execute(sql, 2);
        return returnvalue;
    }

    @Override
    public synchronized boolean execute(String sql, String[] columnNames) throws SQLException {
        boolean returnvalue = this.execute(sql, 2);
        return returnvalue;
    }

    @Override
    public synchronized ResultSet getGeneratedKeys() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public synchronized boolean getMoreResults(int current) throws SQLException {
        throw new UnsupportedOperationException();
    }

    int getHoldability() {
        if (this.is_holdable) {
            return 1;
        }
        return 2;
    }

    @Override
    public synchronized int getResultSetHoldability() throws SQLException {
        return this.getHoldability();
    }

    @Override
    public boolean isClosed() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isPoolable() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setPoolable(boolean poolable) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void closeOnCompletion() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        throw new UnsupportedOperationException();
    }

    protected class QueryTimeout
    implements Runnable {
        MachConnection _mcbConn = null;
        MachStatement _stmtId = null;

        public QueryTimeout(MachConnection conn, MachStatement stmt) {
            this._mcbConn = conn;
            this._stmtId = stmt;
        }

        @Override
        public void run() {
            try {
                Connection conn = DriverManager.getConnection(this._mcbConn.url, this._mcbConn.user, this._mcbConn.password);
                Statement stmt = conn.createStatement();
                boolean ret = stmt.execute("ALTER SYSTEM CANCEL SESSION " + Long.toString(this._mcbConn.getSessionId()));
                if (stmt != null) {
                    stmt.close();
                }
                if (conn != null) {
                    conn.close();
                }
                MachStatement.this.scheduler.shutdown();
                MachStatement.this.timeHandle = null;
            }
            catch (SQLException e) {
                throw new RuntimeException("query timeout.");
            }
        }
    }
}

