/*
 * Decompiled with CFR 0.152.
 */
package com.machbase.jdbc;

import com.machbase.jdbc.MachConnection;
import com.machbase.jdbc.MachMetaData;
import java.sql.SQLException;
import java.util.Vector;

public class MachTableMetaData {
    Vector<Object> tableNameList = null;
    Vector<Object> columnNameList = null;
    Vector<Object> columnTypeList = null;
    int columnCount = 0;
    protected MachConnection mcbConn = null;

    public MachTableMetaData(MachConnection aConn, int count) {
        this.mcbConn = aConn;
        this.columnCount = count;
        this.tableNameList = new Vector(count);
        this.columnNameList = new Vector(count);
        this.columnTypeList = new Vector(count);
    }

    public synchronized int getColumnCount() {
        return this.columnCount;
    }

    public int getColumnDisplaySize(int c) {
        return 20;
    }

    public String getColumnName(int c) throws SQLException {
        if (c < 1 || c > this.columnNameList.size()) {
            throw new SQLException("invalid column index");
        }
        return (String)this.columnNameList.elementAt(c - 1);
    }

    public String getTableName(int c) throws SQLException {
        if (c < 1 || c > this.tableNameList.size()) {
            throw new SQLException("invalid column index");
        }
        return (String)this.tableNameList.elementAt(c - 1);
    }

    public synchronized int getColumnType(int c) throws SQLException {
        if (c < 1 || c > this.columnCount) {
            throw new SQLException("invalid column index");
        }
        return ((MachMetaData)this.columnTypeList.elementAt(c - 1)).getColumnType();
    }

    public int getPrecision(int c) throws SQLException {
        if (c < 1 || c > this.columnCount) {
            throw new SQLException("invalid column index");
        }
        return ((MachMetaData)this.columnTypeList.elementAt(c - 1)).getPrecision();
    }

    public int getScale(int c) throws SQLException {
        if (c < 1 || c > this.columnTypeList.size()) {
            throw new SQLException("invalid column index");
        }
        return ((MachMetaData)this.columnTypeList.elementAt(c - 1)).getScale();
    }

    public int isNullable(int c) throws SQLException {
        if (c < 1 || c > this.columnTypeList.size()) {
            throw new SQLException("invalid column index");
        }
        return ((MachMetaData)this.columnTypeList.elementAt(c - 1)).isNullable();
    }

    public void addColumn(String tname, String name, byte[] type) {
        this.tableNameList.addElement(tname.toUpperCase());
        this.columnNameList.addElement(name.toUpperCase());
        MachMetaData cdata = new MachMetaData(type);
        this.columnTypeList.addElement(cdata);
    }

    public int findColumn(String name) {
        int index = this.columnNameList.indexOf(name.toUpperCase());
        if (index == -1) {
            return index;
        }
        return index + 1;
    }

    public void setColumnName(int idx, String name) {
        this.columnNameList.setElementAt(name, idx);
    }

    public void setColumnType(int c, int type) throws SQLException {
        if (c < 1 || c > this.columnTypeList.size()) {
            throw new SQLException("invalid column index");
        }
        ((MachMetaData)this.columnTypeList.elementAt(c - 1)).setColumnType(type);
    }

    public MachConnection getConnection() throws SQLException {
        return this.mcbConn;
    }
}

