/*
 * Decompiled with CFR 0.152.
 */
package com.machbase.jdbc;

import com.machbase.jdbc.MachConnection;
import com.machbase.jdbc.MachMetaData;
import java.sql.SQLException;
import java.util.Vector;

public class MachTableMetaParam {
    Vector<Object> paramTypeList = null;
    int paramCount = 0;
    protected MachConnection mcbConn = null;

    public MachTableMetaParam(MachConnection aConn, int count) {
        this.mcbConn = aConn;
        this.paramCount = count;
        this.paramTypeList = new Vector(count);
    }

    public synchronized int getParamCount() {
        return this.paramCount;
    }

    public synchronized int getColumnType(int c) throws SQLException {
        if (c < 1 || c > this.paramCount) {
            throw new SQLException("invalid parameter index");
        }
        return ((MachMetaData)this.paramTypeList.elementAt(c - 1)).getColumnType();
    }

    public int getPrecision(int c) throws SQLException {
        if (c < 1 || c > this.paramCount) {
            throw new SQLException("invalid parameter index");
        }
        return ((MachMetaData)this.paramTypeList.elementAt(c - 1)).getPrecision();
    }

    public int getScale(int c) throws SQLException {
        if (c < 1 || c > this.paramCount) {
            throw new SQLException("invalid parameter index");
        }
        return ((MachMetaData)this.paramTypeList.elementAt(c - 1)).getScale();
    }

    public int isNullable(int c) throws SQLException {
        if (c < 1 || c > this.paramCount) {
            throw new SQLException("invalid parameter index");
        }
        return ((MachMetaData)this.paramTypeList.elementAt(c - 1)).isNullable();
    }

    public void addParam(byte[] type) {
        MachMetaData cdata = new MachMetaData(type);
        this.paramTypeList.addElement(cdata);
    }

    public void setParamType(int c, int type) throws SQLException {
        if (c < 1 || c > this.paramTypeList.size()) {
            throw new SQLException("invalid parameter index");
        }
        ((MachMetaData)this.paramTypeList.elementAt(c - 1)).setColumnType(type);
    }

    public MachConnection getConnection() throws SQLException {
        return this.mcbConn;
    }
}

