/*
 * Decompiled with CFR 0.152.
 */
package com.machbase.jdbc;

import java.math.BigInteger;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.StringTokenizer;
import java.util.TimeZone;

public class MachTypeConversion {
    public static byte[] shortToBytes(short val) {
        byte[] b = new byte[2];
        int tmpValue = 0;
        tmpValue = val >> 8;
        b[0] = (byte)tmpValue;
        b[1] = (byte)val;
        return b;
    }

    public static byte[] ushortToBytes(int aVal) {
        byte[] b = new byte[]{(byte)(aVal >>> 8 & 0xFF), (byte)(aVal & 0xFF)};
        return b;
    }

    public static byte[] intToBytes(int val) {
        byte[] b = new byte[4];
        int tmpValue = 0;
        for (int i = 0; i < 4; ++i) {
            tmpValue = val >> 8 * (3 - i);
            b[i] = (byte)tmpValue;
        }
        return b;
    }

    public static byte[] uintToBytes(long aVal) {
        byte[] b = new byte[]{(byte)(aVal >>> 24 & 0xFFL), (byte)(aVal >>> 16 & 0xFFL), (byte)(aVal >>> 8 & 0xFFL), (byte)(aVal & 0xFFL)};
        return b;
    }

    public static byte[] longToBytes(long val) {
        byte[] b = new byte[8];
        int tmpValue = 0;
        for (int i = 0; i < 8; ++i) {
            tmpValue = (int)(val >> 8 * (7 - i));
            b[i] = (byte)tmpValue;
        }
        return b;
    }

    public static byte[] ulongToBytes(long aVal) {
        return MachTypeConversion.longToBytes(aVal);
    }

    public static byte[] ulongToBytes(BigInteger aVal) {
        byte[] sTmp = new byte[8];
        byte[] b = aVal.toByteArray();
        if (b.length <= 8) {
            int sBlank = 8 - b.length;
            for (int i = 0; i < sBlank; ++i) {
                sTmp[i] = 0;
            }
            System.arraycopy(b, 0, sTmp, sBlank, b.length);
        } else {
            int sOver = b.length - 8;
            System.arraycopy(b, sOver, sTmp, 0, 8);
        }
        return sTmp;
    }

    public static byte[] floatToBytes(float f) {
        byte[] b = new byte[4];
        int val = Float.floatToIntBits(f);
        b = MachTypeConversion.intToBytes(val);
        return b;
    }

    public static byte[] doubleToBytes(double d) {
        byte[] b = new byte[8];
        long val = Double.doubleToLongBits(d);
        b = MachTypeConversion.longToBytes(val);
        return b;
    }

    public static byte[] ipv4ToBytes(String s) {
        byte[] b = new byte[5];
        if (s == null || s.length() == 0) {
            for (int i = 0; i < 5; ++i) {
                b[i] = 0;
            }
        } else {
            b[0] = 4;
            int i = 1;
            StringTokenizer st = new StringTokenizer(s, ".");
            while (st.hasMoreTokens()) {
                b[i++] = (byte)Integer.parseInt(st.nextToken());
            }
        }
        return b;
    }

    public static byte[] ipv6ToBytes(String s) {
        byte[] b = new byte[17];
        if (s == null || s.length() == 0) {
            for (int i = 0; i < 17; ++i) {
                b[i] = 0;
            }
        } else {
            try {
                InetAddress sAddr = InetAddress.getByName(s);
                byte[] sBuf = sAddr.getAddress();
                b[0] = 6;
                if (sBuf.length == 4) {
                    int i;
                    for (i = 0; i < 12; ++i) {
                        b[i + 1] = 0;
                    }
                    for (i = 0; i < sBuf.length; ++i) {
                        b[i + 13] = sBuf[i];
                    }
                }
                for (int i = 0; i < sBuf.length; ++i) {
                    b[i + 1] = sBuf[i];
                }
            }
            catch (UnknownHostException e) {
                for (int i = 0; i < 17; ++i) {
                    b[i] = 0;
                }
            }
        }
        return b;
    }

    public static byte[] timeToBytes(Time t) {
        return MachTypeConversion.timeToBytes(t, false, 0L);
    }

    public static byte[] timeToBytes(Time t, long aTimezoneSec) {
        return MachTypeConversion.timeToBytes(t, true, aTimezoneSec);
    }

    public static byte[] timeToBytes(Time t, boolean aUseTimezone, long aTimezoneSec) {
        Calendar c = Calendar.getInstance();
        if (aUseTimezone) {
            TimeZone tmpTimezone = TimeZone.getDefault();
            tmpTimezone.setRawOffset((int)aTimezoneSec * 1000);
            c.setTimeZone(tmpTimezone);
        }
        c.setTime(t);
        byte[] b = new byte[8];
        b = MachTypeConversion.longToBytes(c.getTimeInMillis() * 1000000L);
        return b;
    }

    public static byte[] dateToBytes(Date d) {
        return MachTypeConversion.dateToBytes(d, false, 0L);
    }

    public static byte[] dateToBytes(Date d, long aTimezoneSec) {
        return MachTypeConversion.dateToBytes(d, true, aTimezoneSec);
    }

    public static byte[] dateToBytes(Date d, boolean aUseTimezone, long aTimezoneSec) {
        Calendar c = Calendar.getInstance();
        if (aUseTimezone) {
            TimeZone tmpTimezone = TimeZone.getDefault();
            tmpTimezone.setRawOffset((int)aTimezoneSec * 1000);
            c.setTimeZone(tmpTimezone);
        }
        c.setTime(d);
        byte[] b = new byte[8];
        b = MachTypeConversion.longToBytes(c.getTimeInMillis() * 1000000L);
        return b;
    }

    public static String dateToString(Date d) {
        return MachTypeConversion.dateToString(d, false, 0L);
    }

    public static String dateToString(Date d, long aTimezoneSec) {
        return MachTypeConversion.dateToString(d, true, aTimezoneSec);
    }

    public static String dateToString(Date d, boolean aUseTimezone, long aTimezoneSec) {
        int i;
        Calendar c = Calendar.getInstance();
        if (aUseTimezone) {
            TimeZone tmpTimezone = TimeZone.getDefault();
            tmpTimezone.setRawOffset((int)aTimezoneSec * 1000);
            c.setTimeZone(tmpTimezone);
        }
        c.setTime(d);
        StringBuffer ret = new StringBuffer();
        int tmp = c.get(1);
        String sTmp = Integer.toString(tmp);
        for (i = sTmp.length(); i < 4; ++i) {
            sTmp = "0" + sTmp;
        }
        ret.append(sTmp);
        ret.append("/");
        tmp = c.get(2) + 1;
        sTmp = Integer.toString(tmp);
        for (i = sTmp.length(); i < 2; ++i) {
            sTmp = "0" + sTmp;
        }
        ret.append(sTmp);
        ret.append("/");
        tmp = c.get(5);
        sTmp = Integer.toString(tmp);
        for (i = sTmp.length(); i < 2; ++i) {
            sTmp = "0" + sTmp;
        }
        ret.append(sTmp);
        ret.append(" ");
        tmp = c.get(11);
        sTmp = Integer.toString(tmp);
        for (i = sTmp.length(); i < 2; ++i) {
            sTmp = "0" + sTmp;
        }
        ret.append(sTmp);
        ret.append(":");
        tmp = c.get(12);
        sTmp = Integer.toString(tmp);
        for (i = sTmp.length(); i < 2; ++i) {
            sTmp = "0" + sTmp;
        }
        ret.append(sTmp);
        ret.append(":");
        tmp = c.get(13);
        sTmp = Integer.toString(tmp);
        for (i = sTmp.length(); i < 2; ++i) {
            sTmp = "0" + sTmp;
        }
        ret.append(sTmp);
        return ret.toString();
    }

    public static byte[] timestampToBytes(Timestamp t) {
        return MachTypeConversion.timestampToBytes(t, false, 0L);
    }

    public static byte[] timestampToBytes(Timestamp t, long aTimezoneSec) {
        return MachTypeConversion.timestampToBytes(t, true, aTimezoneSec);
    }

    public static byte[] timestampToBytes(Timestamp t, boolean aUseTimezone, long aTimezoneSec) {
        Calendar c = Calendar.getInstance();
        if (aUseTimezone) {
            TimeZone tmpTimezone = TimeZone.getDefault();
            tmpTimezone.setRawOffset((int)aTimezoneSec * 1000);
            c.setTimeZone(tmpTimezone);
        }
        c.setTime(t);
        byte[] b = new byte[8];
        b = MachTypeConversion.longToBytes(c.getTimeInMillis() * 1000000L);
        return b;
    }

    public static String timestampToString(Timestamp t) {
        return MachTypeConversion.timestampToString(t, false, 0L);
    }

    public static String timestampToString(Timestamp t, long aTimezoneSec) {
        return MachTypeConversion.timestampToString(t, true, aTimezoneSec);
    }

    public static String timestampToString(Timestamp t, boolean aUseTimezone, long aTimezoneSec) {
        int i;
        Calendar c = Calendar.getInstance();
        if (aUseTimezone) {
            TimeZone tmpTimezone = TimeZone.getDefault();
            tmpTimezone.setRawOffset((int)aTimezoneSec * 1000);
            c.setTimeZone(tmpTimezone);
        }
        c.setTime(t);
        StringBuffer ret = new StringBuffer();
        int tmp = c.get(1);
        String sTmp = Integer.toString(tmp);
        for (i = sTmp.length(); i < 4; ++i) {
            sTmp = "0" + sTmp;
        }
        ret.append(sTmp);
        ret.append("/");
        tmp = c.get(2) + 1;
        sTmp = Integer.toString(tmp);
        for (i = sTmp.length(); i < 2; ++i) {
            sTmp = "0" + sTmp;
        }
        ret.append(sTmp);
        ret.append("/");
        tmp = c.get(5);
        sTmp = Integer.toString(tmp);
        for (i = sTmp.length(); i < 2; ++i) {
            sTmp = "0" + sTmp;
        }
        ret.append(sTmp);
        ret.append(" ");
        tmp = c.get(11);
        sTmp = Integer.toString(tmp);
        for (i = sTmp.length(); i < 2; ++i) {
            sTmp = "0" + sTmp;
        }
        ret.append(sTmp);
        ret.append(":");
        tmp = c.get(12);
        sTmp = Integer.toString(tmp);
        for (i = sTmp.length(); i < 2; ++i) {
            sTmp = "0" + sTmp;
        }
        ret.append(sTmp);
        ret.append(":");
        tmp = c.get(13);
        sTmp = Integer.toString(tmp);
        for (i = sTmp.length(); i < 2; ++i) {
            sTmp = "0" + sTmp;
        }
        ret.append(sTmp);
        ret.append(".");
        int milSec = c.get(14);
        sTmp = Integer.toString(tmp);
        for (int i2 = sTmp.length(); i2 < 3; ++i2) {
            sTmp = "0" + sTmp;
        }
        ret.append(sTmp);
        return ret.toString();
    }
}

