/*
 * Decompiled with CFR 0.152.
 */
package com.machinepublishers.jbrowserdriver;

import com.machinepublishers.jbrowserdriver.Settings;
import com.machinepublishers.jbrowserdriver.SettingsManager;
import com.machinepublishers.jbrowserdriver.StatusCode;
import com.machinepublishers.jbrowserdriver.StatusMonitor;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javafx.application.Platform;

class AjaxListener
implements Runnable {
    private static final long MAX_WAIT_DEFAULT = 15000L;
    private static final int IDLE_COUNT_TARGET = 3;
    private final AtomicBoolean started;
    private final AtomicInteger newStatusCode;
    private final StatusCode statusCode;
    private final Map<String, Long> resources;
    private final long timeoutMS;

    AjaxListener(AtomicBoolean started, AtomicInteger newStatusCode, StatusCode statusCode, Map<String, Long> resources, long timeoutMS) {
        this.started = started;
        this.newStatusCode = newStatusCode;
        this.statusCode = statusCode;
        this.resources = resources;
        this.timeoutMS = timeoutMS <= 0L ? 15000L : timeoutMS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (true) {
            long start;
            StatusCode statusCode = this.statusCode;
            synchronized (statusCode) {
                while (this.statusCode.get() != 0) {
                    try {
                        this.statusCode.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            int size = 0;
            long time = start = System.currentTimeMillis();
            Settings settings = SettingsManager.settings();
            final AtomicBoolean done = new AtomicBoolean();
            Platform.runLater((Runnable)new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    AtomicBoolean atomicBoolean = done;
                    synchronized (atomicBoolean) {
                        done.set(true);
                        done.notifyAll();
                    }
                }
            });
            Object object = done;
            synchronized (object) {
                while (!done.get()) {
                    try {
                        done.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            if (settings != null) {
                int idleCountTarget;
                long sleepMS = Math.max(settings.ajaxWait() / 3L, 0L);
                int idleCount = 0;
                int n = idleCountTarget = sleepMS == 0L ? 1 : 3;
                while (time - start < this.timeoutMS) {
                    try {
                        Thread.sleep(sleepMS);
                    }
                    catch (InterruptedException e) {
                        return;
                    }
                    time = System.currentTimeMillis();
                    StatusCode statusCode2 = this.statusCode;
                    synchronized (statusCode2) {
                        if (Thread.interrupted()) {
                            return;
                        }
                        HashSet<String> remove = new HashSet<String>();
                        for (Map.Entry<String, Long> entry : this.resources.entrySet()) {
                            if (time - entry.getValue() <= settings.ajaxResourceTimeout()) continue;
                            remove.add(entry.getKey());
                        }
                        for (String key : remove) {
                            this.resources.remove(key);
                        }
                        size = this.resources.size();
                    }
                    idleCount = size == 0 ? ++idleCount : 0;
                    if (idleCount != idleCountTarget) continue;
                }
            }
            object = this.statusCode;
            synchronized (object) {
                if (Thread.interrupted()) {
                    return;
                }
                int newStatusCodeVal = this.newStatusCode.getAndSet(0);
                newStatusCodeVal = newStatusCodeVal <= 0 ? (this.started.get() ? 0 : 200) : newStatusCodeVal;
                this.resources.clear();
                StatusMonitor.instance().clear();
                this.statusCode.set(newStatusCodeVal);
                this.statusCode.notifyAll();
            }
        }
    }
}

