/*
 * Decompiled with CFR 0.152.
 */
package com.machinepublishers.jbrowserdriver;

import com.google.common.util.concurrent.UncheckedExecutionException;
import com.machinepublishers.jbrowserdriver.LogsServer;
import com.machinepublishers.jbrowserdriver.StatusCode;
import java.util.Random;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javafx.application.Platform;
import org.openqa.selenium.TimeoutException;

class AppThread {
    private static final Random rand = new Random();

    AppThread() {
    }

    private static void pause() {
        AppThread.exec(new Sync<Object>(){

            @Override
            public Object perform() {
                try {
                    Thread.sleep(30 + rand.nextInt(40));
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                return null;
            }
        });
    }

    static void handleExecutionException(Object obj) {
        if (obj instanceof UncheckedExecutionException) {
            throw (UncheckedExecutionException)obj;
        }
        if (obj instanceof RuntimeException) {
            throw new UncheckedExecutionException((Throwable)((RuntimeException)obj));
        }
        if (obj instanceof Throwable) {
            throw new UncheckedExecutionException((Throwable)new RuntimeException((Throwable)obj));
        }
    }

    static <T> T exec(Sync<T> action) {
        return AppThread.exec(false, new StatusCode(), 0L, action);
    }

    static <T> T exec(StatusCode statusCode, Sync<T> action) {
        return AppThread.exec(false, statusCode, 0L, action);
    }

    static <T> T exec(boolean pauseAfterExec, StatusCode statusCode, Sync<T> action) {
        return AppThread.exec(pauseAfterExec, statusCode, 0L, action);
    }

    static <T> T exec(StatusCode statusCode, long timeout, Sync<T> action) {
        return AppThread.exec(false, statusCode, timeout, action);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static <T> T exec(boolean pauseAfterExec, StatusCode statusCode, long timeout, Sync<T> action) {
        try {
            if (Platform.isFxApplicationThread()) {
                T t = action.perform();
                return t;
            }
            Runner<T> runner = new Runner<T>(action, statusCode);
            AtomicBoolean atomicBoolean = ((Runner)runner).done;
            synchronized (atomicBoolean) {
                Platform.runLater(runner);
            }
            atomicBoolean = ((Runner)runner).done;
            synchronized (atomicBoolean) {
                if (!((Runner)runner).done.get()) {
                    try {
                        ((Runner)runner).done.wait(timeout);
                    }
                    catch (InterruptedException e) {
                        LogsServer.instance().exception(e);
                    }
                    if (!((Runner)runner).done.get()) {
                        ((Runner)runner).cancel.set(true);
                        throw new TimeoutException("Timeout of " + timeout + "ms reached.");
                    }
                }
                AppThread.handleExecutionException(((Runner)runner).failure.get());
                Object v = ((Runner)runner).returned.get();
                return (T)v;
            }
        }
        finally {
            if (pauseAfterExec) {
                AppThread.pause();
            }
        }
    }

    private static class Runner<T>
    implements Runnable {
        private static final int MAX_DELAY = 500;
        private final Sync<T> action;
        private final StatusCode statusCode;
        private final AtomicBoolean done;
        private final AtomicReference<T> returned;
        private final int delay;
        private final AtomicBoolean cancel;
        private final AtomicReference<Throwable> failure;

        public Runner(Sync<T> action, StatusCode statusCode) {
            this.action = action;
            this.statusCode = statusCode;
            this.done = new AtomicBoolean();
            this.returned = new AtomicReference();
            this.delay = 1;
            this.cancel = new AtomicBoolean();
            this.failure = new AtomicReference();
        }

        public Runner(Runner other) {
            this.action = other.action;
            this.statusCode = other.statusCode;
            this.done = other.done;
            this.returned = other.returned;
            this.delay = Math.min(500, other.delay * 2);
            this.cancel = other.cancel;
            this.failure = other.failure;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (!this.cancel.get()) {
                StatusCode statusCode = this.statusCode;
                synchronized (statusCode) {
                    if (this.statusCode.get() == 0) {
                        final Runner<T> newRunner = new Runner<T>(this);
                        new Thread(new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    Thread.sleep(delay);
                                }
                                catch (InterruptedException interruptedException) {
                                    // empty catch block
                                }
                                Platform.runLater((Runnable)newRunner);
                            }
                        }).start();
                    } else {
                        if (this.statusCode.get() > 299) {
                            LogsServer.instance().trace("Performing browser action, but HTTP status is " + this.statusCode.get() + ".");
                        }
                        Object result = null;
                        try {
                            result = this.action.perform();
                        }
                        catch (Throwable t) {
                            this.failure.set(t);
                        }
                        finally {
                            AtomicBoolean atomicBoolean = this.done;
                            synchronized (atomicBoolean) {
                                this.returned.set(result);
                                this.done.set(true);
                                this.done.notifyAll();
                            }
                        }
                    }
                }
            }
        }
    }

    static interface Sync<T> {
        public T perform();
    }
}

