/*
 * Decompiled with CFR 0.152.
 */
package com.machinepublishers.jbrowserdriver;

import com.machinepublishers.jbrowserdriver.AjaxListener;
import com.machinepublishers.jbrowserdriver.ContextItem;
import com.machinepublishers.jbrowserdriver.JavascriptLog;
import com.machinepublishers.jbrowserdriver.LogsServer;
import com.machinepublishers.jbrowserdriver.Settings;
import com.machinepublishers.jbrowserdriver.SettingsManager;
import com.machinepublishers.jbrowserdriver.StatusCode;
import com.machinepublishers.jbrowserdriver.StatusMonitor;
import com.sun.javafx.webkit.Accessor;
import com.sun.webkit.LoadListenerClient;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import javafx.scene.web.WebEngine;

class HttpListener
implements LoadListenerClient {
    private static final Map<Integer, String> states;
    private static final Map<Integer, String> errors;
    private final Map<String, Long> resources = new HashMap<String, Long>();
    private final ContextItem contextItem;
    private final StatusCode statusCode;
    private final AtomicLong timeoutMS;
    private final StatusMonitor statusMonitor;
    private final LogsServer logs;
    private final AtomicReference<Thread> ajaxListenerThread = new AtomicReference();
    private final AjaxListener ajaxListener;
    private final AtomicInteger newStatusCode = new AtomicInteger();
    private final AtomicBoolean started = new AtomicBoolean();

    HttpListener(ContextItem contextItem, StatusCode statusCode, AtomicLong timeoutMS) {
        this.contextItem = contextItem;
        this.statusCode = statusCode;
        this.timeoutMS = timeoutMS;
        this.statusMonitor = StatusMonitor.instance();
        this.logs = LogsServer.instance();
        this.ajaxListener = new AjaxListener(this.started, this.newStatusCode, this.statusCode, this.resources, this.timeoutMS.get());
    }

    void init() {
        this.ajaxListenerThread.set(new Thread(this.ajaxListener));
        this.ajaxListenerThread.get().setDaemon(true);
        this.ajaxListenerThread.get().start();
    }

    protected void finalize() throws Throwable {
        try {
            super.finalize();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            this.ajaxListenerThread.get().interrupt();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void trace(String label, long frame, int state, String url, String contentType, double progress, int errorCode) {
        if (state != 30) {
            this.logs.trace("-" + label + "-> " + url + " ** {timestamp: " + System.currentTimeMillis() + ", state: " + states.get(state) + ", progress: " + progress + ", error: " + errors.get(errorCode) + ", contentType: " + contentType + ", frame: " + frame + "}");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispatchResourceLoadEvent(long frame, int state, String url, String contentType, double progress, int errorCode) {
        Settings settings = SettingsManager.settings();
        if (settings == null) {
            throw new RuntimeException("Request made after browser closed. Ignoring...");
        }
        StatusCode statusCode = this.statusCode;
        synchronized (statusCode) {
            if (url.startsWith("http://") || url.startsWith("https://")) {
                if (state == 20) {
                    this.resources.put(frame + url, System.currentTimeMillis());
                } else if (state == 22 || state == 23) {
                    String original = null;
                    original = this.statusMonitor.originalFromRedirect(url);
                    this.resources.remove(frame + url);
                    if (original != null) {
                        this.resources.remove(frame + original);
                    }
                }
            }
        }
        if (settings.logTrace() && (url.startsWith("http://") || url.startsWith("https://"))) {
            this.trace("Rsrc", frame, state, url, contentType, progress, errorCode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void resetStatusCode() {
        StatusCode statusCode = this.statusCode;
        synchronized (statusCode) {
            this.newStatusCode.set(0);
            this.statusCode.set(0);
            this.resources.clear();
            this.started.set(false);
            StatusMonitor.instance().clear();
            this.statusCode.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispatchLoadEvent(long frame, int state, String url, String contentType, double progress, int errorCode) {
        Settings settings = SettingsManager.settings();
        if (settings == null) {
            throw new RuntimeException("Request made after browser closed. Ignoring...");
        }
        long mainFrame = Accessor.getPageFor((WebEngine)this.contextItem.engine.get()).getMainFrame();
        StatusCode statusCode = this.statusCode;
        synchronized (statusCode) {
            if (state == 0 && settings.logJavascript()) {
                JavascriptLog.attach(Accessor.getPageFor((WebEngine)this.contextItem.engine.get()), frame);
            }
            if (state == 0 || state == 2 || state == 14) {
                this.started.set(true);
                this.resources.put(frame + url, System.currentTimeMillis());
                this.statusMonitor.monitor(url);
                this.statusMonitor.addPrimaryDocument(mainFrame == frame, url);
            } else if (state == 1 || state == 6 || state == 5) {
                if (mainFrame == frame) {
                    this.newStatusCode.set(this.statusMonitor.status(url));
                } else {
                    this.newStatusCode.compareAndSet(0, this.statusMonitor.status(url));
                }
                this.resources.remove(frame + url);
                String original = this.statusMonitor.originalFromRedirect(url);
                if (original != null) {
                    this.resources.remove(frame + original);
                }
            }
        }
        if (settings.logTrace()) {
            this.trace("Page", frame, state, url, contentType, progress, errorCode);
        }
    }

    static {
        HashMap<Integer, String> statesTmp = new HashMap<Integer, String>();
        statesTmp.put(0, "page_started");
        statesTmp.put(1, "page_finished");
        statesTmp.put(2, "page_redirected");
        statesTmp.put(5, "load_failed");
        statesTmp.put(6, "load_stopped");
        statesTmp.put(10, "content_received");
        statesTmp.put(11, "title_received");
        statesTmp.put(12, "icon_received");
        statesTmp.put(13, "contenttype_received");
        statesTmp.put(14, "document_available");
        statesTmp.put(20, "resource_started");
        statesTmp.put(21, "resource_redirected");
        statesTmp.put(22, "resource_finished");
        statesTmp.put(23, "resource_failed");
        statesTmp.put(30, "progress_changed");
        states = Collections.unmodifiableMap(statesTmp);
        HashMap<Integer, String> errorsTmp = new HashMap<Integer, String>();
        errorsTmp.put(0, "none");
        errorsTmp.put(1, "unknown_host");
        errorsTmp.put(2, "malformed_url");
        errorsTmp.put(3, "ssl_handshake");
        errorsTmp.put(4, "connection_refused");
        errorsTmp.put(5, "connection_reset");
        errorsTmp.put(6, "no_route_to_host");
        errorsTmp.put(7, "connection_timed_out");
        errorsTmp.put(8, "permission_denied");
        errorsTmp.put(9, "invalid_response");
        errorsTmp.put(10, "too_many_redirects");
        errorsTmp.put(11, "file_not_found");
        errorsTmp.put(99, "unknown_error");
        errors = Collections.unmodifiableMap(errorsTmp);
    }
}

