/*
 * Decompiled with CFR 0.152.
 */
package com.machinepublishers.jbrowserdriver;

import com.machinepublishers.jbrowserdriver.Element;
import com.machinepublishers.jbrowserdriver.ElementRemote;
import com.machinepublishers.jbrowserdriver.FileRemover;
import com.machinepublishers.jbrowserdriver.HeartbeatRemote;
import com.machinepublishers.jbrowserdriver.JBrowserDriverRemote;
import com.machinepublishers.jbrowserdriver.JBrowserDriverServer;
import com.machinepublishers.jbrowserdriver.Job;
import com.machinepublishers.jbrowserdriver.Keyboard;
import com.machinepublishers.jbrowserdriver.KeyboardRemote;
import com.machinepublishers.jbrowserdriver.Logs;
import com.machinepublishers.jbrowserdriver.LogsRemote;
import com.machinepublishers.jbrowserdriver.Mouse;
import com.machinepublishers.jbrowserdriver.MouseRemote;
import com.machinepublishers.jbrowserdriver.Navigation;
import com.machinepublishers.jbrowserdriver.NavigationRemote;
import com.machinepublishers.jbrowserdriver.Options;
import com.machinepublishers.jbrowserdriver.OptionsLocal;
import com.machinepublishers.jbrowserdriver.OptionsRemote;
import com.machinepublishers.jbrowserdriver.PortGroup;
import com.machinepublishers.jbrowserdriver.Settings;
import com.machinepublishers.jbrowserdriver.SocketFactory;
import com.machinepublishers.jbrowserdriver.SocketLock;
import com.machinepublishers.jbrowserdriver.TargetLocator;
import com.machinepublishers.jbrowserdriver.TargetLocatorRemote;
import com.machinepublishers.jbrowserdriver.Util;
import com.machinepublishers.jbrowserdriver.diagnostics.Test;
import io.github.lukehutch.fastclasspathscanner.FastClasspathScanner;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.jar.Attributes;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.openqa.selenium.By;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.Cookie;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.internal.Killable;
import org.openqa.selenium.logging.LogEntries;
import org.openqa.selenium.remote.CommandExecutor;
import org.openqa.selenium.remote.DesiredCapabilities;
import org.openqa.selenium.remote.ErrorHandler;
import org.openqa.selenium.remote.FileDetector;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.openqa.selenium.remote.SessionId;
import org.zeroturnaround.exec.ProcessExecutor;
import org.zeroturnaround.exec.listener.ProcessListener;
import org.zeroturnaround.exec.stream.LogOutputStream;
import org.zeroturnaround.process.PidProcess;
import org.zeroturnaround.process.Processes;

public class JBrowserDriver
extends RemoteWebDriver
implements Killable {
    @Deprecated
    public static final String KEYBOARD_DELETE = "jbrowserdriver-keyboard-delete";
    private static final Set<SocketLock> locks = new HashSet<SocketLock>();
    private static final Set<Job> waiting = new LinkedHashSet<Job>();
    private static final Set<PortGroup> portGroupsActive = new LinkedHashSet<PortGroup>();
    private static final String JAVA_BIN;
    private static final List<String> inheritedArgs;
    private static volatile List<String> classpathSimpleArgs;
    private static volatile List<String> classpathUnpackedArgs;
    private static final AtomicReference<List<String>> classpathArgs;
    private static final AtomicBoolean firstLaunch;
    private static final Set<String> filteredLogs;
    private static final AtomicLong sessionIdCounter;
    private final JBrowserDriverRemote remote;
    private final Logs logs;
    private final AtomicReference<Process> process = new AtomicReference();
    private final AtomicBoolean processEnded = new AtomicBoolean();
    private final AtomicReference<PortGroup> configuredPortGroup = new AtomicReference();
    private final AtomicReference<PortGroup> actualPortGroup = new AtomicReference();
    private final AtomicReference<OptionsLocal> options = new AtomicReference();
    private final SessionId sessionId;
    private final SocketLock lock = new SocketLock();
    private final File tmpDir;
    private final FileRemover shutdownHook;

    private static void initClasspath() {
        List<Object> classpathSimpleTmp = new ArrayList();
        List<Object> classpathUnpackedTmp = new ArrayList();
        try {
            List classpathElements = new FastClasspathScanner(new String[0]).getUniqueClasspathElements();
            File classpathDir = Files.createTempDirectory("jbd_classpath_", new FileAttribute[0]).toFile();
            Runtime.getRuntime().addShutdownHook(new FileRemover(classpathDir));
            ArrayList<String> pathsSimple = new ArrayList<String>();
            ArrayList<String> pathsUnpacked = new ArrayList<String>();
            for (File curElement : classpathElements) {
                String rootLevelElement = curElement.getAbsoluteFile().toURI().toURL().toExternalForm();
                pathsSimple.add(rootLevelElement);
                pathsUnpacked.add(rootLevelElement);
                if (!curElement.isFile() || !curElement.getPath().endsWith(".jar")) continue;
                ZipFile jar = new ZipFile(curElement);
                Throwable throwable = null;
                try {
                    Enumeration<? extends ZipEntry> entries = jar.entries();
                    while (entries.hasMoreElements()) {
                        ZipEntry entry = entries.nextElement();
                        if (!entry.getName().endsWith(".jar")) continue;
                        InputStream in = jar.getInputStream(entry);
                        Throwable throwable2 = null;
                        try {
                            File childJar = new File(classpathDir, Util.randomFileName() + ".jar");
                            Files.copy(in, childJar.toPath(), new CopyOption[0]);
                            pathsUnpacked.add(childJar.getAbsoluteFile().toURI().toURL().toExternalForm());
                            childJar.deleteOnExit();
                        }
                        catch (Throwable throwable3) {
                            throwable2 = throwable3;
                            throw throwable3;
                        }
                        finally {
                            if (in == null) continue;
                            if (throwable2 != null) {
                                try {
                                    in.close();
                                }
                                catch (Throwable throwable4) {
                                    throwable2.addSuppressed(throwable4);
                                }
                                continue;
                            }
                            in.close();
                        }
                    }
                }
                catch (Throwable throwable5) {
                    throwable = throwable5;
                    throw throwable5;
                }
                finally {
                    if (jar == null) continue;
                    if (throwable != null) {
                        try {
                            jar.close();
                        }
                        catch (Throwable throwable6) {
                            throwable.addSuppressed(throwable6);
                        }
                        continue;
                    }
                    jar.close();
                }
            }
            classpathSimpleTmp = JBrowserDriver.createClasspathJar(classpathDir, "classpath-simple.jar", pathsSimple);
            classpathUnpackedTmp = JBrowserDriver.createClasspathJar(classpathDir, "classpath-unpacked.jar", pathsUnpacked);
        }
        catch (Throwable t) {
            Util.handleException(t);
        }
        classpathSimpleArgs = Collections.unmodifiableList(classpathSimpleTmp);
        classpathUnpackedArgs = Collections.unmodifiableList(classpathUnpackedTmp);
    }

    private static List<String> createClasspathJar(File dir, String jarName, List<String> manifestClasspath) throws IOException {
        ArrayList<String> classpathArgs = new ArrayList<String>();
        Manifest manifest = new Manifest();
        manifest.getMainAttributes().put(Attributes.Name.MANIFEST_VERSION, "1.0");
        manifest.getMainAttributes().put(Attributes.Name.CLASS_PATH, StringUtils.join(manifestClasspath, (char)' '));
        File classpathJar = new File(dir, jarName);
        classpathJar.deleteOnExit();
        JarOutputStream stream = new JarOutputStream((OutputStream)new FileOutputStream(classpathJar), manifest);
        Throwable throwable = null;
        if (stream != null) {
            if (throwable != null) {
                try {
                    stream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
            } else {
                stream.close();
            }
        }
        classpathArgs.add("-classpath");
        classpathArgs.add(classpathJar.getCanonicalPath());
        return classpathArgs;
    }

    public static List<String> test() {
        return Test.run();
    }

    public JBrowserDriver() {
        this(Settings.builder().build());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JBrowserDriver(Capabilities capabilities) {
        this(Settings.builder().build(capabilities));
        if (!(capabilities instanceof Serializable)) {
            capabilities = new DesiredCapabilities(capabilities);
        }
        try {
            SocketLock socketLock = this.lock.validated();
            synchronized (socketLock) {
                this.remote.storeCapabilities(capabilities);
            }
        }
        catch (Throwable t) {
            Util.handleException(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JBrowserDriver(Settings settings) {
        Set<SocketLock> set = locks;
        synchronized (set) {
            locks.add(this.lock);
        }
        File tmpDir = null;
        try {
            tmpDir = Files.createTempDirectory("jbd_tmp_", new FileAttribute[0]).toFile();
        }
        catch (Throwable t) {
            Util.handleException(t);
        }
        this.tmpDir = tmpDir;
        this.shutdownHook = new FileRemover(tmpDir);
        Runtime.getRuntime().addShutdownHook(this.shutdownHook);
        Job job = new Job(settings, this.configuredPortGroup);
        Object object = waiting;
        synchronized (object) {
            waiting.add(job);
            waiting.notifyAll();
        }
        object = job;
        synchronized (object) {
            while (this.configuredPortGroup.get() == null) {
                try {
                    job.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        SessionId sessionIdTmp = null;
        if (!settings.customClasspath()) {
            AtomicBoolean atomicBoolean = firstLaunch;
            synchronized (atomicBoolean) {
                if (firstLaunch.compareAndSet(true, false)) {
                    JBrowserDriver.initClasspath();
                    classpathArgs.set(classpathUnpackedArgs);
                    sessionIdTmp = new SessionId(this.launchProcess(settings, this.configuredPortGroup.get()));
                    if (this.actualPortGroup.get() == null) {
                        classpathArgs.set(classpathSimpleArgs);
                    }
                }
            }
        }
        if (this.actualPortGroup.get() == null) {
            sessionIdTmp = new SessionId(this.launchProcess(settings, this.configuredPortGroup.get()));
        }
        this.sessionId = sessionIdTmp;
        if (this.actualPortGroup.get() == null) {
            this.endProcess();
            Util.handleException(new IllegalStateException("Could not launch browser."));
        }
        HeartbeatRemote heartbeatTmp = null;
        JBrowserDriverRemote instanceTmp = null;
        try {
            SocketLock socketLock = this.lock.validated();
            synchronized (socketLock) {
                Registry registry = LocateRegistry.getRegistry(settings.host(), (int)this.actualPortGroup.get().child, new SocketFactory(settings.host(), this.actualPortGroup.get(), locks));
                heartbeatTmp = (HeartbeatRemote)registry.lookup("HeartbeatRemote");
                instanceTmp = (JBrowserDriverRemote)registry.lookup("JBrowserDriverRemote");
                instanceTmp.setUp(settings);
            }
        }
        catch (Throwable t) {
            Util.handleException(t);
        }
        final HeartbeatRemote heartbeat = heartbeatTmp;
        new Thread(new Runnable(){

            @Override
            public void run() {
                while (!JBrowserDriver.this.processEnded.get()) {
                    try {
                        heartbeat.heartbeat();
                    }
                    catch (RemoteException remoteException) {
                        // empty catch block
                    }
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (InterruptedException interruptedException) {
                    }
                }
                return;
            }
        }).start();
        this.remote = instanceTmp;
        LogsRemote logsRemote = null;
        try {
            SocketLock socketLock = this.lock.validated();
            synchronized (socketLock) {
                logsRemote = this.remote.logs();
            }
        }
        catch (Throwable t) {
            Util.handleException(t);
        }
        this.logs = new Logs(logsRemote, this.lock);
    }

    protected void finalize() throws Throwable {
        try {
            super.finalize();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            Runtime.getRuntime().removeShutdownHook(this.shutdownHook);
            this.shutdownHook.run();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String launchProcess(final Settings settings, final PortGroup portGroup) {
        final AtomicBoolean ready = new AtomicBoolean();
        final AtomicReference<String> logPrefix = new AtomicReference<String>("");
        new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                ArrayList<String> myArgs = new ArrayList<String>();
                myArgs.add(settings.javaBinary() == null ? JAVA_BIN : settings.javaBinary());
                myArgs.addAll(inheritedArgs);
                if (!settings.customClasspath()) {
                    myArgs.addAll((Collection)classpathArgs.get());
                }
                if (settings.javaExportModules()) {
                    myArgs.add("-XaddExports:javafx.web/com.sun.webkit.network=ALL-UNNAMED");
                    myArgs.add("-XaddExports:javafx.web/com.sun.webkit.network.about=ALL-UNNAMED");
                    myArgs.add("-XaddExports:javafx.web/com.sun.webkit.network.data=ALL-UNNAMED");
                    myArgs.add("-XaddExports:java.base/sun.net.www.protocol.http=ALL-UNNAMED");
                    myArgs.add("-XaddExports:java.base/sun.net.www.protocol.https=ALL-UNNAMED");
                    myArgs.add("-XaddExports:java.base/sun.net.www.protocol.file=ALL-UNNAMED");
                    myArgs.add("-XaddExports:java.base/sun.net.www.protocol.ftp=ALL-UNNAMED");
                    myArgs.add("-XaddExports:java.base/sun.net.www.protocol.jar=ALL-UNNAMED");
                    myArgs.add("-XaddExports:java.base/sun.net.www.protocol.mailto=ALL-UNNAMED");
                    myArgs.add("-XaddExports:javafx.graphics/com.sun.glass.ui=ALL-UNNAMED");
                    myArgs.add("-XaddExports:javafx.web/com.sun.javafx.webkit=ALL-UNNAMED");
                    myArgs.add("-XaddExports:javafx.web/com.sun.webkit=ALL-UNNAMED");
                }
                myArgs.add("-Djava.io.tmpdir=" + JBrowserDriver.this.tmpDir.getAbsolutePath());
                myArgs.add("-Djava.rmi.server.hostname=" + settings.host());
                myArgs.addAll(settings.javaOptions());
                myArgs.add(JBrowserDriverServer.class.getName());
                myArgs.add(Long.toString(portGroup.child));
                myArgs.add(Long.toString(portGroup.parent));
                myArgs.add(Long.toString(portGroup.parentAlt));
                try {
                    new ProcessExecutor().addListener(new ProcessListener(){

                        public void afterStart(Process proc, ProcessExecutor executor) {
                            JBrowserDriver.this.process.set(proc);
                        }
                    }).redirectOutput((OutputStream)new LogOutputStream(){
                        boolean done = false;

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        protected void processLine(String line) {
                            if (line != null && !line.isEmpty()) {
                                if (!this.done) {
                                    AtomicBoolean atomicBoolean = ready;
                                    synchronized (atomicBoolean) {
                                        if (line.startsWith("ready on ports ")) {
                                            String[] parts = line.substring("ready on ports ".length()).split("/");
                                            JBrowserDriver.this.actualPortGroup.set(new PortGroup(Integer.parseInt(parts[0]), Integer.parseInt(parts[1]), Integer.parseInt(parts[2])));
                                            logPrefix.set("[Instance " + sessionIdCounter.incrementAndGet() + "][Port " + ((PortGroup)((JBrowserDriver)JBrowserDriver.this).actualPortGroup.get()).child + "]");
                                            ready.set(true);
                                            ready.notifyAll();
                                            this.done = true;
                                        } else {
                                            JBrowserDriver.log(settings.logger(), (String)logPrefix.get(), line);
                                        }
                                    }
                                } else {
                                    JBrowserDriver.log(settings.logger(), (String)logPrefix.get(), line);
                                }
                            }
                        }
                    }).redirectError((OutputStream)new LogOutputStream(){

                        protected void processLine(String line) {
                            JBrowserDriver.log(settings.logger(), (String)logPrefix.get(), line);
                        }
                    }).destroyOnExit().command(myArgs).execute();
                }
                catch (Throwable t) {
                    Util.handleException(t);
                }
                AtomicBoolean atomicBoolean = ready;
                synchronized (atomicBoolean) {
                    ready.set(true);
                    ready.notifyAll();
                }
            }
        }).start();
        AtomicBoolean atomicBoolean = ready;
        synchronized (atomicBoolean) {
            while (!ready.get()) {
                try {
                    ready.wait();
                    break;
                }
                catch (InterruptedException interruptedException) {
                }
            }
        }
        return logPrefix.get();
    }

    private static void log(Logger logger, String prefix, String message) {
        if (logger != null && !filteredLogs.contains(message)) {
            LogRecord record = null;
            if (message.startsWith(">")) {
                String[] parts = message.substring(1).split("/", 3);
                record = new LogRecord(Level.parse(parts[0]), prefix + " " + parts[2]);
                record.setSourceMethodName(parts[1]);
                record.setSourceClassName(JBrowserDriver.class.getName());
            } else {
                record = new LogRecord(Level.WARNING, prefix + " " + message);
                record.setSourceMethodName(null);
                record.setSourceClassName(JBrowserDriver.class.getName());
            }
            logger.log(record);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() {
        try {
            SocketLock socketLock = this.lock.validated();
            synchronized (socketLock) {
                this.remote.init();
            }
        }
        catch (Throwable t) {
            Util.handleException(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset(Settings settings) {
        try {
            SocketLock socketLock = this.lock.validated();
            synchronized (socketLock) {
                this.remote.reset(settings);
            }
        }
        catch (Throwable t) {
            Util.handleException(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset(Capabilities capabilities) {
        Settings settings = Settings.builder().build(capabilities);
        try {
            SocketLock socketLock = this.lock.validated();
            synchronized (socketLock) {
                this.remote.reset(settings);
            }
        }
        catch (Throwable t) {
            Util.handleException(t);
        }
        if (!(capabilities instanceof Serializable)) {
            capabilities = new DesiredCapabilities(capabilities);
        }
        try {
            SocketLock t = this.lock.validated();
            synchronized (t) {
                this.remote.storeCapabilities(capabilities);
            }
        }
        catch (Throwable t) {
            Util.handleException(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        try {
            SocketLock socketLock = this.lock.validated();
            synchronized (socketLock) {
                this.remote.reset();
            }
        }
        catch (Throwable t) {
            Util.handleException(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getPageSource() {
        try {
            SocketLock socketLock = this.lock.validated();
            synchronized (socketLock) {
                return this.remote.getPageSource();
            }
        }
        catch (Throwable t) {
            Util.handleException(t);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getCurrentUrl() {
        try {
            SocketLock socketLock = this.lock.validated();
            synchronized (socketLock) {
                return this.remote.getCurrentUrl();
            }
        }
        catch (Throwable t) {
            Util.handleException(t);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getStatusCode() {
        try {
            SocketLock socketLock = this.lock.validated();
            synchronized (socketLock) {
                return this.remote.getStatusCode();
            }
        }
        catch (Throwable t) {
            Util.handleException(t);
            return -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pageWait() {
        try {
            SocketLock socketLock = this.lock.validated();
            synchronized (socketLock) {
                this.remote.pageWait();
            }
        }
        catch (Throwable t) {
            Util.handleException(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getTitle() {
        try {
            SocketLock socketLock = this.lock.validated();
            synchronized (socketLock) {
                return this.remote.getTitle();
            }
        }
        catch (Throwable t) {
            Util.handleException(t);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void get(String url) {
        try {
            SocketLock socketLock = this.lock.validated();
            synchronized (socketLock) {
                this.remote.get(url);
            }
        }
        catch (Throwable t) {
            Util.handleException(t);
        }
    }

    public WebElement findElement(By by) {
        return by.findElement((SearchContext)this);
    }

    public List<WebElement> findElements(By by) {
        return by.findElements((SearchContext)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WebElement findElementById(String id) {
        try {
            SocketLock socketLock = this.lock.validated();
            synchronized (socketLock) {
                return Element.constructElement(this.remote.findElementById(id), this, this.lock);
            }
        }
        catch (Throwable t) {
            Util.handleException(t);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<WebElement> findElementsById(String id) {
        try {
            List<ElementRemote> elements;
            SocketLock socketLock = this.lock.validated();
            synchronized (socketLock) {
                elements = this.remote.findElementsById(id);
            }
            return Element.constructList(elements, this, this.lock);
        }
        catch (Throwable t) {
            Util.handleException(t);
            return new ArrayList<WebElement>();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WebElement findElementByXPath(String expr) {
        try {
            SocketLock socketLock = this.lock.validated();
            synchronized (socketLock) {
                return Element.constructElement(this.remote.findElementByXPath(expr), this, this.lock);
            }
        }
        catch (Throwable t) {
            Util.handleException(t);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<WebElement> findElementsByXPath(String expr) {
        try {
            List<ElementRemote> elements;
            SocketLock socketLock = this.lock.validated();
            synchronized (socketLock) {
                elements = this.remote.findElementsByXPath(expr);
            }
            return Element.constructList(elements, this, this.lock);
        }
        catch (Throwable t) {
            Util.handleException(t);
            return new ArrayList<WebElement>();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WebElement findElementByLinkText(String text) {
        try {
            SocketLock socketLock = this.lock.validated();
            synchronized (socketLock) {
                return Element.constructElement(this.remote.findElementByLinkText(text), this, this.lock);
            }
        }
        catch (Throwable t) {
            Util.handleException(t);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WebElement findElementByPartialLinkText(String text) {
        try {
            SocketLock socketLock = this.lock.validated();
            synchronized (socketLock) {
                return Element.constructElement(this.remote.findElementByPartialLinkText(text), this, this.lock);
            }
        }
        catch (Throwable t) {
            Util.handleException(t);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<WebElement> findElementsByLinkText(String text) {
        try {
            List<ElementRemote> elements;
            SocketLock socketLock = this.lock.validated();
            synchronized (socketLock) {
                elements = this.remote.findElementsByLinkText(text);
            }
            return Element.constructList(elements, this, this.lock);
        }
        catch (Throwable t) {
            Util.handleException(t);
            return new ArrayList<WebElement>();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<WebElement> findElementsByPartialLinkText(String text) {
        try {
            List<ElementRemote> elements;
            SocketLock socketLock = this.lock.validated();
            synchronized (socketLock) {
                elements = this.remote.findElementsByPartialLinkText(text);
            }
            return Element.constructList(elements, this, this.lock);
        }
        catch (Throwable t) {
            Util.handleException(t);
            return new ArrayList<WebElement>();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WebElement findElementByClassName(String cssClass) {
        try {
            SocketLock socketLock = this.lock.validated();
            synchronized (socketLock) {
                return Element.constructElement(this.remote.findElementByClassName(cssClass), this, this.lock);
            }
        }
        catch (Throwable t) {
            Util.handleException(t);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<WebElement> findElementsByClassName(String cssClass) {
        try {
            List<ElementRemote> elements;
            SocketLock socketLock = this.lock.validated();
            synchronized (socketLock) {
                elements = this.remote.findElementsByClassName(cssClass);
            }
            return Element.constructList(elements, this, this.lock);
        }
        catch (Throwable t) {
            Util.handleException(t);
            return new ArrayList<WebElement>();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WebElement findElementByName(String name) {
        try {
            SocketLock socketLock = this.lock.validated();
            synchronized (socketLock) {
                return Element.constructElement(this.remote.findElementByName(name), this, this.lock);
            }
        }
        catch (Throwable t) {
            Util.handleException(t);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<WebElement> findElementsByName(String name) {
        try {
            List<ElementRemote> elements;
            SocketLock socketLock = this.lock.validated();
            synchronized (socketLock) {
                elements = this.remote.findElementsByName(name);
            }
            return Element.constructList(elements, this, this.lock);
        }
        catch (Throwable t) {
            Util.handleException(t);
            return new ArrayList<WebElement>();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WebElement findElementByCssSelector(String expr) {
        try {
            SocketLock socketLock = this.lock.validated();
            synchronized (socketLock) {
                return Element.constructElement(this.remote.findElementByCssSelector(expr), this, this.lock);
            }
        }
        catch (Throwable t) {
            Util.handleException(t);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<WebElement> findElementsByCssSelector(String expr) {
        try {
            List<ElementRemote> elements;
            SocketLock socketLock = this.lock.validated();
            synchronized (socketLock) {
                elements = this.remote.findElementsByCssSelector(expr);
            }
            return Element.constructList(elements, this, this.lock);
        }
        catch (Throwable t) {
            Util.handleException(t);
            return new ArrayList<WebElement>();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WebElement findElementByTagName(String tagName) {
        try {
            SocketLock socketLock = this.lock.validated();
            synchronized (socketLock) {
                return Element.constructElement(this.remote.findElementByTagName(tagName), this, this.lock);
            }
        }
        catch (Throwable t) {
            Util.handleException(t);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<WebElement> findElementsByTagName(String tagName) {
        try {
            List<ElementRemote> elements;
            SocketLock socketLock = this.lock.validated();
            synchronized (socketLock) {
                elements = this.remote.findElementsByTagName(tagName);
            }
            return Element.constructList(elements, this, this.lock);
        }
        catch (Throwable t) {
            Util.handleException(t);
            return new ArrayList<WebElement>();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object executeAsyncScript(String script, Object ... args) {
        try {
            Object result;
            SocketLock socketLock = this.lock.validated();
            synchronized (socketLock) {
                result = this.remote.executeAsyncScript(script, Element.scriptParams(args));
            }
            return Element.constructObject(result, this, this.lock);
        }
        catch (Throwable t) {
            Util.handleException(t);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object executeScript(String script, Object ... args) {
        try {
            Object result;
            SocketLock socketLock = this.lock.validated();
            synchronized (socketLock) {
                result = this.remote.executeScript(script, Element.scriptParams(args));
            }
            return Element.constructObject(result, this, this.lock);
        }
        catch (Throwable t) {
            Util.handleException(t);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public org.openqa.selenium.interactions.Keyboard getKeyboard() {
        try {
            SocketLock socketLock = this.lock.validated();
            synchronized (socketLock) {
                KeyboardRemote keyboard = this.remote.getKeyboard();
                if (keyboard == null) {
                    return null;
                }
                return new Keyboard(keyboard, this.lock);
            }
        }
        catch (Throwable t) {
            Util.handleException(t);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public org.openqa.selenium.interactions.Mouse getMouse() {
        try {
            SocketLock socketLock = this.lock.validated();
            synchronized (socketLock) {
                MouseRemote mouse = this.remote.getMouse();
                if (mouse == null) {
                    return null;
                }
                return new Mouse(mouse, this.lock);
            }
        }
        catch (Throwable t) {
            Util.handleException(t);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Capabilities getCapabilities() {
        try {
            SocketLock socketLock = this.lock.validated();
            synchronized (socketLock) {
                return this.remote.getCapabilities();
            }
        }
        catch (Throwable t) {
            Util.handleException(t);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        try {
            SocketLock socketLock = this.lock.validated();
            synchronized (socketLock) {
                this.remote.close();
            }
        }
        catch (Throwable t) {
            Util.handleException(t);
        }
        Set<String> handles = this.getWindowHandles();
        if (handles == null || handles.isEmpty()) {
            this.quit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getWindowHandle() {
        try {
            SocketLock socketLock = this.lock.validated();
            synchronized (socketLock) {
                return this.remote.getWindowHandle();
            }
        }
        catch (Throwable t) {
            Util.handleException(t);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getWindowHandles() {
        try {
            SocketLock socketLock = this.lock.validated();
            synchronized (socketLock) {
                return this.remote.getWindowHandles();
            }
        }
        catch (Throwable t) {
            Util.handleException(t);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WebDriver.Options manage() {
        if (this.options.get() == null) {
            try {
                SocketLock socketLock = this.lock.validated();
                synchronized (socketLock) {
                    OptionsRemote optionsRemote = this.remote.manage();
                    if (optionsRemote == null) {
                        return null;
                    }
                    return new Options(optionsRemote, this.logs, this.lock);
                }
            }
            catch (Throwable t) {
                Util.handleException(t);
                return null;
            }
        }
        return this.options.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WebDriver.Navigation navigate() {
        try {
            SocketLock socketLock = this.lock.validated();
            synchronized (socketLock) {
                NavigationRemote navigation = this.remote.navigate();
                if (navigation == null) {
                    return null;
                }
                return new Navigation(navigation, this.lock);
            }
        }
        catch (Throwable t) {
            Util.handleException(t);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void endProcess() {
        if (this.processEnded.compareAndSet(false, true)) {
            this.lock.expired.set(true);
            Process proc = this.process.get();
            if (proc != null) {
                while (proc.isAlive()) {
                    try {
                        PidProcess pidProcess = Processes.newPidProcess((Process)proc);
                        try {
                            if (pidProcess.destroyGracefully().waitFor(10L, TimeUnit.SECONDS)) continue;
                            throw new RuntimeException();
                        }
                        catch (Throwable t1) {
                            if (pidProcess.destroyForcefully().waitFor(10L, TimeUnit.SECONDS)) continue;
                            throw new RuntimeException();
                        }
                    }
                    catch (Throwable t2) {
                        try {
                            proc.destroyForcibly().waitFor(10L, TimeUnit.SECONDS);
                        }
                        catch (Throwable throwable) {}
                    }
                }
            }
            FileUtils.deleteQuietly((File)this.tmpDir);
            Set<Object> set = locks;
            synchronized (set) {
                locks.remove(this.lock);
            }
            set = waiting;
            synchronized (set) {
                portGroupsActive.remove(this.configuredPortGroup.get());
                waiting.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveData() {
        try {
            SocketLock socketLock = this.lock.validated();
            synchronized (socketLock) {
                OptionsRemote optionsRemote = this.remote.manage();
                Set<Cookie> cookiesLocal = optionsRemote.getCookies();
                LogsRemote logsRemote = optionsRemote.logs();
                final LogEntries entries = logsRemote.getRemote(null).toLogEntries();
                final Set<String> types = logsRemote.getAvailableLogTypes();
                org.openqa.selenium.logging.Logs logsLocal = new org.openqa.selenium.logging.Logs(){

                    public Set<String> getAvailableLogTypes() {
                        return types;
                    }

                    public LogEntries get(String logType) {
                        return entries;
                    }
                };
                this.options.set(new OptionsLocal(cookiesLocal, logsLocal));
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void quit() {
        this.saveData();
        try {
            SocketLock socketLock = this.lock.validated();
            synchronized (socketLock) {
                this.remote.quit();
            }
        }
        catch (Throwable t) {
            Util.handleException(t);
        }
        finally {
            this.endProcess();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WebDriver.TargetLocator switchTo() {
        try {
            SocketLock socketLock = this.lock.validated();
            synchronized (socketLock) {
                TargetLocatorRemote locator = this.remote.switchTo();
                if (locator == null) {
                    return null;
                }
                return new TargetLocator(locator, this, this.lock);
            }
        }
        catch (Throwable t) {
            Util.handleException(t);
            return null;
        }
    }

    public void kill() {
        this.endProcess();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <X> X getScreenshotAs(OutputType<X> outputType) throws WebDriverException {
        try {
            byte[] bytes;
            SocketLock socketLock = this.lock.validated();
            synchronized (socketLock) {
                bytes = this.remote.getScreenshot();
            }
            if (bytes == null) {
                return null;
            }
            return (X)outputType.convertFromPngBytes(bytes);
        }
        catch (Throwable t) {
            Util.handleException(t);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File cacheDir() {
        try {
            SocketLock socketLock = this.lock.validated();
            synchronized (socketLock) {
                return this.remote.cacheDir();
            }
        }
        catch (Throwable t) {
            Util.handleException(t);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File attachmentsDir() {
        try {
            SocketLock socketLock = this.lock.validated();
            synchronized (socketLock) {
                return this.remote.attachmentsDir();
            }
        }
        catch (Throwable t) {
            Util.handleException(t);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File mediaDir() {
        try {
            SocketLock socketLock = this.lock.validated();
            synchronized (socketLock) {
                return this.remote.mediaDir();
            }
        }
        catch (Throwable t) {
            Util.handleException(t);
            return null;
        }
    }

    public SessionId getSessionId() {
        return this.sessionId;
    }

    public ErrorHandler getErrorHandler() {
        return super.getErrorHandler();
    }

    public CommandExecutor getCommandExecutor() {
        return super.getCommandExecutor();
    }

    public FileDetector getFileDetector() {
        return super.getFileDetector();
    }

    static {
        classpathArgs = new AtomicReference();
        firstLaunch = new AtomicBoolean(true);
        filteredLogs = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("Warning: Single GUI Threadiong is enabled, FPS should be slower")));
        sessionIdCounter = new AtomicLong();
        ArrayList<String> inheritedArgsTmp = new ArrayList<String>();
        File javaBin = new File(System.getProperty("java.home") + "/bin/java");
        if (!javaBin.exists()) {
            javaBin = new File(javaBin.getAbsolutePath() + ".exe");
        }
        JAVA_BIN = javaBin.getAbsolutePath();
        try {
            for (Object keyObj : System.getProperties().keySet()) {
                String key = keyObj.toString();
                if (key == null || !key.startsWith("jbd.rmi.")) continue;
                inheritedArgsTmp.add("-D" + key.substring("jbd.rmi.".length()) + "=" + System.getProperty(key));
            }
        }
        catch (Throwable t) {
            Util.handleException(t);
        }
        inheritedArgs = Collections.unmodifiableList(inheritedArgsTmp);
        Thread work = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Set set = waiting;
                synchronized (set) {
                    block8: while (true) {
                        while (true) {
                            ArrayList<Job> selectedJobs = new ArrayList<Job>();
                            for (Job job : waiting) {
                                for (PortGroup curPortGroup : job.settings.portGroups()) {
                                    boolean conflicts = false;
                                    for (PortGroup curUsed : portGroupsActive) {
                                        if (!curUsed.conflicts(curPortGroup)) continue;
                                        conflicts = true;
                                        break;
                                    }
                                    if (conflicts) continue;
                                    job.portGroup.set(curPortGroup);
                                    break;
                                }
                                if (job.portGroup.get() == null) continue;
                                selectedJobs.add(job);
                                portGroupsActive.add(job.portGroup.get());
                            }
                            for (Job job : selectedJobs) {
                                waiting.remove(job);
                                Job job2 = job;
                                synchronized (job2) {
                                    job.notifyAll();
                                }
                            }
                            try {
                                waiting.wait();
                                continue block8;
                            }
                            catch (InterruptedException interruptedException) {
                                continue;
                            }
                            break;
                        }
                    }
                }
            }
        });
        work.setDaemon(true);
        work.setName("JBrowserDriver queued instance handler");
        work.start();
    }
}

