/*
 * Decompiled with CFR 0.152.
 */
package com.machinepublishers.jbrowserdriver;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

public class RequestHeaders
implements Serializable {
    private final LinkedHashMap<String, String> headersHttp;
    private final Map<String, String> headersHttpCasing;
    private final LinkedHashMap<String, String> headersHttps;
    private final Map<String, String> headersHttpsCasing;
    public static final String DROP_HEADER = "drop_header";
    public static final String DYNAMIC_HEADER = "dynamic_header";
    public static final RequestHeaders TOR;
    public static final RequestHeaders CHROME;

    public RequestHeaders(LinkedHashMap<String, String> headers) {
        this(headers, headers);
    }

    public RequestHeaders(LinkedHashMap<String, String> headersHttp, LinkedHashMap<String, String> headersHttps) {
        LinkedHashMap<String, String> headersHttpTmp = new LinkedHashMap<String, String>();
        HashMap<String, String> headersHttpCasingTmp = new HashMap<String, String>();
        LinkedHashMap<String, String> headersHttpsTmp = new LinkedHashMap<String, String>();
        HashMap<String, String> headersHttpsCasingTmp = new HashMap<String, String>();
        RequestHeaders.createHeaders(headersHttp, headersHttpTmp, headersHttpCasingTmp);
        RequestHeaders.createHeaders(headersHttps, headersHttpsTmp, headersHttpsCasingTmp);
        this.headersHttp = headersHttpTmp;
        this.headersHttpCasing = headersHttpCasingTmp;
        this.headersHttps = headersHttpsTmp;
        this.headersHttpsCasing = headersHttpsCasingTmp;
    }

    private static void createHeaders(LinkedHashMap<String, String> headersIn, LinkedHashMap<String, String> headersOut, Map<String, String> headersCasing) {
        for (Map.Entry<String, String> cur : headersIn.entrySet()) {
            headersOut.put(cur.getKey().toLowerCase(), cur.getValue());
            headersCasing.put(cur.getKey().toLowerCase(), cur.getKey());
        }
        if (!headersOut.containsKey("accept-charset")) {
            headersOut.put("accept-charset", DROP_HEADER);
            headersCasing.put("accept-charset", "Accept-Charset");
        }
        if (!headersOut.containsKey("pragma")) {
            headersOut.put("pragma", DROP_HEADER);
            headersCasing.put("pragma", "Pragma");
        }
    }

    String nameFromLowercase(String headerNameLowercase, boolean https) {
        return https ? this.headersHttpsCasing.get(headerNameLowercase) : this.headersHttpCasing.get(headerNameLowercase);
    }

    Collection<String> headerNames(boolean https) {
        return https ? this.headersHttps.keySet() : this.headersHttp.keySet();
    }

    String headerValue(String name, boolean https) {
        return https ? this.headersHttps.get(name) : this.headersHttp.get(name);
    }

    static {
        LinkedHashMap<String, String> headersTmp = new LinkedHashMap<String, String>();
        headersTmp.put("Host", DYNAMIC_HEADER);
        headersTmp.put("User-Agent", DYNAMIC_HEADER);
        headersTmp.put("Accept", "text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8");
        headersTmp.put("Accept-Language", "en-us,en;q=0.5");
        headersTmp.put("Accept-Encoding", "gzip, deflate");
        headersTmp.put("Cookie", DYNAMIC_HEADER);
        headersTmp.put("DNT", "1");
        headersTmp.put("Referer", DYNAMIC_HEADER);
        headersTmp.put("Connection", "keep-alive");
        TOR = new RequestHeaders(headersTmp);
        headersTmp = new LinkedHashMap();
        headersTmp.put("Host", DYNAMIC_HEADER);
        headersTmp.put("Connection", "keep-alive");
        headersTmp.put("Accept", "text/html,application/xhtml+xml,application/xml;q=0.9,image/webp,*/*;q=0.8");
        headersTmp.put("Upgrade-Insecure-Requests", "1");
        headersTmp.put("User-Agent", DYNAMIC_HEADER);
        headersTmp.put("Referer", DYNAMIC_HEADER);
        headersTmp.put("Accept-Encoding", "gzip, deflate, sdch");
        headersTmp.put("Accept-Language", "en-US,en;q=0.8");
        headersTmp.put("Cookie", DYNAMIC_HEADER);
        CHROME = new RequestHeaders(headersTmp);
    }
}

