/*
 * Decompiled with CFR 0.152.
 */
package com.machinepublishers.jbrowserdriver;

import com.machinepublishers.jbrowserdriver.LogHandler;
import com.machinepublishers.jbrowserdriver.PortGroup;
import com.machinepublishers.jbrowserdriver.ProxyConfig;
import com.machinepublishers.jbrowserdriver.RequestHeaders;
import com.machinepublishers.jbrowserdriver.Timezone;
import com.machinepublishers.jbrowserdriver.UserAgent;
import com.machinepublishers.jbrowserdriver.Util;
import java.io.File;
import java.io.Serializable;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import org.apache.commons.lang.StringUtils;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.Dimension;
import org.openqa.selenium.Platform;
import org.openqa.selenium.remote.DesiredCapabilities;

public class Settings
implements Serializable {
    private static final Logger defaultLogger;
    public static final String HEAD_SCRIPT;
    private static long curAnonPort;
    private static final Object curAnonPortLock;
    private final RequestHeaders requestHeaders;
    private final int screenWidth;
    private final int screenHeight;
    private final String userAgentString;
    private final ProxyConfig proxy;
    private final boolean saveMedia;
    private final boolean saveAttachments;
    private final String script;
    private final String scriptContent;
    private final boolean ignoreDialogs;
    private final boolean cache;
    private final File cacheDir;
    private final int cacheEntries;
    private final long cacheEntrySize;
    private final List<PortGroup> portGroups;
    private final boolean headless;
    private final long ajaxWait;
    private final long ajaxResourceTimeout;
    private final boolean blockAds;
    private final boolean quickRender;
    private final int maxRouteConnections;
    private final int maxConnections;
    private final String ssl;
    private final boolean logWire;
    private final boolean logJavascript;
    private final boolean logTrace;
    private final boolean logWarnings;
    private final int logsMax;
    private final transient Logger logger;
    private final int loggerLevel;
    private final boolean hostnameVerification;
    private final boolean javascript;
    private final int socketTimeout;
    private final int connectTimeout;
    private final int connectionReqTimeout;
    private final String host;
    private final List<String> javaOptions;
    private final boolean customClasspath;
    private final String javaBinary;
    private final boolean javaExportModules;
    private final File userDataDirectory;
    private final String csrfRequestToken;
    private final String csrfResponseToken;
    private final InetAddress nicAddress;

    public static Builder builder() {
        return new Builder();
    }

    private static long nextAnonPort() {
        if (--curAnonPort > -1L) {
            curAnonPort = -1L;
        }
        return curAnonPort;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<PortGroup> parsePorts(int processesMax) {
        ArrayList<PortGroup> portGroups = new ArrayList<PortGroup>();
        Object object = curAnonPortLock;
        synchronized (object) {
            for (int i = 0; i < processesMax; ++i) {
                portGroups.add(new PortGroup(Settings.nextAnonPort(), Settings.nextAnonPort(), Settings.nextAnonPort()));
            }
        }
        return Collections.unmodifiableList(portGroups);
    }

    private static List<PortGroup> parsePorts(String portString) {
        LinkedHashSet<Long> ports = new LinkedHashSet<Long>();
        String[] ranges = portString.split(",");
        for (int i = 0; i < ranges.length; ++i) {
            String[] bounds = ranges[i].split("-");
            long low = Long.parseLong(bounds[0]);
            long high = bounds.length > 1 ? Long.parseLong(bounds[1]) : low;
            for (long j = low; j <= high; ++j) {
                ports.add(j);
            }
        }
        if (ports.size() % 3 != 0) {
            throw new IllegalArgumentException("Each process requires three ports (i.e., number of ports must be a multiple of three).");
        }
        int max = ports.size() / 3;
        Iterator iter = ports.iterator();
        ArrayList<PortGroup> portGroups = new ArrayList<PortGroup>();
        for (int i = 0; i < max; ++i) {
            portGroups.add(new PortGroup((Long)iter.next(), (Long)iter.next(), (Long)iter.next()));
        }
        return Collections.unmodifiableList(portGroups);
    }

    private static void set(DesiredCapabilities capabilities, PropertyName name, int val) {
        capabilities.setCapability(name.propertyName, Integer.toString(val));
    }

    private static void set(DesiredCapabilities capabilities, PropertyName name, long val) {
        capabilities.setCapability(name.propertyName, Long.toString(val));
    }

    private static void set(DesiredCapabilities capabilities, PropertyName name, boolean val) {
        capabilities.setCapability(name.propertyName, Boolean.toString(val));
    }

    private static void set(DesiredCapabilities capabilities, PropertyName name, Logger val) {
        capabilities.setCapability(name.propertyName, val == null ? null : val.getName());
    }

    private static void set(DesiredCapabilities capabilities, PropertyName name, String val) {
        if (val != null) {
            capabilities.setCapability(name.propertyName, val);
        }
    }

    private static int parse(Map capabilities, PropertyName name, int fallback) {
        if (capabilities.get(name.propertyName) != null) {
            return Integer.parseInt(capabilities.get(name.propertyName).toString());
        }
        return fallback;
    }

    private static long parse(Map capabilities, PropertyName name, long fallback) {
        if (capabilities.get(name.propertyName) != null) {
            return Long.parseLong(capabilities.get(name.propertyName).toString());
        }
        return fallback;
    }

    private static boolean parse(Map capabilities, PropertyName name, boolean fallback) {
        if (capabilities.get(name.propertyName) != null) {
            return Boolean.parseBoolean(capabilities.get(name.propertyName).toString());
        }
        return fallback;
    }

    private static String parse(Map capabilities, PropertyName name, String fallback) {
        if (capabilities.get(name.propertyName) != null) {
            return capabilities.get(name.propertyName).toString();
        }
        return fallback;
    }

    private static Logger parse(Map capabilities, PropertyName name, Logger fallback) {
        if (capabilities.containsKey(name.propertyName)) {
            if (capabilities.get(name.propertyName) == null || capabilities.get(name.propertyName).equals("")) {
                return null;
            }
            return Logger.getLogger(capabilities.get(name.propertyName).toString());
        }
        return fallback;
    }

    private static File parse(Map capabilities, PropertyName name, File fallback) {
        if (capabilities.containsKey(name.propertyName)) {
            Object pathName = capabilities.get(name.propertyName);
            if (pathName == null || pathName.equals("")) {
                return null;
            }
            return new File(pathName.toString());
        }
        return fallback;
    }

    private Settings(Builder builder, Map properties) {
        Level curLevel;
        Builder defaults = Settings.builder();
        Dimension screen = builder.screen == null ? defaults.screen : builder.screen;
        this.screenWidth = Settings.parse(properties, PropertyName.SCREEN_WIDTH, screen.getWidth());
        this.screenHeight = Settings.parse(properties, PropertyName.SCREEN_HEIGHT, screen.getHeight());
        this.cacheEntrySize = Settings.parse(properties, PropertyName.CACHE_ENTRY_SIZE, builder.cacheEntrySize);
        this.cacheEntries = Settings.parse(properties, PropertyName.CACHE_ENTRIES, builder.cacheEntries);
        this.cache = Settings.parse(properties, PropertyName.CACHE, builder.cache);
        this.ignoreDialogs = Settings.parse(properties, PropertyName.IGNORE_DIALOGS, builder.ignoreDialogs);
        this.saveAttachments = Settings.parse(properties, PropertyName.SAVE_ATTACHMENTS, builder.saveAttachments);
        this.saveMedia = Settings.parse(properties, PropertyName.SAVE_MEDIA, builder.saveMedia);
        this.ajaxWait = Settings.parse(properties, PropertyName.AJAX_WAIT, builder.ajaxWait);
        this.ajaxResourceTimeout = Settings.parse(properties, PropertyName.AJAX_RESOURCE_TIMEOUT, builder.ajaxResourceTimeout);
        this.blockAds = Settings.parse(properties, PropertyName.BLOCK_ADS, builder.blockAds);
        this.quickRender = Settings.parse(properties, PropertyName.QUICK_RENDER, builder.quickRender);
        this.maxRouteConnections = Settings.parse(properties, PropertyName.MAX_ROUTE_CONNECTIONS, builder.maxRouteConnections);
        this.maxConnections = Settings.parse(properties, PropertyName.MAX_CONNECTIONS, builder.maxConnections);
        this.logJavascript = Settings.parse(properties, PropertyName.LOG_JAVASCRIPT, builder.logJavascript);
        this.javaOptions = properties.get(PropertyName.JAVA_OPTIONS.propertyName) != null ? Collections.unmodifiableList(Arrays.asList(properties.get(PropertyName.JAVA_OPTIONS.propertyName).toString().split("\t"))) : (builder.javaOptions == null ? Collections.unmodifiableList(new ArrayList()) : Collections.unmodifiableList(Arrays.asList(builder.javaOptions)));
        this.customClasspath = this.javaOptions.contains("-classpath") || this.javaOptions.contains("-cp");
        this.javaBinary = Settings.parse(properties, PropertyName.JAVA_BINARY, builder.javaBinary);
        this.javaExportModules = Settings.parse(properties, PropertyName.JAVA_EXPORT_MODULES, builder.javaExportModules);
        if (properties.get(PropertyName.WIRE_CONSOLE.propertyName) != null) {
            System.err.println("jBrowserDriver: The jbd.wireconsole setting is deprecated and will be removed in v2.0.0. Use jbd.logwire, jbd.logger, or jbd.logsmax instead.");
            this.logWire = Settings.parse(properties, PropertyName.WIRE_CONSOLE, builder.logWire);
        } else {
            this.logWire = Settings.parse(properties, PropertyName.LOG_WIRE, builder.logWire);
        }
        if (properties.get(PropertyName.TRACE_CONSOLE.propertyName) != null) {
            System.err.println("jBrowserDriver: The jbd.traceconsole setting is deprecated and will be removed in v2.0.0. Use jbd.logtrace, jbd.logger, or jbd.logsmax instead.");
            this.logTrace = Settings.parse(properties, PropertyName.TRACE_CONSOLE, builder.logTrace);
        } else {
            this.logTrace = Settings.parse(properties, PropertyName.LOG_TRACE, builder.logTrace);
        }
        if (properties.get(PropertyName.WARN_CONSOLE.propertyName) != null) {
            System.err.println("jBrowserDriver: The jbd.warnconsole setting is deprecated and will be removed in v2.0.0. Use jbd.logwarnings, jbd.logger, or jbd.logsmax instead.");
            this.logWarnings = Settings.parse(properties, PropertyName.WARN_CONSOLE, builder.logWarnings);
        } else {
            this.logWarnings = Settings.parse(properties, PropertyName.LOG_WARNINGS, builder.logWarnings);
        }
        if (properties.get(PropertyName.MAX_LOGS.propertyName) != null) {
            System.err.println("jBrowserDriver: The jbd.maxlogs setting is deprecated and will be removed in v2.0.0. Use jbd.logsmax, jbd.logwire, jbd.logtrace, or jbd.logwarnings instead.");
            this.logsMax = Settings.parse(properties, PropertyName.MAX_LOGS, builder.logsMax);
        } else {
            this.logsMax = Settings.parse(properties, PropertyName.LOGS_MAX, builder.logsMax);
        }
        this.logger = Settings.parse(properties, PropertyName.LOGGER, builder.logger);
        this.loggerLevel = this.logger == null ? Level.OFF.intValue() : ((curLevel = this.logger.getLevel()) == null ? Level.INFO.intValue() : curLevel.intValue());
        this.hostnameVerification = Settings.parse(properties, PropertyName.HOSTNAME_VERIFICATION, builder.hostnameVerification);
        this.javascript = Settings.parse(properties, PropertyName.JAVASCRIPT, builder.javascript);
        this.socketTimeout = Settings.parse(properties, PropertyName.SOCKET_TIMEOUT_MS, builder.socketTimeout);
        this.connectTimeout = Settings.parse(properties, PropertyName.CONNECT_TIMEOUT_MS, builder.connectTimeout);
        this.connectionReqTimeout = Settings.parse(properties, PropertyName.CONNECTION_REQ_TIMEOUT_MS, builder.connectionReqTimeout);
        this.cacheDir = Settings.parse(properties, PropertyName.CACHE_DIR, builder.cacheDir);
        this.userDataDirectory = Settings.parse(properties, PropertyName.USER_DATA_DIRECTORY, builder.userDataDirectory);
        this.csrfRequestToken = Settings.parse(properties, PropertyName.CSRF_REQUEST_TOKEN, builder.csrfRequestToken);
        this.csrfResponseToken = Settings.parse(properties, PropertyName.CSRF_RESPONSE_TOKEN, builder.csrfResponseToken);
        this.host = Settings.parse(properties, PropertyName.HOST, builder.host);
        String portRangesTmp = null;
        int processesTmp = -1;
        if (properties.get(PropertyName.PORTS.propertyName) == null && properties.get(PropertyName.PORT_RANGES.propertyName) == null && properties.get(PropertyName.PROCESSES.propertyName) == null) {
            if (builder.processes > -1) {
                processesTmp = builder.processes;
            } else {
                portRangesTmp = builder.portRanges;
            }
        } else if (properties.get(PropertyName.PORTS.propertyName) != null) {
            String[] ranges;
            System.err.println("jBrowserDriver: The jbd.ports property is deprecated and will be removed in v2.0.0. Refer to Settings.Builder.processes(..) API documentation.");
            String portString = properties.get(PropertyName.PORTS.propertyName).toString();
            LinkedHashSet<Long> ports = new LinkedHashSet<Long>();
            for (String range : ranges = portString.split(",")) {
                String[] bounds = range.split("-");
                long low = Long.parseLong(bounds[0]);
                long high = bounds.length > 1 ? Long.parseLong(bounds[1]) : low;
                for (long j = low; j <= high; ++j) {
                    ports.add(j);
                }
            }
            processesTmp = ports.size();
        } else if (properties.get(PropertyName.PORT_RANGES.propertyName) != null) {
            portRangesTmp = properties.get(PropertyName.PORT_RANGES.propertyName).toString();
        } else {
            processesTmp = Integer.parseInt(properties.get(PropertyName.PROCESSES.propertyName).toString());
        }
        this.portGroups = portRangesTmp == null ? Settings.parsePorts(processesTmp) : Settings.parsePorts(portRangesTmp);
        boolean headlessTmp = Settings.parse(properties, PropertyName.HEADLESS, builder.headless);
        this.headless = headlessTmp = System.getProperty(PropertyName.HEADLESS.propertyName) == null && System.getProperty("jbd.browsergui") != null ? !Boolean.parseBoolean(System.getProperty("jbd.browsergui")) : headlessTmp;
        if (System.getProperty("jbd.browsergui") != null) {
            System.err.println("jBrowserDriver: The jbd.browsergui property is deprecated and will be removed in v2.0.0. Use jbd.headless property instead.");
        }
        String sslTmp = Settings.parse(properties, PropertyName.SSL, builder.ssl);
        this.ssl = sslTmp = System.getProperty(PropertyName.SSL.propertyName) == null && System.getProperty("jbd.pemfile") != null ? System.getProperty("jbd.pemfile") : sslTmp;
        if (System.getProperty("jbd.pemfile") != null) {
            System.err.println("jBrowserDriver: The jbd.pemfile property is deprecated and will be removed in v2.0.0. Use jbd.ssl property instead.");
        }
        RequestHeaders requestHeadersTmp = builder.requestHeaders;
        UserAgent userAgentTmp = builder.userAgent;
        if (properties.get(PropertyName.USER_AGENT.propertyName) != null) {
            String value = properties.get(PropertyName.USER_AGENT.propertyName).toString();
            if ("tor".equalsIgnoreCase(value)) {
                requestHeadersTmp = RequestHeaders.TOR;
                userAgentTmp = UserAgent.TOR;
            } else if ("chrome".equalsIgnoreCase(value)) {
                requestHeadersTmp = RequestHeaders.CHROME;
                userAgentTmp = UserAgent.CHROME;
            }
        }
        requestHeadersTmp = requestHeadersTmp == null ? defaults.requestHeaders : requestHeadersTmp;
        userAgentTmp = userAgentTmp == null ? defaults.userAgent : userAgentTmp;
        this.requestHeaders = requestHeadersTmp;
        this.userAgentString = userAgentTmp.userAgentString();
        this.nicAddress = builder.nicAddress;
        ProxyConfig proxyTmp = builder.proxy;
        if (properties.get(PropertyName.PROXY_TYPE.propertyName) != null && properties.get(PropertyName.PROXY_HOST.propertyName) != null && properties.get(PropertyName.PROXY_PORT.propertyName) != null) {
            ProxyConfig.Type type = ProxyConfig.Type.valueOf(properties.get(PropertyName.PROXY_TYPE.propertyName).toString());
            String host = properties.get(PropertyName.PROXY_HOST.propertyName).toString();
            int port = Integer.parseInt(properties.get(PropertyName.PROXY_PORT.propertyName).toString());
            String username = Settings.parse(properties, PropertyName.PROXY_USERNAME, (String)null);
            String password = Settings.parse(properties, PropertyName.PROXY_PASSWORD, (String)null);
            Object expectContinue = properties.get(PropertyName.PROXY_EXPECT_CONTINUE.propertyName);
            proxyTmp = expectContinue == null ? new ProxyConfig(type, host, port, username, password) : new ProxyConfig(type, host, port, username, password, Boolean.parseBoolean(expectContinue.toString()));
        }
        this.proxy = proxyTmp;
        Timezone timezoneTmp = builder.timezone;
        if (properties.get(PropertyName.TIMEZONE.propertyName) != null) {
            timezoneTmp = Timezone.byName(properties.get(PropertyName.TIMEZONE.propertyName).toString());
        }
        timezoneTmp = timezoneTmp == null ? defaults.timezone : timezoneTmp;
        String scriptId = Util.randomPropertyName();
        String headScriptTmp = Settings.parse(properties, PropertyName.HEAD_SCRIPT, builder.headScript);
        StringBuilder scriptBuilder = new StringBuilder();
        StringBuilder scriptContentBuilder = new StringBuilder();
        scriptBuilder.append("<script id='").append(scriptId).append("' language='javascript'>");
        scriptContentBuilder.append("(function(){try{");
        scriptContentBuilder.append(userAgentTmp.script());
        scriptContentBuilder.append(timezoneTmp.script());
        if (headScriptTmp != null) {
            scriptContentBuilder.append(headScriptTmp);
        }
        scriptContentBuilder.append("}catch(e){}})();");
        this.scriptContent = scriptContentBuilder.toString();
        scriptBuilder.append(this.scriptContent);
        scriptBuilder.append("(function(){document.getElementsByTagName('head')[0].removeChild(document.getElementById('");
        scriptBuilder.append(scriptId);
        scriptBuilder.append("'));})();");
        scriptBuilder.append("</script>");
        this.script = scriptBuilder.toString();
    }

    RequestHeaders headers() {
        return this.requestHeaders;
    }

    int screenWidth() {
        return this.screenWidth;
    }

    int screenHeight() {
        return this.screenHeight;
    }

    String userAgentString() {
        return this.userAgentString;
    }

    ProxyConfig proxy() {
        return this.proxy;
    }

    boolean saveMedia() {
        return this.saveMedia;
    }

    boolean saveAttachments() {
        return this.saveAttachments;
    }

    String script() {
        return this.script;
    }

    String scriptContent() {
        return this.scriptContent;
    }

    boolean ignoreDialogs() {
        return this.ignoreDialogs;
    }

    boolean cache() {
        return this.cache;
    }

    File cacheDir() {
        return this.cacheDir;
    }

    int cacheEntries() {
        return this.cacheEntries;
    }

    long cacheEntrySize() {
        return this.cacheEntrySize;
    }

    List<PortGroup> portGroups() {
        return this.portGroups;
    }

    String host() {
        return this.host;
    }

    boolean headless() {
        return this.headless;
    }

    long ajaxWait() {
        return this.ajaxWait;
    }

    long ajaxResourceTimeout() {
        return this.ajaxResourceTimeout;
    }

    boolean blockAds() {
        return this.blockAds;
    }

    boolean quickRender() {
        return this.quickRender;
    }

    int maxRouteConnections() {
        return this.maxRouteConnections;
    }

    int maxConnections() {
        return this.maxConnections;
    }

    String ssl() {
        return this.ssl;
    }

    boolean javascript() {
        return this.javascript;
    }

    int socketTimeout() {
        return this.socketTimeout;
    }

    int connectTimeout() {
        return this.connectTimeout;
    }

    int connectionReqTimeout() {
        return this.connectionReqTimeout;
    }

    boolean hostnameVerification() {
        return this.hostnameVerification;
    }

    boolean logWire() {
        return this.logWire;
    }

    boolean logJavascript() {
        return this.logJavascript;
    }

    boolean logTrace() {
        return this.logTrace;
    }

    boolean logWarnings() {
        return this.logWarnings;
    }

    int logsMax() {
        return this.logsMax;
    }

    Logger logger() {
        return this.logger;
    }

    int loggerLevel() {
        return this.loggerLevel;
    }

    List<String> javaOptions() {
        return this.javaOptions;
    }

    String javaBinary() {
        return this.javaBinary;
    }

    boolean customClasspath() {
        return this.customClasspath;
    }

    boolean javaExportModules() {
        return this.javaExportModules;
    }

    File userDataDirectory() {
        return this.userDataDirectory;
    }

    String getCsrfRequestToken() {
        return this.csrfRequestToken;
    }

    String getCsrfResponseToken() {
        return this.csrfResponseToken;
    }

    InetAddress getLocalIp() {
        return this.nicAddress;
    }

    static /* synthetic */ Logger access$000() {
        return defaultLogger;
    }

    static {
        if (LogManager.getLogManager().getLogger("com.machinepublishers.jbrowserdriver") == null) {
            defaultLogger = Logger.getLogger("com.machinepublishers.jbrowserdriver");
            defaultLogger.setUseParentHandlers(false);
            defaultLogger.addHandler(new LogHandler());
            defaultLogger.setLevel(Level.ALL);
        } else {
            defaultLogger = LogManager.getLogManager().getLogger("com.machinepublishers.jbrowserdriver");
        }
        StringBuilder builder = new StringBuilder();
        builder.append("Object.defineProperty(window, 'external', ");
        builder.append("{value:{AddSearchProvider:function(){},IsSearchProviderInstalled:function(){},addSearchEngine:function(){}}});");
        builder.append("Object.defineProperty(window.external.AddSearchProvider, 'toString', ");
        builder.append("{value:function(){return 'function AddSearchProvider() { [native code] }';}});");
        builder.append("Object.defineProperty(window.external.IsSearchProviderInstalled, 'toString', ");
        builder.append("{value:function(){return 'function IsSearchProviderInstalled() { [native code] }';}});");
        builder.append("Object.defineProperty(window.external.addSearchEngine, 'toString', ");
        builder.append("{value:function(){return 'function addSearchEngine() { [native code] }';}});");
        builder.append("Object.defineProperty(HTMLCanvasElement.prototype, ");
        builder.append("'toBlob', {value:function(){return undefined;}});");
        builder.append("Object.defineProperty(HTMLCanvasElement.prototype, ");
        builder.append("'toDataURL', {value:function(){return undefined;}});");
        builder.append("Object.defineProperty(CanvasRenderingContext2D.prototype, ");
        builder.append("'getImageData', {value:function(){return undefined;}});");
        builder.append("Object.defineProperty(CanvasRenderingContext2D.prototype, ");
        builder.append("'measureText', {value:function(){return undefined;}});");
        builder.append("Object.defineProperty(CanvasRenderingContext2D.prototype, ");
        builder.append("'isPointInPath', {value:function(){return undefined;}});");
        builder.append("Object.defineProperty(CanvasRenderingContext2D.prototype, ");
        builder.append("'isPointInStroke', {value:function(){return undefined;}});");
        HEAD_SCRIPT = builder.toString();
        curAnonPortLock = new Object();
    }

    public static class Builder {
        private RequestHeaders requestHeaders = RequestHeaders.TOR;
        private Dimension screen = new Dimension(1000, 600);
        private UserAgent userAgent = UserAgent.TOR;
        private Timezone timezone = Timezone.UTC;
        private String headScript = HEAD_SCRIPT;
        private ProxyConfig proxy = new ProxyConfig();
        private boolean saveMedia;
        private boolean saveAttachments;
        private boolean ignoreDialogs = true;
        private boolean cache;
        private File cacheDir;
        private int cacheEntries = 10000;
        private long cacheEntrySize = 1000000L;
        private String portRanges;
        private int processes = 2 * Runtime.getRuntime().availableProcessors();
        private boolean headless = true;
        private long ajaxWait = 150L;
        private long ajaxResourceTimeout = 2000L;
        private boolean blockAds;
        private boolean quickRender;
        private int maxRouteConnections = 8;
        private int maxConnections = 300;
        private String ssl;
        private boolean logWire;
        private boolean logJavascript;
        private boolean logTrace;
        private boolean logWarnings = true;
        private Logger logger = Settings.access$000();
        private int logsMax = 1000;
        private boolean hostnameVerification = true;
        private boolean javascript = true;
        private int socketTimeout = -1;
        private int connectTimeout = -1;
        private int connectionReqTimeout = -1;
        private String host = "127.0.0.1";
        private String[] javaOptions;
        private String javaBinary;
        private boolean javaExportModules;
        private File userDataDirectory;
        private String csrfRequestToken;
        private String csrfResponseToken;
        private InetAddress nicAddress;

        public Builder requestHeaders(RequestHeaders requestHeaders) {
            this.requestHeaders = requestHeaders;
            return this;
        }

        public Builder screen(Dimension screen) {
            this.screen = screen;
            return this;
        }

        public Builder userAgent(UserAgent userAgent) {
            this.userAgent = userAgent;
            return this;
        }

        public Builder timezone(Timezone timezone) {
            this.timezone = timezone;
            return this;
        }

        public Builder headScript(String headScript) {
            this.headScript = headScript;
            return this;
        }

        public Builder proxy(ProxyConfig proxy) {
            this.proxy = proxy;
            return this;
        }

        public Builder saveMedia(boolean saveMedia) {
            this.saveMedia = saveMedia;
            return this;
        }

        public Builder saveAttachments(boolean saveAttachments) {
            this.saveAttachments = saveAttachments;
            return this;
        }

        public Builder ignoreDialogs(boolean ignoreDialogs) {
            this.ignoreDialogs = ignoreDialogs;
            return this;
        }

        public Builder cache(boolean cache) {
            this.cache = cache;
            return this;
        }

        public Builder cacheDir(File cacheDir) {
            this.cacheDir = cacheDir;
            return this;
        }

        public Builder cacheEntries(int cacheEntries) {
            this.cacheEntries = cacheEntries;
            return this;
        }

        public Builder cacheEntrySize(long bytes) {
            this.cacheEntrySize = bytes;
            return this;
        }

        @Deprecated
        public Builder ports(int ... ports) {
            System.err.println("jBrowserDriver: The ports setting is deprecated and will be removed in v2.0.0. Use Settings.Builder.processes(..) instead.");
            this.portRanges = null;
            this.processes = ports.length;
            this.host = "127.0.0.1";
            return this;
        }

        @Deprecated
        public Builder portsMax(int startingPort, int maxProcesses) {
            System.err.println("jBrowserDriver: The portsMax setting is deprecated and will be removed in v2.0.0. Use Settings.Builder.processes(..) instead.");
            this.portRanges = null;
            this.processes = maxProcesses;
            this.host = "127.0.0.1";
            return this;
        }

        public Builder processes(int maxProcesses) {
            this.portRanges = null;
            this.processes = maxProcesses;
            this.host = "127.0.0.1";
            return this;
        }

        public Builder processes(int maxProcesses, String host) {
            this.portRanges = null;
            this.processes = maxProcesses;
            this.host = host;
            return this;
        }

        public Builder processes(String portRanges) {
            this.portRanges = portRanges;
            this.processes = -1;
            this.host = "127.0.0.1";
            return this;
        }

        public Builder processes(String portRanges, String host) {
            this.portRanges = portRanges;
            this.processes = -1;
            this.host = host;
            return this;
        }

        public Builder headless(boolean headless) {
            this.headless = headless;
            return this;
        }

        public Builder hostnameVerification(boolean hostnameVerification) {
            this.hostnameVerification = hostnameVerification;
            return this;
        }

        public Builder ajaxWait(long intervalMS) {
            this.ajaxWait = intervalMS;
            return this;
        }

        public Builder ajaxResourceTimeout(long timeoutMS) {
            this.ajaxResourceTimeout = timeoutMS;
            return this;
        }

        public Builder blockAds(boolean blockAds) {
            this.blockAds = blockAds;
            return this;
        }

        public Builder quickRender(boolean quickRender) {
            this.quickRender = quickRender;
            return this;
        }

        public Builder maxRouteConnections(int maxRouteConnections) {
            this.maxRouteConnections = maxRouteConnections;
            return this;
        }

        public Builder maxConnections(int maxConnections) {
            this.maxConnections = maxConnections;
            return this;
        }

        public Builder javascript(boolean isEnabled) {
            this.javascript = isEnabled;
            return this;
        }

        public Builder socketTimeout(int timeoutMS) {
            this.socketTimeout = timeoutMS;
            return this;
        }

        public Builder connectTimeout(int timeoutMS) {
            this.connectTimeout = timeoutMS;
            return this;
        }

        public Builder connectionReqTimeout(int timeoutMS) {
            this.connectionReqTimeout = timeoutMS;
            return this;
        }

        public Builder ssl(String ssl) {
            this.ssl = ssl;
            return this;
        }

        public Builder logWire(boolean logWire) {
            this.logWire = logWire;
            return this;
        }

        public Builder logJavascript(boolean logJavascript) {
            this.logJavascript = logJavascript;
            return this;
        }

        public Builder logTrace(boolean logTrace) {
            this.logTrace = logTrace;
            return this;
        }

        public Builder logWarnings(boolean logWarnings) {
            this.logWarnings = logWarnings;
            return this;
        }

        public Builder loggerLevel(Level loggerLevel) {
            if (loggerLevel == null) {
                this.logger.setLevel(Level.OFF);
            } else {
                this.logger.setLevel(loggerLevel);
            }
            return this;
        }

        public Builder logger(String name) {
            this.logger = name == null ? null : Logger.getLogger(name);
            return this;
        }

        public Builder logsMax(int logsMax) {
            this.logsMax = logsMax;
            return this;
        }

        public Builder javaOptions(String ... options) {
            this.javaOptions = options;
            return this;
        }

        public Builder javaBinary(String javaBinary) {
            this.javaBinary = javaBinary;
            return this;
        }

        public Builder javaExportModules(boolean javaExportModules) {
            this.javaExportModules = javaExportModules;
            return this;
        }

        public Builder userDataDirectory(File userDataDirectory) {
            this.userDataDirectory = userDataDirectory;
            return this;
        }

        public Builder localIp(InetAddress nicAddress) {
            this.nicAddress = nicAddress;
            return this;
        }

        public Builder csrf() {
            return this.csrf("X-XSRF-TOKEN", "XSRF-TOKEN");
        }

        public Builder csrf(String requestToken, String responseToken) {
            this.csrfRequestToken = requestToken;
            this.csrfResponseToken = responseToken;
            return this;
        }

        @Deprecated
        public Builder wireConsole(boolean wireConsole) {
            System.err.println("jBrowserDriver: The wireConsole setting is deprecated and will be removed in v2.0.0. Instead use Settings Builder's logWire, logsMax, or logger.");
            this.logWire = wireConsole;
            return this;
        }

        @Deprecated
        public Builder traceConsole(boolean traceConsole) {
            System.err.println("jBrowserDriver: The traceConsole setting is deprecated and will be removed in v2.0.0. Instead use Settings Builder's logTrace, logsMax, or logger.");
            this.logTrace = traceConsole;
            return this;
        }

        @Deprecated
        public Builder warnConsole(boolean warnConsole) {
            System.err.println("jBrowserDriver: The warnConsole setting is deprecated and will be removed in v2.0.0. Instead use Settings Builder's logWarnings, logsMax, or logger.");
            this.logWarnings = warnConsole;
            return this;
        }

        @Deprecated
        public Builder maxLogs(int maxLogs) {
            System.err.println("jBrowserDriver: The maxLogs setting is deprecated and will be removed in v2.0.0. Instead use Settings Builder's logsMax, logWire, logTrace, or logWarnings.");
            this.logsMax = maxLogs;
            return this;
        }

        public Settings build() {
            return new Settings(this, System.getProperties());
        }

        public Capabilities buildCapabilities() {
            DesiredCapabilities capabilities = new DesiredCapabilities("jbrowserdriver", "", Platform.ANY);
            Settings.set(capabilities, PropertyName.CACHE_ENTRY_SIZE, this.cacheEntrySize);
            Settings.set(capabilities, PropertyName.CACHE_ENTRIES, this.cacheEntries);
            Settings.set(capabilities, PropertyName.CACHE, this.cache);
            Settings.set(capabilities, PropertyName.IGNORE_DIALOGS, this.ignoreDialogs);
            Settings.set(capabilities, PropertyName.SAVE_ATTACHMENTS, this.saveAttachments);
            Settings.set(capabilities, PropertyName.SAVE_MEDIA, this.saveMedia);
            Settings.set(capabilities, PropertyName.AJAX_WAIT, this.ajaxWait);
            Settings.set(capabilities, PropertyName.AJAX_RESOURCE_TIMEOUT, this.ajaxResourceTimeout);
            Settings.set(capabilities, PropertyName.BLOCK_ADS, this.blockAds);
            Settings.set(capabilities, PropertyName.QUICK_RENDER, this.quickRender);
            Settings.set(capabilities, PropertyName.MAX_ROUTE_CONNECTIONS, this.maxRouteConnections);
            Settings.set(capabilities, PropertyName.MAX_CONNECTIONS, this.maxConnections);
            Settings.set(capabilities, PropertyName.LOG_WIRE, this.logWire);
            Settings.set(capabilities, PropertyName.LOG_JAVASCRIPT, this.logJavascript);
            Settings.set(capabilities, PropertyName.LOG_TRACE, this.logTrace);
            Settings.set(capabilities, PropertyName.LOG_WARNINGS, this.logWarnings);
            Settings.set(capabilities, PropertyName.LOGS_MAX, this.logsMax);
            Settings.set(capabilities, PropertyName.LOGGER, this.logger);
            Settings.set(capabilities, PropertyName.HEAD_SCRIPT, this.headScript);
            Settings.set(capabilities, PropertyName.HOST, this.host);
            Settings.set(capabilities, PropertyName.PORT_RANGES, this.portRanges == null || this.portRanges.isEmpty() ? null : this.portRanges);
            if (this.processes > -1) {
                Settings.set(capabilities, PropertyName.PROCESSES, this.processes);
            }
            Settings.set(capabilities, PropertyName.HEADLESS, this.headless);
            Settings.set(capabilities, PropertyName.SSL, this.ssl);
            Settings.set(capabilities, PropertyName.HOSTNAME_VERIFICATION, this.hostnameVerification);
            Settings.set(capabilities, PropertyName.JAVASCRIPT, this.javascript);
            Settings.set(capabilities, PropertyName.SOCKET_TIMEOUT_MS, this.socketTimeout);
            Settings.set(capabilities, PropertyName.CONNECT_TIMEOUT_MS, this.connectTimeout);
            Settings.set(capabilities, PropertyName.CONNECTION_REQ_TIMEOUT_MS, this.connectionReqTimeout);
            Settings.set(capabilities, PropertyName.JAVA_OPTIONS, StringUtils.join((Object[])this.javaOptions, (String)"\t"));
            Settings.set(capabilities, PropertyName.JAVA_BINARY, this.javaBinary);
            Settings.set(capabilities, PropertyName.JAVA_EXPORT_MODULES, this.javaExportModules);
            if (this.screen != null) {
                Settings.set(capabilities, PropertyName.SCREEN_WIDTH, this.screen.getWidth());
                Settings.set(capabilities, PropertyName.SCREEN_HEIGHT, this.screen.getHeight());
            }
            if (this.cacheDir != null) {
                Settings.set(capabilities, PropertyName.CACHE_DIR, this.cacheDir.getAbsolutePath());
            }
            if (this.userDataDirectory != null) {
                capabilities.setCapability(PropertyName.USER_DATA_DIRECTORY.propertyName, this.userDataDirectory.getAbsolutePath());
            }
            if (this.timezone != null) {
                Settings.set(capabilities, PropertyName.TIMEZONE, this.timezone.name());
            }
            if (RequestHeaders.TOR.equals(this.requestHeaders) && UserAgent.TOR.equals(this.userAgent)) {
                Settings.set(capabilities, PropertyName.USER_AGENT, "tor");
            } else if (RequestHeaders.CHROME.equals(this.requestHeaders) && UserAgent.CHROME.equals(this.userAgent)) {
                Settings.set(capabilities, PropertyName.USER_AGENT, "chrome");
            }
            if (this.proxy != null && this.proxy.type() != null) {
                Settings.set(capabilities, PropertyName.PROXY_TYPE, this.proxy.type().toString());
                Settings.set(capabilities, PropertyName.PROXY_HOST, this.proxy.host());
                Settings.set(capabilities, PropertyName.PROXY_PORT, this.proxy.port());
                Settings.set(capabilities, PropertyName.PROXY_USERNAME, this.proxy.user());
                Settings.set(capabilities, PropertyName.PROXY_PASSWORD, this.proxy.password());
                Settings.set(capabilities, PropertyName.PROXY_EXPECT_CONTINUE, this.proxy.expectContinue());
            }
            return capabilities;
        }

        Settings build(Capabilities capabilities) {
            HashMap<Object, Object> properties = new HashMap<Object, Object>(capabilities.asMap());
            for (Map.Entry<Object, Object> entry : System.getProperties().entrySet()) {
                properties.put(entry.getKey(), entry.getValue());
            }
            return new Settings(this, properties);
        }
    }

    private static enum PropertyName {
        PORTS("jbd.ports"),
        PORT_RANGES("jbd.portranges"),
        PROCESSES("jbd.processes"),
        HOST("jbd.host"),
        HEADLESS("jbd.headless"),
        AJAX_WAIT("jbd.ajaxwait"),
        AJAX_RESOURCE_TIMEOUT("jbd.ajaxresourcetimeout"),
        BLOCK_ADS("jbd.blockads"),
        QUICK_RENDER("jbd.quickrender"),
        MAX_ROUTE_CONNECTIONS("jbd.maxrouteconnections"),
        MAX_CONNECTIONS("jbd.maxconnections"),
        SSL("jbd.ssl"),
        USER_AGENT("jbd.useragent"),
        SCREEN_WIDTH("jbd.screenwidth"),
        SCREEN_HEIGHT("jbd.screenheight"),
        TIMEZONE("jbd.timezone"),
        HEAD_SCRIPT("jbd.headscript"),
        PROXY_HOST("jbd.proxyhost"),
        PROXY_PORT("jbd.proxyport"),
        PROXY_TYPE("jbd.proxytype"),
        PROXY_USERNAME("jbd.proxyusername"),
        PROXY_PASSWORD("jbd.proxypassword"),
        PROXY_EXPECT_CONTINUE("jbd.proxyexpectcontinue"),
        SAVE_MEDIA("jbd.savemedia"),
        SAVE_ATTACHMENTS("jbd.saveattachments"),
        IGNORE_DIALOGS("jbd.ignoredialogs"),
        CACHE("jbd.cache"),
        CACHE_DIR("jbd.cachedir"),
        CACHE_ENTRIES("jbd.cacheentries"),
        CACHE_ENTRY_SIZE("jbd.cacheentrysize"),
        HOSTNAME_VERIFICATION("jbd.hostnameverification"),
        JAVASCRIPT("jbd.javascript"),
        SOCKET_TIMEOUT_MS("jbd.sockettimeout"),
        CONNECT_TIMEOUT_MS("jbd.connecttimeout"),
        CONNECTION_REQ_TIMEOUT_MS("jbd.connectionreqtimeout"),
        RESPONSE_INTERCEPTORS("jbd.responseinterceptors"),
        LOG_WIRE("jbd.logwire"),
        LOG_JAVASCRIPT("jbd.logjavascript"),
        LOG_TRACE("jbd.logtrace"),
        LOG_WARNINGS("jbd.logwarnings"),
        LOGS_MAX("jbd.logsmax"),
        LOGGER("jbd.logger"),
        JAVA_OPTIONS("jbd.javaoptions"),
        JAVA_BINARY("jbd.javabinary"),
        JAVA_EXPORT_MODULES("jbd.javaexportmodules"),
        USER_DATA_DIRECTORY("jbd.userdatadirectory"),
        CSRF_REQUEST_TOKEN("jbd.csrfreqtoken"),
        CSRF_RESPONSE_TOKEN("jbd.csrfresptoken"),
        WIRE_CONSOLE("jbd.wireconsole"),
        TRACE_CONSOLE("jbd.traceconsole"),
        WARN_CONSOLE("jbd.warnconsole"),
        MAX_LOGS("jbd.maxlogs");

        private final String propertyName;

        private PropertyName(String propertyName) {
            this.propertyName = propertyName;
        }
    }
}

