/*
 * Decompiled with CFR 0.152.
 */
package com.machinepublishers.jbrowserdriver;

import com.machinepublishers.jbrowserdriver.CookieStore;
import com.machinepublishers.jbrowserdriver.LogsServer;
import com.machinepublishers.jbrowserdriver.ProxyConfig;
import com.machinepublishers.jbrowserdriver.ResponseHandler;
import com.machinepublishers.jbrowserdriver.Settings;
import com.machinepublishers.jbrowserdriver.SettingsManager;
import com.machinepublishers.jbrowserdriver.StatusMonitor;
import com.machinepublishers.jbrowserdriver.StreamConnectionClient;
import com.machinepublishers.jbrowserdriver.Util;
import com.sun.webkit.network.CookieManager;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.security.Permission;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpOptions;
import org.apache.http.client.methods.HttpPatch;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpTrace;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.util.EntityUtils;

class StreamConnection
extends HttpURLConnection
implements Closeable {
    private static final CookieStore cookieStore = (CookieStore)CookieManager.getDefault();
    private static final File attachmentsDir;
    private static final File mediaDir;
    private static final Set<String> ignoredHeaders;
    private static final Pattern invalidUrlChar;
    private static final Set<String> adHosts;
    private static final AtomicReference<StreamConnectionClient> client;
    private static final Set<String> mediaExtensions;
    private final Map<String, List<String>> reqHeaders = new LinkedHashMap<String, List<String>>();
    private final Map<String, String> reqHeadersCasing = new HashMap<String, String>();
    private final AtomicReference<RequestConfig.Builder> config = new AtomicReference<RequestConfig.Builder>(RequestConfig.custom());
    private final URL url;
    private final String urlString;
    private final String urlFragment;
    private final AtomicBoolean skip = new AtomicBoolean();
    private final AtomicReference<String> method = new AtomicReference();
    private final AtomicBoolean connected = new AtomicBoolean();
    private final AtomicBoolean exec = new AtomicBoolean();
    private final AtomicReference<CloseableHttpResponse> response = new AtomicReference();
    private final AtomicReference<HttpEntity> entity = new AtomicReference();
    private final AtomicBoolean consumed = new AtomicBoolean();
    private final AtomicBoolean closed = new AtomicBoolean();
    private final AtomicReference<HttpClientContext> context = new AtomicReference<HttpClientContext>(HttpClientContext.create());
    private final AtomicReference<HttpRequestBase> req = new AtomicReference();
    private final AtomicBoolean contentEncodingRemoved = new AtomicBoolean();
    private final AtomicLong contentLength = new AtomicLong(-1L);
    private final AtomicReference<ByteArrayOutputStream> reqData = new AtomicReference<ByteArrayOutputStream>(new ByteArrayOutputStream());

    static void updateSettings() {
        StreamConnectionClient prevClient = client.get();
        if (prevClient != null) {
            prevClient.shutDown();
        }
        client.set(new StreamConnectionClient());
    }

    static File cacheDir() {
        return client.get().cacheDir();
    }

    static File attachmentsDir() {
        return attachmentsDir;
    }

    static File mediaDir() {
        return mediaDir;
    }

    private boolean isBlocked(String host) {
        if (SettingsManager.settings().blockAds() && !adHosts.isEmpty()) {
            host = host.toLowerCase();
            while (host.contains(".")) {
                if (adHosts.contains(host)) {
                    LogsServer.instance().trace("Ad blocked: " + host);
                    host = null;
                    return true;
                }
                host = host.substring(host.indexOf(46) + 1);
            }
            host = null;
        }
        return false;
    }

    boolean isMedia() {
        String path;
        String contentType = this.entity.get() == null || this.entity.get().getContentType() == null ? null : this.entity.get().getContentType().getValue();
        String string = contentType = contentType == null ? null : contentType.toLowerCase();
        if (contentType != null && (contentType.startsWith("image/") || contentType.startsWith("video/") || contentType.startsWith("audio/") || contentType.startsWith("font/") || contentType.startsWith("application/octet-stream") || contentType.contains("/font-"))) {
            return true;
        }
        String string2 = path = this.url.getPath() == null ? null : this.url.getPath().toLowerCase();
        if (path != null) {
            for (String extension : mediaExtensions) {
                if (!path.endsWith(extension)) continue;
                return true;
            }
        }
        return false;
    }

    StreamConnection(URL url) throws MalformedURLException {
        super(url);
        this.url = new URL(url.getProtocol(), url.getHost(), url.getPort(), url.getFile());
        this.urlString = url.toExternalForm();
        this.urlFragment = url.getRef();
    }

    private String hostHeader() {
        int port = this.url.getPort();
        return port == -1 || port == this.url.getDefaultPort() ? this.url.getHost() : this.url.getHost() + ":" + port;
    }

    private void processHeaders(Settings settings, HttpRequestBase req) {
        boolean https = this.urlString.toLowerCase().startsWith("https://");
        Collection<String> names = settings.headers().headerNames(https);
        for (String string : names) {
            String nameProperCase = settings.headers().nameFromLowercase(string, https);
            List<String> valuesIn = this.reqHeaders.get(string);
            String valueSettings = settings.headers().headerValue(string, https);
            if (valueSettings.equals("drop_header")) continue;
            if (valueSettings.equals("dynamic_header")) {
                if (string.equals("user-agent") && valuesIn != null && !valuesIn.isEmpty()) {
                    req.addHeader(nameProperCase, settings.userAgentString());
                    continue;
                }
                if (string.equals("host")) {
                    req.addHeader(nameProperCase, this.hostHeader());
                    continue;
                }
                if (valuesIn == null || valuesIn.isEmpty()) continue;
                for (String curVal : valuesIn) {
                    req.addHeader(nameProperCase, curVal);
                }
                continue;
            }
            req.addHeader(nameProperCase, valueSettings);
        }
        for (Map.Entry entry : this.reqHeaders.entrySet()) {
            if (names.contains(entry.getKey())) continue;
            for (String val : (List)entry.getValue()) {
                req.addHeader(this.reqHeadersCasing.get(entry.getKey()), val);
            }
        }
        cookieStore.addCsrfHeaders(settings, req);
    }

    @Override
    public void connect() throws IOException {
        block24: {
            try {
                if (!this.connected.compareAndSet(false, true)) break block24;
                if (StatusMonitor.instance().isDiscarded(this.urlString)) {
                    this.skip.set(true);
                    LogsServer.instance().trace("Media skipped: " + this.urlString);
                    break block24;
                }
                if (this.isBlocked(this.url.getHost())) {
                    this.skip.set(true);
                    break block24;
                }
                if (SettingsManager.settings() == null) break block24;
                this.config.get().setCookieSpec("custom").setSocketTimeout(SettingsManager.settings().socketTimeout()).setConnectTimeout(SettingsManager.settings().connectTimeout()).setConnectionRequestTimeout(SettingsManager.settings().connectionReqTimeout()).setLocalAddress(SettingsManager.settings().getLocalIp());
                URI uri = null;
                try {
                    uri = this.url.toURI();
                }
                catch (URISyntaxException e) {
                    uri = new URI(this.url.getProtocol(), this.url.getAuthority(), this.url.getPath() == null ? null : URLDecoder.decode(this.url.getPath(), "utf-8"), this.url.getQuery() == null ? null : URLDecoder.decode(this.url.getQuery(), "utf-8"), this.url.getRef() == null ? null : URLDecoder.decode(this.url.getRef(), "utf-8"));
                }
                if ("OPTIONS".equals(this.method.get())) {
                    this.req.set((HttpRequestBase)new HttpOptions(uri));
                } else if ("GET".equals(this.method.get())) {
                    this.req.set((HttpRequestBase)new HttpGet(uri));
                } else if ("HEAD".equals(this.method.get())) {
                    this.req.set((HttpRequestBase)new HttpHead(uri));
                } else if ("POST".equals(this.method.get())) {
                    this.req.set((HttpRequestBase)new HttpPost(uri));
                } else if ("PUT".equals(this.method.get())) {
                    this.req.set((HttpRequestBase)new HttpPut(uri));
                } else if ("DELETE".equals(this.method.get())) {
                    this.req.set((HttpRequestBase)new HttpDelete(uri));
                } else if ("TRACE".equals(this.method.get())) {
                    this.req.set((HttpRequestBase)new HttpTrace(uri));
                } else if ("PATCH".equals(this.method.get())) {
                    this.req.set((HttpRequestBase)new HttpPatch(uri));
                }
                this.processHeaders(SettingsManager.settings(), this.req.get());
                ProxyConfig proxy = SettingsManager.settings().proxy();
                if (proxy != null && !proxy.directConnection() && !proxy.nonProxyHosts().contains(uri.getHost())) {
                    this.config.get().setExpectContinueEnabled(proxy.expectContinue());
                    InetSocketAddress proxyAddress = new InetSocketAddress(proxy.host(), proxy.port());
                    if (proxy.type() == ProxyConfig.Type.SOCKS) {
                        this.context.get().setAttribute("proxy.socks.address", (Object)proxyAddress);
                    } else {
                        this.config.get().setProxy(new HttpHost(proxy.host(), proxy.port()));
                    }
                }
                this.context.get().setCookieStore((org.apache.http.client.CookieStore)cookieStore);
                this.context.get().setRequestConfig(this.config.get().build());
                StatusMonitor.instance().monitor(this.url, this);
            }
            catch (Throwable t) {
                throw new IOException(t.getMessage() + ": " + this.urlString, t);
            }
        }
    }

    private void exec() throws IOException {
        block12: {
            try {
                String location;
                if (!this.exec.compareAndSet(false, true)) break block12;
                this.connect();
                if (this.req.get() == null) break block12;
                if ("POST".equals(this.method.get())) {
                    ((HttpPost)this.req.get()).setEntity((HttpEntity)new ByteArrayEntity(this.reqData.get().toByteArray()));
                } else if ("PUT".equals(this.method.get())) {
                    ((HttpPut)this.req.get()).setEntity((HttpEntity)new ByteArrayEntity(this.reqData.get().toByteArray()));
                } else if ("PATCH".equals(this.method.get())) {
                    ((HttpPatch)this.req.get()).setEntity((HttpEntity)new ByteArrayEntity(this.reqData.get().toByteArray()));
                }
                this.response.set(client.get().execute(this.req.get(), this.context.get()));
                if (this.response.get() != null && this.response.get().getEntity() != null) {
                    this.entity.set(this.response.get().getEntity());
                    this.response.get().setHeader("Cache-Control", "no-store, no-cache");
                }
                if (this.urlFragment == null || this.response.get() == null) break block12;
                Header header = this.response.get().getFirstHeader("Location");
                String string = location = header == null ? null : header.getValue();
                if (StringUtils.isEmpty((String)location)) break block12;
                try {
                    URI uri = new URIBuilder(location).build();
                    if (StringUtils.isEmpty((String)uri.getRawFragment())) {
                        String path = uri.getPath();
                        path = StringUtils.isEmpty((String)path) ? "/" : path;
                        this.response.get().setHeader("Location", new URIBuilder(location).setPath(path).setFragment(this.urlFragment).build().toString());
                    }
                }
                catch (Throwable t) {
                    if (location.contains("#")) break block12;
                    int fromIndex = location.indexOf("//") + 2;
                    if (fromIndex <= location.length() && location.substring(fromIndex).contains("/")) {
                        this.response.get().setHeader("Location", location + "#" + this.urlFragment);
                        break block12;
                    }
                    this.response.get().setHeader("Location", location + "/#" + this.urlFragment);
                }
            }
            catch (Throwable t) {
                throw new IOException(t.getMessage() + ": " + this.urlString, t);
            }
        }
    }

    @Override
    public void disconnect() {
    }

    @Override
    public void close() throws IOException {
        if (this.closed.compareAndSet(false, true) && this.entity.get() != null) {
            try {
                EntityUtils.consume((HttpEntity)this.entity.get());
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    static void cleanUp() {
        client.get().cleanUp();
    }

    @Override
    public InputStream getInputStream() throws IOException {
        this.exec();
        if (this.consumed.compareAndSet(false, true) && this.entity.get() != null) {
            try {
                InputStream entityStream = this.entity.get().getContent();
                if (entityStream != null && !this.skip.get()) {
                    InputStream inputStream = ResponseHandler.handleResponse(this, entityStream);
                    return inputStream;
                }
            }
            finally {
                this.close();
            }
        }
        return new ByteArrayInputStream(new byte[0]);
    }

    @Override
    public InputStream getErrorStream() {
        try {
            if (this.getResponseCode() > 399) {
                return this.getInputStream();
            }
        }
        catch (IOException e) {
            LogsServer.instance().exception(e);
        }
        return null;
    }

    @Override
    public String getResponseMessage() throws IOException {
        this.exec();
        return this.response.get() == null || this.response.get().getStatusLine() == null ? null : this.response.get().getStatusLine().getReasonPhrase();
    }

    @Override
    public int getResponseCode() throws IOException {
        this.exec();
        try {
            String location = this.getHeaderField("Location");
            if (!StringUtils.isEmpty((String)location)) {
                StatusMonitor.instance().addRedirect(this.urlString, new URL(this.url, location).toExternalForm());
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (this.skip.get()) {
            return 204;
        }
        return this.response.get() == null || this.response.get().getStatusLine() == null ? 499 : this.response.get().getStatusLine().getStatusCode();
    }

    @Override
    public Object getContent() throws IOException {
        throw new UnsupportedOperationException();
    }

    public Object getContent(Class[] classes) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getContentEncoding() {
        if (this.contentEncodingRemoved.get()) {
            return null;
        }
        return this.entity.get() == null || this.entity.get().getContentEncoding() == null || this.skip.get() ? null : this.entity.get().getContentEncoding().getValue();
    }

    public void removeContentEncoding() {
        this.response.get().removeHeaders("Content-Encoding");
        this.contentEncodingRemoved.set(true);
    }

    @Override
    public int getContentLength() {
        if (this.contentLength.get() != -1L) {
            return (int)this.contentLength.get();
        }
        return this.entity.get() == null || this.skip.get() ? 0 : (int)this.entity.get().getContentLength();
    }

    @Override
    public long getContentLengthLong() {
        if (this.contentLength.get() != -1L) {
            return this.contentLength.get();
        }
        return this.entity.get() == null || this.skip.get() ? 0L : this.entity.get().getContentLength();
    }

    public void setContentLength(long contentLength) {
        this.contentLength.set(contentLength);
        this.response.get().setHeader("Content-Length", Long.toString(contentLength));
    }

    @Override
    public Permission getPermission() throws IOException {
        return null;
    }

    @Override
    public String getContentType() {
        return this.entity.get() == null || this.skip.get() ? null : (this.entity.get().getContentType() == null ? "text/html" : this.entity.get().getContentType().getValue());
    }

    public String getContentTypeRaw() {
        return this.entity.get() == null || this.entity.get().getContentType() == null ? null : this.entity.get().getContentType().getValue();
    }

    @Override
    public long getDate() {
        return this.getHeaderFieldLong("Date", 0L);
    }

    @Override
    public long getExpiration() {
        return this.getHeaderFieldLong("Expires", 0L);
    }

    @Override
    public long getLastModified() {
        return this.getHeaderFieldLong("Last-Modified", 0L);
    }

    @Override
    public Map<String, List<String>> getHeaderFields() {
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        if (this.response.get() != null) {
            Header[] headers = this.response.get().getAllHeaders();
            for (int i = 0; headers != null && i < headers.length; ++i) {
                String name = headers[i].getName();
                if (!map.containsKey(name)) {
                    map.put(name, new ArrayList());
                }
                ((List)map.get(name)).add(headers[i].getValue());
            }
        }
        return map;
    }

    @Override
    public String getHeaderField(String name) {
        Header[] headers;
        if (this.response.get() != null && (headers = this.response.get().getHeaders(name)) != null && headers.length > 0) {
            return headers[headers.length - 1].getValue();
        }
        return null;
    }

    @Override
    public int getHeaderFieldInt(String name, int defaultValue) {
        Header[] headers;
        if (this.response.get() != null && (headers = this.response.get().getHeaders(name)) != null && headers.length > 0) {
            return Integer.parseInt(headers[headers.length - 1].getValue());
        }
        return defaultValue;
    }

    @Override
    public long getHeaderFieldLong(String name, long defaultValue) {
        Header[] headers;
        if (this.response.get() != null && (headers = this.response.get().getHeaders(name)) != null && headers.length > 0) {
            return Long.parseLong(headers[headers.length - 1].getValue());
        }
        return defaultValue;
    }

    @Override
    public long getHeaderFieldDate(String name, long defaultValue) {
        return this.getHeaderFieldLong(name, defaultValue);
    }

    @Override
    public String getHeaderFieldKey(int n) {
        return this.response.get() == null || this.response.get().getAllHeaders() == null || n >= this.response.get().getAllHeaders().length || this.response.get().getAllHeaders()[n] == null ? null : this.response.get().getAllHeaders()[n].getName();
    }

    @Override
    public String getHeaderField(int n) {
        return this.response.get() == null || this.response.get().getAllHeaders() == null || n >= this.response.get().getAllHeaders().length || this.response.get().getAllHeaders()[n] == null ? null : this.response.get().getAllHeaders()[n].getValue();
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        return this.skip.get() ? new ByteArrayOutputStream() : (OutputStream)this.reqData.get();
    }

    @Override
    public URL getURL() {
        return this.url;
    }

    @Override
    public String getRequestMethod() {
        return this.method.get();
    }

    @Override
    public void setRequestMethod(String method) throws ProtocolException {
        this.method.set(method.toUpperCase());
    }

    @Override
    public int getConnectTimeout() {
        return 0;
    }

    @Override
    public void setConnectTimeout(int timeout) {
    }

    @Override
    public int getReadTimeout() {
        return 0;
    }

    @Override
    public void setReadTimeout(int timeout) {
    }

    @Override
    public boolean usingProxy() {
        ProxyConfig proxy = SettingsManager.settings().proxy();
        return proxy != null && !proxy.directConnection();
    }

    @Override
    public long getIfModifiedSince() {
        return this.getRequestProperty("If-Modified-Since") == null ? 0L : Long.parseLong(this.getRequestProperty("If-Modified-Since"));
    }

    @Override
    public void setIfModifiedSince(long ifmodifiedsince) {
        this.setRequestProperty("If-Modified-Since", Long.toString(ifmodifiedsince));
    }

    @Override
    public Map<String, List<String>> getRequestProperties() {
        return this.reqHeaders;
    }

    @Override
    public String getRequestProperty(String key) {
        String keyLowercase = key.toLowerCase();
        return this.reqHeaders.get(keyLowercase) == null || this.reqHeaders.get(keyLowercase).isEmpty() ? null : this.reqHeaders.get(keyLowercase).get(0);
    }

    @Override
    public void setRequestProperty(String key, String value) {
        String keyLowercase = key.toLowerCase();
        if (!ignoredHeaders.contains(keyLowercase)) {
            this.reqHeaders.remove(keyLowercase);
            ArrayList<String> list = new ArrayList<String>();
            list.add(value);
            this.reqHeaders.put(keyLowercase, list);
            this.reqHeadersCasing.put(keyLowercase, key);
        }
    }

    @Override
    public void addRequestProperty(String key, String value) {
        String keyLowercase = key.toLowerCase();
        if (!ignoredHeaders.contains(keyLowercase)) {
            if (this.reqHeaders.get(keyLowercase) == null) {
                this.reqHeaders.put(keyLowercase, new ArrayList());
            }
            this.reqHeaders.get(keyLowercase).add(value);
            this.reqHeadersCasing.put(keyLowercase, key);
        }
    }

    @Override
    public void setFixedLengthStreamingMode(int contentLength) {
    }

    @Override
    public void setFixedLengthStreamingMode(long contentLength) {
    }

    @Override
    public void setChunkedStreamingMode(int chunklen) {
    }

    @Override
    public boolean getAllowUserInteraction() {
        return true;
    }

    @Override
    public void setAllowUserInteraction(boolean allowuserinteraction) {
    }

    @Override
    public boolean getDoInput() {
        return true;
    }

    @Override
    public void setDoInput(boolean doinput) {
    }

    @Override
    public boolean getDoOutput() {
        return true;
    }

    @Override
    public void setDoOutput(boolean dooutput) {
    }

    @Override
    public boolean getInstanceFollowRedirects() {
        return false;
    }

    @Override
    public void setInstanceFollowRedirects(boolean followRedirects) {
    }

    @Override
    public boolean getDefaultUseCaches() {
        return false;
    }

    @Override
    public void setDefaultUseCaches(boolean defaultusecaches) {
    }

    @Override
    public boolean getUseCaches() {
        return false;
    }

    @Override
    public void setUseCaches(boolean usecaches) {
    }

    static {
        File attachmentsDirTmp = null;
        File mediaDirTmp = null;
        try {
            attachmentsDirTmp = Files.createTempDirectory("jbd_attachments_", new FileAttribute[0]).toFile();
            mediaDirTmp = Files.createTempDirectory("jbd_media_", new FileAttribute[0]).toFile();
            attachmentsDirTmp.deleteOnExit();
            mediaDirTmp.deleteOnExit();
        }
        catch (Throwable t) {
            Util.handleException(t);
        }
        attachmentsDir = attachmentsDirTmp;
        mediaDir = mediaDirTmp;
        ignoredHeaders = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("cookie", "pragma", "cache-control", "content-length")));
        invalidUrlChar = Pattern.compile("[^-A-Za-z0-9._~:/?#\\[\\]@!$&'()*+,;=]");
        adHosts = new HashSet<String>();
        client = new AtomicReference();
        mediaExtensions = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList(".svg", ".gif", ".jpeg", ".jpg", ".png", ".ico", ".webm", ".mp4", ".ogg", ".ogv", ".mp3", ".aac", ".wav", ".swf", ".woff", ".otf", ".ttf")));
        if (SettingsManager.settings().blockAds()) {
            BufferedReader reader = null;
            try {
                reader = new BufferedReader(new InputStreamReader(StreamConnection.class.getResourceAsStream("/com/machinepublishers/jbrowserdriver/ad-hosts.txt")));
                String line = reader.readLine();
                while (line != null) {
                    adHosts.add(line);
                    line = reader.readLine();
                }
            }
            catch (Throwable t) {
                try {
                    LogsServer.instance().exception(t);
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    Util.close(reader);
                }
            }
            Util.close(reader);
        }
    }
}

