/*
 * Decompiled with CFR 0.152.
 */
package com.machinepublishers.glass.ui.monocle;

import com.machinepublishers.glass.ui.monocle.InputDeviceRegistry;
import com.machinepublishers.glass.ui.monocle.NativeCursor;
import com.machinepublishers.glass.ui.monocle.NativeScreen;
import com.machinepublishers.glass.ui.monocle.RunnableProcessor;

public abstract class NativePlatform {
    private static InputDeviceRegistry inputDeviceRegistry;
    private final RunnableProcessor runnableProcessor = new RunnableProcessor();
    private NativeCursor cursor;
    private NativeScreen screen;

    protected NativePlatform() {
    }

    void shutdown() {
        this.runnableProcessor.shutdown();
        if (this.cursor != null) {
            this.cursor.shutdown();
        }
        if (this.screen != null) {
            this.screen.shutdown();
        }
    }

    RunnableProcessor getRunnableProcessor() {
        return this.runnableProcessor;
    }

    synchronized InputDeviceRegistry getInputDeviceRegistry() {
        if (inputDeviceRegistry == null) {
            inputDeviceRegistry = this.createInputDeviceRegistry();
        }
        return inputDeviceRegistry;
    }

    protected abstract InputDeviceRegistry createInputDeviceRegistry();

    protected abstract NativeCursor createCursor();

    synchronized NativeCursor getCursor() {
        if (this.cursor == null) {
            this.cursor = this.createCursor();
        }
        return this.cursor;
    }

    protected abstract NativeScreen createScreen();

    synchronized NativeScreen getScreen() {
        if (this.screen == null) {
            this.screen = this.createScreen();
        }
        return this.screen;
    }
}

