/*
 * Decompiled with CFR 0.152.
 */
package com.madgag.git.bfg.cleaner;

import com.madgag.git.bfg.CleaningMapper;
import com.madgag.git.bfg.GitUtil$;
import com.madgag.git.bfg.Text$;
import com.madgag.git.bfg.Timing$;
import com.madgag.git.bfg.cleaner.ObjectIdCleaner;
import com.madgag.git.bfg.cleaner.RepoRewriter$;
import com.madgag.git.bfg.cleaner.RepoRewriter$$anonfun$rewrite$1$;
import com.madgag.git.bfg.cleaner.protection.ProtectedObjectDirtReport;
import com.madgag.git.bfg.cleaner.protection.Reporter$;
import com.madgag.git.bfg.cli.Tables$;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.Constants;
import org.eclipse.jgit.lib.ObjectDatabase;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.TextProgressMonitor;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevObject;
import org.eclipse.jgit.revwalk.RevSort;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.transport.ReceiveCommand;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqView;
import scala.collection.SeqView$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.ViewMkString;
import scala.collection.convert.WrapAsScala;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.collection.parallel.ParIterableLike;
import scala.concurrent.ExecutionContext;
import scala.concurrent.package$;
import scala.math.Numeric;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.util.Either$;

public final class RepoRewriter$ {
    public static final RepoRewriter$ MODULE$;

    static {
        new RepoRewriter$();
    }

    public void rewrite(Repository repo, ObjectIdCleaner.Config objectIdCleanerConfig) {
        Predef$.MODULE$.assert(!repo.getAllRefs().isEmpty(), (Function0)new Serializable(repo){
            public static final long serialVersionUID = 0L;
            private final Repository repo$1;

            public final String apply() {
                return new StringBuilder().append((Object)"Can't find any refs in repo at ").append((Object)this.repo$1.getDirectory().getAbsolutePath()).toString();
            }
            {
                this.repo$1 = repo$1;
            }
        });
        TextProgressMonitor progressMonitor = new TextProgressMonitor();
        ObjectDatabase objectDB = repo.getObjectDatabase();
        RevWalk revWalk = this.createRevWalk$1(repo, objectDB);
        ObjectIdCleaner objectIdCleaner = new ObjectIdCleaner(objectIdCleanerConfig, repo.getObjectDatabase(), revWalk);
        Predef$.MODULE$.println((Object)this.title("Protected commits"));
        if (objectIdCleanerConfig.objectProtection().objectProtection().isEmpty()) {
            Predef$.MODULE$.println((Object)"You're not protecting any commits, which means the BFG will modify the contents of even *current* commits.\n\nThis isn't recommended - ideally, if your current commits are dirty, you should fix up your working copy and commit that, check that your build still works, and only then run the BFG to clean up your history.");
        } else {
            this.reportObjectProtection(objectIdCleanerConfig, objectIdCleaner, revWalk);
        }
        Predef$.MODULE$.println((Object)this.title("Cleaning"));
        List commits = ((WrapAsScala)scala.collection.convert.package$.MODULE$.wrapAll()).iterableAsScalaIterable((java.lang.Iterable)revWalk).toList();
        Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"Found ").append((Object)BoxesRunTime.boxToInteger((int)commits.size())).append((Object)" commits").toString());
        Timing$.MODULE$.measureTask("Cleaning commits", commits.size(), new Serializable(progressMonitor, objectIdCleaner, commits){
            public static final long serialVersionUID = 0L;
            public final TextProgressMonitor progressMonitor$1;
            public final ObjectIdCleaner objectIdCleaner$1;
            public final List commits$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                package$.MODULE$.future((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.rewrite.1 $outer;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        ((ParIterableLike)this.$outer.commits$1.par()).foreach((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ anonfun$rewrite$1$$anonfun$apply$mcV$sp$1 $outer;

                            public final ObjectId apply(RevCommit commit) {
                                return this.$outer.com$madgag$git$bfg$cleaner$RepoRewriter$$anonfun$$anonfun$$$outer().objectIdCleaner$1.apply((ObjectId)commit.getTree());
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                            }
                        });
                    }

                    public /* synthetic */ anonfun.rewrite.1 com$madgag$git$bfg$cleaner$RepoRewriter$$anonfun$$anonfun$$$outer() {
                        return this.$outer;
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                }, (ExecutionContext)ExecutionContext.Implicits$.MODULE$.global());
                this.commits$1.foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.rewrite.1 $outer;

                    public final void apply(RevCommit commit) {
                        this.$outer.objectIdCleaner$1.apply((ObjectId)commit);
                        this.$outer.progressMonitor$1.update(1);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
            }
            {
                this.progressMonitor$1 = progressMonitor$1;
                this.objectIdCleaner$1 = objectIdCleaner$1;
                this.commits$1 = commits$1;
            }
        }, (ProgressMonitor)progressMonitor);
        if (commits.exists((Function1)new Serializable(objectIdCleaner){
            public static final long serialVersionUID = 0L;
            private final ObjectIdCleaner objectIdCleaner$1;

            public final boolean apply(ObjectId v) {
                return this.objectIdCleaner$1.isDirty(v);
            }
            {
                this.objectIdCleaner$1 = objectIdCleaner$1;
            }
        })) {
            this.reportTreeDirtHistory((List<RevCommit>)commits, objectIdCleaner);
            Iterable refUpdateCommands = (Iterable)((WrapAsScala)scala.collection.convert.package$.MODULE$.wrapAll()).collectionAsScalaIterable(repo.getAllRefs().values()).withFilter((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final boolean apply(Ref ref) {
                    return !ref.isSymbolic();
                }
            }).flatMap((Function1)new Serializable(objectIdCleaner){
                public static final long serialVersionUID = 0L;
                private final ObjectIdCleaner objectIdCleaner$1;

                public final Iterable<ReceiveCommand> apply(Ref ref) {
                    return Option$.MODULE$.option2Iterable(this.objectIdCleaner$1.substitution(ref.getObjectId()).map((Function1)new Serializable(this, ref){
                        public static final long serialVersionUID = 0L;
                        private final Ref ref$1;

                        public final ReceiveCommand apply(Tuple2<ObjectId, ObjectId> x$2) {
                            Tuple2<ObjectId, ObjectId> tuple2 = x$2;
                            if (tuple2 != null) {
                                ObjectId oldId = (ObjectId)tuple2._1();
                                ObjectId newId = (ObjectId)tuple2._2();
                                ReceiveCommand receiveCommand = new ReceiveCommand(oldId, newId, this.ref$1.getName());
                                return receiveCommand;
                            }
                            throw new MatchError(tuple2);
                        }
                        {
                            this.ref$1 = ref$1;
                        }
                    }));
                }
                {
                    this.objectIdCleaner$1 = objectIdCleaner$1;
                }
            }, scala.collection.Iterable$.MODULE$.canBuildFrom());
            Predef$.MODULE$.println((Object)this.title(new StringBuilder().append((Object)"Updating ").append((Object)Text$.MODULE$.plural(refUpdateCommands, "Ref")).toString()));
            if (refUpdateCommands.isEmpty()) {
                Predef$.MODULE$.println((Object)"WARNING: No refs to update - no dirty commits found??");
            } else {
                Iterable summaryTableCells = (Iterable)refUpdateCommands.map((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final Tuple3<String, String, String> apply(ReceiveCommand update) {
                        return new Tuple3((Object)update.getRefName(), (Object)GitUtil$.MODULE$.RichObjectId((AnyObjectId)update.getOldId()).shortName(), (Object)GitUtil$.MODULE$.RichObjectId((AnyObjectId)update.getNewId()).shortName());
                    }
                }, scala.collection.Iterable$.MODULE$.canBuildFrom());
                ((IterableLike)Tables$.MODULE$.formatTable((Product)new Tuple3((Object)"Ref", (Object)"Before", (Object)"After"), (Seq<Product>)summaryTableCells.toSeq()).map((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final String apply(String x$3) {
                        return new StringBuilder().append((Object)"\t").append((Object)x$3).toString();
                    }
                }, Seq$.MODULE$.canBuildFrom())).foreach((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final void apply(Object x) {
                        Predef$.MODULE$.println(x);
                    }
                });
                Predef$.MODULE$.println();
                repo.getRefDatabase().newBatchUpdate().setAllowNonFastForwards(true).addCommand(scala.collection.convert.package$.MODULE$.wrapAll().asJavaCollection(refUpdateCommands)).execute(revWalk, (ProgressMonitor)progressMonitor);
            }
            Predef$.MODULE$.println((Object)"\nBFG run is complete!");
        } else {
            Predef$.MODULE$.println((Object)"\nBFG aborting: No unprotected dirty commits found - has this repo already been cleaned?\n");
        }
    }

    public void reportObjectProtection(ObjectIdCleaner.Config objectIdCleanerConfig, ObjectIdCleaner objectIdCleaner, RevWalk revWalk) {
        Predef$.MODULE$.println((Object)"These are your latest commits, and so their contents will NOT be altered:\n");
        List reports = ((TraversableOnce)objectIdCleanerConfig.objectProtection().objectProtection().map((Function1)new Serializable(objectIdCleaner, revWalk){
            public static final long serialVersionUID = 0L;
            private final ObjectIdCleaner objectIdCleaner$2;
            private final RevWalk revWalk$2;

            public final ProtectedObjectDirtReport apply(Tuple2<RevObject, Set<String>> x0$2) {
                Tuple2<RevObject, Set<String>> tuple2 = x0$2;
                if (tuple2 != null) {
                    RevObject revObj = (RevObject)tuple2._1();
                    Set refNames = (Set)tuple2._2();
                    ObjectReader reader = this.revWalk$2.getObjectReader();
                    RevObject originalContentObject = (RevObject)Either$.MODULE$.MergeableEither(GitUtil$.MODULE$.treeOrBlobPointedToBy(revObj, this.revWalk$2)).merge();
                    Option<ObjectId> replacementTreeOrBlob = GitUtil$.MODULE$.cleaner2CleaningMapper(this.objectIdCleaner$2.uncachedClean()).replacement((ObjectId)originalContentObject);
                    ProtectedObjectDirtReport protectedObjectDirtReport = new ProtectedObjectDirtReport(revObj, originalContentObject, replacementTreeOrBlob);
                    return protectedObjectDirtReport;
                }
                throw new MatchError(tuple2);
            }
            {
                this.objectIdCleaner$2 = objectIdCleaner$2;
                this.revWalk$2 = revWalk$2;
            }
        }, Iterable$.MODULE$.canBuildFrom())).toList();
        Reporter$.MODULE$.reportProtectedCommitsAndTheirDirt((List<ProtectedObjectDirtReport>)reports, objectIdCleanerConfig, revWalk);
    }

    public void reportTreeDirtHistory(List<RevCommit> commits, Function1<ObjectId, ObjectId> objectIdCleaner) {
        int dirtHistoryElements = scala.math.package$.MODULE$.max(20, scala.math.package$.MODULE$.min(60, commits.size()));
        String treeDirtHistory = ((ViewMkString)this.cut$1((Seq)commits, dirtHistoryElements).map((Function1)new Serializable(objectIdCleaner){
            public static final long serialVersionUID = 0L;
            public final Function1 objectIdCleaner$3;

            public final char apply(Seq<RevCommit> x0$3) {
                CleaningMapper<V> cleaningMapper;
                Seq<RevCommit> seq = x0$3;
                int n = seq.isEmpty() ? 32 : (seq.exists((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.6 $outer;

                    public final boolean apply(RevCommit c) {
                        return GitUtil$.MODULE$.cleaner2CleaningMapper(this.$outer.objectIdCleaner$3).isDirty(c.getTree());
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                }) ? 68 : (seq.exists((Function1)new Serializable(this, cleaningMapper = GitUtil$.MODULE$.cleaner2CleaningMapper(this.objectIdCleaner$3)){
                    public static final long serialVersionUID = 0L;
                    private final CleaningMapper eta$0$1$1;

                    public final boolean apply(ObjectId v) {
                        return this.eta$0$1$1.isDirty(v);
                    }
                    {
                        this.eta$0$1$1 = eta$0$1$1;
                    }
                }) ? 109 : 46));
                return (char)n;
            }
            {
                this.objectIdCleaner$3 = objectIdCleaner$3;
            }
        }, SeqView$.MODULE$.canBuildFrom())).mkString();
        Predef$.MODULE$.println((Object)this.title("Commit Tree-Dirt History"));
        Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"\t").append((Object)this.leftRight$1((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Earliest", "Latest"})), treeDirtHistory)).toString());
        Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"\t").append((Object)this.leftRight$1((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"|", "|"})), treeDirtHistory)).toString());
        Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"\t").append((Object)treeDirtHistory).toString());
        Predef$.MODULE$.println((Object)"\n\tD = dirty commits (file tree fixed)");
        Predef$.MODULE$.println((Object)"\tm = modified commits (commit message or parents changed)");
        Predef$.MODULE$.println((Object)"\t. = clean commits (no changes to file tree)\n");
        CleaningMapper<ObjectId> cleaningMapper = GitUtil$.MODULE$.cleaner2CleaningMapper(objectIdCleaner);
        Tuple2 firstModifiedCommit = new Tuple2((Object)"First modified commit", commits.find((Function1)new Serializable(cleaningMapper){
            public static final long serialVersionUID = 0L;
            private final CleaningMapper eta$0$2$1;

            public final boolean apply(ObjectId v) {
                return this.eta$0$2$1.isDirty(v);
            }
            {
                this.eta$0$2$1 = eta$0$2$1;
            }
        }).get());
        Tuple2 lastDirtyCommit = new Tuple2((Object)"Last dirty commit", commits.reverse().find((Function1)new Serializable(objectIdCleaner){
            public static final long serialVersionUID = 0L;
            private final Function1 objectIdCleaner$3;

            public final boolean apply(RevCommit c) {
                return GitUtil$.MODULE$.cleaner2CleaningMapper(this.objectIdCleaner$3).isDirty(c.getTree());
            }
            {
                this.objectIdCleaner$3 = objectIdCleaner$3;
            }
        }).get());
        Seq items = (Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{firstModifiedCommit, lastDirtyCommit}))).flatMap((Function1)new Serializable(objectIdCleaner){
            public static final long serialVersionUID = 0L;
            private final Function1 objectIdCleaner$3;

            public final Iterable<Tuple3<String, String, String>> apply(Tuple2<String, RevCommit> x$6) {
                Tuple2<String, RevCommit> tuple2 = x$6;
                if (tuple2 != null) {
                    String desc = (String)tuple2._1();
                    RevCommit commit = (RevCommit)tuple2._2();
                    Iterable iterable = Option$.MODULE$.option2Iterable(GitUtil$.MODULE$.cleaner2CleaningMapper(this.objectIdCleaner$3).substitution(commit).map((Function1)new Serializable(this, desc){
                        public static final long serialVersionUID = 0L;
                        private final String desc$1;

                        public final Tuple3<String, String, String> apply(Tuple2<ObjectId, ObjectId> x$5) {
                            Tuple2<ObjectId, ObjectId> tuple2 = x$5;
                            if (tuple2 != null) {
                                ObjectId before = (ObjectId)tuple2._1();
                                ObjectId after = (ObjectId)tuple2._2();
                                Tuple3 tuple3 = new Tuple3((Object)this.desc$1, (Object)GitUtil$.MODULE$.RichObjectId((AnyObjectId)before).shortName(), (Object)GitUtil$.MODULE$.RichObjectId((AnyObjectId)after).shortName());
                                return tuple3;
                            }
                            throw new MatchError(tuple2);
                        }
                        {
                            this.desc$1 = desc$1;
                        }
                    }));
                    return iterable;
                }
                throw new MatchError(tuple2);
            }
            {
                this.objectIdCleaner$3 = objectIdCleaner$3;
            }
        }, Seq$.MODULE$.canBuildFrom());
        ((IterableLike)Tables$.MODULE$.formatTable((Product)new Tuple3((Object)"", (Object)"Before", (Object)"After"), (Seq<Product>)items).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(String x$7) {
                return new StringBuilder().append((Object)"\t").append((Object)x$7).toString();
            }
        }, Seq$.MODULE$.canBuildFrom())).foreach((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply(Object x) {
                Predef$.MODULE$.println(x);
            }
        });
    }

    public String title(String text) {
        return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\\n", "\\n"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{text}))).append((Object)new StringOps(Predef$.MODULE$.augmentString("-")).$times(new StringOps(Predef$.MODULE$.augmentString(text)).size())).append((Object)"\n").toString();
    }

    /*
     * WARNING - void declaration
     */
    private final RevWalk createRevWalk$1(Repository repo$1, ObjectDatabase objectDB$1) {
        void var3_3;
        RevWalk revWalk = new RevWalk(repo$1);
        revWalk.sort(RevSort.TOPO);
        revWalk.sort(RevSort.REVERSE, true);
        ObjectReader objReader = objectDB$1.newReader();
        Map refsByObjType = ((WrapAsScala)scala.collection.convert.package$.MODULE$.wrapAll()).collectionAsScalaIterable(repo$1.getAllRefs().values()).groupBy((Function1)new Serializable(objReader){
            public static final long serialVersionUID = 0L;
            private final ObjectReader objReader$1;

            public final int apply(Ref ref) {
                return this.objReader$1.open((AnyObjectId)ref.getObjectId()).getType();
            }
            {
                this.objReader$1 = objReader$1;
            }
        }).withDefault((Function1)Seq$.MODULE$.empty());
        refsByObjType.foreach((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply(Tuple2<Object, Iterable<Ref>> x0$1) {
                Tuple2<Object, Iterable<Ref>> tuple2 = x0$1;
                if (tuple2 != null) {
                    int typ = tuple2._1$mcI$sp();
                    Iterable refs = (Iterable)tuple2._2();
                    Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"Found ").append((Object)BoxesRunTime.boxToInteger((int)refs.size())).append((Object)" ").append((Object)Constants.typeString((int)typ)).append((Object)"-pointing refs : ").append((Object)Text$.MODULE$.abbreviate(((TraversableOnce)refs.map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final String apply(Ref x$1) {
                            return x$1.getName();
                        }
                    }, scala.collection.Iterable$.MODULE$.canBuildFrom())).toSeq(), "...", 4).mkString(", ")).toString());
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError(tuple2);
            }
        });
        revWalk.markStart(scala.collection.convert.package$.MODULE$.wrapAll().asJavaCollection((Iterable)((TraversableLike)refsByObjType.apply((Object)BoxesRunTime.boxToInteger((int)1))).map((Function1)new Serializable(revWalk){
            public static final long serialVersionUID = 0L;
            private final RevWalk revWalk$1;

            public final RevCommit apply(Ref ref) {
                return GitUtil$.MODULE$.RichObjectId((AnyObjectId)ref.getObjectId()).asRevCommit(this.revWalk$1);
            }
            {
                this.revWalk$1 = revWalk$1;
            }
        }, scala.collection.Iterable$.MODULE$.canBuildFrom())));
        return var3_3;
    }

    public final int com$madgag$git$bfg$cleaner$RepoRewriter$$startOf$1(int unit, float avgSize$1) {
        return scala.math.package$.MODULE$.round((float)unit * avgSize$1);
    }

    private final SeqView cut$1(Seq xs, int n) {
        float avgSize = (float)xs.size() / (float)n;
        return (SeqView)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), n).view().map((Function1)new Serializable(xs, avgSize){
            public static final long serialVersionUID = 0L;
            private final Seq xs$1;
            private final float avgSize$1;

            public final Seq<A> apply(int u) {
                return (Seq)this.xs$1.slice(RepoRewriter$.MODULE$.com$madgag$git$bfg$cleaner$RepoRewriter$$startOf$1(u, this.avgSize$1), RepoRewriter$.MODULE$.com$madgag$git$bfg$cleaner$RepoRewriter$$startOf$1(u + 1, this.avgSize$1));
            }
            {
                this.xs$1 = xs$1;
                this.avgSize$1 = avgSize$1;
            }
        }, SeqView$.MODULE$.canBuildFrom());
    }

    private final String leftRight$1(Seq markers, String treeDirtHistory$1) {
        return markers.mkString(new StringOps(Predef$.MODULE$.augmentString(" ")).$times(treeDirtHistory$1.length() - BoxesRunTime.unboxToInt((Object)((TraversableOnce)markers.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final int apply(String x$4) {
                return new StringOps(Predef$.MODULE$.augmentString(x$4)).size();
            }
        }, Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$))));
    }

    private RepoRewriter$() {
        MODULE$ = this;
    }
}

