/*
 * Decompiled with CFR 0.152.
 */
package com.madgag.guardian.contentapi;

import com.google.common.base.Joiner;
import com.google.common.collect.Maps;
import com.madgag.guardian.contentapi.ApiConfig;
import com.madgag.guardian.contentapi.ApiResponse;
import com.madgag.guardian.contentapi.UrlHitter;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import javax.xml.bind.JAXBContext;

public abstract class ApiRequest<Req extends ApiRequest<Req, Resp>, Resp extends ApiResponse<Req, Resp>> {
    protected static final Joiner COMMA_JOINER = Joiner.on((String)",");
    private static final Joiner.MapJoiner QUERY_PARAMS_JOINER = Joiner.on((String)"&").withKeyValueSeparator("=");
    protected final UrlHitter hitter;

    protected ApiRequest(UrlHitter hitter) {
        this.hitter = hitter;
    }

    abstract String getPathPrefix();

    abstract Map<String, String> getParams();

    public abstract JAXBContext getJaxbContextForResponse();

    public final Resp execute() {
        return this.hitter.makeWebRequestFor(this);
    }

    public URI toUri() {
        ApiConfig config = this.hitter.getConfig();
        HashMap params = Maps.newHashMap(this.getParams());
        params.put("format", "xml");
        if (config.getApiKey() != null) {
            params.put("api-key", config.getApiKey());
        }
        return URI.create(config.getServerPath() + this.getPathPrefix() + "?" + QUERY_PARAMS_JOINER.join((Map)params));
    }
}

