/*
 * Decompiled with CFR 0.152.
 */
package com.madgag.guardian.contentapi;

import com.google.inject.Inject;
import com.madgag.guardian.contentapi.ApiConfig;
import com.madgag.guardian.contentapi.ApiRequest;
import com.madgag.guardian.contentapi.ApiResponse;
import com.madgag.guardian.contentapi.ContentApiException;
import com.madgag.guardian.contentapi.UrlHitter;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;

public class JavaNetUrlHitter
implements UrlHitter {
    private static final Logger log = Logger.getLogger(JavaNetUrlHitter.class.getName());
    private final ApiConfig apiConfig;

    @Inject
    public JavaNetUrlHitter(ApiConfig urlGenerator) {
        this.apiConfig = urlGenerator;
    }

    @Override
    public <Req extends ApiRequest<Req, Resp>, Resp extends ApiResponse<Req, Resp>> Resp makeWebRequestFor(Req apiRequest) {
        URI uri = apiRequest.toUri();
        try {
            URL url = uri.toURL();
            if (log.isLoggable(Level.FINE)) {
                log.fine(url.toString());
            }
            ApiResponse response = (ApiResponse)apiRequest.getJaxbContextForResponse().createUnmarshaller().unmarshal(url.openStream());
            response.setOriginalRequest(apiRequest);
            return (Resp)response;
        }
        catch (MalformedURLException mue) {
            log.log(Level.SEVERE, "Apparently this is a malformed URL: ---" + uri + "---", mue);
            throw new ContentApiException("Bizarre Malformed URL Exception reading from " + uri, mue);
        }
        catch (Exception e) {
            throw new ContentApiException("Error reading from " + uri, e);
        }
    }

    @Override
    public ApiConfig getConfig() {
        return this.apiConfig;
    }
}

