/*
 * Decompiled with CFR 0.152.
 */
package com.madgag.guardian.contentapi;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.madgag.guardian.contentapi.ApiRequest;
import com.madgag.guardian.contentapi.ContentRequest;
import com.madgag.guardian.contentapi.UrlHitter;
import com.madgag.guardian.contentapi.jaxb.SearchResponse;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import org.joda.time.DateTimeZone;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadableInterval;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class SearchRequest
extends ApiRequest<SearchRequest, SearchResponse>
implements ContentRequest<SearchRequest> {
    private static final DateTimeFormatter DATE_FORMAT = DateTimeFormat.forPattern((String)"yyyy-MM-dd").withZone(DateTimeZone.UTC);
    private static final Joiner COMMA_JOINER = Joiner.on((String)",");
    private final ImmutableMap<String, String> params;

    public SearchRequest(UrlHitter hitter) {
        super(hitter);
        this.params = ImmutableMap.of();
    }

    public SearchRequest(UrlHitter hitter, ImmutableMap<String, String> params) {
        super(hitter);
        this.params = params;
    }

    public SearchRequest withIds(Iterable<String> ids) {
        return this.newSearchRequestWith("ids", COMMA_JOINER.join(ids));
    }

    public SearchRequest withIds(String ... ids) {
        return this.newSearchRequestWith("ids", COMMA_JOINER.join((Object[])ids));
    }

    public SearchRequest withTags(String ... tags) {
        return this.newSearchRequestWith("tag", COMMA_JOINER.join((Object[])tags));
    }

    public SearchRequest to(ReadableInstant end) {
        return this.newSearchRequestWith("to-date", DATE_FORMAT.print(end));
    }

    public SearchRequest from(ReadableInstant start) {
        return this.newSearchRequestWith("from-date", DATE_FORMAT.print(start));
    }

    @Override
    public SearchRequest showFields(String ... fields) {
        return this.newSearchRequestWith("show-fields", COMMA_JOINER.join((Object[])fields));
    }

    @Override
    public SearchRequest showTags(String ... tagTypes) {
        return this.newSearchRequestWith("show-tags", COMMA_JOINER.join((Object[])tagTypes));
    }

    public SearchRequest during(ReadableInterval searchInterval) {
        return this.from((ReadableInstant)searchInterval.getStart()).to((ReadableInstant)searchInterval.getEnd());
    }

    public SearchRequest pageSize(int itemsPerPage) {
        return this.newSearchRequestWith("page-size", "" + itemsPerPage);
    }

    public SearchRequest page(int page) {
        return this.newSearchRequestWith("page", "" + page);
    }

    public SearchRequest orderBy(String order) {
        return this.newSearchRequestWith("order-by", order);
    }

    private SearchRequest newSearchRequestWith(String key, String val) {
        LinkedHashMap newParams = Maps.newLinkedHashMap(this.params);
        newParams.put(key, val);
        return new SearchRequest(this.hitter, (ImmutableMap<String, String>)ImmutableMap.copyOf((Map)newParams));
    }

    @Override
    public JAXBContext getJaxbContextForResponse() {
        return SearchResponse.JAXB_CONTEXT;
    }

    @Override
    protected Map<String, String> getParams() {
        return this.params;
    }

    @Override
    protected String getPathPrefix() {
        return "search";
    }

    public List<String> getIds() {
        return Arrays.asList(((String)this.params.get((Object)"ids")).split(","));
    }
}

