/*
 * Decompiled with CFR 0.152.
 */
package com.madgag.guardian.contentapi.jaxb;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.madgag.guardian.contentapi.jaxb.BooBoo;
import com.madgag.guardian.contentapi.jaxb.Field;
import com.madgag.guardian.contentapi.jaxb.HasId;
import com.madgag.guardian.contentapi.jaxb.StringUriAdapter;
import com.madgag.guardian.contentapi.jaxb.Tag;
import java.io.Serializable;
import java.net.URI;
import java.util.List;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.joda.time.DateTime;

@XmlRootElement
public class Content
implements HasId,
Serializable {
    private static final long serialVersionUID = 1L;
    @XmlAttribute(name="web-title")
    public String webTitle;
    @XmlAttribute
    public String id;
    @XmlAttribute(name="api-url")
    public String apiUrl;
    @XmlJavaTypeAdapter(value=StringUriAdapter.class)
    @XmlAttribute(name="web-url")
    public URI webUrl;
    @XmlElementWrapper(name="tags")
    @XmlElement(name="tag")
    public List<Tag> tags = Lists.newArrayList();
    @XmlElementWrapper(name="fields")
    @XmlElement(name="field")
    public List<Field> fields = Lists.newArrayList();
    @XmlJavaTypeAdapter(value=BooBoo.class)
    @XmlAttribute(name="web-publication-date", required=true)
    public DateTime webPublicationDate;

    @Override
    public String getId() {
        return this.id;
    }

    public String getField(String fieldName) {
        for (Field field : this.fields) {
            if (!fieldName.equals(field.name)) continue;
            return field.value;
        }
        return null;
    }

    public boolean hasField(String fieldName) {
        return this.getField(fieldName) != null;
    }

    public Multimap<String, Tag> getTagsCategorisedByType() {
        return Multimaps.index(this.tags, (Function)new Function<Tag, String>(){

            public String apply(Tag from) {
                return from.type;
            }
        });
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.id + "]";
    }
}

