/*
 * Decompiled with CFR 0.152.
 */
package com.madgag.hamcrest;

import java.io.File;
import org.hamcrest.Description;
import org.hamcrest.Factory;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;

public class FileExistenceMatcher
extends TypeSafeMatcher<File> {
    private final boolean exists;

    private FileExistenceMatcher(boolean exists) {
        this.exists = exists;
    }

    public boolean matchesSafely(File file) {
        return file.exists() == this.exists;
    }

    public void describeTo(Description description) {
        description.appendText("file which ").appendText(this.exists ? "exists" : "does not exist");
    }

    @Factory
    public static <T> Matcher<File> exists() {
        return new FileExistenceMatcher(true);
    }

    @Factory
    public static <T> Matcher<File> doesNotExist() {
        return new FileExistenceMatcher(false);
    }
}

