/*
 * Decompiled with CFR 0.152.
 */
package com.madgag.hamcrest;

import java.io.File;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Description;
import org.hamcrest.Factory;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;

public class FileLengthMatcher
extends TypeSafeMatcher<File> {
    private final Matcher<Long> lengthMatcher;

    private FileLengthMatcher(Matcher<Long> lengthMatcher) {
        this.lengthMatcher = lengthMatcher;
    }

    public boolean matchesSafely(File file) {
        return this.lengthMatcher.matches((Object)file.length());
    }

    public void describeTo(Description description) {
        description.appendText("file of length ").appendDescriptionOf(this.lengthMatcher);
    }

    @Factory
    public static <T> Matcher<File> ofLength(long length) {
        return new FileLengthMatcher((Matcher<Long>)CoreMatchers.equalTo((Object)length));
    }
}

