/*
 * Decompiled with CFR 0.152.
 */
package com.madgag.hamcrest;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;

public class IsMap<K, V>
extends TypeSafeMatcher<Map<K, V>> {
    private Map<Matcher<K>, Matcher<V>> keyValueConstraints;
    private final boolean shouldHaveOnlyTheseEntries;

    private IsMap(boolean shouldHaveOnlyTheseEntries) {
        this.shouldHaveOnlyTheseEntries = shouldHaveOnlyTheseEntries;
        this.keyValueConstraints = new HashMap<Matcher<K>, Matcher<V>>();
    }

    public static <K, V> IsMap<K, V> containing(Matcher<K> keyConstraint, Matcher<V> valueConstraint) {
        return new IsMap<Matcher<K>, Matcher<V>>(false).and(keyConstraint, valueConstraint);
    }

    public static <K, V> IsMap<K, V> containing(K key, V value) {
        return new IsMap<K, V>(false).and(key, value);
    }

    public static <K, V> IsMap<K, V> containingOnly(K key, Matcher<V> valueConstraint) {
        return new IsMap<K, Matcher<V>>(true).and(key, valueConstraint);
    }

    public static <K, V> IsMap<K, V> containingOnly(Matcher<K> keyConstraint, Matcher<V> valueConstraint) {
        return new IsMap<Matcher<K>, Matcher<V>>(true).and(keyConstraint, valueConstraint);
    }

    public static <K, V> IsMap<K, V> containingOnly(K key, V value) {
        return new IsMap<K, V>(true).and(key, value);
    }

    public IsMap<K, V> and(Matcher<K> keyConstraint, Matcher<V> valueConstraint) {
        this.keyValueConstraints.put(keyConstraint, valueConstraint);
        return this;
    }

    public IsMap<K, V> and(K key, Matcher<V> valueConstraint) {
        return this.and((K)CoreMatchers.equalTo(key), (V)valueConstraint);
    }

    public IsMap<K, V> and(K key, V value) {
        return this.and(key, (V)CoreMatchers.equalTo(value));
    }

    public boolean matchesSafely(Map<K, V> map) {
        HashSet<Map.Entry<Matcher<K>, Matcher<V>>> keyValueConstraintsNotYetSatisfied = new HashSet<Map.Entry<Matcher<K>, Matcher<V>>>(this.keyValueConstraints.entrySet());
        for (Map.Entry<K, V> mapEntry : map.entrySet()) {
            boolean matchedEntry = false;
            for (Map.Entry entry : keyValueConstraintsNotYetSatisfied) {
                Matcher keyConstraint = (Matcher)entry.getKey();
                if (!keyConstraint.matches(mapEntry.getKey())) continue;
                Matcher valueConstraint = (Matcher)entry.getValue();
                if (valueConstraint.matches(mapEntry.getValue())) {
                    matchedEntry = true;
                    keyValueConstraintsNotYetSatisfied.remove(entry);
                    break;
                }
                return false;
            }
            if (matchedEntry || !this.shouldHaveOnlyTheseEntries) continue;
            return false;
        }
        return keyValueConstraintsNotYetSatisfied.isEmpty();
    }

    public void describeTo(Description description) {
        description.appendText("map containing");
        if (this.shouldHaveOnlyTheseEntries) {
            description.appendText(" only");
        }
        description.appendText(" [");
        boolean firstEntry = true;
        for (Map.Entry<Matcher<K>, Matcher<V>> entry : this.keyValueConstraints.entrySet()) {
            if (firstEntry) {
                firstEntry = false;
            } else {
                description.appendText(", ");
            }
            entry.getKey().describeTo(description);
            description.appendText("->");
            entry.getValue().describeTo(description);
        }
        description.appendText("]");
    }
}

