/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.api;

import org.eclipse.jgit.api.MergeResult;
import org.eclipse.jgit.transport.FetchResult;

public class PullResult {
    private final FetchResult fetchResult;
    private final MergeResult mergeResult;
    private final String fetchedFrom;

    PullResult(FetchResult fetchResult, String fetchedFrom, MergeResult mergeResult) {
        this.fetchResult = fetchResult;
        this.fetchedFrom = fetchedFrom;
        this.mergeResult = mergeResult;
    }

    public FetchResult getFetchResult() {
        return this.fetchResult;
    }

    public MergeResult getMergeResult() {
        return this.mergeResult;
    }

    public String getFetchedFrom() {
        return this.fetchedFrom;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.fetchResult != null) {
            sb.append(this.fetchResult.toString());
        } else {
            sb.append("No fetch result");
        }
        sb.append("\n");
        if (this.mergeResult != null) {
            sb.append(this.mergeResult.toString());
        } else {
            sb.append("No merge result");
        }
        return sb.toString();
    }
}

