/*
 * Decompiled with CFR 0.152.
 */
package org.spongycastle.cms;

import java.util.ArrayList;
import java.util.List;
import org.spongycastle.asn1.cms.OriginatorInfo;
import org.spongycastle.cert.X509CertificateHolder;
import org.spongycastle.cms.CMSException;
import org.spongycastle.cms.CMSUtils;
import org.spongycastle.cms.OriginatorInformation;
import org.spongycastle.util.Store;

public class OriginatorInfoGenerator {
    private final List origCerts;
    private final List origCRLs;

    public OriginatorInfoGenerator(X509CertificateHolder origCert) {
        this.origCerts = new ArrayList(1);
        this.origCRLs = null;
        this.origCerts.add(origCert.toASN1Structure());
    }

    public OriginatorInfoGenerator(Store origCerts) throws CMSException {
        this(origCerts, null);
    }

    public OriginatorInfoGenerator(Store origCerts, Store origCRLs) throws CMSException {
        this.origCerts = CMSUtils.getCertificatesFromStore(origCerts);
        this.origCRLs = origCRLs != null ? CMSUtils.getCRLsFromStore(origCRLs) : null;
    }

    public OriginatorInformation generate() {
        if (this.origCRLs != null) {
            return new OriginatorInformation(new OriginatorInfo(CMSUtils.createDerSetFromList(this.origCerts), CMSUtils.createDerSetFromList(this.origCRLs)));
        }
        return new OriginatorInformation(new OriginatorInfo(CMSUtils.createDerSetFromList(this.origCerts), null));
    }
}

