/*
 * Decompiled with CFR 0.152.
 */
package org.spongycastle.jsse.provider;

import java.security.GeneralSecurityException;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.Security;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.spongycastle.jsse.provider.EngineCreator;
import org.spongycastle.jsse.provider.ProvKeyManagerFactorySpi;
import org.spongycastle.jsse.provider.ProvSSLContextSpi;
import org.spongycastle.jsse.provider.ProvTrustManagerFactorySpi;
import org.spongycastle.tls.crypto.impl.jcajce.JcaTlsCryptoProvider;
import org.spongycastle.util.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BouncyCastleJsseProvider
extends Provider {
    public static final String PROVIDER_NAME = "SCJSSE";
    private static final double PROVIDER_VERSION = 1.0;
    private static final String PROVIDER_INFO = "Bouncy Castle JSSE Provider Version 1.0.0";
    private Map<String, BcJsseService> serviceMap = new HashMap<String, BcJsseService>();
    private Map<String, EngineCreator> creatorMap = new HashMap<String, EngineCreator>();
    private final boolean isInFipsMode;
    private static final Map<Map<String, String>, Map<String, String>> attributeMaps = new HashMap<Map<String, String>, Map<String, String>>();

    public BouncyCastleJsseProvider() {
        super(PROVIDER_NAME, 1.0, PROVIDER_INFO);
        this.isInFipsMode = this.configure(false, new JcaTlsCryptoProvider());
    }

    public BouncyCastleJsseProvider(Provider provider) {
        this(false, provider);
    }

    public BouncyCastleJsseProvider(boolean fipsMode, Provider provider) {
        super(PROVIDER_NAME, 1.0, PROVIDER_INFO);
        this.isInFipsMode = this.configure(fipsMode, new JcaTlsCryptoProvider().setProvider(provider));
    }

    public BouncyCastleJsseProvider(String config) {
        super(PROVIDER_NAME, 1.0, PROVIDER_INFO);
        JcaTlsCryptoProvider cryptoProvider;
        config = config.trim();
        boolean fipsMode = false;
        String cryptoName = config;
        int colonPos = config.indexOf(58);
        if (colonPos >= 0) {
            String first = config.substring(0, colonPos).trim();
            String second = config.substring(colonPos + 1).trim();
            fipsMode = first.equalsIgnoreCase("fips");
            cryptoName = second;
        }
        try {
            cryptoProvider = this.createCryptoProvider(cryptoName);
        }
        catch (GeneralSecurityException e) {
            throw new IllegalArgumentException("unable to set up TlsCrypto: " + e.getMessage(), e);
        }
        this.isInFipsMode = this.configure(fipsMode, cryptoProvider);
    }

    public BouncyCastleJsseProvider(boolean fipsMode, JcaTlsCryptoProvider tlsCryptoProvider) {
        super(PROVIDER_NAME, 1.0, PROVIDER_INFO);
        this.isInFipsMode = this.configure(fipsMode, tlsCryptoProvider);
    }

    private JcaTlsCryptoProvider createCryptoProvider(String cryptoName) throws GeneralSecurityException {
        if (cryptoName.equalsIgnoreCase("default")) {
            return new JcaTlsCryptoProvider();
        }
        Provider provider = Security.getProvider(cryptoName);
        if (provider != null) {
            return new JcaTlsCryptoProvider().setProvider(provider);
        }
        try {
            Class<?> cryptoProviderClass = Class.forName(cryptoName);
            Object cryptoProviderInstance = cryptoProviderClass.newInstance();
            if (cryptoProviderInstance instanceof JcaTlsCryptoProvider) {
                return (JcaTlsCryptoProvider)cryptoProviderInstance;
            }
            if (cryptoProviderInstance instanceof Provider) {
                return new JcaTlsCryptoProvider().setProvider((Provider)cryptoProviderInstance);
            }
            throw new IllegalArgumentException("unrecognized class: " + cryptoName);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("unable to find Provider/TlsCrypto class: " + cryptoName);
        }
        catch (InstantiationException e) {
            throw new IllegalArgumentException("unable to create Provider/TlsCrypto class '" + cryptoName + "': " + e.getMessage(), e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException("unable to create Provider/TlsCrypto class '" + cryptoName + "': " + e.getMessage(), e);
        }
    }

    private boolean configure(final boolean fipsMode, final JcaTlsCryptoProvider baseCryptoProvider) {
        this.addAlgorithmImplementation("KeyManagerFactory.X.509", "org.spongycastle.jsse.provider.KeyManagerFactory", new EngineCreator(){

            public Object createInstance(Object constructorParameter) {
                return new ProvKeyManagerFactorySpi();
            }
        });
        this.addAlias("Alg.Alias.KeyManagerFactory.X509", "X.509");
        this.addAlias("Alg.Alias.KeyManagerFactory.PKIX", "X.509");
        this.addAlgorithmImplementation("TrustManagerFactory.PKIX", "org.spongycastle.jsse.provider.TrustManagerFactory", new EngineCreator(){

            public Object createInstance(Object constructorParameter) {
                return new ProvTrustManagerFactorySpi(baseCryptoProvider.getPkixProvider());
            }
        });
        this.addAlias("Alg.Alias.TrustManagerFactory.X.509", "PKIX");
        this.addAlias("Alg.Alias.TrustManagerFactory.X509", "PKIX");
        this.addAlgorithmImplementation("SSLContext.TLS", "org.spongycastle.jsse.provider.SSLContext.TLS", new EngineCreator(){

            public Object createInstance(Object constructorParameter) {
                return new ProvSSLContextSpi(fipsMode, baseCryptoProvider, new String[]{"TLSv1.2"});
            }
        });
        this.addAlgorithmImplementation("SSLContext.TLSV1", "org.spongycastle.jsse.provider.SSLContext.TLSv1", new EngineCreator(){

            public Object createInstance(Object constructorParameter) {
                return new ProvSSLContextSpi(fipsMode, baseCryptoProvider, new String[]{"TLSv1", "TLSv1.1", "TLSv1.2"});
            }
        });
        this.addAlgorithmImplementation("SSLContext.TLSV1.1", "org.spongycastle.jsse.provider.SSLContext.TLSv1_1", new EngineCreator(){

            public Object createInstance(Object constructorParameter) {
                return new ProvSSLContextSpi(fipsMode, baseCryptoProvider, new String[]{"TLSv1.1", "TLSv1.2"});
            }
        });
        this.addAlgorithmImplementation("SSLContext.TLSV1.2", "org.spongycastle.jsse.provider.SSLContext.TLSv1_2", new EngineCreator(){

            public Object createInstance(Object constructorParameter) {
                return new ProvSSLContextSpi(fipsMode, baseCryptoProvider, new String[]{"TLSv1.2"});
            }
        });
        this.addAlgorithmImplementation("SSLContext.DEFAULT", "org.spongycastle.jsse.provider.SSLContext.Default", new EngineCreator(){

            public Object createInstance(Object constructorParameter) {
                try {
                    ProvSSLContextSpi defaultSSLContextSpi = new ProvSSLContextSpi(fipsMode, baseCryptoProvider, new String[]{"TLSv1.2"});
                    defaultSSLContextSpi.engineInit(null, null, null);
                    return defaultSSLContextSpi;
                }
                catch (GeneralSecurityException e) {
                    return null;
                }
            }
        });
        return fipsMode;
    }

    void addAttribute(String key, String attributeName, String attributeValue) {
        String attributeKey = key + " " + attributeName;
        if (this.containsKey(attributeKey)) {
            throw new IllegalStateException("duplicate provider attribute key (" + attributeKey + ") found");
        }
        this.put(attributeKey, attributeValue);
    }

    void addAlgorithmImplementation(String key, String className, EngineCreator creator) {
        if (this.containsKey(key)) {
            throw new IllegalStateException("duplicate provider key (" + key + ") found");
        }
        this.addAttribute(key, "ImplementedIn", "Software");
        this.put(key, className);
        this.creatorMap.put(className, creator);
    }

    void addAlias(String key, String value) {
        if (this.containsKey(key)) {
            throw new IllegalStateException("duplicate provider key (" + key + ") found");
        }
        this.put(key, value);
    }

    @Override
    public final synchronized Provider.Service getService(String type, String algorithm) {
        String upperCaseAlgName = Strings.toUpperCase((String)algorithm);
        BcJsseService service = this.serviceMap.get(type + "." + upperCaseAlgName);
        if (service == null) {
            String className;
            String aliasString = "Alg.Alias." + type + ".";
            String realName = (String)this.get(aliasString + upperCaseAlgName);
            if (realName == null) {
                realName = upperCaseAlgName;
            }
            if ((className = (String)this.get(type + "." + realName)) == null) {
                return null;
            }
            String attributeKeyStart = type + "." + upperCaseAlgName + " ";
            ArrayList<String> aliases = new ArrayList<String>();
            HashMap<String, String> attributes = new HashMap<String, String>();
            for (Object key : this.keySet()) {
                String sKey = (String)key;
                if (sKey.startsWith(aliasString) && this.get(key).equals(algorithm)) {
                    aliases.add(sKey.substring(aliasString.length()));
                }
                if (!sKey.startsWith(attributeKeyStart)) continue;
                attributes.put(sKey.substring(attributeKeyStart.length()), (String)this.get(sKey));
            }
            service = new BcJsseService(this, type, upperCaseAlgName, className, aliases, BouncyCastleJsseProvider.getAttributeMap(attributes), this.creatorMap.get(className));
            this.serviceMap.put(type + "." + upperCaseAlgName, service);
        }
        return service;
    }

    @Override
    public final synchronized Set<Provider.Service> getServices() {
        Set<Provider.Service> serviceSet = super.getServices();
        HashSet<Provider.Service> bcServiceSet = new HashSet<Provider.Service>();
        for (Provider.Service service : serviceSet) {
            bcServiceSet.add(this.getService(service.getType(), service.getAlgorithm()));
        }
        return bcServiceSet;
    }

    private static Map<String, String> getAttributeMap(Map<String, String> attributeMap) {
        Map<String, String> attrMap = attributeMaps.get(attributeMap);
        if (attrMap != null) {
            return attrMap;
        }
        attributeMaps.put(attributeMap, attributeMap);
        return attributeMap;
    }

    public boolean isFipsMode() {
        return this.isInFipsMode;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class BcJsseService
    extends Provider.Service {
        private final EngineCreator creator;

        public BcJsseService(Provider provider, String type, String algorithm, String className, List<String> aliases, Map<String, String> attributes, EngineCreator creator) {
            super(provider, type, algorithm, className, aliases, attributes);
            this.creator = creator;
        }

        @Override
        public Object newInstance(Object constructorParameter) throws NoSuchAlgorithmException {
            try {
                Object instance = this.creator.createInstance(constructorParameter);
                if (instance == null) {
                    throw new NoSuchAlgorithmException("No such algorithm in FIPS approved mode: " + this.getAlgorithm());
                }
                return instance;
            }
            catch (NoSuchAlgorithmException e) {
                throw e;
            }
            catch (Exception e) {
                throw new NoSuchAlgorithmException("Unable to invoke creator for " + this.getAlgorithm() + ": " + e.getMessage(), e);
            }
        }
    }
}

