/*
 * Decompiled with CFR 0.152.
 */
package org.spongycastle.jsse.provider;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.nio.channels.ServerSocketChannel;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLSocket;
import org.spongycastle.jsse.provider.ContextData;
import org.spongycastle.jsse.provider.ProvSSLContextSpi;
import org.spongycastle.jsse.provider.ProvSSLParameters;
import org.spongycastle.jsse.provider.ProvSSLSocketDirect;
import org.spongycastle.jsse.provider.SSLParametersUtil;

class ProvSSLServerSocket
extends SSLServerSocket {
    protected final ProvSSLContextSpi context;
    protected final ContextData contextData;
    protected ProvSSLParameters sslParameters;
    protected boolean enableSessionCreation = false;
    protected boolean useClientMode = false;

    protected ProvSSLServerSocket(ProvSSLContextSpi context, ContextData contextData) throws IOException {
        this.context = context;
        this.contextData = contextData;
        this.sslParameters = ProvSSLParameters.extractDefaultParameters(context);
    }

    protected ProvSSLServerSocket(ProvSSLContextSpi context, ContextData contextData, int port) throws IOException {
        super(port);
        this.context = context;
        this.contextData = contextData;
        this.sslParameters = ProvSSLParameters.extractDefaultParameters(context);
    }

    protected ProvSSLServerSocket(ProvSSLContextSpi context, ContextData contextData, int port, int backlog) throws IOException {
        super(port, backlog);
        this.context = context;
        this.contextData = contextData;
        this.sslParameters = ProvSSLParameters.extractDefaultParameters(context);
    }

    protected ProvSSLServerSocket(ProvSSLContextSpi context, ContextData contextData, int port, int backlog, InetAddress address) throws IOException {
        super(port, backlog, address);
        this.context = context;
        this.contextData = contextData;
        this.sslParameters = ProvSSLParameters.extractDefaultParameters(context);
    }

    public synchronized Socket accept() throws IOException {
        ProvSSLSocketDirect socket = new ProvSSLSocketDirect(this.context, this.contextData);
        this.implAccept(socket);
        if (ProvSSLParameters.hasSslParameters) {
            ((SSLSocket)socket).setSSLParameters(SSLParametersUtil.toSSLParameters(this.sslParameters));
        } else {
            String[] protocols;
            String[] cipherSuites = this.sslParameters.getCipherSuites();
            if (cipherSuites != null) {
                ((SSLSocket)socket).setEnabledCipherSuites(cipherSuites);
            }
            if ((protocols = this.sslParameters.getProtocols()) != null) {
                ((SSLSocket)socket).setEnabledProtocols(protocols);
            }
            if (this.sslParameters.getNeedClientAuth()) {
                ((SSLSocket)socket).setNeedClientAuth(true);
            } else if (this.sslParameters.getWantClientAuth()) {
                ((SSLSocket)socket).setWantClientAuth(true);
            } else {
                ((SSLSocket)socket).setWantClientAuth(false);
            }
        }
        ((SSLSocket)socket).setEnableSessionCreation(this.enableSessionCreation);
        ((SSLSocket)socket).setUseClientMode(this.useClientMode);
        return socket;
    }

    public ServerSocketChannel getChannel() {
        throw new UnsupportedOperationException();
    }

    public synchronized boolean getEnableSessionCreation() {
        return this.enableSessionCreation;
    }

    public synchronized String[] getEnabledCipherSuites() {
        return this.sslParameters.getCipherSuites();
    }

    public synchronized String[] getEnabledProtocols() {
        return this.sslParameters.getProtocols();
    }

    public synchronized boolean getNeedClientAuth() {
        return this.sslParameters.getNeedClientAuth();
    }

    public synchronized SSLParameters getSSLParameters() {
        return SSLParametersUtil.toSSLParameters(this.sslParameters);
    }

    public synchronized String[] getSupportedCipherSuites() {
        return this.context.getSupportedCipherSuites();
    }

    public synchronized String[] getSupportedProtocols() {
        return this.context.getSupportedProtocols();
    }

    public synchronized boolean getUseClientMode() {
        return this.useClientMode;
    }

    public synchronized boolean getWantClientAuth() {
        return this.sslParameters.getWantClientAuth();
    }

    public synchronized void setEnableSessionCreation(boolean flag) {
        this.enableSessionCreation = flag;
    }

    public synchronized void setEnabledCipherSuites(String[] suites) {
        if (!this.context.isSupportedCipherSuites(suites)) {
            throw new IllegalArgumentException("'suites' cannot be null, or contain unsupported cipher suites");
        }
        this.sslParameters.setCipherSuites(suites);
    }

    public synchronized void setEnabledProtocols(String[] protocols) {
        if (!this.context.isSupportedProtocols(protocols)) {
            throw new IllegalArgumentException("'protocols' cannot be null, or contain unsupported protocols");
        }
        this.sslParameters.setProtocols(protocols);
    }

    public synchronized void setNeedClientAuth(boolean need) {
        this.sslParameters.setNeedClientAuth(need);
    }

    public synchronized void setSSLParameters(SSLParameters sslParameters) {
        this.sslParameters = SSLParametersUtil.toProvSSLParameters(sslParameters);
    }

    public synchronized void setUseClientMode(boolean mode) {
        this.useClientMode = mode;
    }

    public synchronized void setWantClientAuth(boolean want) {
        this.sslParameters.setWantClientAuth(want);
    }
}

