/*
 * Decompiled with CFR 0.152.
 */
package org.spongycastle.jsse.provider;

import java.security.Principal;
import java.security.cert.Certificate;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSessionBindingEvent;
import javax.net.ssl.SSLSessionBindingListener;
import javax.net.ssl.SSLSessionContext;
import javax.security.auth.x500.X500Principal;
import javax.security.cert.X509Certificate;
import org.spongycastle.jsse.provider.JsseUtils;
import org.spongycastle.jsse.provider.ProvSSLSessionContext;
import org.spongycastle.jsse.provider.SessionBindingListenerAdapter;
import org.spongycastle.tls.SessionParameters;
import org.spongycastle.tls.TlsSession;
import org.spongycastle.util.Arrays;

class ProvSSLSession
implements SSLSession {
    protected static final ProvSSLSession NULL_SESSION = new ProvSSLSession(null, null);
    protected final Map<String, Object> valueMap = Collections.synchronizedMap(new HashMap());
    protected final ProvSSLSessionContext sslSessionContext;
    protected final TlsSession tlsSession;
    protected final SessionParameters sessionParameters;

    ProvSSLSession(ProvSSLSessionContext sslSessionContext, TlsSession tlsSession) {
        this.sslSessionContext = sslSessionContext;
        this.tlsSession = tlsSession;
        this.sessionParameters = tlsSession == null ? null : tlsSession.exportSessionParameters();
    }

    public int getApplicationBufferSize() {
        return 16384;
    }

    public String getCipherSuite() {
        return this.sessionParameters == null ? null : this.sslSessionContext.getSSLContext().getCipherSuiteString(this.sessionParameters.getCipherSuite());
    }

    public long getCreationTime() {
        throw new UnsupportedOperationException();
    }

    public byte[] getId() {
        return this.tlsSession == null ? null : Arrays.clone((byte[])this.tlsSession.getSessionID());
    }

    public long getLastAccessedTime() {
        throw new UnsupportedOperationException();
    }

    public Certificate[] getLocalCertificates() {
        Certificate[] chain;
        if (this.sessionParameters != null && (chain = JsseUtils.getX509CertificateChain(this.sslSessionContext.getCrypto(), this.sessionParameters.getLocalCertificate())) != null && chain.length > 0) {
            return chain;
        }
        return null;
    }

    public Principal getLocalPrincipal() {
        return this.sessionParameters == null ? null : JsseUtils.getSubject(this.sslSessionContext.getCrypto(), this.sessionParameters.getLocalCertificate());
    }

    public int getPacketBufferSize() {
        return 18437;
    }

    public X509Certificate[] getPeerCertificateChain() throws SSLPeerUnverifiedException {
        throw new UnsupportedOperationException();
    }

    public Certificate[] getPeerCertificates() throws SSLPeerUnverifiedException {
        Certificate[] chain;
        if (this.sessionParameters != null && (chain = JsseUtils.getX509CertificateChain(this.sslSessionContext.getCrypto(), this.sessionParameters.getPeerCertificate())) != null && chain.length > 0) {
            return chain;
        }
        throw new SSLPeerUnverifiedException("No peer identity established");
    }

    public String getPeerHost() {
        return null;
    }

    public int getPeerPort() {
        return -1;
    }

    public Principal getPeerPrincipal() throws SSLPeerUnverifiedException {
        X500Principal principal;
        if (this.sessionParameters != null && (principal = JsseUtils.getSubject(this.sslSessionContext.getCrypto(), this.sessionParameters.getPeerCertificate())) != null) {
            return principal;
        }
        throw new SSLPeerUnverifiedException("No peer identity established");
    }

    public String getProtocol() {
        return this.sessionParameters == null ? null : this.sslSessionContext.getSSLContext().getProtocolString(this.sessionParameters.getNegotiatedVersion());
    }

    public SSLSessionContext getSessionContext() {
        return this.sslSessionContext;
    }

    public Object getValue(String name) {
        return this.valueMap.get(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getValueNames() {
        Map<String, Object> map = this.valueMap;
        synchronized (map) {
            return this.valueMap.keySet().toArray(new String[this.valueMap.size()]);
        }
    }

    public void invalidate() {
        if (this.tlsSession != null) {
            this.tlsSession.invalidate();
        }
    }

    public boolean isValid() {
        return this.tlsSession != null && this.tlsSession.isResumable();
    }

    public void putValue(String name, Object value) {
        this.notifyUnbound(name, this.valueMap.put(name, value));
        this.notifyBound(name, value);
    }

    public void removeValue(String name) {
        this.notifyUnbound(name, this.valueMap.remove(name));
    }

    protected void notifyBound(String name, Object value) {
        if (value instanceof SSLSessionBindingListener) {
            new SessionBindingListenerAdapter((SSLSessionBindingListener)value).valueBound(new SSLSessionBindingEvent(this, name));
        }
    }

    protected void notifyUnbound(String name, Object value) {
        if (value instanceof SSLSessionBindingListener) {
            new SessionBindingListenerAdapter((SSLSessionBindingListener)value).valueUnbound(new SSLSessionBindingEvent(this, name));
        }
    }
}

