/*
 * Decompiled with CFR 0.152.
 */
package org.spongycastle.jsse.provider;

import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import javax.net.ssl.SSLSocketFactory;
import org.spongycastle.jsse.provider.ProvSSLContextSpi;
import org.spongycastle.jsse.provider.ProvSSLSocketDirect;
import org.spongycastle.jsse.provider.ProvSSLSocketWrap;

class ProvSSLSocketFactory
extends SSLSocketFactory {
    protected final ProvSSLContextSpi context;

    ProvSSLSocketFactory(ProvSSLContextSpi context) {
        this.context = context;
    }

    public Socket createSocket() throws IOException {
        return new ProvSSLSocketDirect(this.context, this.context.createContextData());
    }

    public Socket createSocket(InetAddress host, int port) throws IOException {
        return new ProvSSLSocketDirect(this.context, this.context.createContextData(), host, port);
    }

    public Socket createSocket(InetAddress address, int port, InetAddress localAddress, int localPort) throws IOException {
        return new ProvSSLSocketDirect(this.context, this.context.createContextData(), address, port, localAddress, localPort);
    }

    public Socket createSocket(String host, int port) throws IOException, UnknownHostException {
        return new ProvSSLSocketDirect(this.context, this.context.createContextData(), host, port);
    }

    public Socket createSocket(String host, int port, InetAddress localHost, int localPort) throws IOException, UnknownHostException {
        return new ProvSSLSocketDirect(this.context, this.context.createContextData(), host, port, localHost, localPort);
    }

    public Socket createSocket(Socket s, InputStream consumed, boolean autoClose) throws IOException {
        throw new UnsupportedOperationException();
    }

    public Socket createSocket(Socket s, String host, int port, boolean autoClose) throws IOException {
        return new ProvSSLSocketWrap(this.context, this.context.createContextData(), s, host, port, autoClose);
    }

    public String[] getDefaultCipherSuites() {
        return this.context.getDefaultCipherSuites();
    }

    public String[] getSupportedCipherSuites() {
        return this.context.getSupportedCipherSuites();
    }
}

