/*
 * Decompiled with CFR 0.152.
 */
package org.spongycastle.jsse.provider;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.nio.channels.SocketChannel;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLSession;
import javax.net.ssl.X509TrustManager;
import org.spongycastle.jsse.BCSSLConnection;
import org.spongycastle.jsse.provider.ContextData;
import org.spongycastle.jsse.provider.ProvSSLConnection;
import org.spongycastle.jsse.provider.ProvSSLContextSpi;
import org.spongycastle.jsse.provider.ProvSSLParameters;
import org.spongycastle.jsse.provider.ProvSSLSession;
import org.spongycastle.jsse.provider.ProvSSLSocketBase;
import org.spongycastle.jsse.provider.ProvTlsClient;
import org.spongycastle.jsse.provider.ProvTlsManager;
import org.spongycastle.jsse.provider.ProvTlsPeer;
import org.spongycastle.jsse.provider.ProvTlsServer;
import org.spongycastle.jsse.provider.SSLParametersUtil;
import org.spongycastle.tls.TlsClientProtocol;
import org.spongycastle.tls.TlsProtocol;
import org.spongycastle.tls.TlsServerProtocol;

class ProvSSLSocketWrap
extends ProvSSLSocketBase
implements ProvTlsManager {
    protected final AppDataInput appDataIn = new AppDataInput();
    protected final AppDataOutput appDataOut = new AppDataOutput();
    protected final ProvSSLContextSpi context;
    protected final ContextData contextData;
    protected final Socket wrapSocket;
    protected final String wrapHost;
    protected final int wrapPort;
    protected final boolean wrapAutoClose;
    protected ProvSSLParameters sslParameters;
    protected boolean enableSessionCreation = false;
    protected boolean useClientMode = true;
    protected boolean initialHandshakeBegun = false;
    protected TlsProtocol protocol = null;
    protected ProvTlsPeer protocolPeer = null;
    protected BCSSLConnection connection = null;
    protected SSLSession handshakeSession = null;

    protected ProvSSLSocketWrap(ProvSSLContextSpi context, ContextData contextData, Socket s, String host, int port, boolean autoClose) {
        this.context = context;
        this.contextData = contextData;
        this.wrapSocket = s;
        this.wrapHost = host;
        this.wrapPort = port;
        this.wrapAutoClose = autoClose;
        this.sslParameters = ProvSSLParameters.extractDefaultParameters(context);
    }

    public ProvSSLContextSpi getContext() {
        return this.context;
    }

    public ContextData getContextData() {
        return this.contextData;
    }

    public void bind(SocketAddress bindpoint) throws IOException {
        throw new SocketException("Wrapped socket should already be bound");
    }

    public synchronized void close() throws IOException {
        if (this.protocol != null) {
            this.protocol.close();
        }
        if (this.wrapAutoClose) {
            this.wrapSocket.close();
        }
    }

    public void connect(SocketAddress endpoint, int timeout) throws IOException {
        throw new SocketException("Wrapped socket should already be connected");
    }

    public SocketChannel getChannel() {
        return this.wrapSocket.getChannel();
    }

    public synchronized BCSSLConnection getConnection() {
        try {
            this.handshakeIfNecessary();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.connection;
    }

    public synchronized String[] getEnabledCipherSuites() {
        return this.sslParameters.getCipherSuites();
    }

    public synchronized String[] getEnabledProtocols() {
        return this.sslParameters.getProtocols();
    }

    public synchronized boolean getEnableSessionCreation() {
        return this.enableSessionCreation;
    }

    public synchronized SSLSession getHandshakeSession() {
        return this.handshakeSession;
    }

    public InetAddress getInetAddress() {
        return this.wrapSocket.getInetAddress();
    }

    public InputStream getInputStream() throws IOException {
        return this.appDataIn;
    }

    public boolean getKeepAlive() throws SocketException {
        return this.wrapSocket.getKeepAlive();
    }

    public InetAddress getLocalAddress() {
        return this.wrapSocket.getLocalAddress();
    }

    public int getLocalPort() {
        return this.wrapSocket.getLocalPort();
    }

    public SocketAddress getLocalSocketAddress() {
        return this.wrapSocket.getLocalSocketAddress();
    }

    public synchronized boolean getNeedClientAuth() {
        return this.sslParameters.getNeedClientAuth();
    }

    public OutputStream getOutputStream() throws IOException {
        return this.appDataOut;
    }

    public int getPort() {
        return this.wrapSocket.getPort();
    }

    public int getReceiveBufferSize() throws SocketException {
        return this.wrapSocket.getReceiveBufferSize();
    }

    public SocketAddress getRemoteSocketAddress() {
        return this.wrapSocket.getRemoteSocketAddress();
    }

    public boolean getReuseAddress() throws SocketException {
        return this.wrapSocket.getReuseAddress();
    }

    public int getSendBufferSize() throws SocketException {
        return this.wrapSocket.getSendBufferSize();
    }

    public synchronized SSLSession getSession() {
        BCSSLConnection connection = this.getConnection();
        return connection == null ? ProvSSLSession.NULL_SESSION : connection.getSession();
    }

    public int getSoLinger() throws SocketException {
        return this.wrapSocket.getSoLinger();
    }

    public int getSoTimeout() throws SocketException {
        return this.wrapSocket.getSoTimeout();
    }

    public synchronized SSLParameters getSSLParameters() {
        return SSLParametersUtil.toSSLParameters(this.sslParameters);
    }

    public synchronized ProvSSLParameters getProvSSLParameters() {
        return this.sslParameters;
    }

    public synchronized String[] getSupportedCipherSuites() {
        return this.context.getSupportedCipherSuites();
    }

    public synchronized String[] getSupportedProtocols() {
        return this.context.getSupportedProtocols();
    }

    public boolean getTcpNoDelay() throws SocketException {
        return this.wrapSocket.getTcpNoDelay();
    }

    public int getTrafficClass() throws SocketException {
        return this.wrapSocket.getTrafficClass();
    }

    public synchronized boolean getUseClientMode() {
        return this.useClientMode;
    }

    public synchronized boolean getWantClientAuth() {
        return this.sslParameters.getWantClientAuth();
    }

    public boolean isBound() {
        return this.wrapSocket.isBound();
    }

    public boolean isConnected() {
        return this.wrapSocket.isConnected();
    }

    public synchronized boolean isClosed() {
        return this.protocol != null && this.protocol.isClosed();
    }

    public boolean isInputShutdown() {
        return this.wrapSocket.isInputShutdown();
    }

    public boolean isOutputShutdown() {
        return this.wrapSocket.isOutputShutdown();
    }

    public synchronized void setEnabledCipherSuites(String[] suites) {
        if (!this.context.isSupportedCipherSuites(suites)) {
            throw new IllegalArgumentException("'suites' cannot be null, or contain unsupported cipher suites");
        }
        this.sslParameters.setCipherSuites(suites);
    }

    public synchronized void setEnabledProtocols(String[] protocols) {
        if (!this.context.isSupportedProtocols(protocols)) {
            throw new IllegalArgumentException("'protocols' cannot be null, or contain unsupported protocols");
        }
        this.sslParameters.setProtocols(protocols);
    }

    public synchronized void setEnableSessionCreation(boolean flag) {
        this.enableSessionCreation = flag;
    }

    public void setKeepAlive(boolean on) throws SocketException {
        this.wrapSocket.setKeepAlive(on);
    }

    public synchronized void setNeedClientAuth(boolean need) {
        this.sslParameters.setNeedClientAuth(need);
    }

    public void setPerformancePreferences(int connectionTime, int latency, int bandwidth) {
        this.wrapSocket.setPerformancePreferences(connectionTime, latency, bandwidth);
    }

    public void setReceiveBufferSize(int size) throws SocketException {
        this.wrapSocket.setReceiveBufferSize(size);
    }

    public void setReuseAddress(boolean on) throws SocketException {
        this.wrapSocket.setReuseAddress(on);
    }

    public void setSendBufferSize(int size) throws SocketException {
        this.wrapSocket.setSendBufferSize(size);
    }

    public synchronized void setSSLParameters(SSLParameters sslParameters) {
        this.sslParameters = SSLParametersUtil.toProvSSLParameters(sslParameters);
    }

    public void setSoLinger(boolean on, int linger) throws SocketException {
        this.wrapSocket.setSoLinger(on, linger);
    }

    public void setSoTimeout(int timeout) throws SocketException {
        this.wrapSocket.setSoTimeout(timeout);
    }

    public void setTcpNoDelay(boolean on) throws SocketException {
        this.wrapSocket.setTcpNoDelay(on);
    }

    public void setTrafficClass(int tc) throws SocketException {
        this.wrapSocket.setTrafficClass(tc);
    }

    public synchronized void setUseClientMode(boolean mode) {
        if (this.initialHandshakeBegun && mode != this.useClientMode) {
            throw new IllegalArgumentException("Mode cannot be changed after the initial handshake has begun");
        }
        this.useClientMode = mode;
    }

    public synchronized void setWantClientAuth(boolean want) {
        this.sslParameters.setWantClientAuth(want);
    }

    public synchronized void startHandshake() throws IOException {
        if (this.initialHandshakeBegun) {
            throw new UnsupportedOperationException("Renegotiation not supported");
        }
        this.initialHandshakeBegun = true;
        try {
            if (this.useClientMode) {
                TlsClientProtocol clientProtocol = new TlsClientProtocol(this.wrapSocket.getInputStream(), this.wrapSocket.getOutputStream());
                this.protocol = clientProtocol;
                ProvTlsClient client = new ProvTlsClient(this);
                this.protocolPeer = client;
                clientProtocol.connect(client);
            } else {
                TlsServerProtocol serverProtocol = new TlsServerProtocol(this.wrapSocket.getInputStream(), this.wrapSocket.getOutputStream());
                this.protocol = serverProtocol;
                ProvTlsServer server = new ProvTlsServer(this);
                this.protocolPeer = server;
                serverProtocol.accept(server);
            }
        }
        finally {
            this.handshakeSession = null;
        }
    }

    public String toString() {
        return this.wrapSocket.toString();
    }

    public String getPeerHost() {
        return this.wrapHost;
    }

    public boolean isClientTrusted(X509Certificate[] chain, String authType) {
        X509TrustManager tm = this.contextData.getTrustManager();
        if (tm != null) {
            try {
                tm.checkClientTrusted(chain, authType);
                return true;
            }
            catch (CertificateException certificateException) {
                // empty catch block
            }
        }
        return false;
    }

    public boolean isServerTrusted(X509Certificate[] chain, String authType) {
        X509TrustManager tm = this.contextData.getTrustManager();
        if (tm != null) {
            try {
                tm.checkServerTrusted(chain, authType);
                return true;
            }
            catch (CertificateException certificateException) {
                // empty catch block
            }
        }
        return false;
    }

    public synchronized void notifyHandshakeComplete(ProvSSLConnection connection) {
        this.connection = connection;
    }

    synchronized void handshakeIfNecessary() throws IOException {
        if (!this.initialHandshakeBegun) {
            this.startHandshake();
        }
    }

    class AppDataOutput
    extends OutputStream {
        AppDataOutput() {
        }

        public void close() throws IOException {
            ProvSSLSocketWrap.this.close();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void flush() throws IOException {
            ProvSSLSocketWrap provSSLSocketWrap = ProvSSLSocketWrap.this;
            synchronized (provSSLSocketWrap) {
                if (ProvSSLSocketWrap.this.protocol != null) {
                    ProvSSLSocketWrap.this.protocol.flush();
                }
            }
        }

        public void write(int b) throws IOException {
            ProvSSLSocketWrap.this.handshakeIfNecessary();
            byte[] buf = new byte[]{(byte)b};
            ProvSSLSocketWrap.this.protocol.writeApplicationData(buf, 0, 1);
        }

        public void write(byte[] b, int off, int len) throws IOException {
            if (len > 0) {
                ProvSSLSocketWrap.this.handshakeIfNecessary();
                ProvSSLSocketWrap.this.protocol.writeApplicationData(b, off, len);
            }
        }
    }

    class AppDataInput
    extends InputStream {
        AppDataInput() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int available() throws IOException {
            ProvSSLSocketWrap provSSLSocketWrap = ProvSSLSocketWrap.this;
            synchronized (provSSLSocketWrap) {
                return ProvSSLSocketWrap.this.protocol == null ? 0 : ProvSSLSocketWrap.this.protocol.applicationDataAvailable();
            }
        }

        public void close() throws IOException {
            ProvSSLSocketWrap.this.close();
        }

        public int read() throws IOException {
            ProvSSLSocketWrap.this.handshakeIfNecessary();
            byte[] buf = new byte[1];
            int ret = ProvSSLSocketWrap.this.protocol.readApplicationData(buf, 0, 1);
            return ret < 0 ? -1 : buf[0] & 0xFF;
        }

        public int read(byte[] b, int off, int len) throws IOException {
            if (len < 1) {
                return 0;
            }
            ProvSSLSocketWrap.this.handshakeIfNecessary();
            return ProvSSLSocketWrap.this.protocol.readApplicationData(b, off, len);
        }
    }
}

