/*
 * Decompiled with CFR 0.152.
 */
package org.spongycastle.jsse.provider;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.Socket;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.Hashtable;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLSession;
import javax.net.ssl.X509KeyManager;
import javax.security.auth.x500.X500Principal;
import org.spongycastle.asn1.x500.X500Name;
import org.spongycastle.jsse.BCSNIServerName;
import org.spongycastle.jsse.provider.JsseUtils;
import org.spongycastle.jsse.provider.PropertyUtils;
import org.spongycastle.jsse.provider.ProvDHConfigVerifier;
import org.spongycastle.jsse.provider.ProvSSLConnection;
import org.spongycastle.jsse.provider.ProvSSLParameters;
import org.spongycastle.jsse.provider.ProvSSLSessionContext;
import org.spongycastle.jsse.provider.ProvTlsManager;
import org.spongycastle.jsse.provider.ProvTlsPeer;
import org.spongycastle.tls.Certificate;
import org.spongycastle.tls.CertificateRequest;
import org.spongycastle.tls.CertificateStatusRequest;
import org.spongycastle.tls.DefaultTlsClient;
import org.spongycastle.tls.DefaultTlsKeyExchangeFactory;
import org.spongycastle.tls.ProtocolVersion;
import org.spongycastle.tls.ServerName;
import org.spongycastle.tls.ServerNameList;
import org.spongycastle.tls.SignatureAndHashAlgorithm;
import org.spongycastle.tls.TlsAuthentication;
import org.spongycastle.tls.TlsCredentials;
import org.spongycastle.tls.TlsExtensionsUtils;
import org.spongycastle.tls.TlsFatalAlert;
import org.spongycastle.tls.TlsServerCertificate;
import org.spongycastle.tls.TlsSession;
import org.spongycastle.tls.TlsUtils;
import org.spongycastle.tls.crypto.TlsCrypto;
import org.spongycastle.tls.crypto.TlsCryptoParameters;
import org.spongycastle.tls.crypto.impl.jcajce.JcaDefaultTlsCredentialedSigner;
import org.spongycastle.tls.crypto.impl.jcajce.JcaTlsCrypto;
import org.spongycastle.tls.crypto.impl.jcajce.JceDefaultTlsCredentialedAgreement;
import org.spongycastle.util.IPAddress;

class ProvTlsClient
extends DefaultTlsClient
implements ProvTlsPeer {
    private static Logger LOG = Logger.getLogger(ProvTlsClient.class.getName());
    private static final boolean provEnableSNIExtension = PropertyUtils.getBooleanSystemProperty("jsse.enableSNIExtension", true);
    protected final ProvTlsManager manager;
    protected final ProvSSLParameters sslParameters;
    protected boolean handshakeComplete = false;

    ProvTlsClient(ProvTlsManager manager) {
        super(manager.getContextData().getCrypto(), new DefaultTlsKeyExchangeFactory(), new ProvDHConfigVerifier());
        this.manager = manager;
        this.sslParameters = manager.getProvSSLParameters();
    }

    protected CertificateStatusRequest getCertificateStatusRequest() {
        return null;
    }

    protected Vector getSNIServerNames() {
        if (provEnableSNIExtension) {
            List<BCSNIServerName> sniServerNames = this.manager.getProvSSLParameters().getServerNames();
            if (sniServerNames == null) {
                String peerHost = this.manager.getPeerHost();
                if (peerHost != null && peerHost.indexOf(46) > 0 && !IPAddress.isValid((String)peerHost)) {
                    Vector<ServerName> serverNames = new Vector<ServerName>(1);
                    serverNames.addElement(new ServerName(0, peerHost));
                    return serverNames;
                }
            } else {
                Vector<ServerName> serverNames = new Vector<ServerName>(sniServerNames.size());
                for (BCSNIServerName sniServerName : sniServerNames) {
                    if (sniServerName.getType() != 0) continue;
                    try {
                        serverNames.addElement(new ServerName((short)sniServerName.getType(), new String(sniServerName.getEncoded(), "ASCII")));
                    }
                    catch (UnsupportedEncodingException e) {
                        LOG.log(Level.WARNING, "Unable to include SNI server name", e);
                    }
                }
                if (!serverNames.isEmpty()) {
                    return serverNames;
                }
            }
        }
        return null;
    }

    protected Vector getSupportedSignatureAlgorithms() {
        return JsseUtils.getSupportedSignatureAlgorithms(this.getCrypto());
    }

    public synchronized boolean isHandshakeComplete() {
        return this.handshakeComplete;
    }

    public TlsAuthentication getAuthentication() throws IOException {
        return new TlsAuthentication(){

            public TlsCredentials getClientCredentials(CertificateRequest certificateRequest) throws IOException {
                Socket socket;
                String alias;
                int keyExchangeAlgorithm = TlsUtils.getKeyExchangeAlgorithm(ProvTlsClient.this.selectedCipherSuite);
                switch (keyExchangeAlgorithm) {
                    case 7: 
                    case 9: 
                    case 16: 
                    case 18: {
                        return null;
                    }
                    case 1: 
                    case 3: 
                    case 5: 
                    case 17: 
                    case 19: {
                        break;
                    }
                    default: {
                        throw new TlsFatalAlert(80);
                    }
                }
                X509KeyManager km = ProvTlsClient.this.manager.getContextData().getKeyManager();
                if (km == null) {
                    return null;
                }
                short[] certTypes = certificateRequest.getCertificateTypes();
                if (certTypes == null || certTypes.length == 0) {
                    return null;
                }
                String[] keyTypes = new String[certTypes.length];
                for (int i = 0; i < certTypes.length; ++i) {
                    keyTypes[i] = JsseUtils.getAuthTypeClient(certTypes[i]);
                }
                Principal[] issuers = null;
                Vector cas = certificateRequest.getCertificateAuthorities();
                if (cas != null && cas.size() > 0) {
                    X500Name[] names = cas.toArray(new X500Name[cas.size()]);
                    Set<X500Principal> principals = JsseUtils.toX500Principals(names);
                    issuers = principals.toArray(new Principal[principals.size()]);
                }
                if ((alias = km.chooseClientAlias(keyTypes, issuers, socket = null)) == null) {
                    return null;
                }
                TlsCrypto crypto = ProvTlsClient.this.getCrypto();
                if (!(crypto instanceof JcaTlsCrypto)) {
                    throw new UnsupportedOperationException();
                }
                PrivateKey privateKey = km.getPrivateKey(alias);
                Certificate certificate = JsseUtils.getCertificateMessage(crypto, km.getCertificateChain(alias));
                if (privateKey == null || certificate.isEmpty()) {
                    return null;
                }
                switch (keyExchangeAlgorithm) {
                    case 7: 
                    case 9: 
                    case 16: 
                    case 18: {
                        return new JceDefaultTlsCredentialedAgreement((JcaTlsCrypto)crypto, certificate, privateKey);
                    }
                    case 1: 
                    case 3: 
                    case 5: 
                    case 17: 
                    case 19: {
                        short certificateType = certificate.getCertificateAt(0).getClientCertificateType();
                        short signatureAlgorithm = TlsUtils.getSignatureAlgorithmClient(certificateType);
                        SignatureAndHashAlgorithm sigAlg = TlsUtils.chooseSignatureAndHashAlgorithm(ProvTlsClient.this.context, ProvTlsClient.this.supportedSignatureAlgorithms, signatureAlgorithm);
                        return new JcaDefaultTlsCredentialedSigner(new TlsCryptoParameters(ProvTlsClient.this.context), (JcaTlsCrypto)crypto, privateKey, certificate, sigAlg);
                    }
                }
                throw new TlsFatalAlert(80);
            }

            public void notifyServerCertificate(TlsServerCertificate serverCertificate) throws IOException {
                String authType;
                boolean noServerCert;
                boolean bl = noServerCert = serverCertificate == null || serverCertificate.getCertificate() == null || serverCertificate.getCertificate().isEmpty();
                if (noServerCert) {
                    throw new TlsFatalAlert(40);
                }
                X509Certificate[] chain = JsseUtils.getX509CertificateChain(ProvTlsClient.this.manager.getContextData().getCrypto(), serverCertificate.getCertificate());
                if (!ProvTlsClient.this.manager.isServerTrusted(chain, authType = JsseUtils.getAuthTypeServer(TlsUtils.getKeyExchangeAlgorithm(ProvTlsClient.this.selectedCipherSuite)))) {
                    throw new TlsFatalAlert(42);
                }
            }
        };
    }

    public int[] getCipherSuites() {
        return TlsUtils.getSupportedCipherSuites(this.manager.getContextData().getCrypto(), this.manager.getContext().convertCipherSuites(this.sslParameters.getCipherSuites()));
    }

    public short[] getCompressionMethods() {
        short[] sArray;
        if (this.manager.getContext().isFips()) {
            short[] sArray2 = new short[1];
            sArray = sArray2;
            sArray2[0] = 0;
        } else {
            sArray = super.getCompressionMethods();
        }
        return sArray;
    }

    public Hashtable getClientExtensions() throws IOException {
        Hashtable clientExtensions = TlsExtensionsUtils.ensureExtensionsInitialised(super.getClientExtensions());
        if (provEnableSNIExtension) {
            List<BCSNIServerName> sniServerNames = this.manager.getProvSSLParameters().getServerNames();
            if (sniServerNames == null) {
                String peerHost = this.manager.getPeerHost();
                if (peerHost != null && peerHost.indexOf(46) > 0 && !IPAddress.isValid((String)peerHost)) {
                    Vector<ServerName> serverNames = new Vector<ServerName>(1);
                    serverNames.addElement(new ServerName(0, peerHost));
                    TlsExtensionsUtils.addServerNameExtension(clientExtensions, new ServerNameList(serverNames));
                }
            } else if (!sniServerNames.isEmpty()) {
                Vector<ServerName> serverNames = new Vector<ServerName>(sniServerNames.size());
                for (BCSNIServerName sniServerName : sniServerNames) {
                    if (sniServerName.getType() != 0) continue;
                    serverNames.addElement(new ServerName((short)sniServerName.getType(), new String(sniServerName.getEncoded(), "ASCII")));
                }
                TlsExtensionsUtils.addServerNameExtension(clientExtensions, new ServerNameList(serverNames));
            }
        }
        return clientExtensions;
    }

    public ProtocolVersion getMinimumVersion() {
        return this.manager.getContext().getMinimumVersion(this.sslParameters.getProtocols());
    }

    public ProtocolVersion getClientVersion() {
        return this.manager.getContext().getMaximumVersion(this.sslParameters.getProtocols());
    }

    public TlsSession getSessionToResume() {
        return null;
    }

    public void notifyAlertRaised(short alertLevel, short alertDescription, String message, Throwable cause) {
        Level level;
        super.notifyAlertRaised(alertLevel, alertDescription, message, cause);
        Level level2 = alertLevel == 1 ? Level.FINE : (level = alertDescription == 80 ? Level.WARNING : Level.INFO);
        if (LOG.isLoggable(level)) {
            String msg = JsseUtils.getAlertLogMessage("Client raised", alertLevel, alertDescription);
            if (message != null) {
                msg = msg + ": " + message;
            }
            LOG.log(level, msg, cause);
        }
    }

    public void notifyAlertReceived(short alertLevel, short alertDescription) {
        Level level;
        super.notifyAlertReceived(alertLevel, alertDescription);
        Level level2 = level = alertLevel == 1 ? Level.FINE : Level.INFO;
        if (LOG.isLoggable(level)) {
            String msg = JsseUtils.getAlertLogMessage("Client received", alertLevel, alertDescription);
            LOG.log(level, msg);
        }
    }

    public synchronized void notifyHandshakeComplete() throws IOException {
        this.handshakeComplete = true;
        ProvSSLSessionContext sessionContext = this.manager.getContextData().getClientSessionContext();
        SSLSession session = sessionContext.reportSession(this.context.getSession());
        ProvSSLConnection connection = new ProvSSLConnection(this.context, session);
        this.manager.notifyHandshakeComplete(connection);
    }

    public void notifySelectedCipherSuite(int selectedCipherSuite) {
        this.manager.getContext().validateNegotiatedCipherSuite(selectedCipherSuite);
        super.notifySelectedCipherSuite(selectedCipherSuite);
        LOG.fine("Client notified of selected cipher suite: " + this.manager.getContext().getCipherSuiteString(selectedCipherSuite));
    }

    public void notifyServerVersion(ProtocolVersion serverVersion) throws IOException {
        String selected = this.manager.getContext().getProtocolString(serverVersion);
        if (selected != null) {
            for (String protocol : this.sslParameters.getProtocols()) {
                if (!selected.equals(protocol)) continue;
                LOG.fine("Client notified of selected protocol version: " + selected);
                return;
            }
        }
        throw new TlsFatalAlert(70);
    }
}

