/*
 * Decompiled with CFR 0.152.
 */
package org.spongycastle.jsse.provider;

import java.io.IOException;
import java.net.Socket;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLSession;
import javax.net.ssl.X509KeyManager;
import javax.net.ssl.X509TrustManager;
import org.spongycastle.asn1.x500.X500Name;
import org.spongycastle.jsse.BCSNIMatcher;
import org.spongycastle.jsse.BCSNIServerName;
import org.spongycastle.jsse.provider.FipsUtils;
import org.spongycastle.jsse.provider.JsseUtils;
import org.spongycastle.jsse.provider.PropertyUtils;
import org.spongycastle.jsse.provider.ProvSSLConnection;
import org.spongycastle.jsse.provider.ProvSSLParameters;
import org.spongycastle.jsse.provider.ProvSSLSessionContext;
import org.spongycastle.jsse.provider.ProvTlsManager;
import org.spongycastle.jsse.provider.ProvTlsPeer;
import org.spongycastle.tls.Certificate;
import org.spongycastle.tls.CertificateRequest;
import org.spongycastle.tls.DefaultTlsServer;
import org.spongycastle.tls.NamedGroup;
import org.spongycastle.tls.ProtocolVersion;
import org.spongycastle.tls.ServerNameList;
import org.spongycastle.tls.SignatureAndHashAlgorithm;
import org.spongycastle.tls.TlsCredentials;
import org.spongycastle.tls.TlsExtensionsUtils;
import org.spongycastle.tls.TlsFatalAlert;
import org.spongycastle.tls.TlsUtils;
import org.spongycastle.tls.crypto.DHGroup;
import org.spongycastle.tls.crypto.DHStandardGroups;
import org.spongycastle.tls.crypto.TlsCrypto;
import org.spongycastle.tls.crypto.TlsCryptoParameters;
import org.spongycastle.tls.crypto.impl.jcajce.JcaDefaultTlsCredentialedSigner;
import org.spongycastle.tls.crypto.impl.jcajce.JcaTlsCrypto;
import org.spongycastle.tls.crypto.impl.jcajce.JceDefaultTlsCredentialedAgreement;
import org.spongycastle.tls.crypto.impl.jcajce.JceDefaultTlsCredentialedDecryptor;

class ProvTlsServer
extends DefaultTlsServer
implements ProvTlsPeer {
    private static Logger LOG = Logger.getLogger(ProvTlsServer.class.getName());
    private static final int provEphemeralDHKeySize = PropertyUtils.getIntegerSystemProperty("jdk.tls.ephemeralDHKeySize", 2048, 1024, 8192);
    protected final ProvTlsManager manager;
    protected final ProvSSLParameters sslParameters;
    protected BCSNIServerName matchedSNIServerName = null;
    protected Set<String> keyManagerMissCache = null;
    protected TlsCredentials credentials = null;
    protected boolean handshakeComplete = false;

    ProvTlsServer(ProvTlsManager manager) {
        super(manager.getContextData().getCrypto());
        this.manager = manager;
        this.sslParameters = manager.getProvSSLParameters();
    }

    protected DHGroup getDHParameters() {
        if (provEphemeralDHKeySize <= 1024) {
            return DHStandardGroups.rfc2409_1024;
        }
        if (provEphemeralDHKeySize <= 1536) {
            return DHStandardGroups.rfc3526_1536;
        }
        if (provEphemeralDHKeySize <= 2048) {
            return DHStandardGroups.rfc7919_ffdhe2048;
        }
        if (provEphemeralDHKeySize <= 3072) {
            return DHStandardGroups.rfc7919_ffdhe3072;
        }
        if (provEphemeralDHKeySize <= 4096) {
            return DHStandardGroups.rfc7919_ffdhe4096;
        }
        if (provEphemeralDHKeySize <= 6144) {
            return DHStandardGroups.rfc7919_ffdhe6144;
        }
        if (provEphemeralDHKeySize <= 8192) {
            return DHStandardGroups.rfc7919_ffdhe8192;
        }
        throw new IllegalStateException("Ephemeral DH key size has unexpected value: " + provEphemeralDHKeySize);
    }

    protected int getMaximumNegotiableCurveBits() {
        boolean isFips = this.manager.getContext().isFips();
        if (this.clientSupportedGroups == null) {
            return isFips ? FipsUtils.getFipsMaximumCurveBits() : NamedGroup.getMaximumCurveBits();
        }
        int maxBits = 0;
        for (int i = 0; i < this.clientSupportedGroups.length; ++i) {
            int namedGroup = this.clientSupportedGroups[i];
            if (isFips && !FipsUtils.isFipsCurve(namedGroup)) continue;
            maxBits = Math.max(maxBits, NamedGroup.getCurveBits(namedGroup));
        }
        return maxBits;
    }

    protected boolean selectCipherSuite(int cipherSuite) throws IOException {
        if (!this.selectCredentials(cipherSuite)) {
            return false;
        }
        this.manager.getContext().validateNegotiatedCipherSuite(cipherSuite);
        return super.selectCipherSuite(cipherSuite);
    }

    protected int selectCurve(int minimumCurveBits) {
        if (this.clientSupportedGroups == null) {
            return this.selectDefaultCurve(minimumCurveBits);
        }
        boolean isFips = this.manager.getContext().isFips();
        for (int i = 0; i < this.clientSupportedGroups.length; ++i) {
            int namedGroup = this.clientSupportedGroups[i];
            if (NamedGroup.getCurveBits(namedGroup) < minimumCurveBits || isFips && !FipsUtils.isFipsCurve(namedGroup)) continue;
            return namedGroup;
        }
        return -1;
    }

    protected int selectDefaultCurve(int minimumCurveBits) {
        return minimumCurveBits <= 256 ? 23 : (minimumCurveBits <= 384 ? 24 : -1);
    }

    public synchronized boolean isHandshakeComplete() {
        return this.handshakeComplete;
    }

    public TlsCredentials getCredentials() throws IOException {
        return this.credentials;
    }

    public int[] getCipherSuites() {
        return TlsUtils.getSupportedCipherSuites(this.manager.getContextData().getCrypto(), this.manager.getContext().convertCipherSuites(this.sslParameters.getCipherSuites()));
    }

    protected short[] getCompressionMethods() {
        short[] sArray;
        if (this.manager.getContext().isFips()) {
            short[] sArray2 = new short[1];
            sArray = sArray2;
            sArray2[0] = 0;
        } else {
            sArray = super.getCompressionMethods();
        }
        return sArray;
    }

    public CertificateRequest getCertificateRequest() throws IOException {
        boolean shouldRequest;
        boolean bl = shouldRequest = this.sslParameters.getNeedClientAuth() || this.sslParameters.getWantClientAuth();
        if (!shouldRequest) {
            return null;
        }
        short[] certificateTypes = new short[]{1, 2, 64};
        Vector serverSigAlgs = null;
        if (TlsUtils.isSignatureAlgorithmsExtensionAllowed(this.serverVersion)) {
            serverSigAlgs = JsseUtils.getSupportedSignatureAlgorithms(this.getCrypto());
        }
        Vector<X500Name> certificateAuthorities = new Vector<X500Name>();
        X509TrustManager tm = this.manager.getContextData().getTrustManager();
        if (tm != null) {
            for (X509Certificate caCert : tm.getAcceptedIssuers()) {
                certificateAuthorities.addElement(X500Name.getInstance((Object)caCert.getSubjectX500Principal().getEncoded()));
            }
        }
        return new CertificateRequest(certificateTypes, serverSigAlgs, certificateAuthorities);
    }

    public int getSelectedCipherSuite() throws IOException {
        this.keyManagerMissCache = new HashSet<String>();
        int selectedCipherSuite = super.getSelectedCipherSuite();
        LOG.fine("Server selected cipher suite: " + this.manager.getContext().getCipherSuiteString(selectedCipherSuite));
        this.keyManagerMissCache = null;
        return selectedCipherSuite;
    }

    public Hashtable getServerExtensions() throws IOException {
        super.getServerExtensions();
        if (this.matchedSNIServerName != null) {
            this.checkServerExtensions().put(TlsExtensionsUtils.EXT_server_name, TlsExtensionsUtils.createEmptyExtensionData());
        }
        return this.serverExtensions;
    }

    public void notifyAlertRaised(short alertLevel, short alertDescription, String message, Throwable cause) {
        Level level;
        Level level2 = alertLevel == 1 ? Level.FINE : (level = alertDescription == 80 ? Level.WARNING : Level.INFO);
        if (LOG.isLoggable(level)) {
            String msg = JsseUtils.getAlertLogMessage("Server raised", alertLevel, alertDescription);
            if (message != null) {
                msg = msg + ": " + message;
            }
            LOG.log(level, msg, cause);
        }
    }

    public void notifyAlertReceived(short alertLevel, short alertDescription) {
        Level level;
        super.notifyAlertReceived(alertLevel, alertDescription);
        Level level2 = level = alertLevel == 1 ? Level.FINE : Level.INFO;
        if (LOG.isLoggable(level)) {
            String msg = JsseUtils.getAlertLogMessage("Server received", alertLevel, alertDescription);
            LOG.log(level, msg);
        }
    }

    public ProtocolVersion getServerVersion() throws IOException {
        String[] protocols = this.sslParameters.getProtocols();
        if (protocols != null && protocols.length > 0) {
            for (ProtocolVersion version = this.clientVersion; version != null; version = version.getPreviousVersion()) {
                String versionString = this.manager.getContext().getProtocolString(version);
                if (versionString == null || !JsseUtils.contains(protocols, versionString)) continue;
                LOG.fine("Server selected protocol version: " + version);
                this.serverVersion = version;
                return this.serverVersion;
            }
        }
        throw new TlsFatalAlert(70);
    }

    public void notifyClientCertificate(Certificate clientCertificate) throws IOException {
        boolean noClientCert;
        assert (this.sslParameters.getNeedClientAuth() || this.sslParameters.getWantClientAuth());
        boolean bl = noClientCert = clientCertificate == null || clientCertificate.isEmpty();
        if (noClientCert) {
            if (this.sslParameters.getNeedClientAuth()) {
                throw new TlsFatalAlert(40);
            }
        } else {
            short clientCertificateType;
            String authType;
            X509Certificate[] chain = JsseUtils.getX509CertificateChain(this.manager.getContextData().getCrypto(), clientCertificate);
            if (!this.manager.isClientTrusted(chain, authType = JsseUtils.getAuthTypeClient(clientCertificateType = clientCertificate.getCertificateAt(0).getClientCertificateType()))) {
                throw new TlsFatalAlert(42);
            }
        }
    }

    public synchronized void notifyHandshakeComplete() throws IOException {
        this.handshakeComplete = true;
        ProvSSLSessionContext sessionContext = this.manager.getContextData().getServerSessionContext();
        SSLSession session = sessionContext.reportSession(this.context.getSession());
        ProvSSLConnection connection = new ProvSSLConnection(this.context, session);
        this.manager.notifyHandshakeComplete(connection);
    }

    public void processClientExtensions(Hashtable clientExtensions) throws IOException {
        ServerNameList serverNameList;
        Collection<BCSNIMatcher> sniMatchers;
        super.processClientExtensions(clientExtensions);
        if (clientExtensions != null && (sniMatchers = this.manager.getProvSSLParameters().getSNIMatchers()) != null && !sniMatchers.isEmpty() && (serverNameList = TlsExtensionsUtils.getServerNameExtension(clientExtensions)) != null) {
            this.matchedSNIServerName = JsseUtils.findMatchingSNIServerName(serverNameList, sniMatchers);
            if (this.matchedSNIServerName == null) {
                throw new TlsFatalAlert(112);
            }
        }
    }

    protected boolean selectCredentials(int cipherSuite) throws IOException {
        this.credentials = null;
        int keyExchangeAlgorithm = TlsUtils.getKeyExchangeAlgorithm(cipherSuite);
        switch (keyExchangeAlgorithm) {
            case 11: 
            case 20: {
                return true;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                break;
            }
            default: {
                return false;
            }
        }
        X509KeyManager km = this.manager.getContextData().getKeyManager();
        if (km == null) {
            return false;
        }
        String keyType = JsseUtils.getAuthTypeServer(keyExchangeAlgorithm);
        if (this.keyManagerMissCache.contains(keyType)) {
            return false;
        }
        Principal[] issuers = null;
        Socket socket = null;
        String alias = km.chooseServerAlias(keyType, issuers, socket);
        if (alias == null) {
            this.keyManagerMissCache.add(keyType);
            return false;
        }
        TlsCrypto crypto = this.getCrypto();
        if (!(crypto instanceof JcaTlsCrypto)) {
            throw new UnsupportedOperationException();
        }
        PrivateKey privateKey = km.getPrivateKey(alias);
        Certificate certificate = JsseUtils.getCertificateMessage(crypto, km.getCertificateChain(alias));
        if (privateKey == null || !JsseUtils.isUsableKeyForServer(keyExchangeAlgorithm, privateKey) || certificate.isEmpty()) {
            this.keyManagerMissCache.add(keyType);
            return false;
        }
        switch (keyExchangeAlgorithm) {
            case 7: 
            case 9: 
            case 16: 
            case 18: {
                this.credentials = new JceDefaultTlsCredentialedAgreement((JcaTlsCrypto)crypto, certificate, privateKey);
                return true;
            }
            case 3: 
            case 5: 
            case 17: 
            case 19: {
                short signatureAlgorithm = TlsUtils.getSignatureAlgorithm(keyExchangeAlgorithm);
                SignatureAndHashAlgorithm sigAlg = TlsUtils.chooseSignatureAndHashAlgorithm(this.context, this.supportedSignatureAlgorithms, signatureAlgorithm);
                this.credentials = new JcaDefaultTlsCredentialedSigner(new TlsCryptoParameters(this.context), (JcaTlsCrypto)crypto, privateKey, certificate, sigAlg);
                return true;
            }
            case 1: {
                this.credentials = new JceDefaultTlsCredentialedDecryptor((JcaTlsCrypto)crypto, certificate, privateKey);
                return true;
            }
        }
        return false;
    }
}

