/*
 * Decompiled with CFR 0.152.
 */
package org.spongycastle.jsse.provider;

import java.net.Socket;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPublicKey;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.X509ExtendedKeyManager;
import org.spongycastle.asn1.x500.X500Name;
import org.spongycastle.asn1.x509.Extensions;
import org.spongycastle.asn1.x509.KeyUsage;
import org.spongycastle.asn1.x509.TBSCertificate;
import org.spongycastle.jsse.provider.JsseUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ProvX509KeyManager
extends X509ExtendedKeyManager {
    private final List<KeyStore.Builder> builders;
    private final Map<String, KeyStore.PrivateKeyEntry> keys = new HashMap<String, KeyStore.PrivateKeyEntry>();
    private final AtomicLong version = new AtomicLong();

    public ProvX509KeyManager(List<KeyStore.Builder> builders) {
        this.builders = builders;
    }

    @Override
    public String chooseClientAlias(String[] keyTypes, Principal[] issuers, Socket socket) {
        return this.chooseAlias(false, keyTypes, issuers);
    }

    @Override
    public String chooseEngineClientAlias(String[] keyTypes, Principal[] issuers, SSLEngine engine) {
        return this.chooseAlias(false, keyTypes, issuers);
    }

    @Override
    public String chooseEngineServerAlias(String keyType, Principal[] issuers, SSLEngine engine) {
        return this.chooseAlias(true, new String[]{keyType}, issuers);
    }

    @Override
    public String chooseServerAlias(String keyType, Principal[] issuers, Socket socket) {
        return this.chooseAlias(true, new String[]{keyType}, issuers);
    }

    @Override
    public X509Certificate[] getCertificateChain(String alias) {
        KeyStore.PrivateKeyEntry entry = this.getPrivateKeyEntry(alias);
        return entry == null ? null : (X509Certificate[])entry.getCertificateChain();
    }

    @Override
    public String[] getClientAliases(String keyType, Principal[] issuers) {
        return this.getAliases(false, keyType, issuers);
    }

    @Override
    public PrivateKey getPrivateKey(String alias) {
        KeyStore.PrivateKeyEntry entry = this.getPrivateKeyEntry(alias);
        return entry == null ? null : entry.getPrivateKey();
    }

    @Override
    public String[] getServerAliases(String keyType, Principal[] issuers) {
        return this.getAliases(true, keyType, issuers);
    }

    private String chooseAlias(boolean forServer, String[] keyTypes, Principal[] issuers) {
        try {
            Set<X500Name> issuerNames = JsseUtils.toX500Names(issuers);
            for (int i = 0; i != keyTypes.length; ++i) {
                List<String> aliases = this.findAliases(forServer, keyTypes[i], issuerNames);
                if (aliases.isEmpty()) continue;
                return aliases.get(0);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private List<String> findAliases(boolean forServer, String keyType, Set<X500Name> issuers) {
        ArrayList<String> aliases = new ArrayList<String>();
        for (int i = 0; i != this.builders.size(); ++i) {
            KeyStore.Builder builder = this.builders.get(i);
            try {
                aliases.addAll(this.findAliases(forServer, i, builder.getKeyStore(), builder, keyType, issuers));
                continue;
            }
            catch (GeneralSecurityException e) {
                throw new IllegalStateException("unable to build key store: " + e.getMessage(), e);
            }
        }
        return aliases;
    }

    private List<String> findAliases(boolean forServer, int index, KeyStore keyStore, KeyStore.Builder storeBuilder, String keyType, Set<X500Name> issuers) throws GeneralSecurityException {
        ArrayList<String> aliases = new ArrayList<String>();
        Enumeration<String> en = keyStore.aliases();
        while (en.hasMoreElements()) {
            X509Certificate[] chain;
            String eName = en.nextElement();
            if (!keyStore.isKeyEntry(eName) || (chain = JsseUtils.getX509CertificateChain(keyStore.getCertificateChain(eName))) == null || chain.length == 0 || !this.isSuitableCredential(forServer, keyType, issuers, chain)) continue;
            KeyStore.PrivateKeyEntry kEntry = (KeyStore.PrivateKeyEntry)keyStore.getEntry(eName, storeBuilder.getProtectionParameter(eName));
            String alias = index + "." + eName + "." + this.version.getAndIncrement();
            this.keys.put(alias, kEntry);
            aliases.add(alias);
        }
        return aliases;
    }

    private String[] getAliases(boolean forServer, String keyType, Principal[] issuers) {
        List<String> aliases = this.findAliases(forServer, keyType, JsseUtils.toX500Names(issuers));
        return aliases.toArray(new String[aliases.size()]);
    }

    private KeyStore.PrivateKeyEntry getPrivateKeyEntry(String alias) {
        return alias == null ? null : this.keys.get(alias);
    }

    private boolean hasSuitableIssuer(Set<X500Name> issuerNames, X509Certificate c) {
        return issuerNames.contains(JsseUtils.toX500Name(c.getIssuerX500Principal()));
    }

    private boolean isSuitableCredential(boolean forServer, String keyType, Set<X500Name> issuerNames, X509Certificate[] certificateChain) {
        if (!this.isSuitableCertificate(forServer, keyType, certificateChain[0])) {
            return false;
        }
        if (issuerNames == null || issuerNames.isEmpty()) {
            return true;
        }
        int pos = certificateChain.length;
        while (--pos >= 0) {
            if (!this.hasSuitableIssuer(issuerNames, certificateChain[pos])) continue;
            return true;
        }
        return false;
    }

    private boolean isSuitableCertificate(boolean forServer, String keyType, X509Certificate c) {
        if (keyType == null || c == null) {
            return false;
        }
        PublicKey pub = c.getPublicKey();
        if (keyType.equalsIgnoreCase("DHE_RSA") || keyType.equalsIgnoreCase("ECDHE_RSA") || keyType.equalsIgnoreCase("SRP_RSA")) {
            return pub instanceof RSAPublicKey && this.isSuitableKeyUsage(128, c);
        }
        if (keyType.equalsIgnoreCase("DHE_DSS") || keyType.equalsIgnoreCase("SRP_DSS")) {
            return pub instanceof DSAPublicKey && this.isSuitableKeyUsage(128, c);
        }
        if (keyType.equalsIgnoreCase("ECDHE_ECDSA")) {
            return pub instanceof ECPublicKey && this.isSuitableKeyUsage(128, c);
        }
        if (keyType.equalsIgnoreCase("RSA")) {
            int keyUsage = forServer ? 32 : 128;
            return pub instanceof RSAPublicKey && this.isSuitableKeyUsage(keyUsage, c);
        }
        if (keyType.equalsIgnoreCase("DSA")) {
            return !forServer && pub instanceof DSAPublicKey && this.isSuitableKeyUsage(128, c);
        }
        if (keyType.equalsIgnoreCase("EC")) {
            return pub instanceof ECPublicKey && this.isSuitableKeyUsage(128, c);
        }
        return false;
    }

    private boolean isSuitableKeyUsage(int keyUsageBits, X509Certificate c) {
        try {
            int bits;
            KeyUsage ku;
            Extensions exts = TBSCertificate.getInstance((Object)c.getTBSCertificate()).getExtensions();
            if (exts != null && (ku = KeyUsage.fromExtensions((Extensions)exts)) != null && ((bits = ku.getBytes()[0] & 0xFF) & keyUsageBits) != keyUsageBits) {
                return false;
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }
}

