/*
 * Decompiled with CFR 0.152.
 */
package org.spongycastle.tls;

import org.spongycastle.tls.ProtocolVersion;
import org.spongycastle.tls.SecurityParameters;
import org.spongycastle.tls.TlsContext;
import org.spongycastle.tls.TlsSession;
import org.spongycastle.tls.TlsUtils;
import org.spongycastle.tls.crypto.TlsCrypto;
import org.spongycastle.tls.crypto.TlsNonceGenerator;
import org.spongycastle.util.Arrays;
import org.spongycastle.util.Pack;
import org.spongycastle.util.Times;

abstract class AbstractTlsContext
implements TlsContext {
    private static long counter = Times.nanoTime();
    private TlsCrypto crypto;
    private TlsNonceGenerator nonceGenerator;
    private SecurityParameters securityParameters;
    private ProtocolVersion clientVersion = null;
    private ProtocolVersion serverVersion = null;
    private TlsSession session = null;
    private Object userObject = null;

    private static synchronized long nextCounterValue() {
        return ++counter;
    }

    private static TlsNonceGenerator createNonceGenerator(TlsCrypto crypto, SecurityParameters securityParameters) {
        byte[] additionalSeedMaterial = new byte[16];
        Pack.longToBigEndian((long)AbstractTlsContext.nextCounterValue(), (byte[])additionalSeedMaterial, (int)0);
        Pack.longToBigEndian((long)Times.nanoTime(), (byte[])additionalSeedMaterial, (int)8);
        additionalSeedMaterial[0] = (byte)securityParameters.entity;
        return crypto.createNonceGenerator(additionalSeedMaterial);
    }

    AbstractTlsContext(TlsCrypto crypto, SecurityParameters securityParameters) {
        this.crypto = crypto;
        this.nonceGenerator = AbstractTlsContext.createNonceGenerator(crypto, securityParameters);
        this.securityParameters = securityParameters;
    }

    public TlsCrypto getCrypto() {
        return this.crypto;
    }

    public TlsNonceGenerator getNonceGenerator() {
        return this.nonceGenerator;
    }

    public SecurityParameters getSecurityParameters() {
        return this.securityParameters;
    }

    public ProtocolVersion getClientVersion() {
        return this.clientVersion;
    }

    void setClientVersion(ProtocolVersion clientVersion) {
        this.clientVersion = clientVersion;
    }

    public ProtocolVersion getServerVersion() {
        return this.serverVersion;
    }

    void setServerVersion(ProtocolVersion serverVersion) {
        this.serverVersion = serverVersion;
    }

    public TlsSession getResumableSession() {
        TlsSession session = this.getSession();
        if (session == null || !session.isResumable()) {
            return null;
        }
        return session;
    }

    public TlsSession getSession() {
        return this.session;
    }

    void setSession(TlsSession session) {
        this.session = session;
    }

    public Object getUserObject() {
        return this.userObject;
    }

    public void setUserObject(Object userObject) {
        this.userObject = userObject;
    }

    public byte[] exportChannelBinding(int channelBinding) {
        switch (channelBinding) {
            case 1: {
                byte[] tlsUnique = this.getSecurityParameters().getTLSUnique();
                if (tlsUnique == null) {
                    throw new IllegalStateException("'tls-unique' channel binding unavailable before handshake completion");
                }
                return Arrays.clone((byte[])tlsUnique);
            }
        }
        throw new UnsupportedOperationException();
    }

    public byte[] exportKeyingMaterial(String asciiLabel, byte[] context_value, int length) {
        if (context_value != null && !TlsUtils.isValidUint16(context_value.length)) {
            throw new IllegalArgumentException("'context_value' must have length less than 2^16 (or be null)");
        }
        SecurityParameters sp = this.getSecurityParameters();
        byte[] cr = sp.getClientRandom();
        byte[] sr = sp.getServerRandom();
        int seedLength = cr.length + sr.length;
        if (context_value != null) {
            seedLength += 2 + context_value.length;
        }
        byte[] seed = new byte[seedLength];
        int seedPos = 0;
        System.arraycopy(cr, 0, seed, seedPos, cr.length);
        System.arraycopy(sr, 0, seed, seedPos += cr.length, sr.length);
        seedPos += sr.length;
        if (context_value != null) {
            TlsUtils.writeUint16(context_value.length, seed, seedPos);
            System.arraycopy(context_value, 0, seed, seedPos += 2, context_value.length);
            seedPos += context_value.length;
        }
        if (seedPos != seedLength) {
            throw new IllegalStateException("error in calculation of seed for export");
        }
        return TlsUtils.PRF(this, sp.getMasterSecret(), asciiLabel, seed, length).extract();
    }
}

