/*
 * Decompiled with CFR 0.152.
 */
package org.spongycastle.tls;

import java.io.IOException;
import java.util.Hashtable;
import java.util.Vector;
import org.spongycastle.tls.AbstractTlsPeer;
import org.spongycastle.tls.Certificate;
import org.spongycastle.tls.CertificateRequest;
import org.spongycastle.tls.CertificateStatus;
import org.spongycastle.tls.CertificateStatusRequest;
import org.spongycastle.tls.DefaultTlsKeyExchangeFactory;
import org.spongycastle.tls.MaxFragmentLength;
import org.spongycastle.tls.NamedGroup;
import org.spongycastle.tls.NewSessionTicket;
import org.spongycastle.tls.ProtocolVersion;
import org.spongycastle.tls.TlsCompression;
import org.spongycastle.tls.TlsECCUtils;
import org.spongycastle.tls.TlsExtensionsUtils;
import org.spongycastle.tls.TlsFatalAlert;
import org.spongycastle.tls.TlsKeyExchangeFactory;
import org.spongycastle.tls.TlsNullCompression;
import org.spongycastle.tls.TlsServer;
import org.spongycastle.tls.TlsServerContext;
import org.spongycastle.tls.TlsUtils;
import org.spongycastle.tls.crypto.DHGroup;
import org.spongycastle.tls.crypto.DHStandardGroups;
import org.spongycastle.tls.crypto.TlsCipher;
import org.spongycastle.tls.crypto.TlsCrypto;
import org.spongycastle.tls.crypto.TlsCryptoParameters;
import org.spongycastle.tls.crypto.TlsDHConfig;
import org.spongycastle.tls.crypto.TlsECConfig;
import org.spongycastle.util.Arrays;

public abstract class AbstractTlsServer
extends AbstractTlsPeer
implements TlsServer {
    protected TlsKeyExchangeFactory keyExchangeFactory;
    protected TlsServerContext context;
    protected ProtocolVersion clientVersion;
    protected int[] offeredCipherSuites;
    protected short[] offeredCompressionMethods;
    protected Hashtable clientExtensions;
    protected boolean encryptThenMACOffered;
    protected short maxFragmentLengthOffered;
    protected boolean truncatedHMacOffered;
    protected Vector supportedSignatureAlgorithms;
    protected int[] clientSupportedGroups;
    protected short[] clientECPointFormats;
    protected short[] serverECPointFormats;
    protected CertificateStatusRequest certificateStatusRequest;
    protected ProtocolVersion serverVersion;
    protected int selectedCipherSuite;
    protected short selectedCompressionMethod;
    protected Hashtable serverExtensions;

    public AbstractTlsServer(TlsCrypto crypto) {
        this(crypto, new DefaultTlsKeyExchangeFactory());
    }

    public AbstractTlsServer(TlsCrypto crypto, TlsKeyExchangeFactory keyExchangeFactory) {
        super(crypto);
        this.keyExchangeFactory = keyExchangeFactory;
    }

    protected boolean allowEncryptThenMAC() {
        return true;
    }

    protected boolean allowTruncatedHMac() {
        return false;
    }

    protected Hashtable checkServerExtensions() {
        this.serverExtensions = TlsExtensionsUtils.ensureExtensionsInitialised(this.serverExtensions);
        return this.serverExtensions;
    }

    protected abstract int[] getCipherSuites();

    protected short[] getCompressionMethods() {
        return new short[]{0};
    }

    protected DHGroup getDHParameters() {
        return DHStandardGroups.rfc7919_ffdhe2048;
    }

    protected ProtocolVersion getMaximumVersion() {
        return ProtocolVersion.TLSv12;
    }

    protected ProtocolVersion getMinimumVersion() {
        return ProtocolVersion.TLSv10;
    }

    protected int getMaximumNegotiableCurveBits() {
        if (this.clientSupportedGroups == null) {
            return NamedGroup.getMaximumCurveBits();
        }
        int maxBits = 0;
        for (int i = 0; i < this.clientSupportedGroups.length; ++i) {
            maxBits = Math.max(maxBits, NamedGroup.getCurveBits(this.clientSupportedGroups[i]));
        }
        return maxBits;
    }

    protected boolean isSelectableCipherSuite(int cipherSuite, int availCurveBits, Vector sigAlgs) {
        return Arrays.contains((int[])this.offeredCipherSuites, (int)cipherSuite) && TlsUtils.isValidCipherSuiteForVersion(cipherSuite, this.serverVersion) && availCurveBits >= TlsECCUtils.getMinimumCurveBits(cipherSuite) && TlsUtils.isValidCipherSuiteForSignatureAlgorithms(cipherSuite, sigAlgs);
    }

    protected boolean selectCipherSuite(int cipherSuite) throws IOException {
        this.selectedCipherSuite = cipherSuite;
        return true;
    }

    protected int selectCurve(int minimumCurveBits) {
        if (this.clientSupportedGroups == null) {
            return this.selectDefaultCurve(minimumCurveBits);
        }
        for (int i = 0; i < this.clientSupportedGroups.length; ++i) {
            int namedGroup = this.clientSupportedGroups[i];
            if (NamedGroup.getCurveBits(namedGroup) < minimumCurveBits) continue;
            return namedGroup;
        }
        return -1;
    }

    protected int selectDefaultCurve(int minimumCurveBits) {
        return minimumCurveBits <= 256 ? 23 : (minimumCurveBits <= 384 ? 24 : (minimumCurveBits <= 521 ? 25 : -1));
    }

    protected TlsDHConfig selectDHConfig() {
        return new TlsDHConfig(this.getDHParameters());
    }

    protected TlsECConfig selectECConfig() throws IOException {
        int minimumCurveBits = TlsECCUtils.getMinimumCurveBits(this.selectedCipherSuite);
        int namedGroup = this.selectCurve(minimumCurveBits);
        if (namedGroup < 0) {
            throw new TlsFatalAlert(80);
        }
        boolean compressed = TlsECCUtils.isCompressionPreferred(this.clientECPointFormats, namedGroup);
        TlsECConfig ecConfig = new TlsECConfig();
        ecConfig.setNamedGroup(namedGroup);
        ecConfig.setPointCompression(compressed);
        return ecConfig;
    }

    public void init(TlsServerContext context) {
        this.context = context;
    }

    public void notifyClientVersion(ProtocolVersion clientVersion) throws IOException {
        this.clientVersion = clientVersion;
    }

    public void notifyFallback(boolean isFallback) throws IOException {
        if (isFallback && this.getMaximumVersion().isLaterVersionOf(this.clientVersion)) {
            throw new TlsFatalAlert(86);
        }
    }

    public void notifyOfferedCipherSuites(int[] offeredCipherSuites) throws IOException {
        this.offeredCipherSuites = offeredCipherSuites;
    }

    public void notifyOfferedCompressionMethods(short[] offeredCompressionMethods) throws IOException {
        this.offeredCompressionMethods = offeredCompressionMethods;
    }

    public void processClientExtensions(Hashtable clientExtensions) throws IOException {
        this.clientExtensions = clientExtensions;
        if (clientExtensions != null) {
            this.encryptThenMACOffered = TlsExtensionsUtils.hasEncryptThenMACExtension(clientExtensions);
            this.maxFragmentLengthOffered = TlsExtensionsUtils.getMaxFragmentLengthExtension(clientExtensions);
            if (this.maxFragmentLengthOffered >= 0 && !MaxFragmentLength.isValid(this.maxFragmentLengthOffered)) {
                throw new TlsFatalAlert(47);
            }
            this.truncatedHMacOffered = TlsExtensionsUtils.hasTruncatedHMacExtension(clientExtensions);
            this.supportedSignatureAlgorithms = TlsUtils.getSignatureAlgorithmsExtension(clientExtensions);
            if (this.supportedSignatureAlgorithms != null && !TlsUtils.isSignatureAlgorithmsExtensionAllowed(this.clientVersion)) {
                throw new TlsFatalAlert(47);
            }
            this.clientSupportedGroups = TlsExtensionsUtils.getSupportedGroupsExtension(clientExtensions);
            this.clientECPointFormats = TlsECCUtils.getSupportedPointFormatsExtension(clientExtensions);
            this.certificateStatusRequest = TlsExtensionsUtils.getStatusRequestExtension(clientExtensions);
        }
    }

    public ProtocolVersion getServerVersion() throws IOException {
        if (this.getMinimumVersion().isEqualOrEarlierVersionOf(this.clientVersion)) {
            ProtocolVersion maximumVersion = this.getMaximumVersion();
            if (this.clientVersion.isEqualOrEarlierVersionOf(maximumVersion)) {
                this.serverVersion = this.clientVersion;
                return this.serverVersion;
            }
            if (this.clientVersion.isLaterVersionOf(maximumVersion)) {
                this.serverVersion = maximumVersion;
                return this.serverVersion;
            }
        }
        throw new TlsFatalAlert(70);
    }

    public int getSelectedCipherSuite() throws IOException {
        Vector sigAlgs = TlsUtils.getUsableSignatureAlgorithms(this.supportedSignatureAlgorithms);
        int availCurveBits = this.getMaximumNegotiableCurveBits();
        int[] cipherSuites = this.getCipherSuites();
        for (int i = 0; i < cipherSuites.length; ++i) {
            int cipherSuite = cipherSuites[i];
            if (!this.isSelectableCipherSuite(cipherSuite, availCurveBits, sigAlgs) || !this.selectCipherSuite(cipherSuite)) continue;
            return cipherSuite;
        }
        throw new TlsFatalAlert(40);
    }

    public short getSelectedCompressionMethod() throws IOException {
        short[] compressionMethods = this.getCompressionMethods();
        for (int i = 0; i < compressionMethods.length; ++i) {
            if (!Arrays.contains((short[])this.offeredCompressionMethods, (short)compressionMethods[i])) continue;
            this.selectedCompressionMethod = compressionMethods[i];
            return this.selectedCompressionMethod;
        }
        throw new TlsFatalAlert(40);
    }

    public Hashtable getServerExtensions() throws IOException {
        if (this.encryptThenMACOffered && this.allowEncryptThenMAC() && TlsUtils.isBlockCipherSuite(this.selectedCipherSuite)) {
            TlsExtensionsUtils.addEncryptThenMACExtension(this.checkServerExtensions());
        }
        if (this.maxFragmentLengthOffered >= 0 && MaxFragmentLength.isValid(this.maxFragmentLengthOffered)) {
            TlsExtensionsUtils.addMaxFragmentLengthExtension(this.checkServerExtensions(), this.maxFragmentLengthOffered);
        }
        if (this.truncatedHMacOffered && this.allowTruncatedHMac()) {
            TlsExtensionsUtils.addTruncatedHMacExtension(this.checkServerExtensions());
        }
        if (this.clientECPointFormats != null && TlsECCUtils.isECCipherSuite(this.selectedCipherSuite)) {
            this.serverECPointFormats = new short[]{0, 1, 2};
            TlsECCUtils.addSupportedPointFormatsExtension(this.checkServerExtensions(), this.serverECPointFormats);
        }
        if (this.certificateStatusRequest != null) {
            this.checkServerExtensions().put(TlsExtensionsUtils.EXT_status_request, TlsExtensionsUtils.createEmptyExtensionData());
        }
        return this.serverExtensions;
    }

    public Vector getServerSupplementalData() throws IOException {
        return null;
    }

    public CertificateStatus getCertificateStatus() throws IOException {
        return null;
    }

    public CertificateRequest getCertificateRequest() throws IOException {
        return null;
    }

    public void processClientSupplementalData(Vector clientSupplementalData) throws IOException {
        if (clientSupplementalData != null) {
            throw new TlsFatalAlert(10);
        }
    }

    public void notifyClientCertificate(Certificate clientCertificate) throws IOException {
        throw new TlsFatalAlert(80);
    }

    public TlsCompression getCompression() throws IOException {
        switch (this.selectedCompressionMethod) {
            case 0: {
                return new TlsNullCompression();
            }
        }
        throw new TlsFatalAlert(80);
    }

    public TlsCipher getCipher() throws IOException {
        int encryptionAlgorithm = TlsUtils.getEncryptionAlgorithm(this.selectedCipherSuite);
        int macAlgorithm = TlsUtils.getMACAlgorithm(this.selectedCipherSuite);
        if (encryptionAlgorithm < 0 || macAlgorithm < 0) {
            throw new TlsFatalAlert(80);
        }
        return this.context.getSecurityParameters().getMasterSecret().createCipher(new TlsCryptoParameters(this.context), encryptionAlgorithm, macAlgorithm);
    }

    public NewSessionTicket getNewSessionTicket() throws IOException {
        return new NewSessionTicket(0L, TlsUtils.EMPTY_BYTES);
    }
}

