/*
 * Decompiled with CFR 0.152.
 */
package org.spongycastle.tls;

import java.io.IOException;
import org.spongycastle.tls.ByteQueue;
import org.spongycastle.tls.DTLSEpoch;
import org.spongycastle.tls.DTLSHandshakeRetransmit;
import org.spongycastle.tls.DatagramTransport;
import org.spongycastle.tls.ProtocolVersion;
import org.spongycastle.tls.TlsContext;
import org.spongycastle.tls.TlsFatalAlert;
import org.spongycastle.tls.TlsPeer;
import org.spongycastle.tls.TlsUtils;
import org.spongycastle.tls.crypto.TlsCipher;
import org.spongycastle.tls.crypto.TlsNullNullCipher;

class DTLSRecordLayer
implements DatagramTransport {
    private static final int RECORD_HEADER_LENGTH = 13;
    private static final int MAX_FRAGMENT_LENGTH = 16384;
    private static final long TCP_MSL = 120000L;
    private static final long RETRANSMIT_TIMEOUT = 240000L;
    private final DatagramTransport transport;
    private final TlsContext context;
    private final TlsPeer peer;
    private final ByteQueue recordQueue = new ByteQueue();
    private volatile boolean closed = false;
    private volatile boolean failed = false;
    private volatile ProtocolVersion readVersion = null;
    private volatile ProtocolVersion writeVersion = null;
    private volatile boolean inHandshake;
    private volatile int plaintextLimit;
    private DTLSEpoch currentEpoch;
    private DTLSEpoch pendingEpoch;
    private DTLSEpoch readEpoch;
    private DTLSEpoch writeEpoch;
    private DTLSHandshakeRetransmit retransmit = null;
    private DTLSEpoch retransmitEpoch = null;
    private long retransmitExpiry = 0L;

    DTLSRecordLayer(DatagramTransport transport, TlsContext context, TlsPeer peer, short contentType) {
        this.transport = transport;
        this.context = context;
        this.peer = peer;
        this.inHandshake = true;
        this.currentEpoch = new DTLSEpoch(0, new TlsNullNullCipher());
        this.pendingEpoch = null;
        this.readEpoch = this.currentEpoch;
        this.writeEpoch = this.currentEpoch;
        this.setPlaintextLimit(16384);
    }

    void setPlaintextLimit(int plaintextLimit) {
        this.plaintextLimit = plaintextLimit;
    }

    int getReadEpoch() {
        return this.readEpoch.getEpoch();
    }

    ProtocolVersion getReadVersion() {
        return this.readVersion;
    }

    void setReadVersion(ProtocolVersion readVersion) {
        this.readVersion = readVersion;
    }

    void setWriteVersion(ProtocolVersion writeVersion) {
        this.writeVersion = writeVersion;
    }

    void initPendingEpoch(TlsCipher pendingCipher) {
        if (this.pendingEpoch != null) {
            throw new IllegalStateException();
        }
        this.pendingEpoch = new DTLSEpoch(this.writeEpoch.getEpoch() + 1, pendingCipher);
    }

    void handshakeSuccessful(DTLSHandshakeRetransmit retransmit) {
        if (this.readEpoch == this.currentEpoch || this.writeEpoch == this.currentEpoch) {
            throw new IllegalStateException();
        }
        if (retransmit != null) {
            this.retransmit = retransmit;
            this.retransmitEpoch = this.currentEpoch;
            this.retransmitExpiry = System.currentTimeMillis() + 240000L;
        }
        this.inHandshake = false;
        this.currentEpoch = this.pendingEpoch;
        this.pendingEpoch = null;
    }

    void resetWriteEpoch() {
        this.writeEpoch = this.retransmitEpoch != null ? this.retransmitEpoch : this.currentEpoch;
    }

    public int getReceiveLimit() throws IOException {
        return Math.min(this.plaintextLimit, this.readEpoch.getCipher().getPlaintextLimit(this.transport.getReceiveLimit() - 13));
    }

    public int getSendLimit() throws IOException {
        return Math.min(this.plaintextLimit, this.writeEpoch.getCipher().getPlaintextLimit(this.transport.getSendLimit() - 13));
    }

    /*
     * Exception decompiling
     */
    public int receive(byte[] buf, int off, int len, int waitMillis) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [12[UNCONDITIONALDOLOOP]], but top level block is 0[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void send(byte[] buf, int off, int len) throws IOException {
        short contentType = 23;
        if (this.inHandshake || this.writeEpoch == this.retransmitEpoch) {
            contentType = 22;
            short handshakeType = TlsUtils.readUint8(buf, off);
            if (handshakeType == 20) {
                DTLSEpoch nextEpoch = null;
                if (this.inHandshake) {
                    nextEpoch = this.pendingEpoch;
                } else if (this.writeEpoch == this.retransmitEpoch) {
                    nextEpoch = this.currentEpoch;
                }
                if (nextEpoch == null) {
                    throw new IllegalStateException();
                }
                byte[] data = new byte[]{1};
                this.sendRecord((short)20, data, 0, data.length);
                this.writeEpoch = nextEpoch;
            }
        }
        this.sendRecord(contentType, buf, off, len);
    }

    public void close() throws IOException {
        if (!this.closed) {
            if (this.inHandshake) {
                this.warn((short)90, "User canceled handshake");
            }
            this.closeTransport();
        }
    }

    void fail(short alertDescription) {
        if (!this.closed) {
            try {
                this.raiseAlert((short)2, alertDescription, null, null);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.failed = true;
            this.closeTransport();
        }
    }

    void failed() {
        if (!this.closed) {
            this.failed = true;
            this.closeTransport();
        }
    }

    void warn(short alertDescription, String message) throws IOException {
        this.raiseAlert((short)1, alertDescription, message, null);
    }

    private void closeTransport() {
        if (!this.closed) {
            try {
                if (!this.failed) {
                    this.warn((short)0, null);
                }
                this.transport.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.closed = true;
        }
    }

    private void raiseAlert(short alertLevel, short alertDescription, String message, Throwable cause) throws IOException {
        this.peer.notifyAlertRaised(alertLevel, alertDescription, message, cause);
        byte[] error = new byte[]{(byte)alertLevel, (byte)alertDescription};
        this.sendRecord((short)21, error, 0, 2);
    }

    private int receiveRecord(byte[] buf, int off, int len, int waitMillis) throws IOException {
        int fragmentLength;
        int recordLength;
        if (this.recordQueue.available() > 0) {
            int length = 0;
            if (this.recordQueue.available() >= 13) {
                byte[] lengthBytes = new byte[2];
                this.recordQueue.read(lengthBytes, 0, 2, 11);
                length = TlsUtils.readUint16(lengthBytes, 0);
            }
            int received = Math.min(this.recordQueue.available(), 13 + length);
            this.recordQueue.removeData(buf, off, received, 0);
            return received;
        }
        int received = this.transport.receive(buf, off, len, waitMillis);
        if (received >= 13 && received > (recordLength = 13 + (fragmentLength = TlsUtils.readUint16(buf, off + 11)))) {
            this.recordQueue.addData(buf, off + recordLength, received - recordLength);
            received = recordLength;
        }
        return received;
    }

    private void sendRecord(short contentType, byte[] buf, int off, int len) throws IOException {
        if (this.writeVersion == null) {
            return;
        }
        if (len > this.plaintextLimit) {
            throw new TlsFatalAlert(80);
        }
        if (len < 1 && contentType != 23) {
            throw new TlsFatalAlert(80);
        }
        int recordEpoch = this.writeEpoch.getEpoch();
        long recordSequenceNumber = this.writeEpoch.allocateSequenceNumber();
        byte[] ciphertext = this.writeEpoch.getCipher().encodePlaintext(DTLSRecordLayer.getMacSequenceNumber(recordEpoch, recordSequenceNumber), contentType, buf, off, len);
        byte[] record = new byte[ciphertext.length + 13];
        TlsUtils.writeUint8(contentType, record, 0);
        TlsUtils.writeVersion(this.writeVersion, record, 1);
        TlsUtils.writeUint16(recordEpoch, record, 3);
        TlsUtils.writeUint48(recordSequenceNumber, record, 5);
        TlsUtils.writeUint16(ciphertext.length, record, 11);
        System.arraycopy(ciphertext, 0, record, 13, ciphertext.length);
        this.transport.send(record, 0, record.length);
    }

    private static long getMacSequenceNumber(int epoch, long sequence_number) {
        return ((long)epoch & 0xFFFFFFFFL) << 48 | sequence_number;
    }
}

