/*
 * Decompiled with CFR 0.152.
 */
package org.spongycastle.tls;

import java.math.BigInteger;
import java.util.Vector;
import org.spongycastle.tls.NamedGroup;
import org.spongycastle.tls.TlsDHConfigVerifier;
import org.spongycastle.tls.crypto.DHGroup;
import org.spongycastle.tls.crypto.DHStandardGroups;
import org.spongycastle.tls.crypto.TlsDHConfig;

public class DefaultTlsDHConfigVerifier
implements TlsDHConfigVerifier {
    public static final int DEFAULT_MINIMUM_PRIME_BITS = 2048;
    protected static final Vector DEFAULT_GROUPS = new Vector();
    protected Vector groups;
    protected int minimumPrimeBits;

    private static void addDefaultGroup(DHGroup dhGroup) {
        DEFAULT_GROUPS.addElement(dhGroup);
    }

    public DefaultTlsDHConfigVerifier() {
        this(2048);
    }

    public DefaultTlsDHConfigVerifier(int minimumPrimeBits) {
        this(DEFAULT_GROUPS, minimumPrimeBits);
    }

    public DefaultTlsDHConfigVerifier(Vector groups, int minimumPrimeBits) {
        this.groups = groups;
        this.minimumPrimeBits = minimumPrimeBits;
    }

    public boolean accept(TlsDHConfig dhConfig) {
        return this.checkMinimumPrimeBits(dhConfig) && this.checkGroup(dhConfig);
    }

    public int getMinimumPrimeBits() {
        return this.minimumPrimeBits;
    }

    protected boolean areGroupsEqual(DHGroup a, DHGroup b) {
        return a == b || this.areParametersEqual(a.getP(), b.getP()) && this.areParametersEqual(a.getG(), b.getG());
    }

    protected boolean areParametersEqual(BigInteger a, BigInteger b) {
        return a == b || a.equals(b);
    }

    protected boolean checkGroup(TlsDHConfig dhConfig) {
        if (NamedGroup.refersToASpecificFiniteField(dhConfig.getNamedGroup())) {
            return true;
        }
        DHGroup explicitGroup = dhConfig.getExplicitGroup();
        for (int i = 0; i < this.groups.size(); ++i) {
            if (!this.areGroupsEqual(explicitGroup, (DHGroup)this.groups.elementAt(i))) continue;
            return true;
        }
        return false;
    }

    protected boolean checkMinimumPrimeBits(TlsDHConfig dhConfig) {
        int bits = this.getMinimumPrimeBits();
        int namedGroup = dhConfig.getNamedGroup();
        if (namedGroup >= 0) {
            return NamedGroup.getFiniteFieldBits(namedGroup) >= bits;
        }
        DHGroup explicitGroup = dhConfig.getExplicitGroup();
        return explicitGroup.getP().bitLength() >= bits;
    }

    static {
        DefaultTlsDHConfigVerifier.addDefaultGroup(DHStandardGroups.rfc7919_ffdhe2048);
        DefaultTlsDHConfigVerifier.addDefaultGroup(DHStandardGroups.rfc7919_ffdhe3072);
        DefaultTlsDHConfigVerifier.addDefaultGroup(DHStandardGroups.rfc7919_ffdhe4096);
        DefaultTlsDHConfigVerifier.addDefaultGroup(DHStandardGroups.rfc7919_ffdhe6144);
        DefaultTlsDHConfigVerifier.addDefaultGroup(DHStandardGroups.rfc7919_ffdhe8192);
        DefaultTlsDHConfigVerifier.addDefaultGroup(DHStandardGroups.rfc3526_1536);
        DefaultTlsDHConfigVerifier.addDefaultGroup(DHStandardGroups.rfc3526_2048);
        DefaultTlsDHConfigVerifier.addDefaultGroup(DHStandardGroups.rfc3526_3072);
        DefaultTlsDHConfigVerifier.addDefaultGroup(DHStandardGroups.rfc3526_4096);
        DefaultTlsDHConfigVerifier.addDefaultGroup(DHStandardGroups.rfc3526_6144);
        DefaultTlsDHConfigVerifier.addDefaultGroup(DHStandardGroups.rfc3526_8192);
    }
}

