/*
 * Decompiled with CFR 0.152.
 */
package org.spongycastle.tls;

import java.util.Vector;
import org.spongycastle.tls.NamedGroup;
import org.spongycastle.tls.TlsECConfigVerifier;
import org.spongycastle.tls.crypto.TlsECConfig;

public class DefaultTlsECConfigVerifier
implements TlsECConfigVerifier {
    protected int minimumCurveBits;
    protected Vector namedGroups;

    public DefaultTlsECConfigVerifier(int minimumCurveBits, Vector namedGroups) {
        this.minimumCurveBits = Math.max(1, minimumCurveBits);
        this.namedGroups = namedGroups;
    }

    public boolean accept(TlsECConfig ecConfig) {
        int namedGroup = ecConfig.getNamedGroup();
        if (namedGroup < 0) {
            return false;
        }
        if (NamedGroup.getCurveBits(namedGroup) < this.minimumCurveBits) {
            return false;
        }
        return this.namedGroups == null || this.namedGroups.contains(namedGroup);
    }
}

