/*
 * Decompiled with CFR 0.152.
 */
package org.spongycastle.tls;

import java.io.IOException;
import org.spongycastle.tls.AbstractTlsClient;
import org.spongycastle.tls.DefaultTlsDHConfigVerifier;
import org.spongycastle.tls.DefaultTlsKeyExchangeFactory;
import org.spongycastle.tls.TlsAuthentication;
import org.spongycastle.tls.TlsDHConfigVerifier;
import org.spongycastle.tls.TlsECConfigVerifier;
import org.spongycastle.tls.TlsFatalAlert;
import org.spongycastle.tls.TlsKeyExchange;
import org.spongycastle.tls.TlsKeyExchangeFactory;
import org.spongycastle.tls.TlsPSKIdentity;
import org.spongycastle.tls.TlsUtils;
import org.spongycastle.tls.crypto.TlsCrypto;
import org.spongycastle.util.Arrays;

public class PSKTlsClient
extends AbstractTlsClient {
    protected static final int[] BASE_CIPHER_SUITES = new int[]{52396, 49207, 49205, 52397, 170, 178, 144};
    protected TlsDHConfigVerifier dhConfigVerifier;
    protected TlsPSKIdentity pskIdentity;
    protected int[] supportedCipherSuites;

    public PSKTlsClient(TlsCrypto crypto, TlsPSKIdentity pskIdentity) {
        this(crypto, new DefaultTlsKeyExchangeFactory(), new DefaultTlsDHConfigVerifier(), pskIdentity);
    }

    public PSKTlsClient(TlsCrypto crypto, TlsKeyExchangeFactory keyExchangeFactory, TlsDHConfigVerifier dhConfigVerifier, TlsPSKIdentity pskIdentity) {
        super(crypto, keyExchangeFactory);
        this.dhConfigVerifier = dhConfigVerifier;
        this.pskIdentity = pskIdentity;
        this.supportedCipherSuites = TlsUtils.getSupportedCipherSuites(crypto, BASE_CIPHER_SUITES);
    }

    public int[] getCipherSuites() {
        return Arrays.clone((int[])this.supportedCipherSuites);
    }

    public TlsKeyExchange getKeyExchange() throws IOException {
        int keyExchangeAlgorithm = TlsUtils.getKeyExchangeAlgorithm(this.selectedCipherSuite);
        switch (keyExchangeAlgorithm) {
            case 14: {
                return this.createPSKKeyExchange(keyExchangeAlgorithm, this.dhConfigVerifier, null);
            }
            case 24: {
                return this.createPSKKeyExchange(keyExchangeAlgorithm, null, this.createECConfigVerifier());
            }
            case 13: 
            case 15: {
                return this.createPSKKeyExchange(keyExchangeAlgorithm, null, null);
            }
        }
        throw new TlsFatalAlert(80);
    }

    public TlsAuthentication getAuthentication() throws IOException {
        throw new TlsFatalAlert(80);
    }

    protected TlsKeyExchange createPSKKeyExchange(int keyExchange, TlsDHConfigVerifier dhConfigVerifier, TlsECConfigVerifier ecConfigVerifier) throws IOException {
        return this.keyExchangeFactory.createPSKKeyExchangeClient(keyExchange, this.supportedSignatureAlgorithms, this.pskIdentity, dhConfigVerifier, ecConfigVerifier, this.clientECPointFormats, this.serverECPointFormats);
    }
}

