/*
 * Decompiled with CFR 0.152.
 */
package org.spongycastle.tls;

import java.io.IOException;
import org.spongycastle.tls.AbstractTlsServer;
import org.spongycastle.tls.DefaultTlsKeyExchangeFactory;
import org.spongycastle.tls.TlsCredentialedDecryptor;
import org.spongycastle.tls.TlsCredentials;
import org.spongycastle.tls.TlsFatalAlert;
import org.spongycastle.tls.TlsKeyExchange;
import org.spongycastle.tls.TlsKeyExchangeFactory;
import org.spongycastle.tls.TlsPSKIdentityManager;
import org.spongycastle.tls.TlsUtils;
import org.spongycastle.tls.crypto.TlsCrypto;
import org.spongycastle.tls.crypto.TlsDHConfig;
import org.spongycastle.tls.crypto.TlsECConfig;
import org.spongycastle.util.Arrays;

public class PSKTlsServer
extends AbstractTlsServer {
    public static final int[] BASE_CIPHER_SUITES = new int[]{52396, 49208, 49207, 49206, 49205, 52397, 171, 170, 179, 178, 145, 144};
    protected TlsPSKIdentityManager pskIdentityManager;
    protected int[] supportedCipherSuites;

    public PSKTlsServer(TlsCrypto crypto, TlsPSKIdentityManager pskIdentityManager) {
        this(crypto, new DefaultTlsKeyExchangeFactory(), pskIdentityManager);
    }

    public PSKTlsServer(TlsCrypto crypto, TlsKeyExchangeFactory keyExchangeFactory, TlsPSKIdentityManager pskIdentityManager) {
        super(crypto, keyExchangeFactory);
        this.pskIdentityManager = pskIdentityManager;
        this.supportedCipherSuites = TlsUtils.getSupportedCipherSuites(crypto, BASE_CIPHER_SUITES);
    }

    protected TlsCredentialedDecryptor getRSAEncryptionCredentials() throws IOException {
        throw new TlsFatalAlert(80);
    }

    protected int[] getCipherSuites() {
        return Arrays.clone((int[])this.supportedCipherSuites);
    }

    public TlsCredentials getCredentials() throws IOException {
        int keyExchangeAlgorithm = TlsUtils.getKeyExchangeAlgorithm(this.selectedCipherSuite);
        switch (keyExchangeAlgorithm) {
            case 13: 
            case 14: 
            case 24: {
                return null;
            }
            case 15: {
                return this.getRSAEncryptionCredentials();
            }
        }
        throw new TlsFatalAlert(80);
    }

    public TlsKeyExchange getKeyExchange() throws IOException {
        int keyExchangeAlgorithm = TlsUtils.getKeyExchangeAlgorithm(this.selectedCipherSuite);
        switch (keyExchangeAlgorithm) {
            case 14: {
                return this.createPSKKeyExchange(keyExchangeAlgorithm, this.selectDHConfig(), null);
            }
            case 24: {
                return this.createPSKKeyExchange(keyExchangeAlgorithm, null, this.selectECConfig());
            }
            case 13: 
            case 15: {
                return this.createPSKKeyExchange(keyExchangeAlgorithm, null, null);
            }
        }
        throw new TlsFatalAlert(80);
    }

    protected TlsKeyExchange createPSKKeyExchange(int keyExchange, TlsDHConfig dhConfig, TlsECConfig ecConfig) throws IOException {
        return this.keyExchangeFactory.createPSKKeyExchangeServer(keyExchange, this.supportedSignatureAlgorithms, this.pskIdentityManager, dhConfig, ecConfig, this.serverECPointFormats);
    }
}

