/*
 * Decompiled with CFR 0.152.
 */
package org.spongycastle.tls;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Vector;
import org.spongycastle.tls.NameType;
import org.spongycastle.tls.ServerName;
import org.spongycastle.tls.TlsFatalAlert;
import org.spongycastle.tls.TlsUtils;
import org.spongycastle.util.Arrays;
import org.spongycastle.util.io.Streams;

public class ServerNameList {
    protected Vector serverNameList;

    public ServerNameList(Vector serverNameList) {
        if (serverNameList == null) {
            throw new IllegalArgumentException("'serverNameList' must not be null");
        }
        this.serverNameList = serverNameList;
    }

    public Vector getServerNameList() {
        return this.serverNameList;
    }

    public void encode(OutputStream output) throws IOException {
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        short[] nameTypesSeen = new short[]{};
        for (int i = 0; i < this.serverNameList.size(); ++i) {
            ServerName entry = (ServerName)this.serverNameList.elementAt(i);
            if ((nameTypesSeen = ServerNameList.checkNameType(nameTypesSeen, entry.getNameType())) == null) {
                throw new TlsFatalAlert(80);
            }
            entry.encode(buf);
        }
        TlsUtils.checkUint16(buf.size());
        TlsUtils.writeUint16(buf.size(), output);
        Streams.writeBufTo((ByteArrayOutputStream)buf, (OutputStream)output);
    }

    public static ServerNameList parse(InputStream input) throws IOException {
        int length = TlsUtils.readUint16(input);
        if (length < 1) {
            throw new TlsFatalAlert(50);
        }
        byte[] data = TlsUtils.readFully(length, input);
        ByteArrayInputStream buf = new ByteArrayInputStream(data);
        short[] nameTypesSeen = new short[]{};
        Vector<ServerName> server_name_list = new Vector<ServerName>();
        while (buf.available() > 0) {
            ServerName entry = ServerName.parse(buf);
            if ((nameTypesSeen = ServerNameList.checkNameType(nameTypesSeen, entry.getNameType())) == null) {
                throw new TlsFatalAlert(47);
            }
            server_name_list.addElement(entry);
        }
        return new ServerNameList(server_name_list);
    }

    private static short[] checkNameType(short[] nameTypesSeen, short nameType) {
        if (!NameType.isValid(nameType) || Arrays.contains((short[])nameTypesSeen, (short)nameType)) {
            return null;
        }
        return Arrays.append((short[])nameTypesSeen, (short)nameType);
    }
}

