/*
 * Decompiled with CFR 0.152.
 */
package org.spongycastle.tls;

import java.io.IOException;
import java.math.BigInteger;
import org.spongycastle.tls.TlsSRPIdentityManager;
import org.spongycastle.tls.TlsSRPLoginParameters;
import org.spongycastle.tls.crypto.SRP6Group;
import org.spongycastle.tls.crypto.TlsCrypto;
import org.spongycastle.tls.crypto.TlsHMAC;
import org.spongycastle.tls.crypto.TlsMAC;
import org.spongycastle.tls.crypto.TlsSRP6VerifierGenerator;
import org.spongycastle.tls.crypto.TlsSRPConfig;
import org.spongycastle.util.Strings;

public class SimulatedTlsSRPIdentityManager
implements TlsSRPIdentityManager {
    private static final byte[] PREFIX_PASSWORD = Strings.toByteArray((String)"password");
    private static final byte[] PREFIX_SALT = Strings.toByteArray((String)"salt");
    protected SRP6Group group;
    protected TlsSRP6VerifierGenerator verifierGenerator;
    protected TlsMAC mac;

    public static SimulatedTlsSRPIdentityManager getRFC5054Default(TlsCrypto crypto, SRP6Group group, byte[] seedKey) throws IOException {
        TlsHMAC mac = crypto.createHMAC(2);
        mac.setKey(seedKey, 0, seedKey.length);
        TlsSRPConfig srpConfig = new TlsSRPConfig();
        srpConfig.setExplicitNG(new BigInteger[]{group.getN(), group.getG()});
        return new SimulatedTlsSRPIdentityManager(group, crypto.createSRP6VerifierGenerator(srpConfig), mac);
    }

    public SimulatedTlsSRPIdentityManager(SRP6Group group, TlsSRP6VerifierGenerator verifierGenerator, TlsMAC mac) {
        this.group = group;
        this.verifierGenerator = verifierGenerator;
        this.mac = mac;
    }

    public TlsSRPLoginParameters getLoginParameters(byte[] identity) {
        this.mac.update(PREFIX_SALT, 0, PREFIX_SALT.length);
        this.mac.update(identity, 0, identity.length);
        byte[] salt = this.mac.calculateMAC();
        this.mac.update(PREFIX_PASSWORD, 0, PREFIX_PASSWORD.length);
        this.mac.update(identity, 0, identity.length);
        byte[] password = this.mac.calculateMAC();
        BigInteger verifier = this.verifierGenerator.generateVerifier(salt, identity, password);
        TlsSRPConfig srpConfig = new TlsSRPConfig();
        srpConfig.setExplicitNG(new BigInteger[]{this.group.getN(), this.group.getG()});
        return new TlsSRPLoginParameters(srpConfig, verifier, salt);
    }
}

