/*
 * Decompiled with CFR 0.152.
 */
package org.spongycastle.tls;

import java.io.IOException;
import java.io.InputStream;
import org.spongycastle.tls.TlsProtocol;

class TlsInputStream
extends InputStream {
    private byte[] buf = new byte[1];
    private TlsProtocol handler = null;

    TlsInputStream(TlsProtocol handler) {
        this.handler = handler;
    }

    public int available() throws IOException {
        return this.handler.applicationDataAvailable();
    }

    public int read(byte[] buf, int offset, int len) throws IOException {
        return this.handler.readApplicationData(buf, offset, len);
    }

    public int read() throws IOException {
        if (this.read(this.buf) < 0) {
            return -1;
        }
        return this.buf[0] & 0xFF;
    }

    public void close() throws IOException {
        this.handler.close();
    }
}

