/*
 * Decompiled with CFR 0.152.
 */
package org.spongycastle.tls;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Vector;
import org.spongycastle.tls.AbstractTlsKeyExchange;
import org.spongycastle.tls.Certificate;
import org.spongycastle.tls.CertificateRequest;
import org.spongycastle.tls.TlsCredentialedDecryptor;
import org.spongycastle.tls.TlsCredentialedSigner;
import org.spongycastle.tls.TlsCredentials;
import org.spongycastle.tls.TlsFatalAlert;
import org.spongycastle.tls.TlsRSAUtils;
import org.spongycastle.tls.TlsUtils;
import org.spongycastle.tls.crypto.TlsCertificate;
import org.spongycastle.tls.crypto.TlsCryptoParameters;
import org.spongycastle.tls.crypto.TlsSecret;

public class TlsRSAKeyExchange
extends AbstractTlsKeyExchange {
    protected TlsCredentialedDecryptor serverCredentials = null;
    protected TlsCertificate serverCertificate;
    protected TlsSecret preMasterSecret;

    public TlsRSAKeyExchange(Vector supportedSignatureAlgorithms) {
        super(1, supportedSignatureAlgorithms);
    }

    public void skipServerCredentials() throws IOException {
        throw new TlsFatalAlert(80);
    }

    public void processServerCredentials(TlsCredentials serverCredentials) throws IOException {
        if (!(serverCredentials instanceof TlsCredentialedDecryptor)) {
            throw new TlsFatalAlert(80);
        }
        this.serverCredentials = (TlsCredentialedDecryptor)serverCredentials;
    }

    public void processServerCertificate(Certificate serverCertificate) throws IOException {
        if (serverCertificate.isEmpty()) {
            throw new TlsFatalAlert(42);
        }
        this.checkServerCertSigAlg(serverCertificate);
        this.serverCertificate = serverCertificate.getCertificateAt(0).useInRole(0, this.keyExchange);
    }

    public void validateCertificateRequest(CertificateRequest certificateRequest) throws IOException {
        short[] types = certificateRequest.getCertificateTypes();
        block3: for (int i = 0; i < types.length; ++i) {
            switch (types[i]) {
                case 1: 
                case 2: 
                case 64: {
                    continue block3;
                }
                default: {
                    throw new TlsFatalAlert(47);
                }
            }
        }
    }

    public void processClientCredentials(TlsCredentials clientCredentials) throws IOException {
        if (!(clientCredentials instanceof TlsCredentialedSigner)) {
            throw new TlsFatalAlert(80);
        }
    }

    public void generateClientKeyExchange(OutputStream output) throws IOException {
        this.preMasterSecret = TlsRSAUtils.generateEncryptedPreMasterSecret(this.context, this.serverCertificate, output);
    }

    public void processClientKeyExchange(InputStream input) throws IOException {
        byte[] encryptedPreMasterSecret = TlsUtils.readOpaque16(input);
        this.preMasterSecret = this.serverCredentials.decrypt(new TlsCryptoParameters(this.context), encryptedPreMasterSecret);
    }

    public TlsSecret generatePreMasterSecret() throws IOException {
        TlsSecret tmp = this.preMasterSecret;
        this.preMasterSecret = null;
        return tmp;
    }
}

