/*
 * Decompiled with CFR 0.152.
 */
package org.spongycastle.tls;

import java.io.IOException;
import java.io.OutputStream;
import org.spongycastle.tls.TlsContext;
import org.spongycastle.tls.TlsUtils;
import org.spongycastle.tls.crypto.TlsCertificate;
import org.spongycastle.tls.crypto.TlsSecret;

public abstract class TlsRSAUtils {
    private TlsRSAUtils() {
    }

    public static TlsSecret generateEncryptedPreMasterSecret(TlsContext context, TlsCertificate certificate, OutputStream output) throws IOException {
        TlsSecret preMasterSecret = context.getCrypto().generateRSAPreMasterSecret(context.getClientVersion());
        byte[] encryptedPreMasterSecret = preMasterSecret.encrypt(certificate);
        TlsUtils.writeOpaque16(encryptedPreMasterSecret, output);
        return preMasterSecret;
    }
}

