/*
 * Decompiled with CFR 0.152.
 */
package org.spongycastle.tls.crypto;

import java.io.IOException;
import java.math.BigInteger;
import java.security.SecureRandom;
import org.spongycastle.tls.ProtocolVersion;
import org.spongycastle.tls.SignatureAndHashAlgorithm;
import org.spongycastle.tls.crypto.TlsCertificate;
import org.spongycastle.tls.crypto.TlsDHConfig;
import org.spongycastle.tls.crypto.TlsDHDomain;
import org.spongycastle.tls.crypto.TlsECConfig;
import org.spongycastle.tls.crypto.TlsECDomain;
import org.spongycastle.tls.crypto.TlsHMAC;
import org.spongycastle.tls.crypto.TlsHash;
import org.spongycastle.tls.crypto.TlsNonceGenerator;
import org.spongycastle.tls.crypto.TlsSRP6Client;
import org.spongycastle.tls.crypto.TlsSRP6Server;
import org.spongycastle.tls.crypto.TlsSRP6VerifierGenerator;
import org.spongycastle.tls.crypto.TlsSRPConfig;
import org.spongycastle.tls.crypto.TlsSecret;

public interface TlsCrypto {
    public boolean hasAllRawSignatureAlgorithms();

    public boolean hasDHAgreement();

    public boolean hasECDHAgreement();

    public boolean hasEncryptionAlgorithm(int var1);

    public boolean hasHashAlgorithm(short var1);

    public boolean hasMacAlgorithm(int var1);

    public boolean hasNamedGroup(int var1);

    public boolean hasRSAEncryption();

    public boolean hasSignatureAlgorithm(int var1);

    public boolean hasSignatureAndHashAlgorithm(SignatureAndHashAlgorithm var1);

    public boolean hasSRPAuthentication();

    public TlsSecret createSecret(byte[] var1);

    public TlsSecret generateRSAPreMasterSecret(ProtocolVersion var1);

    public SecureRandom getSecureRandom();

    public TlsCertificate createCertificate(byte[] var1) throws IOException;

    public TlsDHDomain createDHDomain(TlsDHConfig var1);

    public TlsECDomain createECDomain(TlsECConfig var1);

    public TlsSecret adoptSecret(TlsSecret var1);

    public TlsHash createHash(short var1);

    public TlsHMAC createHMAC(int var1);

    public TlsNonceGenerator createNonceGenerator(byte[] var1);

    public TlsSRP6Client createSRP6Client(TlsSRPConfig var1);

    public TlsSRP6Server createSRP6Server(TlsSRPConfig var1, BigInteger var2);

    public TlsSRP6VerifierGenerator createSRP6VerifierGenerator(TlsSRPConfig var1);
}

