/*
 * Decompiled with CFR 0.152.
 */
package org.spongycastle.tls.crypto.impl.bc;

import java.io.IOException;
import org.spongycastle.crypto.params.AsymmetricKeyParameter;
import org.spongycastle.crypto.params.DHPrivateKeyParameters;
import org.spongycastle.crypto.params.DHPublicKeyParameters;
import org.spongycastle.crypto.params.ECPrivateKeyParameters;
import org.spongycastle.crypto.params.ECPublicKeyParameters;
import org.spongycastle.tls.Certificate;
import org.spongycastle.tls.TlsCredentialedAgreement;
import org.spongycastle.tls.crypto.TlsCertificate;
import org.spongycastle.tls.crypto.TlsSecret;
import org.spongycastle.tls.crypto.impl.bc.BcTlsCertificate;
import org.spongycastle.tls.crypto.impl.bc.BcTlsCrypto;
import org.spongycastle.tls.crypto.impl.bc.BcTlsDHDomain;
import org.spongycastle.tls.crypto.impl.bc.BcTlsECDomain;

public class BcDefaultTlsCredentialedAgreement
implements TlsCredentialedAgreement {
    protected TlsCredentialedAgreement agreementCredentials;

    public BcDefaultTlsCredentialedAgreement(BcTlsCrypto crypto, Certificate certificate, AsymmetricKeyParameter privateKey) {
        if (crypto == null) {
            throw new IllegalArgumentException("'crypto' cannot be null");
        }
        if (certificate == null) {
            throw new IllegalArgumentException("'certificate' cannot be null");
        }
        if (certificate.isEmpty()) {
            throw new IllegalArgumentException("'certificate' cannot be empty");
        }
        if (privateKey == null) {
            throw new IllegalArgumentException("'privateKey' cannot be null");
        }
        if (!privateKey.isPrivate()) {
            throw new IllegalArgumentException("'privateKey' must be private");
        }
        if (privateKey instanceof DHPrivateKeyParameters) {
            this.agreementCredentials = new DHCredentialedAgreement(crypto, certificate, (DHPrivateKeyParameters)privateKey);
        } else if (privateKey instanceof ECPrivateKeyParameters) {
            this.agreementCredentials = new ECCredentialedAgreement(crypto, certificate, (ECPrivateKeyParameters)privateKey);
        } else {
            throw new IllegalArgumentException("'privateKey' type not supported: " + privateKey.getClass().getName());
        }
    }

    public Certificate getCertificate() {
        return this.agreementCredentials.getCertificate();
    }

    public TlsSecret generateAgreement(TlsCertificate peerCertificate) throws IOException {
        return this.agreementCredentials.generateAgreement(peerCertificate);
    }

    private class ECCredentialedAgreement
    implements TlsCredentialedAgreement {
        final BcTlsCrypto crypto;
        final Certificate certificate;
        final ECPrivateKeyParameters privateKey;

        ECCredentialedAgreement(BcTlsCrypto crypto, Certificate certificate, ECPrivateKeyParameters privateKey) {
            this.crypto = crypto;
            this.certificate = certificate;
            this.privateKey = privateKey;
        }

        public TlsSecret generateAgreement(TlsCertificate peerCertificate) throws IOException {
            ECPublicKeyParameters peerPublicKey = BcTlsCertificate.convert(this.crypto, peerCertificate).getPubKeyEC();
            return this.crypto.adoptLocalSecret(BcTlsECDomain.calculateBasicAgreement(this.privateKey, peerPublicKey));
        }

        public Certificate getCertificate() {
            return this.certificate;
        }
    }

    private class DHCredentialedAgreement
    implements TlsCredentialedAgreement {
        final BcTlsCrypto crypto;
        final Certificate certificate;
        final DHPrivateKeyParameters privateKey;

        DHCredentialedAgreement(BcTlsCrypto crypto, Certificate certificate, DHPrivateKeyParameters privateKey) {
            this.crypto = crypto;
            this.certificate = certificate;
            this.privateKey = privateKey;
        }

        public TlsSecret generateAgreement(TlsCertificate peerCertificate) throws IOException {
            DHPublicKeyParameters peerPublicKey = BcTlsCertificate.convert(this.crypto, peerCertificate).getPubKeyDH();
            return this.crypto.adoptLocalSecret(BcTlsDHDomain.calculateBasicAgreement(this.privateKey, peerPublicKey));
        }

        public Certificate getCertificate() {
            return this.certificate;
        }
    }
}

