/*
 * Decompiled with CFR 0.152.
 */
package org.spongycastle.tls.crypto.impl.bc;

import org.spongycastle.crypto.params.AsymmetricKeyParameter;
import org.spongycastle.crypto.params.DSAPrivateKeyParameters;
import org.spongycastle.crypto.params.ECPrivateKeyParameters;
import org.spongycastle.crypto.params.RSAKeyParameters;
import org.spongycastle.tls.Certificate;
import org.spongycastle.tls.DefaultTlsCredentialedSigner;
import org.spongycastle.tls.SignatureAndHashAlgorithm;
import org.spongycastle.tls.crypto.TlsCryptoParameters;
import org.spongycastle.tls.crypto.TlsSigner;
import org.spongycastle.tls.crypto.impl.bc.BcTlsCrypto;
import org.spongycastle.tls.crypto.impl.bc.BcTlsDSASigner;
import org.spongycastle.tls.crypto.impl.bc.BcTlsECDSASigner;
import org.spongycastle.tls.crypto.impl.bc.BcTlsRSASigner;
import org.spongycastle.tls.crypto.impl.bc.BcTlsSigner;

public class BcDefaultTlsCredentialedSigner
extends DefaultTlsCredentialedSigner {
    private static TlsSigner makeSigner(BcTlsCrypto crypto, AsymmetricKeyParameter privateKey) {
        BcTlsSigner signer;
        if (privateKey instanceof RSAKeyParameters) {
            signer = new BcTlsRSASigner(crypto, (RSAKeyParameters)privateKey);
        } else if (privateKey instanceof DSAPrivateKeyParameters) {
            signer = new BcTlsDSASigner(crypto, (DSAPrivateKeyParameters)privateKey);
        } else if (privateKey instanceof ECPrivateKeyParameters) {
            signer = new BcTlsECDSASigner(crypto, (ECPrivateKeyParameters)privateKey);
        } else {
            throw new IllegalArgumentException("'privateKey' type not supported: " + privateKey.getClass().getName());
        }
        return signer;
    }

    public BcDefaultTlsCredentialedSigner(TlsCryptoParameters cryptoParams, BcTlsCrypto crypto, AsymmetricKeyParameter privateKey, Certificate certificate, SignatureAndHashAlgorithm signatureAndHashAlgorithm) {
        super(cryptoParams, BcDefaultTlsCredentialedSigner.makeSigner(crypto, privateKey), certificate, signatureAndHashAlgorithm);
    }
}

